package pl.topteam.empatia_formularze.utils;

import com.google.common.base.Preconditions;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

/**
 * Created by arek on 2017-06-06.
 */
public class FormularzEmpatiiUtil {
    private static JAXBContext context;

    private static synchronized JAXBContext pobierzJAXBContext() {
        if (context == null) {
            try {
                context = JAXBContext.newInstance(
                        pl.mpips.piu.rd.fa_1._1.ObjectFactory.class,
                        pl.mpips.piu.rd.fa_1._2.ObjectFactory.class,
                        pl.mpips.piu.rd.fa_1z._1.ObjectFactory.class,
                        pl.mpips.piu.rd.fa_1z._2.ObjectFactory.class,
                        pl.mpips.piu.rd.fa_2._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_01._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_02._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_03._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_03._2.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_04._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_04._2.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_05._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_05._2.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_06._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_06._2.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_07._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_08._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_09._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zfa_10._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zs_1._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zs_2._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zs_3._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zs_4._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zs_5._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zs_6._1.ObjectFactory.class,

                        pl.mpips.piu.rd.sr_1._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_1._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_1z._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_1z._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_2._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_2._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_2z._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_2z._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_3._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_3._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_4._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_4._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_4z._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_4z._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_5._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_5._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_6._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_6z._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_7._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_7._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_7z._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_7z._2.ObjectFactory.class,
                        pl.mpips.piu.rd.sr_8._1.ObjectFactory.class,
                        pl.gov.mpips.piu.rd.sw_1._1.ObjectFactory.class,
                        pl.mpips.piu.rd.sw_1._2.ObjectFactory.class,

                        pl.mpips.piu.rd.zsr_01._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_02._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_03._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_04._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_05._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_06._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_07._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_08._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_09._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_10._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_11._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_12._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_13._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_14._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_15._1.ObjectFactory.class,
                        pl.mpips.piu.rd.zsr_16._1.ObjectFactory.class,

                        pl.gov.mpips.xsd.csizs.pi.mkm.dok.ogolne.v2.ObjectFactory.class
                );
            } catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return context;
    }

    public static Object wczytaj(byte[] tresc) {
        try {
            Unmarshaller unmarshaller = pobierzJAXBContext().createUnmarshaller();
            JAXBElement<?> element = (JAXBElement<?>) unmarshaller.unmarshal(new ByteArrayInputStream(tresc));
            return element.getValue();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String drukuj(byte[] tresc) {
        Object formularz = wczytaj(tresc);
        try (InputStream styl = formularz.getClass().getResourceAsStream("styl.xsl")) {
            Preconditions.checkNotNull(styl, "nie udało się odnaleźć xsl dla klasy: %s", formularz.getClass());
            return transformuj(tresc, styl);
        } catch (IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static String transformuj(byte[] tresc, InputStream styl) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(styl));
        Source xmlSource = new StreamSource(new ByteArrayInputStream(tresc));
        StringWriter sw = new StringWriter();
        transformer.transform(xmlSource, new StreamResult(sw));
        return sw.toString();
    }
}
