package pl.topteam.empatia_formularze.utils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;


public class LocalDateAdapter extends XmlAdapter<String, LocalDate> {

    private static final String FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter PARSER;

    static {
        DateTimeParser tOffset = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 2).toParser();
        PARSER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendOptional(tOffset).toFormatter();
    }

    public LocalDate unmarshal(String value) {
        return PARSER.parseLocalDate(value);
    }

    public String marshal(LocalDate value) {
        return value.toString(FORMAT);
    }

}
