<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/SDS_1/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>SDS-1 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      </head>
      <body style="font-family: Arial; text-align: center; ">
		<!-- Pierwsza część, statyczna formularza -->		
		<xsl:call-template name="poczatkowaStatycznaCzescSDS">
		</xsl:call-template>		

		<!-- Sekcja dynamiczna - kolejne dzieci -->			  
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="dynamicznaSekcjaDzieciSDS">
					<xsl:with-param name="BiezaceDziecko" select="position()"/>
				</xsl:call-template>
			</xsl:if>
			
		</xsl:for-each>		
		
		<!-- Końcowa część, statyczna formularza -->		
		<xsl:call-template name="KoncowaStatycznaCzescSDS">
		</xsl:call-template>	
	  
		<!-- Stopka prawna Inna Instytucja -->		
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc != 'ZUS'">
			<xsl:call-template name="notaPrawnaInnaInstytucjaSDS">
			</xsl:call-template>
		</xsl:if>

		<!-- Stopka prawna - ZUS -->				
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc = 'ZUS'">
			<xsl:call-template name="notaPrawnaZusSDS">
			</xsl:call-template>
		</xsl:if>
	  
	  </body>
    </html>
  </xsl:template>
  
   <xsl:template name="formatRokuSzkolnego1">
     <xsl:param name="wartosc" />
     <xsl:if test="$wartosc != ''">
       <xsl:value-of select="substring($wartosc, 1, 4)" />
     </xsl:if>
   </xsl:template>

  <xsl:template name="formatRokuSzkolnego2">
     <xsl:param name="wartosc" />
     <xsl:if test="$wartosc != ''">
       <xsl:value-of select="substring($wartosc, 6, 4)" />
     </xsl:if>
   </xsl:template>
  
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
	  

	<!-- Część implementacyjna formularza -->

	<xsl:template name="poczatkowaStatycznaCzescSDS">

        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SDS-1</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="top: 220px; left: 0px; width: 880px; position: absolute; height: 101px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 101px; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">NAZWA ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA DOBRY START (1)</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 68px; " class="SofBorderContainer">
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 7px; left: 3px; display: block; width: 840px; font-size: 18px; position: absolute; height: 54px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                      <xsl:with-param name="wysokosc" select="54" />
                      <xsl:with-param name="szerokosc" select="840" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="wysokoscLini" select="20" />
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="top: 320px; left: 0px; width: 880px; position: absolute; height: 233px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA DOBRY START (1)</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 200px; " class="SofBorderContainer">
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 171px; " class="SofLabel">03. Miejscowość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 171px; display: block; width: 697px; font-size: 18px; position: absolute; height: 27px; text-align: left; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:27px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Miejscowosc" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">04. Ulica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 3px; " class="SofLabel">05. Numer domu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 195px; " class="SofLabel">06. Numer lokalu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 195px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="color: #000000; top: 183px; left: 3px; width: 867px; font-size: 12px; position: absolute; height: 26px; " class="SofLabel">(1) Przez organ właściwy rozumie się wójta, burmistrza lub prezydenta miasta właściwego ze względu na miejsce zamieszkania osoby składającej wniosek.</div>
              </div>
            </div>
          </div>
          <div style="color: #000000; top: 564px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">CZĘŚĆ I</div>
          <div style="color: #000000; top: 584px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 18px; " class="SofLabel justified14Bold">1. Dane osoby składającej wniosek o świadczenie dobry start, zwanej dalej „wnioskodawcą".</div>
          <div style="top: 604px; left: 0px; width: 880px; position: absolute; height: 306px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 273px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:PESEL" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Data urodzenia (dd / mm / rrrr)</div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:DataUrodzenia" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 230px; left: 3px; " class="SofLabel"></div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 244px; left: 3px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 507px; " class="SofLabel">05. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 507px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Imie" />
                  </span>
                </div>
                <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 3px; " class="SofLabel">06. Obywatelstwo</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 3px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 181px; left: 3px; " class="SofLabel">07. Stan cywilny</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 194px; left: 3px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:StanCywilny" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="top: 915px; left: 0px; width: 880px; position: absolute; height: 307px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 274px; " class="SofBorderContainer">
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 171px; " class="SofLabel">03. Miejscowość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 171px; display: block; width: 697px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">04. Ulica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 3px; " class="SofLabel">05. Numer domu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 195px; " class="SofLabel">06. Numer mieszkania</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 195px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="width: 126px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 411px; " class="SofLabel">07. Numer telefonu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 411px; display: block; width: 241px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerTelefonu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 181px; left: 3px; " class="SofLabel">08. Adres poczty elektronicznej — e-mail</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 194px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:AdresPocztyElektronicznej" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 790px; font-size: 12px; position: absolute; color: #000000; top: 230px; left: 4px; " class="SofLabel"></div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 244px; left: 4px; " class="SofLabel"></div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 258px; left: 22px; " class="SofLabel"></div>
              </div>
            </div>
          </div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SDS-1(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: 1/<xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 4"/></div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 35px; left: 0px; font-weight: bold; width: 100%; font-size: 16px; position: absolute; text-align: center; height: 78px; " class="SofLabel formTitle">
            WNIOSEK
            <br />
            O &#xa0;USTALENIE &#xa0;PRAWA
            <br />
            DO ŚWIADCZENIA DOBRY START
          </div>
          </div>
	</xsl:template>
	
	
	<!-- Strona dynamiczna formularza (dzieci) -->	
	
	<xsl:template name="dynamicznaSekcjaDzieciSDS">
		<xsl:param name="BiezaceDziecko"/>
		
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SDS-1</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
		  
		  <xsl:if test="$BiezaceDziecko=1">
			<div style="color: #000000; top: 35px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">2. Składam wniosek o świadczenie dobry start na następujące dzieci:</div>
			<div style="color: #000000; top: 53px; left: 6px; width: 870px; font-size: 12px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified"></div>
		  </xsl:if>
		  
          <div style="background-color: #E7E5E6; top: 85px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 256px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE DZIECKA-<xsl:value-of select="($BiezaceDziecko)"/></div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 517px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 13px; " class="SofLabel">Obywatelstwo:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 169px; left: 14px; display: block; width: 502px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="color: #000000; top: 161px; left: 578px; width: 291px; font-size: 12px; position: absolute; text-align: justify; " class="SofLabel justified">Czy dziecko posiada orzeczenie o umiarkowanym albo znacznym stopniu niepełnosprawności lub orzeczenie o potrzebie kształcenia specjalnego albo potrzebie zajęć rewalidacyjno-wychowawczych?</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 169px; left: 542px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
              <xsl:if test="wnio:Niepelnosprawnosc='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 207px; left: 13px; " class="SofLabel"></div>
            <div style="color: #000000; top: 222px; left: 13px; width: 856px; font-size: 12px; position: absolute; text-align: justify; " class="SofLabel justified"></div>
          </div>
          <div style="background-color: #E7E5E6; top: 350px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 211px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 10px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">OŚWIADCZAM, ŻE DZIECKO W ROKU SZKOLNYM</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 30px; left: 13px; " class="SofLabel">Rok (rrrr)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 43px; left: 13px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
				 <xsl:call-template name="formatRokuSzkolnego1">
					<xsl:with-param name="wartosc" select="wnio:RokSzkolnySzkola/wnio:RokSzkolny" />
                 </xsl:call-template> 
              </span>
            </div>
            <div style="font-size: 18px; position: absolute; color: #000000; top: 49px; left: 119px; font-weight: normal; " class="SofLabel global18Normal">/</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 30px; left: 133px; " class="SofLabel">Rok (rrrr)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 43px; left: 133px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:call-template name="formatRokuSzkolnego2">
					<xsl:with-param name="wartosc" select="wnio:RokSzkolnySzkola/wnio:RokSzkolny" />
                 </xsl:call-template> 
              </span>
            </div>
            <div style="font-size: 18px; position: absolute; color: #000000; top: 49px; left: 119px; font-weight: normal; " class="SofLabel global18Normal">/</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 13px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
              <xsl:if test="wnio:RokSzkolnySzkola/wnio:UczeszczaDoSzkoly/wnio:Tak='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="width: 423px; font-size: 12px; position: absolute; color: #000000; top: 84px; left: 50px; " class="SofLabel">będzie uczęszczało/uczęszcza do szkoły (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 109px; left: 13px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
              <xsl:if test="wnio:RokSzkolnySzkola/wnio:UczeszczaDoSzkoly/wnio:Nie='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="width: 423px; font-size: 12px; position: absolute; color: #000000; top: 117px; left: 50px; " class="SofLabel">nie będzie uczęszczało/nie uczęszcza do szkoły (1)</div>
            <div style="color: #000000; top: 148px; left: 13px; width: 856px; font-size: 12px; position: absolute; text-align: justify; height: 58px; " class="SofLabel justified">(1) Świadczenie przysługuje z tytułu rozpoczęcia roku szkolnego w następujących szkołach: szkoła podstawowa, szkoła ponadpodstawowa, klasach dotychczasowej szkoły ponadgimnazjalnej prowadzonych w szkole ponadpodstawowej, szkoła artystyczna, w której jest realizowany obowiązek szkolny lub nauki, a także młodzieżowy ośrodek socjoterapii, specjalny ośrodek szkolno-wychowawczy, specjalny ośrodek wychowawczy, ośrodek rewalidacyjno-wychowawczy.</div>
          </div>
          <div style="background-color: #E7E5E6; top: 570px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 207px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 10px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">WYPEŁNIJ PONIŻSZE OŚWIADCZENIE (OŚWIADCZENIE DOTYCZY TYLKO DZIECI W WIEKU OD 6 DO 9 LAT)</div>
            <div style="color: #000000; top: 25px; left: 13px; width: 857px; font-size: 12px; position: absolute; text-align: justify; height: 35px; " class="SofLabel justified">
              <div style="margin-top: 0px; margin-bottom: 0px; font-weight: 700">
                <span>Oświadczenie wymagane ponieważ </span>
                <span style="text-decoration: underline;">świadczenie dobry start nie przysługuje</span>
                <span> na dziecko uczęszczające do przedszkola, w tym realizujące roczne przygotowanie przedszkolne („tzw. zerówka”) w szkole podstawowej, a także w przedszkolu lub w innej formie wychowania przedszkolnego.</span>
              </div>
            </div>
            <div style="color: #000000; top: 70px; left: 13px; font-weight: bold; width: 857px; font-size: 12px; position: absolute; " class="SofLabel sectionHeader">Oświadczam, że dziecko w roku szkolnym:</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 90px; left: 13px; " class="SofLabel">Rok (rrrr)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 103px; left: 13px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">			
				<xsl:call-template name="formatRokuSzkolnego1">
					<xsl:with-param name="wartosc" select="wnio:RokSzkolnyPrzedszkoleZerowka/wnio:RokSzkolny" />
                 </xsl:call-template> 
              </span>
            </div>
            <div style="font-size: 18px; position: absolute; color: #000000; top: 109px; left: 119px; font-weight: normal; " class="SofLabel global18Normal">/</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 90px; left: 133px; " class="SofLabel">Rok (rrrr)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 103px; left: 133px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:call-template name="formatRokuSzkolnego2">
					<xsl:with-param name="wartosc" select="wnio:RokSzkolnyPrzedszkoleZerowka/wnio:RokSzkolny" />
                 </xsl:call-template> 
              </span>
            </div>
            <div style="font-size: 18px; position: absolute; color: #000000; top: 109px; left: 119px; font-weight: normal; " class="SofLabel global18Normal">/</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 136px; left: 13px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
              <xsl:if test="wnio:RokSzkolnyPrzedszkoleZerowka/wnio:UczeszczaDoPrzedszkolaZerowki/wnio:Nie='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="width: 423px; font-size: 12px; position: absolute; color: #000000; top: 144px; left: 50px; " class="SofLabel">nie będzie uczęszczało/nie uczęszcza do przedszkola ani tzw. zerówki</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 169px; left: 13px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
              <xsl:if test="wnio:RokSzkolnyPrzedszkoleZerowka/wnio:UczeszczaDoPrzedszkolaZerowki/wnio:Tak='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="width: 423px; font-size: 12px; position: absolute; color: #000000; top: 177px; left: 50px; " class="SofLabel">będzie uczęszczało/uczęszcza do przedszkola albo do tzw. zerówki</div>
          </div>
          <div style="background-color: #E7E5E6; top: 786px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 95px; " class="SofBorderContainer lightGrayAll">
            <div style="color: #000000; top: 8px; left: 10px; font-weight: bold; width: 860px; font-size: 12px; position: absolute; " class="SofLabel sectionHeader">WPISZ RODZAJ SZKOŁY (NP.: SZKOŁA PODSTAWOWA, LICEUM OGÓLNOKSZTAŁCĄCE, ITP.), DO KTÓREJ BĘDZIE UCZĘSZCZAŁO/UCZĘSZCZA DZIECKO-<xsl:value-of select="($BiezaceDziecko)"/></div>
            <div style="background-color: #E7E5E6; top: 36px; left: 10px; width: 870px; border-color: #E7E5E6; position: absolute; height: 55px; " class="SofBorderContainer lightGrayAll">
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 1px; left: 3px; display: block; width: 840px; font-size: 18px; position: absolute; height: 54px; " class="SofTextArea dotted">
                <div style="padding-left:5px ; padding-top:2px; display: block;">
                  <xsl:call-template name="formatTextArea">
                    <xsl:with-param name="tekst" select="wnio:Szkola/wnio:RodzajSzkoly" />
                    <xsl:with-param name="wysokosc" select="54" />
                    <xsl:with-param name="szerokosc" select="840" />
                    <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                    <xsl:with-param name="wysokoscLini" select="20" />
                    <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                    <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="wnio:Szkola/wnio:RodzajSzkoly" />
                  </xsl:call-template>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 890px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 330px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE ADRESOWE SZKOŁY, DO KTÓREJ BĘDZIE UCZĘSZCZAŁO/UCZĘSZCZA DZIECKO-<xsl:value-of select="($BiezaceDziecko)"/></div>
            <div style="color: #000000; top: 24px; left: 13px; font-weight: bold; width: 856px; font-size: 12px; position: absolute; text-align: justify; height: 65px; " class="SofLabel justified">(Świadczenie przysługuje z tytułu rozpoczęcia roku szkolnego w następujących szkołach: szkoła podstawowa, szkoła ponadpodstawowa, klasach dotychczasowej szkoły ponadgimnazjalnej prowadzonych w szkole ponadpodstawowej, szkoła artystyczna, w której jest realizowany obowiązek szkolny lub nauki, a także młodzieżowy ośrodek socjoterapii, specjalny ośrodek szkolno-wychowawczy, specjalny ośrodek wychowawczy, ośrodek rewalidacyjno-wychowawczy.)</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 128px; left: 13px; " class="SofLabel">Kod pocztowy:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 141px; left: 13px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;display: block;">
                <xsl:if test="wnio:Szkola/wnio:AdresSzkoly/wnio:KodPocztowy!= ''">
                  <xsl:value-of select="substring(wnio:Szkola/wnio:AdresSzkoly/wnio:KodPocztowy, 1, 2)" />
                  -
                  <xsl:value-of select="substring(wnio:Szkola/wnio:AdresSzkoly/wnio:KodPocztowy, 3, 4)" />
                </xsl:if>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 84px; left: 13px; " class="SofLabel">Gmina / Dzielnica:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 97px; left: 13px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Szkola/wnio:AdresSzkoly/wnio:GminaDzielnica" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 172px; left: 13px; " class="SofLabel">Ulica:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 185px; left: 13px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Szkola/wnio:AdresSzkoly/wnio:Ulica" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 216px; left: 13px; " class="SofLabel">Numer domu:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 229px; left: 13px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Szkola/wnio:AdresSzkoly/wnio:NumerDomu" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 216px; left: 205px; " class="SofLabel">Numer lokalu:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 229px; left: 205px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Szkola/wnio:AdresSzkoly/wnio:NumerLokalu" />
              </span>
            </div>
            <div style="width: 189px; font-size: 12px; position: absolute; color: #000000; top: 260px; left: 13px; " class="SofLabel">Zagraniczny kod pocztowy:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 273px; left: 13px; display: block; width: 289px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Szkola/wnio:AdresSzkoly/wnio:ZagranicznyKodPocztowy" />
              </span>
            </div>
            <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 260px; left: 325px; " class="SofLabel">Nazwa państwa:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 273px; left: 325px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Szkola/wnio:AdresSzkoly/wnio:NazwaPanstwa" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 128px; left: 181px; " class="SofLabel">Miejscowość:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 141px; left: 181px; display: block; width: 696px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Szkola/wnio:AdresSzkoly/wnio:Miejscowosc" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="696" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 790px; font-size: 12px; position: absolute; color: #000000; top: 310px; left: 13px; " class="SofLabel"></div>
          </div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SDS-1(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: <xsl:value-of select="($BiezaceDziecko) + 1"/>/<xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 4"/></div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
		
	</xsl:template> 
	
	
	<!-- Końcowa część, statyczna formularza -->	
	<xsl:template name="KoncowaStatycznaCzescSDS">
		
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SDS-1</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 30px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">CZĘŚĆ II POUCZENIA I OŚWIADCZENIA</div>
          <div style="color: #000000; top: 50px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified14Bold">1. POUCZENIE</div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 72px; left: 0px; height: 869px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 10px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified14">1.</div>
            <div style="color: #000000; top: 0px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 94px; " class="SofLabel justified14">Na podstawie Rozporządzenia Rady Ministrów z dnia 30 maja 2018 r. w sprawie szczegółowych warunków realizacji rządowego programu „Dobry start”, zwanego dalej „rozporządzeniem”, świadczenie dobry start przysługuje: rodzicom, opiekunom faktycznym, opiekunom prawnym, rodzinom zastępczym, osobom prowadzącym rodzinne domy dziecka, dyrektorom placówek opiekuńczo-wychowawczych, dyrektorom regionalnych placówek opiekuńczo-terapeutycznych* - raz w roku na dziecko oraz osobom uczącym się&#42;&#42; - raz w roku.</div>
            <div style="color: #000000; top: 84px; left: 10px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified14">2.</div>
            <div style="color: #000000; top: 84px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified14">Świadczenie dobry start przysługuje wyżej wymienionym osobom w związku z rozpoczęciem roku szkolnego, w wysokości 300 zł.</div>
            <div style="color: #000000; top: 101px; left: 10px; width: 870px; font-size: 14px; position: absolute; text-align: justify; " class="SofLabel justified14">3.</div>
            <div style="color: #000000; top: 101px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; " class="SofLabel justified14">Świadczenie dobry start przysługuje do ukończenia:</div>
            <div style="color: #000000; top: 119px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified14">1)</div>
            <div style="color: #000000; top: 119px; left: 50px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified14">przez dziecko lub osobę uczącą się 20. roku życia;</div>
            <div style="color: #000000; top: 136px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified14">2)</div>
            <div style="color: #000000; top: 136px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified14">przez dziecko lub osobę uczącą się 24. roku życia &#xa0;w przypadku dzieci lub osób uczących się legitymujących się orzeczeniem o niepełnosprawności.</div>
            <div style="color: #000000; top: 169px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified14">Świadczenie dobry start przysługuje także w przypadku:</div>
            <div style="color: #000000; top: 186px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified14">1)</div>
            <div style="color: #000000; top: 186px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 39px; " class="SofLabel justified14">ukończenia 20. roku życia przez dziecko lub osobę uczącą się przed rozpoczęciem roku szkolnego &#xa0;w roku kalendarzowym, w którym dziecko lub osoba ucząca się kończy 20. rok życia;</div>
            <div style="color: #000000; top: 220px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified14">2)</div>
            <div style="color: #000000; top: 220px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 50px; " class="SofLabel justified14">ukończenia 24. roku życia przez dziecko lub osobę uczącą się przed rozpoczęciem roku szkolnego w roku kalendarzowym, w którym dziecko lub osoba ucząca się kończy 24. rok życia - w przypadku dzieci lub osób uczących się legitymujących się orzeczeniem o niepełnosprawności.</div>
            <div style="color: #000000; top: 269px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 50px; " class="SofLabel justified14">W przypadku dziecka biorącego udział w zajęciach rewalidacyjno-wychowawczych, świadczenie dobry start przysługuje nie wcześniej niż od roku kalendarzowego, w którym dziecko kończy 7. rok życia.</div>
            <div style="color: #000000; top: 303px; left: 10px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">4.</div>
            <div style="color: #000000; top: 303px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 77px; " class="SofLabel justified14">Świadczenie dobry start przysługuje:</div>
            <div style="color: #000000; top: 319px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified14">1)</div>
            <div style="color: #000000; top: 319px; left: 50px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified14">obywatelom polskim,</div>
            <div style="color: #000000; top: 337px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 22px; " class="SofLabel justified14">2)</div>
            <div style="color: #000000; top: 337px; left: 50px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified14">cudzoziemcom:</div>
            <div style="color: #000000; top: 354px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">a)</div>
            <div style="color: #000000; top: 354px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">obywatelom Unii Europejskiej, Europejskiego Obszaru Gospodarczego albo Szwajcarii,</div>
            <div style="color: #000000; top: 371px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">b)</div>
            <div style="color: #000000; top: 371px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">jeżeli wynika to z wiążących Rzeczpospolitą Polską dwustronnych umów międzynarodowych o zabezpieczeniu społecznym,</div>
            <div style="color: #000000; top: 387px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">c)</div>
            <div style="color: #000000; top: 387px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">przebywającym na terytorium Rzeczypospolitej Polskiej na podstawie zezwolenia na pobyt czasowy udzielonego w związku z okolicznościami, o których mowa w art. 127 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach jeżeli zamieszkują z członkami rodzin na terytorium Rzeczypospolitej Polskiej,</div>
            <div style="color: #000000; top: 438px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">d)</div>
            <div style="color: #000000; top: 438px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">posiadającym kartę pobytu z adnotacją „dostęp do rynku pracy”, jeżeli zamieszkują z członkami rodzin na terytorium Rzeczypospolitej Polskiej, z wyłączeniem obywateli państw trzecich, którzy uzyskali zezwolenie na pracę na terytorium państwa członkowskiego na okres nieprzekraczający sześciu miesięcy, obywateli państw trzecich przyjętych w celu podjęcia studiów lub pracy sezonowej oraz obywateli państw trzecich, którzy mają prawo do wykonywania pracy na podstawie wizy,</div>
            <div style="color: #000000; top: 507px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">e)</div>
            <div style="color: #000000; top: 507px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">przebywającym na terytorium Rzeczypospolitej Polskiej na podstawie:</div>
            <div style="color: #000000; top: 525px; left: 60px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 525px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 44px; " class="SofLabel justified14">zezwolenia na pobyt czasowy, o którym mowa w art. 139a ust. 1 lub 139o ust. 1 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach, lub</div>
            <div style="color: #000000; top: 558px; left: 60px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 558px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 133px; " class="SofLabel justified14">dokumentu pobytowego, o którym mowa w art. 1 ust. 2 lit. a rozporządzenia Rady (WE) nr 1030/2002 z dnia 13 czerwca 2002 r. ustanawiającego jednolity wzór dokumentów pobytowych dla obywateli państw trzecich z adnotacją „ICT”, wydanego przez inne państwo członkowskie Unii Europejskiej, i gdy celem ich pobytu na terytorium Rzeczypospolitej Polskiej jest wykonywanie pracy w charakterze pracownika kadry kierowniczej, specjalisty lub pracownika odbywającego staż w ramach przeniesienia wewnątrz przedsiębiorstwa, o którym mowa w art. 3 pkt 13b ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach przez okres nieprzekraczający 90 dni w okresie 180 dni</div>
            <div style="color: #000000; top: 657px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 657px; left: 60px; width: 815px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">jeżeli zamieszkują z członkami rodzin na terytorium Rzeczypospolitej Polskiej, z wyłączeniem cudzoziemców, którym zezwolono na pobyt i pracę na terytorium Rzeczypospolitej Polskiej przez okres nieprzekraczający dziewięciu miesięcy, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej.</div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 818px; left: 0px; height: 345px; " class="SofBorderContainer">
            <div style="color: #000000; top: -20px; left: 10px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 14px; " class="SofLabel justified14">5.</div>
            <div style="color: #000000; top: -20px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 60px; " class="SofLabel justified14">W przypadku gdy dziecko, zgodnie z orzeczeniem sądu, jest pod opieką naprzemienną obydwojga rodziców rozwiedzionych, żyjących w separacji lub żyjących w rozłączeniu sprawowaną w porównywalnych i powtarzających się okresach, kwotę świadczenia dobry start ustala się każdemu z rodziców w wysokości połowy kwoty przysługującego świadczenia dobry start.</div>
            <div style="color: #000000; top: 32px; left: 10px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 14px; " class="SofLabel justified14">6.</div>
            <div style="color: #000000; top: 32px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified14">Świadczenie dobry start nie przysługuje:</div>
            <div style="color: #000000; top: 49px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified14">1)</div>
            <div style="color: #000000; top: 49px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 61px; " class="SofLabel justified14">jeżeli dziecko lub osoba ucząca się zostały umieszczone w domu pomocy społecznej, schronisku dla nieletnich, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatnie pełne utrzymanie;</div>
            <div style="color: #000000; top: 99px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">2)</div>
            <div style="color: #000000; top: 99px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 77px; " class="SofLabel justified14">na dziecko z tytułu rozpoczęcia rocznego przygotowania przedszkolnego.</div>
            <div style="color: #000000; top: 121px; left: 10px; width: 865px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">Niepoinformowanie gminnego organu właściwego prowadzącego postępowanie w sprawie świadczenia dobry start o zmianach, o których mowa powyżej, może skutkować powstaniem nienależnie pobranych świadczeń, a w konsekwencji koniecznością ich zwrotu wraz z odsetkami ustawowymi za opóźnienie.</div>
            <div style="color: #000000; top: 176px; left: 10px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 77px; " class="SofLabel justified14">Osoba, która pobrała nienależnie świadczenie dobry start, jest obowiązana do jego zwrotu.</div>
            <div style="color: #000000; top: 193px; left: 20px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">1.</div>
            <div style="color: #000000; top: 193px; left: 40px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 77px; " class="SofLabel justified14">Za nienależnie pobrane świadczenie dobry start uważa się:</div>
            <div style="color: #000000; top: 209px; left: 40px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">1)</div>
            <div style="color: #000000; top: 209px; left: 60px; width: 815px; font-size: 14px; position: absolute; text-align: justify; height: 44px; " class="SofLabel justified14">świadczenie dobry start wypłacone na podstawie fałszywych oświadczeń lub dokumentów albo w innych przypadkach świadomego wprowadzenia w błąd przez osobę pobierającą to świadczenie;</div>
            <div style="color: #000000; top: 244px; left: 40px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">2)</div>
            <div style="color: #000000; top: 244px; left: 60px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 72px; " class="SofLabel justified14">świadczenie dobry start wypłacone mimo braku prawa do tego świadczenia;</div>
            <div style="color: #000000; top: 261px; left: 40px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">3)</div>
            <div style="color: #000000; top: 261px; left: 60px; width: 814px; font-size: 14px; position: absolute; text-align: justify; height: 42px; " class="SofLabel justified14">świadczenie dobry start wypłacone osobie innej niż osoba uprawniona do tego świadczenia, z przyczyn niezależnych od organu, który przyznał to świadczenie.</div>
            <div style="color: #000000; top: 295px; left: 20px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 21px; " class="SofLabel justified14">2.</div>
            <div style="color: #000000; top: 295px; left: 40px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 26px; " class="SofLabel justified14">Od kwot nienależnie pobranego świadczenia dobry start naliczane są odsetki ustawowe za opóźnienie.</div>
          </div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SDS-1(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: <xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 2"/>/<xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 4"/></div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SDS-1</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 30px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified14Bold">2. OŚWIADCZENIE</div>
          <div style="color: #000000; top: 50px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified14Bold">Oświadczenie służące ustaleniu uprawnień do świadczenia dobry start:</div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 72px; left: 0px; height: 787px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 10px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 82px; " class="SofLabel justified14">Oświadczam, że:</div>
            <div style="color: #000000; top: 16px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 16px; left: 40px; width: 845px; font-size: 14px; position: absolute; text-align: justify; " class="SofLabel justified14">powyższe dane są prawdziwe,</div>
            <div style="color: #000000; top: 33px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 33px; left: 40px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified14">zapoznałam/zapoznałem się z warunkami uprawniającymi do świadczenia dobry start,</div>
            <div style="color: #000000; top: 50px; left: 30px; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 50px; left: 40px; width: 835px; font-size: 14px; position: absolute; text-align: justify; height: 61px; " class="SofLabel justified14">dziecko/osoba ucząca się, której wniosek dotyczy, nie przebywa w instytucji zapewniającej całodobowe utrzymanie, tj. w domu pomocy społecznej, młodzieżowym ośrodku wychowawczym, schronisku dla nieletnich, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatnie pełne utrzymanie,</div>
            <div style="color: #000000; top: 100px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 100px; left: 40px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 77px; " class="SofLabel justified14">na dziecko/osobę uczącą się którego wniosek dotyczy, nie został złożony wniosek w innej instytucji.</div>
            <div style="color: #000000; top: 119px; left: 10px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified14">Zgodnie z § 3 rozporządzenia ilekroć jest mowa o:</div>
            <div style="color: #000000; top: 138px; left: 10px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 22px; " class="SofLabel justified14">1)</div>
            <div style="color: #000000; top: 138px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; " class="SofLabel justified14">dziecku - oznacza to uczące się w szkole: dziecko własne, dziecko znajdujące się pod opieką opiekuna faktycznego, dziecko znajdujące się pod opieką prawną, lub dziecko, które zostało umieszczone w pieczy zastępczej oraz osobę, o której mowa w art. 37 ust. 2 ustawy z dnia 9 czerwca 2011 r. o wspieraniu rodziny i systemie pieczy zastępczej, zwanej dalej „ustawą”;</div>
            <div style="color: #000000; top: 190px; left: 10px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">2)</div>
            <div style="color: #000000; top: 190px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">opiekunie faktycznym - oznacza to osobę faktycznie opiekującą się dzieckiem, jeżeli wystąpiła z wnioskiem do sądu opiekuńczego o jego przysposobienie;</div>
            <div style="color: #000000; top: 227px; left: 10px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">3)</div>
            <div style="color: #000000; top: 227px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">osobie uczącej się - oznacza to osobę pełnoletnią uczącą się, niepozostającą na utrzymaniu rodziców w związku z ich śmiercią lub w związku z ustaleniem wyrokiem sądowym lub ugodą sądową prawa do alimentów z ich strony oraz osobę usamodzielnianą, o której mowa w ustawie;</div>
            <div style="color: #000000; top: 279px; left: 10px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">4)</div>
            <div style="color: #000000; top: 279px; left: 30px; width: 840px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">niepełnosprawności - oznacza to:</div>
            <div style="color: #000000; top: 298px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">a)</div>
            <div style="color: #000000; top: 298px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">potrzebę kształcenia specjalnego, o którym mowa w art. 127 ust. 10 ustawy z dnia 14 grudnia 2016 r. Prawo oświatowe albo potrzebę kształcenia specjalnego, o którym mowa w art. 312 ust. 1 i 2 ustawy z dnia 14 grudnia 2016 r. &#xa0;przepisy wprowadzające ustawę &#xa0;Prawo oświatowe,</div>
            <div style="color: #000000; top: 350px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">b)</div>
            <div style="color: #000000; top: 350px; left: 50px; width: 825px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">potrzebę zajęć rewalidacyjno-wychowawczych organizowanych zgodnie z przepisami o ochronie zdrowia psychicznego, o których mowa w art. 127 ust. 10 ustawy z dnia 14 grudnia 2016 r. &#xa0;Prawo oświatowe lub potrzebę zajęć rewalidacyjno-wychowawczych, o których mowa w art. 312 ust. 1 i 2 ustawy z dnia 14 grudnia 2016 r. &#xa0;Przepisy wprowadzające ustawę Prawo oświatowe,</div>
            <div style="color: #000000; top: 401px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">c)</div>
            <div style="color: #000000; top: 401px; left: 50px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">umiarkowany stopień niepełnosprawności, przez który rozumie się:</div>
            <div style="color: #000000; top: 420px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 420px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">niepełnosprawność w umiarkowanym stopniu w rozumieniu przepisów o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych;</div>
            <div style="color: #000000; top: 454px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 454px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 44px; " class="SofLabel justified14">całkowitą niezdolność do pracy orzeczoną na podstawie przepisów o emeryturach i rentach z Funduszu Ubezpieczeń Społecznych,</div>
            <div style="color: #000000; top: 486px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 486px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 32px; " class="SofLabel justified14">posiadanie orzeczenia o zaliczeniu do II grupy inwalidów,</div>
            <div style="color: #000000; top: 503px; left: 30px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">d)</div>
            <div style="color: #000000; top: 503px; left: 50px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">znaczny stopnień niepełnosprawności, przez który rozumie się:</div>
            <div style="color: #000000; top: 520px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 520px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">niepełnosprawność w stopniu znacznym w rozumieniu przepisów o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych,</div>
            <div style="color: #000000; top: 554px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 554px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">całkowitą niezdolność do pracy i samodzielnej egzystencji orzeczoną na podstawie przepisów o emeryturach i rentach z Funduszu Ubezpieczeń Społecznych,</div>
            <div style="color: #000000; top: 588px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 588px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">stałą albo długotrwałą niezdolność do pracy w gospodarstwie rolnym i do samodzielnej egzystencji albo trwałą lub okresową całkowitą niezdolność do pracy w gospodarstwie rolnym i do samodzielnej egzystencji, orzeczoną na podstawie przepisów o ubezpieczeniu społecznym rolników w celu uzyskania świadczeń określonych w tych przepisach,</div>
            <div style="color: #000000; top: 638px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 638px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">posiadanie orzeczenia o zaliczeniu do I grupy inwalidów,</div>
            <div style="color: #000000; top: 655px; left: 50px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">-</div>
            <div style="color: #000000; top: 655px; left: 70px; width: 805px; font-size: 14px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified14">niezdolność do samodzielnej egzystencji orzeczoną na podstawie przepisów o emeryturach i rentach z Funduszu Ubezpieczeń Społecznych lub przepisów o ubezpieczeniu społecznym rolników;</div>
            <div style="color: #000000; top: 691px; left: 10px; width: 800px; font-size: 14px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified14">5)</div>
            <div style="color: #000000; top: 691px; left: 30px; width: 845px; font-size: 14px; position: absolute; text-align: justify; height: 76px; " class="SofLabel justified14">szkole - oznacza to szkołę podstawową, szkołę ponadpodstawową, klasy dotychczasowej szkoły ponadgimnazjalnej prowadzone w szkole ponadpodstawowej, szkołę artystyczną, w której jest realizowany obowiązek szkolny lub nauki, a także młodzieżowy ośrodek socjoterapii, specjalny ośrodek szkolno-wychowawczy, specjalny ośrodek wychowawczy, ośrodek rewalidacyjno-wychowawczy.</div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 865px; left: 0px; height: 350px; " class="SofBorderContainer">
            <div style="color: #000000; top: -24px; left: 10px; font-weight: bold; width: 865px; font-size: 14px; position: absolute; text-align: justify; height: 144px; " class="SofLabel justified14">* UWAGA: Rodziny zastępcze, osoby prowadzące rodzinne domy dziecka, dyrektorzy placówek opiekuńczo-wychowawczych, dyrektorzy regionalnych placówek opiekuńczo-terapeutycznych, osoby uczące się będące osobami usamodzielnianymi w rozumieniu ustawy o wspieraniu rodziny i systemie pieczy zastępczej, wniosek składają bezpośrednio u starosty właściwego ze względu na zamieszkanie osoby ubiegającej się o świadczenie dobry start na dziecko umieszczone w rodzinnej pieczy zastępczej, miejsce zamieszkania osoby uczącej się będącej osobą usamodzielnianą w rozumieniu ustawy o wspieraniu rodziny i systemie pieczy zastępczej ubiegającej się o świadczenie dobry start, siedziby placówki opiekuńczo-wychowawczej lub regionalnej placówki opiekuńczo-terapeutycznej w przypadku dziecka umieszczonego w instytucjonalnej pieczy zastępczej.</div>
            <div style="color: #000000; top: 123px; left: 10px; font-weight: bold; width: 865px; font-size: 14px; position: absolute; text-align: justify; height: 86px; " class="SofLabel justified14">&#42;&#42; UWAGA: Osoby uczące się nie będące osobami usamodzielnianymi w rozumieniu ustawy o wspieraniu rodziny i systemie pieczy zastępczej, opiekunowie faktyczni i opiekunowie prawni składają wniosek bezpośrednio w organie właściwym, którym jest wójt, burmistrz lub prezydent miasta, właściwy ze względu na miejsce zamieszkania osoby ubiegającej się o świadczenie dobry start.</div>
            <div style="color: #000000; top: 201px; left: 10px; width: 865px; font-size: 14px; position: absolute; text-align: justify; height: 42px; " class="SofLabel justified14">Przyznanie świadczenia dobry start nie wymaga wydania decyzji. Odmowa przyznania świadczenia dobry start oraz rozstrzygnięcie w sprawie nienależnie pobranego świadczenia dobry start wymagają wydania decyzji.</div>
            <div style="color: #000000; top: 246px; left: 10px; width: 865px; font-size: 14px; position: absolute; text-align: justify; height: 79px; " class="SofLabel justified14">Organ właściwy przesyła wnioskodawcy informację o przyznaniu świadczenia dobry start na wskazany przez niego adres poczty elektronicznej - o ile wnioskodawca wskazał adres poczty elektronicznej we wniosku. W przypadku, gdy wnioskodawca nie wskazał adresu poczty elektronicznej organ właściwy odbierając wniosek od wnioskodawcy informuje go o możliwości odebrania od tego organu informacji o przyznaniu świadczenia dobry start.</div>
          </div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SDS-1(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: <xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 3"/>/<xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 4"/></div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1180px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SDS-1</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 35px; left: 0px; height: 301px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 10px; font-weight: bold; width: 864px; font-size: 14px; position: absolute; text-align: justify; height: 37px; " class="SofLabel justified14Bold">Proszę o wpłatę świadczenia dobry start na następujący nr rachunku bankowego/w spółdzielczej kasie oszczędnościowo-kredytowej:</div>
            <div style="width: 833px; font-size: 12px; position: absolute; color: #000000; top: 73px; left: 17px; " class="SofLabel left"></div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 36px; left: 17px; display: block; width: 625px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:NrRachunkuBankowego" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="625" />
                </xsl:call-template>
              </span>
            </div>
            <div style="color: #000000; top: 115px; left: 10px; font-weight: normal; width: 864px; font-size: 14px; font-family: arial; position: absolute; height: 18px; " class="SofLabel global14Normal">Do wniosku dołączam następujące dokumenty (oświadczenia są także dokumentami):</div>
            <div style="color: #000000; top: 151px; left: 10px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 145px; left: 34px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik1" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
                </xsl:call-template>
              </span>
            </div>
            <div style="color: #000000; top: 187px; left: 10px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">2)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 181px; left: 34px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik2" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
                </xsl:call-template>
              </span>
            </div>
            <div style="color: #000000; top: 223px; left: 10px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">3)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 217px; left: 34px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik3" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
                </xsl:call-template>
              </span>
            </div>
            <div style="color: #000000; top: 259px; left: 10px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">4)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 253px; left: 34px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik4" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
                </xsl:call-template>
              </span>
            </div>
          </div>
          <div style="color: #000000; top: 393px; left: 31px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 463px; left: 6px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
          <div style="top: 1123px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SDS-1(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: <xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 4"/>/<xsl:value-of select="(count(//wnio:TrescDokumentu/wnio:WniosekOSwiadczenieDobryStart/wnio:DaneIdentyfikacyjneDziecka)) + 4"/></div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
  </xsl:template> 
  
  <xsl:template name="notaPrawnaInnaInstytucjaSDS">
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 80px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">
          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold"></div>
        </div>
  </xsl:template>	
  
  <xsl:template name="notaPrawnaZusSDS">
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 80px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">
          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold"></div>
        </div>
  </xsl:template>	  
</xsl:stylesheet>
