<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://piu.mpips.pl/rd/SR_7Z/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>SR-7Z</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      </head>
      <body style="font-family: Arial; text-align: center; ">
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SR-7Z</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 322px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">CZĘŚĆ I</div>
          <div style="color: #000000; top: 342px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; " class="SofLabel justified14Bold">1. Dane osoby ubiegającej się o ustalenie prawa do świadczenia rodzicielskiego, zwanej dalej „osobą ubiegającą się”</div>
          <div style="top: 361px; left: 0px; width: 880px; position: absolute; height: 188px; ">
            <div style="background-color: #ebd7ff; top: 0px; left: 0px; width: 100%; border-color: #ebd7ff; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer violetAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE OSOBY UBIEGAJĄCEJ SIĘ</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 155px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
                  </span>
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 4px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 291px; " class="SofLabel">02. Data urodzenia: (dd / mm / rrrr)</div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 18px; left: 291px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:DataUrodzenia" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 507px; " class="SofLabel">03. Numer dokumentu (1)</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 507px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">03. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">04. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 721px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="color: #000000; top: 568px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">2. Wnoszę o ustalenie prawa do świadczenia rodzicielskiego na następujące dzieci:</div>
          <div style="width: 874px; font-size: 12px; position: absolute; color: #000000; top: 584px; left: 6px; " class="SofLabel">(Wypełnić tylko w przypadku, gdy liczba dzieci, na które ustala się prawo do świadczenia rodzicielskiego jest większa niż liczba pozycji na formularzu SR-7 -część I, punkt 2.)</div>
          <div style="background-color: #E7E5E6; top: 617px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 1</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:Nazwisko" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Imię:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 721px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:Imie" />
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:PESEL" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 517px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 301px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 37px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 160px; left: 14px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="background-color: #E7E5E6; top: 811px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 2</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:Nazwisko" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Imię:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 721px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:Imie" />
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:PESEL" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 517px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 301px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 37px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 160px; left: 14px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="background-color: #E7E5E6; top: 1005px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 3</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:Nazwisko" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Imię:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 721px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:Imie" />
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:PESEL" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 517px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 301px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 37px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 160px; left: 14px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SR-7Z(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: 1/2</div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 140px; left: 0px; font-weight: bold; width: 100%; font-size: 16px; position: absolute; text-align: center; height: 80px; " class="SofLabel formTitle">
            ZAŁĄCZNIK DO WNIOSKU
            <br />
            O &#xa0;USTALENIE &#xa0;PRAWA &#xa0;DO &#xa0;ŚWIADCZENIA &#xa0;RODZICIELSKIEGO
          </div>
        </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SR-7Z</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 35px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 4</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:Nazwisko" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Imię:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 721px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:Imie" />
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:PESEL" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 517px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 301px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 37px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 160px; left: 14px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="color: #000000; top: 284px; left: 13px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 384px; left: 8px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal">......................................</div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel">(Podpis podpis członka rodziny składającego oświadczenie)</div>
            </div>
          </div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: SR-7Z(2)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: 2/2</div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
