package pl.topteam.empatia_formularze.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Map;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;

import pl.topteam.empatia_formularze.utils.internal.LSResourceResolverImpl;

/**
 * @author arek
 */
public final class FormularzEmpatiiUtil {
	// Effective Java, Item 4
	private FormularzEmpatiiUtil() {}
	
	// https://en.wikipedia.org/wiki/Initialization-on-demand_holder_idiom
	private static final class JAXBContextHolder {
		public static final JAXBContext INSTANCE = newInstance();
		
		private static JAXBContext newInstance() {
			Class<?>[] classes = {
				pl.mpips.piu.rd.fa_1._1.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1._2.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1._3.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1._4.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1._5.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1z._1.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1z._2.ObjectFactory.class,
				pl.mpips.piu.rd.fa_1z._3.ObjectFactory.class,
				pl.mpips.piu.rd.fa_2._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_01._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_02._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_03._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_03._2.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_03._3.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_03._4.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_04._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_04._2.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_05._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_05._2.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_06._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_06._2.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_06._3.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_07._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_08._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_09._1.ObjectFactory.class,
				pl.mpips.piu.rd.zfa_10._1.ObjectFactory.class,
				pl.mpips.piu.rd.zs_1._1.ObjectFactory.class,
				pl.mpips.piu.rd.zs_2._1.ObjectFactory.class,
				pl.mpips.piu.rd.zs_3._1.ObjectFactory.class,
				pl.mpips.piu.rd.zs_4._1.ObjectFactory.class,
				pl.mpips.piu.rd.zs_5._1.ObjectFactory.class,
				pl.mpips.piu.rd.zs_6._1.ObjectFactory.class,
				
				pl.mpips.piu.rd.sr_1._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1._4.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1._5.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1z._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1z._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_1z._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2._4.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2._5.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2._6.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2z._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2z._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_2z._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_3._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_3._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_3._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_3._4.ObjectFactory.class,
				pl.mpips.piu.rd.sr_3._5.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4._4.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4._5.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4z._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4z._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_4z._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_5._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_5._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_5._4.ObjectFactory.class,
				pl.mpips.piu.rd.sr_5._5.ObjectFactory.class,
				pl.mpips.piu.rd.sr_5._6.ObjectFactory.class,
				pl.mpips.piu.rd.sr_6._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_6z._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7._3.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7._4.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7._5.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7._6.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7z._1.ObjectFactory.class,
				pl.mpips.piu.rd.sr_7z._2.ObjectFactory.class,
				pl.mpips.piu.rd.sr_8._1.ObjectFactory.class,
				pl.gov.mpips.piu.rd.sw_1._1.ObjectFactory.class,
				pl.mpips.piu.rd.sw_1._2.ObjectFactory.class,
				pl.mpips.piu.rd.sw_1._3.ObjectFactory.class,
				pl.mpips.piu.rd.sw_1._4.ObjectFactory.class,
				pl.mpips.piu.rd.sw_1._5.ObjectFactory.class,
				pl.mpips.piu.rd.sds_1._1.ObjectFactory.class,
				pl.mpips.piu.rd.sds_1._2.ObjectFactory.class,

				pl.mpips.piu.rd.zsr_01._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_02._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_03._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_04._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_05._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_05._2.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_05._3.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_05._4.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_06._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_07._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_08._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_09._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_10._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_11._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_12._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_13._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_14._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_15._1.ObjectFactory.class,
				pl.mpips.piu.rd.zsr_16._1.ObjectFactory.class,
				
				pl.gov.mpips.xsd.csizs.pi.mkm.dok.ogolne.v2.ObjectFactory.class,

				pl.gov.crd.xml.schematy.upo._2008._05._09.ObjectFactory.class
			};
			try {
				return JAXBContext.newInstance(classes);
			} catch (JAXBException e) {
				throw new RuntimeException(e);
			}
		}
	}
	
	// https://en.wikipedia.org/wiki/Initialization-on-demand_holder_idiom
	private static final class SchemaContextHolder {
		private static final Schema INSTANCE = newSchema();
		
		private static Schema newSchema() {
			String[] xsd = {
				"pl/gov/mpips/piu/rd/sw_1/_1/schemat.xsd",
				"pl/gov/mpips/xsd/csizs/pi/mkm/dok/ogolne/v2/schemat.xsd",
				"pl/mpips/piu/rd/fa_1/_1/schemat.xsd",
				"pl/mpips/piu/rd/fa_1/_2/schemat.xsd",
				"pl/mpips/piu/rd/fa_1/_3/schemat.xsd",
				"pl/mpips/piu/rd/fa_1/_4/schemat.xsd",
				"pl/mpips/piu/rd/fa_1/_5/schemat.xsd",
				"pl/mpips/piu/rd/fa_1z/_1/schemat.xsd",
				"pl/mpips/piu/rd/fa_1z/_2/schemat.xsd",
				"pl/mpips/piu/rd/fa_1z/_3/schemat.xsd",
				"pl/mpips/piu/rd/fa_2/_1/schemat.xsd",
				"pl/mpips/piu/rd/sds_1/_1/schemat.xsd",
				"pl/mpips/piu/rd/sds_1/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_1/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_1/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_1/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_1/_4/schemat.xsd",
				"pl/mpips/piu/rd/sr_1/_5/schemat.xsd",
				"pl/mpips/piu/rd/sr_1z/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_1z/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_1z/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_2/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_2/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_2/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_2/_4/schemat.xsd",
				"pl/mpips/piu/rd/sr_2/_5/schemat.xsd",
				"pl/mpips/piu/rd/sr_2/_6/schemat.xsd",
				"pl/mpips/piu/rd/sr_2z/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_2z/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_2z/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_3/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_3/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_3/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_3/_4/schemat.xsd",
				"pl/mpips/piu/rd/sr_3/_5/schemat.xsd",
				"pl/mpips/piu/rd/sr_4/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_4/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_4/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_4/_4/schemat.xsd",
				"pl/mpips/piu/rd/sr_4/_5/schemat.xsd",
				"pl/mpips/piu/rd/sr_4z/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_4z/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_4z/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_5/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_5/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_5/_4/schemat.xsd",
				"pl/mpips/piu/rd/sr_5/_5/schemat.xsd",
				"pl/mpips/piu/rd/sr_5/_6/schemat.xsd",
				"pl/mpips/piu/rd/sr_6/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_6z/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_7/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_7/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_7/_3/schemat.xsd",
				"pl/mpips/piu/rd/sr_7/_4/schemat.xsd",
				"pl/mpips/piu/rd/sr_7/_5/schemat.xsd",
				"pl/mpips/piu/rd/sr_7/_6/schemat.xsd",
				"pl/mpips/piu/rd/sr_7z/_1/schemat.xsd",
				"pl/mpips/piu/rd/sr_7z/_2/schemat.xsd",
				"pl/mpips/piu/rd/sr_8/_1/schemat.xsd",
				"pl/mpips/piu/rd/sw_1/_2/schemat.xsd",
				"pl/mpips/piu/rd/sw_1/_3/schemat.xsd",
				"pl/mpips/piu/rd/sw_1/_4/schemat.xsd",
				"pl/mpips/piu/rd/sw_1/_5/schemat.xsd",
				"pl/mpips/piu/rd/zfa_01/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_02/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_03/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_03/_2/schemat.xsd",
				"pl/mpips/piu/rd/zfa_03/_3/schemat.xsd",
				"pl/mpips/piu/rd/zfa_03/_4/schemat.xsd",
				"pl/mpips/piu/rd/zfa_04/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_04/_2/schemat.xsd",
				"pl/mpips/piu/rd/zfa_05/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_05/_2/schemat.xsd",
				"pl/mpips/piu/rd/zfa_06/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_06/_2/schemat.xsd",
				"pl/mpips/piu/rd/zfa_06/_3/schemat.xsd",
				"pl/mpips/piu/rd/zfa_07/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_08/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_09/_1/schemat.xsd",
				"pl/mpips/piu/rd/zfa_10/_1/schemat.xsd",
				"pl/mpips/piu/rd/zs_1/_1/schemat.xsd",
				"pl/mpips/piu/rd/zs_2/_1/schemat.xsd",
				"pl/mpips/piu/rd/zs_3/_1/schemat.xsd",
				"pl/mpips/piu/rd/zs_4/_1/schemat.xsd",
				"pl/mpips/piu/rd/zs_5/_1/schemat.xsd",
				"pl/mpips/piu/rd/zs_6/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_01/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_02/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_03/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_04/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_05/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_05/_2/schemat.xsd",
				"pl/mpips/piu/rd/zsr_05/_3/schemat.xsd",
				"pl/mpips/piu/rd/zsr_05/_4/schemat.xsd",
				"pl/mpips/piu/rd/zsr_06/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_07/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_08/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_09/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_10/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_11/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_12/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_13/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_14/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_15/_1/schemat.xsd",
				"pl/mpips/piu/rd/zsr_16/_1/schemat.xsd",
				"pl/gov/crd/xml/schematy/upo/2008/05/09/upo.xsd"
			};
			Map<String, String> rewrites = ImmutableMap.<String, String>builder()
				.put("datatypes.dtd", "org/w3/www/2001/datatypes.dtd")
				.put("http://www.w3.org/2001/XMLSchema.dtd", "org/w3/www/2001/XMLSchema.dtd")
				.put("http://www.w3.org/TR/xmldsig-core/xmldsig-core-schema.xsd", "org/w3/www/TR/xmldsig-core/xmldsig-core-schema.xsd")
				.put("http://crd.gov.pl/xml/schematy/zewnetrzne/2008/05/09/CountryCode.xsd", "pl/gov/crd/xml/schematy/zewnetrzne/2008/05/09/CountryCode.xsd")
				.put("http://crd.gov.pl/xml/schematy/zewnetrzne/2008/05/09/iso639-2.xsd", "pl/gov/crd/xml/schematy/zewnetrzne/2008/05/09/iso639-2.xsd")
				.put("http://crd.gov.pl/xml/schematy/adres/2009/11/09/adres.xsd", "pl/gov/crd/xml/schematy/adres/2009/11/09/adres.xsd")
				.put("http://crd.gov.pl/xml/schematy/adres/2008/05/09/adres.xsd", "pl/gov/crd/xml/schematy/adres/2008/05/09/adres.xsd")
				.put("http://crd.gov.pl/xml/schematy/osoba/2009/11/16/osoba.xsd", "pl/gov/crd/xml/schematy/osoba/2009/11/16/osoba.xsd")
				.put("http://crd.gov.pl/xml/schematy/osoba/2008/05/09/osoba.xsd", "pl/gov/crd/xml/schematy/osoba/2008/05/09/osoba.xsd")
				.put("http://crd.gov.pl/xml/schematy/meta/2009/11/16/meta.xsd", "pl/gov/crd/xml/schematy/meta/2009/11/16/meta.xsd")
				.put("http://crd.gov.pl/xml/schematy/meta/2008/05/09/meta.xsd", "pl/gov/crd/xml/schematy/meta/2008/05/09/meta.xsd")
				.put("http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/instytucja.xsd", "pl/gov/crd/xml/schematy/instytucja/2009/11/16/instytucja.xsd")
				.put("http://crd.gov.pl/xml/schematy/instytucja/2008/05/09/instytucja.xsd", "pl/gov/crd/xml/schematy/instytucja/2008/05/09/instytucja.xsd")
				.put("http://crd.gov.pl/xml/schematy/struktura/2009/11/16/struktura.xsd", "pl/gov/crd/xml/schematy/struktura/2009/11/16/struktura.xsd")
				.put("http://crd.gov.pl/xml/schematy/struktura/2008/05/09/struktura.xsd", "pl/gov/crd/xml/schematy/struktura/2008/05/09/struktura.xsd")
				.build();
			try {
				Source[] schemas = Arrays.stream(xsd)
					.map(Resources::getResource)
					.map(Object::toString)
					.map(StreamSource::new)
					.toArray(Source[]::new);
				SchemaFactory schemaFactory = SchemaFactory
					.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
				schemaFactory.setResourceResolver(
					new LSResourceResolverImpl(rewrites)
				);
				return schemaFactory
					.newSchema(schemas);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
	}
	
	public static Object wczytaj(byte[] tresc) {
		try {
			Unmarshaller unmarshaller = JAXBContextHolder.INSTANCE.createUnmarshaller();
			JAXBElement<?> element = (JAXBElement<?>) unmarshaller.unmarshal(new ByteArrayInputStream(tresc));
			return element.getValue();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	public static String drukuj(byte[] tresc) {
		Object formularz = wczytaj(tresc);
		try (InputStream styl = formularz.getClass().getResourceAsStream("styl.xsl")) {
			Preconditions.checkNotNull(styl, "nie udało się odnaleźć xsl dla klasy: %s", formularz.getClass());
			return transformuj(tresc, styl);
		} catch (IOException | TransformerException e) {
			throw new RuntimeException(e);
		}
	}
	
	private static String transformuj(byte[] tresc, InputStream styl) throws TransformerException {
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer(new StreamSource(styl));
		Source xmlSource = new StreamSource(new ByteArrayInputStream(tresc));
		StringWriter sw = new StringWriter();
		transformer.transform(xmlSource, new StreamResult(sw));
		return sw.toString();
	}

	public static void waliduj(byte[] tresc) {
		try {
			Validator validator = SchemaContextHolder.INSTANCE.newValidator();
			validator.validate(new StreamSource(new ByteArrayInputStream(tresc)));
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
