package pl.topteam.empatia_formularze.utils.internal;

import java.util.Map;

import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

import com.google.common.io.Resources;

public class LSResourceResolverImpl implements LSResourceResolver {
	private final Map<String, String> rewrites;

	public LSResourceResolverImpl(Map<String, String> rewrites) {
		this.rewrites = rewrites;
	}

	@Override
	public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
		String resourceName = rewrites.get(systemId);
		return resourceName == null ? null : new LSInputImpl() {
			@Override
			public String getSystemId() {
				return Resources.getResource(resourceName).toExternalForm();
			}
		};
	}
}
