<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/ZFA_02/1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>ZFA-02 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      </head>
      <body style="text-align: center; font-family: Arial; ">
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZFA-02</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page" />
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="position: absolute; height: 194px; width: 880px; left: 0px; top: 264px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="position: absolute; height: 161px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">03. Numer PESEL</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 3px; top: 143px; " class="SofLabel"></div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 93px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:NumerDokumentu" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 181px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 479px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE CZŁONKA RODZINY, KTÓREGO DOTYCZY OŚWIADCZENIE</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Numer PESEL</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 112px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 301px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:NumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 13px; top: 162px; " class="SofLabel"></div>
          </div>
          <div style="position: absolute; height: 47px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 810px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; height: 47px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 902px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 700px; " class="SofLabel global14Normal">Oświadczam, że w roku kalendarzowym:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 388px; font-family: arial; font-weight: normal; top: 700px; " class="SofLabel global14Normal">uzyskałam / uzyskałem dochód z działalności opodatkowanej w formie:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 277px; top: 679px; " class="SofLabel">Rok (rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 97px; font-size: 18px; background-color: white; display: block; left: 277px; border: 1px solid black; top: 692px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:Oswiadczenie/wnio:RokPodatkowy" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="97" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 738px; " class="SofLabel global14Normal">ryczałtu ewidencjonowanego,</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 730px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:Oswiadczenie/wnio:FormaOpodatkowania/wnio:RyczaltEwidencjonowany='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 774px; " class="SofLabel global14Normal">karty podatkowej.</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 766px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:Oswiadczenie/wnio:FormaOpodatkowania/wnio:KartaPodatkowa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 828px; " class="SofLabel global14Normal">1. Dochód po odliczeniu kwot z pozycji 2-4 wyniósł:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 828px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 820px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OsiagnietyDochod,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 874px; " class="SofLabel global14Normal">2. Należne składki na ubezpieczenia społeczne wyniosły:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 874px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 866px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:UbezpieczenieSpoleczne,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 920px; " class="SofLabel global14Normal">3. Należne składki na ubezpieczenie zdrowotne wyniosły:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 920px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 912px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:UbezpieczenieZdrowotne,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 966px; " class="SofLabel global14Normal">4. Należny zryczałtowany podatek dochodowy wyniósł:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 966px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 958px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:PodatekZryczaltowanyNalezny,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 30px; font-family: arial; font-weight: normal; top: 1045px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 1125px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: ZFA-02(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 1/1</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="position: absolute; height: 110px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 70px; " class="SofLabel formTitle">
            OŚWIADCZENIE WNIOSKODAWCY
            <br />
            O DOCHODZIE CZŁONKA RODZINY ROZLICZAJĄCEGO SIĘ NA PODSTAWIE
            <br />
            PRZEPISÓW O ZRYCZAŁTOWANYM PODATKU DOCHODOWYM OD NIEKTÓRYCH
            <br />
            PRZYCHODÓW OSIĄGNIĘTYCH PRZEZ OSOBY FIZYCZNE, O DOCHODZIE OSIĄGNIĘTYM
            <br />
            W ROKU KALENDARZOWYM POPRZEDZAJĄCYM OKRES ŚWIADCZENIOWY
          </div>
          </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
