<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://piu.mpips.pl/rd/ZFA_06/1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>ZFA-06 (Formularz) - Ministerstwo Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"></meta>
      </head>
      <body style="text-align: center; font-family: Arial; ">
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZFA-06</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 6px; " class="SofLabel page"></span>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 25px; " class="SofHRule">
              <span></span>
            </div>
          </div>
          <div style="position: absolute; height: 188px; width: 880px; left: 0px; top: 300px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 6px; " class="SofLabel sectionHeader">DANE OSOBY UBIEGAJĄCEJ SIĘ</div>
              <div style="position: absolute; height: 155px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 3px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:PESEL"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 135px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 3px; " class="SofLabel">02. Numer dokumentu (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:NumerDokumentu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 47px; " class="SofLabel">03. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 91px; " class="SofLabel">04. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Imie"></xsl:value-of>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 92px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 497px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 6px; " class="SofLabel sectionHeader">ORGAN PROWADZĄCY EGZEKUCJĘ</div>
            <div style="position: absolute; height: 68px; width: 869px; background-color: #E7E5E6; border-color: #E7E5E6; left: 10px; top: 23px; " class="SofBorderContainer lightGrayAll">
              <div style="position: absolute; line-height: 20px; height: 54px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
                <div style="padding-left:5px ; padding-top:2px; display: block;">
                  <xsl:call-template name="formatTextArea">
                    <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuProwadzacegoEgzekucje"></xsl:with-param>
                    <xsl:with-param name="wysokosc" select="54"></xsl:with-param>
                    <xsl:with-param name="szerokosc" select="865"></xsl:with-param>
                    <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                    <xsl:with-param name="wysokoscLini" select="20"></xsl:with-param>
                    <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"></xsl:with-param>
                    <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuProwadzacegoEgzekucje"></xsl:with-param>
                  </xsl:call-template>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 207px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 598px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 5px; " class="SofLabel sectionHeader">DANE ADRESOWE ORGANU PROWADZĄCEGO EGZEKUCJĘ</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 67px; " class="SofLabel">Kod pocztowy</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 82px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;display: block;">
                <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:KodPocztowy!= ''">
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:KodPocztowy, 1, 2)"></xsl:value-of>
                  -
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:KodPocztowy, 3, 4)"></xsl:value-of>
                </xsl:if>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 181px; top: 67px; " class="SofLabel">Miejscowość</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 672px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 181px; border: 1px solid black; top: 82px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:Miejscowosc"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="672"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 22px; " class="SofLabel">Gmina / Dzielnica</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:GminaDzielnica"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 111px; " class="SofLabel">Ulica</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 126px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:Ulica"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 155px; " class="SofLabel">Numer domu</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 170px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:NumerDomu"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 205px; top: 155px; " class="SofLabel">Numer lokalu</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 205px; border: 1px solid black; top: 170px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje/wnio:NumerLokalu"></xsl:value-of>
              </span>
            </div>
          </div>
          <div style="position: absolute; height: 262px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 914px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 5px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE ZOBOWIĄZANEGO</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 110px; " class="SofLabel">Nazwisko</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Nazwisko"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 154px; " class="SofLabel">Imię</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 169px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Imie"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 22px; " class="SofLabel">Numer PESEL (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:PESEL"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 22px; " class="SofLabel">Numer dokumentu potwierdzającgo tożsamość (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:SeriaINumerDokumentu"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 66px; " class="SofLabel">Data urodzenia (dd / mm / rrrr) (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:DataUrodzenia"></xsl:with-param>
                </xsl:call-template>
              </span>
              <span></span>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 198px; " class="SofLabel">Obywatelstwo (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 213px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Obywatelstwo"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 242px; " class="SofLabel">(1) Należy podać, jeżeli są znane.</div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 844px; " class="SofLabel global14Normal">Data wszczęcia egzekucji:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 181px; top: 823px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 181px; border: 1px solid black; top: 838px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataWszczeciaEgzekucji"></xsl:with-param>
              </xsl:call-template>
            </span>
            <span></span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 882px; " class="SofLabel global14Normal">Oświadczam, że w okresie ostatnich dwóch miesięcy egzekucja alimentów należnych od:</div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 1px; " class="SofLabel footnote">wersja: ZFA-06(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 1px; " class="SofLabel footnote">strona: 1/2</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 1px; " class="SofHRule">
              <span></span>
            </div>
          </div>
          <div style="position: absolute; height: 100px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 111px; " class="SofLabel formTitle">
            OŚWIADCZENIE
            <br></br>
            O BEZSKUTECZNOŚCI EGZEKUCJI ALIMENTÓW
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZFA-06</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 6px; " class="SofLabel page"></span>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 25px; " class="SofHRule">
              <span></span>
            </div>
          </div>
          <div style="position: absolute; height: 262px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 35px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 5px; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA ZOBOWIĄZANEGO (jeżeli są znane)</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 67px; " class="SofLabel">Kod pocztowy</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 82px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;display: block;">
                <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy!= ''">
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy, 1, 2)"></xsl:value-of>
                  -
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy, 3, 4)"></xsl:value-of>
                </xsl:if>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 181px; top: 67px; " class="SofLabel">Miejscowość</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 673px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 181px; border: 1px solid black; top: 82px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:Miejscowosc"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="673"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 22px; " class="SofLabel">Gmina / Dzielnica</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:GminaDzielnica"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 111px; " class="SofLabel">Ulica</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 126px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:Ulica"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 155px; " class="SofLabel">Numer domu</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 170px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NumerDomu"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 205px; top: 155px; " class="SofLabel">Numer lokalu</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 205px; border: 1px solid black; top: 170px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NumerLokalu"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 189px; font-size: 12px; left: 13px; top: 199px; " class="SofLabel">Zagraniczny kod pocztowy (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 289px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 214px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:ZagranicznyKodPocztowy"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 325px; top: 199px; " class="SofLabel">Nazwa państwa (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 325px; border: 1px solid black; top: 214px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NazwaPanstwa"></xsl:with-param>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552"></xsl:with-param>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 14px; top: 243px; " class="SofLabel">(1) Wypełnić w przypadku, gdy adres jest inny niż polski.</div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 314px; " class="SofLabel global14Normal">przyznanych dla:</div>
          <div style="position: absolute; height: 175px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 346px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 5px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE OSOBY, KTÓREJ PRZYZNANO ALIMENTY</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 66px; " class="SofLabel">Nazwisko</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:Nazwisko"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 110px; " class="SofLabel">Imię</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:Imie"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 22px; " class="SofLabel">Numer PESEL (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:PESEL"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 22px; " class="SofLabel">Numer dokumentu (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:NumerDokumentu"></xsl:value-of>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 154px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 559px; " class="SofLabel global14Normal">orzeczeniem sądu z dnia:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 181px; top: 538px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 181px; border: 1px solid black; top: 553px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataOrzeczeniaSadu"></xsl:with-param>
              </xsl:call-template>
            </span>
            <span></span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 388px; font-family: arial; font-weight: normal; top: 559px; " class="SofLabel global14Normal">sygnatura akt:</div>
          <div style="position: absolute; height: 27px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 385px; font-size: 18px; background-color: white; display: block; left: 485px; border: 1px solid black; top: 553px; " class="SofTextInput dotted">
            <span style="padding-left:5px ;line-height:27px;padding-right: 5px; display: block;">
              <xsl:value-of select="//wnio:TrescDokumentu/wnio:SygnaturaAkt"></xsl:value-of>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 595px; " class="SofLabel global14Normal">w wysokości miesięcznie:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 383px; font-family: arial; font-weight: normal; top: 595px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 633px; " class="SofLabel global14Normal">EGZEKUCJA&#xa0;&#xa0;ALIMENÓW okazała się bezskuteczna (1).</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 181px; border: 1px solid black; top: 589px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:WysokoscAlimentow,'.',',')"></xsl:value-of>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 801px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 866px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 36px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc"></xsl:value-of>
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data"></xsl:with-param>
                  </xsl:call-template>
                </span>
                <span></span>
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 36px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 20px; " class="SofLabel paragraph14Normal">......................................</div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 39px; " class="SofLabel">(Podpis osoby ubiegającej się składającej oświadczenie)</div>
            </div>
          </div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 860px; font-size: 12px; left: 14px; top: 651px; " class="SofLabel justified">
            (1) Bezskuteczność egzekucji - zgodnie z art. 2 pkt 2 ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. z 2009 r. Nr 1, poz. 7, z późn. zm.) - oznacza egzekucję, w wyniku której w okresie ostatnich dwóch miesięcy nie wyegzekwowano pełnej należności z tytułu zaległych i bieżących zobowiązań alimentacyjnych. Za bezskuteczną egzekucję uważa się również niemożność wszczęcia lub prowadzenia egzekucji alimentów przeciwko dłużnikowi
            <br></br>
            alimentacyjnemu przebywającemu poza granicami Rzeczypospolitej Polskiej, w szczególności z powodu:
          </div>
          <div style="position: absolute; color: #000000; width: 812px; font-size: 12px; left: 24px; top: 708px; " class="SofLabel">
            a) braku podstawy prawnej do pojęcia czynności zmierzających do wykonania tytułu wykonawczego w miejscu zamieszkania dłużnika,
            <br></br>
            b) braku możliwości wskazania przez osobę uprawnioną miejsca zamieszkania dłużnika alimentacyjnego za granicą.
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 1px; " class="SofLabel footnote">wersja: ZFA-06(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 1px; " class="SofLabel footnote">strona: 2/2</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 1px; " class="SofHRule">
              <span></span>
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates></xsl:apply-templates>
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates></xsl:apply-templates>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates></xsl:apply-templates>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="."></xsl:value-of>
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates></xsl:apply-templates>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="dlugoscPolaWPikselach"></xsl:param>
    <xsl:variable name="dlugoscTekstuWPikselach">
      <!-- chodzi o makstylana dlugosc - przypadek kiedy caly tekst skladal sie z liter 'W' -->
      <xsl:value-of select="string-length($tekst) * $bazowyRozmiarCzcionki"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="roznicaDlugosciTekstuIPolaWPikselach">
      <xsl:value-of select="$dlugoscTekstuWPikselach - $dlugoscPolaWPikselach"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$roznicaDlugosciTekstuIPolaWPikselach &lt; 0">1</xsl:when>
        <xsl:otherwise>
          <xsl:variable name="ulamekOJakiZmniejszamyCzcionke">
            <xsl:value-of select="($roznicaDlugosciTekstuIPolaWPikselach div $dlugoscTekstuWPikselach)"></xsl:value-of>
          </xsl:variable>
          <xsl:value-of select="1 - $ulamekOJakiZmniejszamyCzcionke"></xsl:value-of>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'em')"></xsl:value-of>
      </xsl:attribute>
      <xsl:value-of select="$tekst"></xsl:value-of>
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc"></xsl:param>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)"></xsl:value-of>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"></xsl:value-of>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"></xsl:value-of>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc"></xsl:param>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)"></xsl:value-of>
      -
      <xsl:value-of select="substring($wartosc, 3, 4)"></xsl:value-of>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="wysokosc"></xsl:param>
    <xsl:param name="szerokosc"></xsl:param>
    <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="wysokoscLini"></xsl:param>
    <xsl:param name="liczbaPrzejscDoNowychLini"></xsl:param>
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini"></xsl:param>
    <xsl:choose>
      <xsl:when test="contains($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')">
        <xsl:call-template name="formatTextArea">
          <xsl:with-param name="tekst" select="$tekst"></xsl:with-param>
          <xsl:with-param name="wysokosc" select="$wysokosc"></xsl:with-param>
          <xsl:with-param name="szerokosc" select="$szerokosc"></xsl:with-param>
          <xsl:with-param name="bazowyRozmiarCzcionki" select="$bazowyRozmiarCzcionki"></xsl:with-param>
          <xsl:with-param name="wysokoscLini" select="$wysokoscLini"></xsl:with-param>
          <xsl:with-param name="liczbaPrzejscDoNowychLini" select="$liczbaPrzejscDoNowychLini + 1"></xsl:with-param>
          <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini">
            <xsl:value-of select="substring-after($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')"></xsl:value-of>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="redukcjaCzcionkiTextArea">
          <xsl:with-param name="tekst" select="$tekst"></xsl:with-param>
          <xsl:with-param name="wysokosc" select="$wysokosc"></xsl:with-param>
          <xsl:with-param name="szerokosc" select="$szerokosc"></xsl:with-param>
          <xsl:with-param name="bazowyRozmiarCzcionki" select="$bazowyRozmiarCzcionki"></xsl:with-param>
          <xsl:with-param name="wysokoscLini" select="$wysokoscLini"></xsl:with-param>
          <xsl:with-param name="liczbaPrzejscDoNowychLini" select="$liczbaPrzejscDoNowychLini"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionkiTextArea">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="wysokosc"></xsl:param>
    <xsl:param name="szerokosc"></xsl:param>
    <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="wysokoscLini"></xsl:param>
    <xsl:param name="liczbaPrzejscDoNowychLini"></xsl:param>
    <xsl:variable name="liczbaLini">
      <xsl:value-of select="floor((string-length($tekst) * $bazowyRozmiarCzcionki) div $szerokosc) + $liczbaPrzejscDoNowychLini"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="liczbaLiniKtoraSieMiesci">
      <xsl:value-of select="ceiling($wysokosc div $wysokoscLini)"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="roznicaLiczyLini">
      <xsl:value-of select="$liczbaLini - $liczbaLiniKtoraSieMiesci"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$roznicaLiczyLini &lt; 0">1</xsl:when>
        <xsl:otherwise>
          <xsl:variable name="ulamekOJakiZmniejszamyCzcionke">
            <xsl:value-of select="$liczbaLini div $liczbaLiniKtoraSieMiesci"></xsl:value-of>
          </xsl:variable>
          <xsl:value-of select="1 div $ulamekOJakiZmniejszamyCzcionke"></xsl:value-of>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="docelowaWysokoscLini">
      <xsl:value-of select="($wysokoscLini * $docelowyRozmiarCzcionki)"></xsl:value-of>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'em;', 'line-height:', $docelowaWysokoscLini, 'px; word-wrap : break-word;')"></xsl:value-of>
      </xsl:attribute>
      <!--<xsl:value-of select="substring-before($tekst,'&#xA;')"></xsl:value-of> -->
      <xsl:call-template name="podzialTekstuWTextArea">
        <xsl:with-param name="tekst" select="$tekst"></xsl:with-param>
        <xsl:with-param name="docelowyRozmiarCzcionki" select="$docelowyRozmiarCzcionki"></xsl:with-param>
        <xsl:with-param name="docelowaWysokoscLini" select="$docelowaWysokoscLini"></xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>
  <xsl:template name="podzialTekstuWTextArea">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="docelowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="docelowaWysokoscLini"></xsl:param>
    <xsl:choose>
      <xsl:when test="contains($tekst,'&#xA;')">
        <div>
          <xsl:value-of select="substring-before($tekst,'&#xA;')"></xsl:value-of>
        </div>
        <xsl:call-template name="podzialTekstuWTextArea">
          <xsl:with-param name="tekst" select="substring-after($tekst,'&#xA;')"></xsl:with-param>
          <xsl:with-param name="docelowyRozmiarCzcionki" select="$docelowyRozmiarCzcionki"></xsl:with-param>
          <xsl:with-param name="docelowaWysokoscLini" select="$docelowaWysokoscLini"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <div>
          <xsl:value-of select="$tekst"></xsl:value-of>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
