<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/ZFA_06/3/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>ZFA-06 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      </head>
      <body style="font-family: Arial; text-align: center; ">
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">ZFA-06</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="top: 249px; left: 0px; width: 880px; position: absolute; height: 194px; ">
            <div style="background-color: #ebd7ff; top: 0px; left: 0px; width: 100%; border-color: #ebd7ff; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer violetAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 161px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 143px; left: 3px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 463px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 88px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">WPISZ ORGAN PROWADZĄCY EGZEKUCJĘ ALIMENTÓW</div>
            <div style="background-color: #E7E5E6; top: 28px; left: 10px; width: 869px; border-color: #E7E5E6; position: absolute; height: 56px; " class="SofBorderContainer lightGrayAll">
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 1px; left: 3px; display: block; width: 850px; font-size: 18px; position: absolute; height: 54px; " class="SofTextArea dotted">
                <div style="padding-left:5px ; padding-top:2px; display: block;">
                  <xsl:call-template name="formatTextArea">
                    <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuProwadzacegoEgzekucje" />
                    <xsl:with-param name="wysokosc" select="54" />
                    <xsl:with-param name="szerokosc" select="850" />
                    <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                    <xsl:with-param name="wysokoscLini" select="20" />
                    <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                    <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuProwadzacegoEgzekucje" />
                  </xsl:call-template>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 560px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 196px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE ADRESOWE ORGANU PROWADZĄCEGO EGZEKUCJĘ ALIMENTÓW</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 28px; left: 13px; display: block; width: 850px; font-size: 18px; position: absolute; height: 162px; " class="SofTextArea dotted">
              <div style="padding-left:5px ; padding-top:2px; display: block;">
                <xsl:call-template name="formatTextArea">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje" />
                  <xsl:with-param name="wysokosc" select="162" />
                  <xsl:with-param name="szerokosc" select="850" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="wysokoscLini" select="20" />
                  <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                  <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje" />
                </xsl:call-template>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 895px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 226px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE ZOBOWIĄZANEGO DO ALIMENTÓW</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 517px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Data urodzenia (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 13px; " class="SofLabel">Obywatelstwo</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 169px; left: 13px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 205px; left: 13px; " class="SofLabel"></div>
          </div>
          <div style="color: #000000; top: 803px; left: 13px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">Data wszczęcia egzekucji:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 782px; left: 204px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 795px; left: 204px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataWszczeciaEgzekucji" />
              </xsl:call-template>
            </span>
            <span />
          </div>
          <div style="color: #000000; top: 861px; left: 13px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">Oświadczam, że w okresie ostatnich dwóch miesięcy egzekucja alimentów należnych od:</div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: ZFA-06(3)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: 1/2</div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 70px; left: 0px; font-weight: bold; width: 100%; font-size: 16px; position: absolute; text-align: center; height: 70px; " class="SofLabel formTitle">
            OŚWIADCZENIE WNIOSKODAWCY
            <br />
            O BEZSKUTECZNOŚCI EGZEKUCJI ALIMENTÓW
          </div>
          </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">ZFA-06</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 30px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 270px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA ZOBOWIĄZANEGO (jeżeli jest znany)</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 69px; left: 13px; " class="SofLabel">Kod pocztowy</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 82px; left: 13px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;display: block;">
                <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy!= ''">
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy, 1, 2)" />
                  -
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy, 3, 4)" />
                </xsl:if>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 69px; left: 181px; " class="SofLabel">Miejscowość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 82px; left: 181px; display: block; width: 697px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:Miejscowosc" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Gmina / Dzielnica</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:GminaDzielnica" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 113px; left: 13px; " class="SofLabel">Ulica</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 126px; left: 13px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:Ulica" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 157px; left: 13px; " class="SofLabel">Numer domu</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 170px; left: 13px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NumerDomu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="169" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 157px; left: 205px; " class="SofLabel">Numer mieszkania</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 170px; left: 205px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NumerLokalu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="169" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 189px; font-size: 12px; position: absolute; color: #000000; top: 201px; left: 13px; " class="SofLabel">Zagraniczny kod pocztowy</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 214px; left: 13px; display: block; width: 289px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:ZagranicznyKodPocztowy" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="289" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 201px; left: 325px; " class="SofLabel">Nazwa państwa</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 214px; left: 325px; display: block; width: 553px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NazwaPanstwa" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="553" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 790px; font-size: 12px; position: absolute; color: #000000; top: 251px; left: 13px; " class="SofLabel"></div>
          </div>
          <div style="color: #000000; top: 321px; left: 13px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">przyznanych dla:</div>
          <div style="background-color: #E7E5E6; top: 355px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 181px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE OSOBY, KTÓREJ PRZYZNANO ALIMENTY</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Data urodzenia (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 517px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 162px; left: 13px; " class="SofLabel"></div>
          </div>
          <div style="color: #000000; top: 570px; left: 13px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">tytułem wykonawczym (np. wyrok sądu) z dnia:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 549px; left: 324px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 562px; left: 324px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataOrzeczeniaSadu" />
              </xsl:call-template>
            </span>
            <span />
          </div>
          <div style="color: #000000; top: 570px; left: 531px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">sygnatura akt:</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 562px; left: 628px; display: block; width: 251px; font-size: 18px; position: absolute; height: 27px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:27px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SygnaturaAkt" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="251" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 606px; left: 13px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">w wysokości miesięcznie:</div>
          <div style="color: #000000; top: 606px; left: 382px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł.</div>
          <div style="color: #000000; top: 644px; left: 13px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">EGZEKUCJA&#xa0;&#xa0;ALIMENTÓW - OKAZAŁA SIĘ BEZSKUTECZNA(1).</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 598px; left: 180px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:WysokoscAlimentow,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 823px; left: 30px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 923px; left: 8px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
          <div style="color: #000000; top: 668px; left: 13px; width: 860px; font-size: 12px; position: absolute; text-align: justify; height: 100px; " class="SofLabel justified">(1) Za bezskuteczną uważa się egzekucję (art. 2 pkt 2 ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów) w wyniku której w okresie ostatnich dwóch miesięcy nie wyegzekwowano pełnej należności z tytułu zaległych i bieżących zobowiązań alimentacyjnych, albo postępowanie upadłościowe, w toku którego w okresie ostatnich dwóch miesięcy nie otrzymano pełnej należności z tytułu zaległych i bieżących zobowiązań alimentacyjnych.</div>
          <div style="color: #000000; top: 710px; left: 13px; width: 860px; font-size: 12px; position: absolute; text-align: justify; height: 100px; " class="SofLabel justified">Za bezskuteczną egzekucję uważa się również niemożność wszczęcia lub prowadzenia egzekucji alimentów przeciwko dłużnikowi alimentacyjnemu przebywającemu poza granicami Rzeczpospolitej Polskiej, w szczególności z powodu: braku podstawy prawnej do podjęcia czynności zmierzających do wykonania tytułu wykonawczego w miejscu zamieszania dłużnika, braku możliwości wskazania przez osobę uprawnioną miejsca zamieszkania dłużnika alimentacyjnego za granicą.</div>
          <div style="top: 1223px; left: 0px; width: 880px; position: absolute; height: 16px; ">
            <div style="color: #000000; top: 3px; left: 559px; width: 300px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: right; " class="SofLabel footnote">wersja: ZFA-06(3)</div>
            <div style="color: #000000; top: 3px; left: 10px; width: 850px; font-size: 11px; font-family: verdana; position: absolute; height: 14px; text-align: center; " class="SofLabel footnote">strona: 2/2</div>
            <div style="border-top: 2px solid black; top: 1px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.7 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.7 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
