/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.integracja.edoreczenia;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.jwt.JwtBearerClientCredentialsGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import pl.topteam.integracja.edoreczenia.DostawcaParametrowTokenuDostepowego;
import pl.topteam.integracja.edoreczenia.GeneratorJWT;
import pl.topteam.integracja.edoreczenia.ParametryPobraniaTokenuDostepowego;

public final class DostawcaTokenuDostepowego
implements HttpAuthSupplier {
    private final URL tokenUrl;
    private final URL audienceUrl;
    private final DostawcaParametrowTokenuDostepowego dostawcaParametrow;
    private volatile ClientAccessToken token;

    public DostawcaTokenuDostepowego(URL tokenUrl, URL audienceUrl, DostawcaParametrowTokenuDostepowego dostawcaParametrowTokenuDostepowego) {
        this.tokenUrl = tokenUrl;
        this.audienceUrl = audienceUrl;
        this.dostawcaParametrow = dostawcaParametrowTokenuDostepowego;
    }

    public synchronized boolean requiresRequestCaching() {
        return false;
    }

    public synchronized String getAuthorization(AuthorizationPolicy authPolicy, URI currentURI, Message message, String fullHeader) {
        if (this.isNull(this.token) || this.isExpired(this.token)) {
            this.token = this.getAccessToken();
        }
        return OAuthClientUtils.createAuthorizationHeader((ClientAccessToken)this.token);
    }

    private ClientAccessToken getAccessToken() {
        ParametryPobraniaTokenuDostepowego parametry = this.dostawcaParametrow.get();
        WebClient webClient = WebClient.create((String)this.tokenUrl.toString(), (List)ImmutableList.of((Object)new OAuthJSONProvider()));
        webClient.query("login_hint", new Object[]{parametry.getAdres().value()});
        String assertion = new GeneratorJWT(this.audienceUrl).generuj(parametry);
        return OAuthClientUtils.getAccessToken((WebClient)webClient, (AccessTokenGrant)new JwtBearerClientCredentialsGrant(assertion, true, null));
    }

    private boolean isNull(ClientAccessToken token) {
        return Objects.isNull(token);
    }

    private boolean isExpired(ClientAccessToken token) {
        return OAuthUtils.isExpired((Long)token.getIssuedAt(), (Long)token.getExpiresIn());
    }
}

