/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.integracja.edoreczenia;

import java.security.KeyPair;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public final class GeneratorCSR {
    private static final String signerAlgorithm = "SHA256withRSA";

    public PKCS10CertificationRequest generuj(X500Principal principal, KeyPair keyPair) throws OperatorCreationException {
        if (!Objects.equals(keyPair.getPublic().getAlgorithm(), "RSA")) {
            throw new AssertionError();
        }
        JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(principal, keyPair.getPublic());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signerAlgorithm);
        ContentSigner contentSigner = signerBuilder.build(keyPair.getPrivate());
        return requestBuilder.build(contentSigner);
    }
}

