/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.integracja.edoreczenia;

import java.net.URL;
import java.security.PrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import pl.topteam.integracja.edoreczenia.ParametryPobraniaTokenuDostepowego;

final class GeneratorJWT {
    private final URL url;

    public GeneratorJWT(URL url) {
        this.url = url;
    }

    public String generuj(ParametryPobraniaTokenuDostepowego parametry) {
        Instant teraz = Instant.now();
        JwtClaims claims = new JwtClaims();
        claims.setTokenId(UUID.randomUUID().toString());
        claims.setIssuer(parametry.getAdres().value() + ".SYSTEM." + parametry.getNazwaSystemu());
        claims.setSubject(parametry.getAdres().value() + ".SYSTEM." + parametry.getNazwaSystemu());
        claims.setAudience(this.url.toString());
        claims.setIssuedAt(Long.valueOf(teraz.getEpochSecond()));
        claims.setNotBefore(Long.valueOf(teraz.minus(Duration.ofMinutes(15L)).getEpochSecond()));
        claims.setExpiryTime(Long.valueOf(teraz.plus(Duration.ofMinutes(15L)).getEpochSecond()));
        PrivateKey privateKey = parametry.getKlucz();
        JwsSignatureProvider signatureProvider = JwsUtils.getPrivateKeySignatureProvider((PrivateKey)privateKey, (SignatureAlgorithm)SignatureAlgorithm.RS512);
        JwsJwtCompactProducer jwsProducer = new JwsJwtCompactProducer(claims);
        return jwsProducer.signWith(signatureProvider);
    }
}

