/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.integracja.edoreczenia.cxf.se.v3_0_4.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import pl.topteam.integracja.edoreczenia.cxf.se.v3_0_4.model.AddressTypeEnum;
import pl.topteam.integracja.edoreczenia.cxf.se.v3_0_4.model.CountryCodeEnum;

@ApiModel(description="Correspondence or headquarters address.")
public class AddressData {
    @ApiModelProperty(value="List of address types.")
    private List<AddressTypeEnum> addressType;
    @ApiModelProperty(required=true, value="")
    private CountryCodeEnum countryCode;
    @ApiModelProperty(example="POLNA", value="Street.")
    private String street;
    @ApiModelProperty(example="STREET", value="Type of street.")
    private TypeOfStreetEnum typeOfStreet;
    @ApiModelProperty(example="05-569", value="Postal code.")
    private String postalCode;
    @ApiModelProperty(example="WARSZAWA", required=true, value="City.")
    private String city;
    @ApiModelProperty(example="12AA", required=true, value="Building number.")
    private String buildingNumber;
    @ApiModelProperty(example="123A", value="Flat number.")
    private String flatNumber;
    @ApiModelProperty(example="Warszawa", value="Postal office.")
    private String postalOffice;
    @ApiModelProperty(example="46", value="Post office box.")
    private String postOfficeBox;
    @ApiModelProperty(example="MAZOWIECKIE", value="Voivodeship.")
    private String voivodeship;
    @ApiModelProperty(example="MI\u0143SKI", value="Disctrict.")
    private String district;
    @ApiModelProperty(example="HALIN\u00d3W", value="Community.")
    private String community;

    @JsonProperty(value="addressType")
    public List<AddressTypeEnum> getAddressType() {
        return this.addressType;
    }

    public void setAddressType(List<AddressTypeEnum> addressType) {
        this.addressType = addressType;
    }

    public AddressData addressType(List<AddressTypeEnum> addressType) {
        this.addressType = addressType;
        return this;
    }

    public AddressData addAddressTypeItem(AddressTypeEnum addressTypeItem) {
        this.addressType.add(addressTypeItem);
        return this;
    }

    @JsonProperty(value="countryCode")
    public CountryCodeEnum getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
    }

    public AddressData countryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @JsonProperty(value="street")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public AddressData street(String street) {
        this.street = street;
        return this;
    }

    @JsonProperty(value="typeOfStreet")
    public String getTypeOfStreet() {
        if (this.typeOfStreet == null) {
            return null;
        }
        return this.typeOfStreet.value();
    }

    @JsonProperty(value="postalCode")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public AddressData postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @JsonProperty(value="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public AddressData city(String city) {
        this.city = city;
        return this;
    }

    @JsonProperty(value="buildingNumber")
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public AddressData buildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
        return this;
    }

    @JsonProperty(value="flatNumber")
    public String getFlatNumber() {
        return this.flatNumber;
    }

    public void setFlatNumber(String flatNumber) {
        this.flatNumber = flatNumber;
    }

    public AddressData flatNumber(String flatNumber) {
        this.flatNumber = flatNumber;
        return this;
    }

    @JsonProperty(value="postalOffice")
    public String getPostalOffice() {
        return this.postalOffice;
    }

    @JsonProperty(value="postOfficeBox")
    public String getPostOfficeBox() {
        return this.postOfficeBox;
    }

    @JsonProperty(value="voivodeship")
    public String getVoivodeship() {
        return this.voivodeship;
    }

    @JsonProperty(value="district")
    public String getDistrict() {
        return this.district;
    }

    @JsonProperty(value="community")
    public String getCommunity() {
        return this.community;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressData addressData = (AddressData)o;
        return Objects.equals(this.addressType, addressData.addressType) && Objects.equals((Object)this.countryCode, (Object)addressData.countryCode) && Objects.equals(this.street, addressData.street) && Objects.equals((Object)this.typeOfStreet, (Object)addressData.typeOfStreet) && Objects.equals(this.postalCode, addressData.postalCode) && Objects.equals(this.city, addressData.city) && Objects.equals(this.buildingNumber, addressData.buildingNumber) && Objects.equals(this.flatNumber, addressData.flatNumber) && Objects.equals(this.postalOffice, addressData.postalOffice) && Objects.equals(this.postOfficeBox, addressData.postOfficeBox) && Objects.equals(this.voivodeship, addressData.voivodeship) && Objects.equals(this.district, addressData.district) && Objects.equals(this.community, addressData.community);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressType, this.countryCode, this.street, this.typeOfStreet, this.postalCode, this.city, this.buildingNumber, this.flatNumber, this.postalOffice, this.postOfficeBox, this.voivodeship, this.district, this.community});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressData {\n");
        sb.append("    addressType: ").append(AddressData.toIndentedString(this.addressType)).append("\n");
        sb.append("    countryCode: ").append(AddressData.toIndentedString((Object)this.countryCode)).append("\n");
        sb.append("    street: ").append(AddressData.toIndentedString(this.street)).append("\n");
        sb.append("    typeOfStreet: ").append(AddressData.toIndentedString((Object)this.typeOfStreet)).append("\n");
        sb.append("    postalCode: ").append(AddressData.toIndentedString(this.postalCode)).append("\n");
        sb.append("    city: ").append(AddressData.toIndentedString(this.city)).append("\n");
        sb.append("    buildingNumber: ").append(AddressData.toIndentedString(this.buildingNumber)).append("\n");
        sb.append("    flatNumber: ").append(AddressData.toIndentedString(this.flatNumber)).append("\n");
        sb.append("    postalOffice: ").append(AddressData.toIndentedString(this.postalOffice)).append("\n");
        sb.append("    postOfficeBox: ").append(AddressData.toIndentedString(this.postOfficeBox)).append("\n");
        sb.append("    voivodeship: ").append(AddressData.toIndentedString(this.voivodeship)).append("\n");
        sb.append("    district: ").append(AddressData.toIndentedString(this.district)).append("\n");
        sb.append("    community: ").append(AddressData.toIndentedString(this.community)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeOfStreetEnum {
        STREET(String.valueOf("STREET")),
        AVENUE(String.valueOf("AVENUE")),
        PLAZA(String.valueOf("PLAZA")),
        SQUARE(String.valueOf("SQUARE")),
        BOULEVARD(String.valueOf("BOULEVARD")),
        ROUNDABOUT(String.valueOf("ROUNDABOUT")),
        PARK(String.valueOf("PARK")),
        MARKET(String.valueOf("MARKET")),
        ROUTE(String.valueOf("ROUTE")),
        ROAD(String.valueOf("ROAD")),
        ESTATE(String.valueOf("ESTATE")),
        GARDEN(String.valueOf("GARDEN")),
        ISLAND(String.valueOf("ISLAND")),
        COAST(String.valueOf("COAST")),
        OTHER(String.valueOf("OTHER"));

        private String value;

        private TypeOfStreetEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeOfStreetEnum fromValue(String value) {
            for (TypeOfStreetEnum b : TypeOfStreetEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

