/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.time.Instant;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.ErrorInfo;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.Message;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessageControlDataPatchResponse;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessageInfo;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessageOperationResponseSingleWrapper;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessageOperationResponseWrapperStatus;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessagePending;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessageTaskStatus;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.MessagesWrapper;
import pl.topteam.integracja.edoreczenia.cxf.ua.v3_0_8.model.PatchBodyInner;

@Path(value="")
@Api(value="/", description="")
public interface MessagesApi {
    @GET
    @Path(value="/dictionary/countries")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets names of countries.", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Operacja wykonana poprawnie", response=String.class, responseContainer="List"), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public List<String> dictionaryCountriesGet();

    @GET
    @Path(value="/{eDeliveryAddress}/messages")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists messages.", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Operacja wykonana poprawnie", response=MessagesWrapper.class), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public MessagesWrapper eDeliveryAddressMessagesGet(@PathParam(value="eDeliveryAddress") String var1, @QueryParam(value="offset") @DefaultValue(value="0") Integer var2, @QueryParam(value="limit") @DefaultValue(value="20") Integer var3, @QueryParam(value="format") @DefaultValue(value="minimal") String var4, @QueryParam(value="sender") String var5, @QueryParam(value="massMessagesGrouped") @DefaultValue(value="false") Boolean var6, @QueryParam(value="massMessageId") String var7, @QueryParam(value="recipient") String var8, @QueryParam(value="subject") String var9, @QueryParam(value="submissionDateFrom") Instant var10, @QueryParam(value="submissionDateTo") Instant var11, @QueryParam(value="eventDateFrom") Instant var12, @QueryParam(value="eventDateTo") Instant var13, @QueryParam(value="receiptDateFrom") Instant var14, @QueryParam(value="receiptDateTo") Instant var15, @QueryParam(value="attachments") Boolean var16, @QueryParam(value="label") String var17, @QueryParam(value="shippingService") String var18, @QueryParam(value="sortColumn") String var19, @QueryParam(value="sortDirection") String var20, @QueryParam(value="opened") Boolean var21);

    @DELETE
    @Path(value="/{eDeliveryAddress}/messages/{messageId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes message.", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Operacja wykonana poprawnie.", response=MessageOperationResponseSingleWrapper.class, responseContainer="List"), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public List<MessageOperationResponseSingleWrapper> eDeliveryAddressMessagesMessageIdDelete(@PathParam(value="eDeliveryAddress") String var1, @PathParam(value="messageId") List<String> var2);

    @GET
    @Path(value="/{eDeliveryAddress}/messages/{messageId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets message.", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Operacja wykonana poprawnie", response=Message.class, responseContainer="List"), @ApiResponse(code=202, message="Operacja w toku", response=MessagePending.class), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public List<Message> eDeliveryAddressMessagesMessageIdGet(@PathParam(value="eDeliveryAddress") String var1, @PathParam(value="messageId") List<String> var2, @QueryParam(value="format") @DefaultValue(value="full") String var3);

    @PATCH
    @Path(value="/{eDeliveryAddress}/messages/{messageId}/message_control_data")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update message control data.", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Operacja wykonana poprawnie", response=MessageControlDataPatchResponse.class, responseContainer="List"), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public List<MessageControlDataPatchResponse> eDeliveryAddressMessagesMessageIdMessageControlDataPatch(@PathParam(value="eDeliveryAddress") String var1, @PathParam(value="messageId") List<String> var2, List<PatchBodyInner> var3);

    @POST
    @Path(value="/{eDeliveryAddress}/messages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Sends message.", tags={})
    @ApiResponses(value={@ApiResponse(code=202, message="Mass message response", response=MessageInfo.class), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public MessageInfo eDeliveryAddressMessagesPost(@PathParam(value="eDeliveryAddress") String var1, Message var2);

    @GET
    @Path(value="/{eDeliveryAddress}/messages/tasks/{messageTaskId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get message task", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Message response for messageTask status", response=MessageOperationResponseWrapperStatus.class, responseContainer="List"), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public List<MessageOperationResponseWrapperStatus> eDeliveryAddressMessagesTasksMessageTaskIdGet(@PathParam(value="eDeliveryAddress") String var1, @PathParam(value="messageTaskId") String var2);

    @GET
    @Path(value="/{eDeliveryAddress}/messages/tasks/{messageTaskId}/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get status of message task", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="ok", response=MessageTaskStatus.class), @ApiResponse(code=400, message="Error response", response=ErrorInfo.class, responseContainer="List")})
    public MessageTaskStatus eDeliveryAddressMessagesTasksMessageTaskIdStatusGet(@PathParam(value="eDeliveryAddress") String var1, @PathParam(value="messageTaskId") String var2);
}

