/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.mybatis.generator.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class CommentGenerator
implements org.mybatis.generator.api.CommentGenerator {
    private static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private boolean suppressAllComments;
    private String generationTimestamp;

    public void addJavaFileComment(CompilationUnit compilationUnit) {
    }

    public void addComment(XmlElement xmlElement) {
        if (this.suppressAllComments) {
            return;
        }
        xmlElement.addElement((Element)new TextElement("<!--"));
        StringBuilder sb = new StringBuilder();
        sb.append("  WARNING - ");
        sb.append("@mbggenerated");
        xmlElement.addElement((Element)new TextElement(sb.toString()));
        xmlElement.addElement((Element)new TextElement("  Kod zosta\u0142 automatycznie wygenerowany przez MyBatis Generator, MODYFIKUJESZ NA W\u0141ASN\u0104 ODPOWIEDZIALNO\u015a\u0106 !!!."));
        sb.setLength(0);
        sb.append("  wygenerowano ");
        sb.append(this.generationTimestamp);
        sb.append('.');
        xmlElement.addElement((Element)new TextElement(sb.toString()));
        xmlElement.addElement((Element)new TextElement("-->"));
    }

    public void addRootComment(XmlElement rootElement) {
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        innerEnum.addJavaDocLine(" * " + introspectedTable.getFullyQualifiedTable().toString());
        this.addJavadocTag((JavaElement)innerEnum, false);
        innerEnum.addJavaDocLine(" */");
    }

    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        method.addJavaDocLine("/**");
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        method.addJavaDocLine("/**");
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        sb.setLength(0);
        sb.append(" * @return ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        method.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)method);
        method.addJavaDocLine(" */");
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        method.addJavaDocLine("/**");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" *");
        sb.setLength(0);
        Parameter parm = (Parameter)method.getParameters().get(0);
        sb.append(" * @param ");
        sb.append(parm.getName());
        method.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)method);
        method.addJavaDocLine(" */");
    }

    public void addConfigurationProperties(Properties properties) {
        String df = properties.getProperty("dateFormat");
        if (df == null || df.isEmpty()) {
            df = DEFAULT_DATE_FORMAT;
        }
        this.generationTimestamp = new SimpleDateFormat(df).format(new Date());
        this.suppressAllComments = StringUtility.isTrue((String)properties.getProperty("suppressAllComments"));
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        field.addJavaDocLine("/**");
        if (introspectedColumn != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" * ");
            sb.append(introspectedTable.getFullyQualifiedTable());
            sb.append('.');
            sb.append(introspectedColumn.getActualColumnName());
            field.addJavaDocLine(sb.toString());
            field.addJavaDocLine(" *");
        }
        this.addJavadocTag((JavaElement)field);
        field.addJavaDocLine(" */");
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
        this.addFieldComment(field, introspectedTable, null);
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        this.addClassComment(innerClass, introspectedTable, false);
    }

    protected void addJavadocTag(JavaElement javaElement) {
        this.addJavadocTag(javaElement, false);
    }

    protected void addJavadocTag(JavaElement javaElement, boolean markAsDoNotDelete) {
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append("@mbggenerated");
        if (markAsDoNotDelete) {
            sb.append(" do_not_delete_during_merge");
        }
        sb.append(" ");
        sb.append(this.generationTimestamp);
        javaElement.addJavaDocLine(sb.toString());
    }
}

