/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.mybatis.generator.plugins;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;

public class GenMirrorPlugin
extends PluginAdapter {
    private static final String generatePojoQN = "GeneratePojoBuilder";
    private static final String generatePojoAnnotation = "@GeneratePojoBuilder";
    private static final String generatePojoFQN = "net.karneim.pojobuilder.GeneratePojoBuilder";
    private Logger log = Logger.getLogger(GenMirrorPlugin.class);
    private Pattern endLinePattern = Pattern.compile("\r?\n");
    private boolean createMainFiles;
    private String genSuffix;
    private File projectDir;
    private File tmpDir;
    private List<IntrospectedTable> tables = Lists.newArrayList();

    public boolean validate(List<String> warnings) {
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        this.tables.add(introspectedTable);
        return new ArrayList<GeneratedJavaFile>();
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        File destFile;
        ArrayList lines;
        FileTypeF fileTypeF = null;
        String pack = null;
        Integer packageIndex = 0;
        Integer classIndex = null;
        Predicate classPredicate = Predicates.containsPattern((String)"public class");
        Predicate interfacePredicate = Predicates.containsPattern((String)"interface");
        Integer critIndex = null;
        Predicate criteriaPredicate = Predicates.containsPattern((String)"\\.Criteria");
        Predicate criterionPredicate = Predicates.containsPattern((String)"\\.Criterion");
        try {
            for (IntrospectedTable t : this.tables) {
                for (GeneratedJavaFile tFile : t.getGeneratedJavaFiles()) {
                    lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)this.endLinePattern).split((CharSequence)tFile.getFormattedContent()));
                    pack = ((String)lines.get(packageIndex)).substring("package ".length()).replace("dao", "model").replace(";", "");
                    lines.set(packageIndex, ((String)lines.get(packageIndex)).replace(";", this.genSuffix + ";"));
                    classIndex = Iterables.indexOf((Iterable)lines, (Predicate)classPredicate);
                    if (classIndex != -1) {
                        lines.set(classIndex, ((String)lines.get(classIndex)).replace("public", "public abstract"));
                    }
                    if ((critIndex = Integer.valueOf(Iterables.indexOf((Iterable)lines, (Predicate)criteriaPredicate))) >= 0) {
                        lines.set(critIndex, ((String)lines.get(critIndex)).replace(pack, pack + this.genSuffix));
                    }
                    if ((critIndex = Integer.valueOf(Iterables.indexOf((Iterable)lines, (Predicate)criterionPredicate))) >= 0) {
                        lines.set(critIndex, ((String)lines.get(critIndex)).replace(pack, pack + this.genSuffix));
                    }
                    destFile = this.absoluteTargetFileGenPath((GeneratedFile)tFile).toFile();
                    Files.createParentDirs((File)destFile);
                    destFile.createNewFile();
                    Files.write((CharSequence)Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).join((Iterable)lines), (File)destFile, (Charset)Charsets.UTF_8);
                }
                for (GeneratedJavaFile tFile : t.getGeneratedXmlFiles()) {
                    lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)this.endLinePattern).split((CharSequence)tFile.getFormattedContent()));
                    destFile = this.absoluteTargetFileGenPath((GeneratedFile)tFile).toFile();
                    Files.createParentDirs((File)destFile);
                    destFile.createNewFile();
                    Files.write((CharSequence)Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).join((Iterable)lines), (File)destFile, (Charset)Charsets.UTF_8);
                }
            }
        }
        catch (IOException ioex) {
            this.log.error((Object)ioex);
        }
        if (this.createMainFiles) {
            try {
                for (IntrospectedTable t : this.tables) {
                    fileTypeF = new FileTypeF(t);
                    for (GeneratedJavaFile tFile : t.getGeneratedJavaFiles()) {
                        GeneratedFileTypeSuffix fileType = (GeneratedFileTypeSuffix)((Object)fileTypeF.apply(tFile));
                        switch (fileType) {
                            case KEY: 
                            case MODEL: 
                            case CRITERIA: 
                            case MAPPER: {
                                int i;
                                ArrayList lines2 = Lists.newArrayList((Iterable)Splitter.on((Pattern)this.endLinePattern).split((CharSequence)tFile.getFormattedContent()));
                                classIndex = Iterables.indexOf((Iterable)lines2, (Predicate)classPredicate);
                                if (classIndex < 0) {
                                    classIndex = Iterables.indexOf((Iterable)lines2, (Predicate)interfacePredicate);
                                } else if (!GeneratedFileTypeSuffix.CRITERIA.equals((Object)fileType)) {
                                    lines2.add(classIndex, generatePojoAnnotation);
                                    lines2.add(2, String.format("import %s;", generatePojoFQN));
                                    lines2.add(3, "");
                                    classIndex = classIndex + 3;
                                }
                                String className = tFile.getCompilationUnit().getType().getShortName();
                                if (((String)lines2.get(classIndex)).contains("GenericDPSObject")) {
                                    lines2.set(classIndex, ((String)lines2.get(classIndex)).replace("GenericDPSObject", tFile.getCompilationUnit().getType().getFullyQualifiedName().replace("." + className, this.genSuffix + "." + className)));
                                } else {
                                    lines2.set(classIndex, ((String)lines2.get(classIndex)).replace("{", "extends " + tFile.getCompilationUnit().getType().getFullyQualifiedName().replace("." + className, this.genSuffix + "." + className + " {")));
                                }
                                for (i = lines2.size() - 2; i > classIndex; --i) {
                                    if (((String)lines2.get(i)).contains("serialVersionUID")) continue;
                                    lines2.remove(i);
                                }
                                for (i = classIndex - 1; i > 1; --i) {
                                    if (((String)lines2.get(i)).contains(generatePojoQN) || ((String)lines2.get(i)).contains("Serializable") || ((String)lines2.get(i)).isEmpty()) continue;
                                    lines2.remove(i);
                                }
                                lines2.add(lines2.size() - 1, "");
                                boolean prevEmpty = false;
                                ListIterator it = lines2.listIterator();
                                while (it.hasNext()) {
                                    String l = (String)it.next();
                                    if (prevEmpty && l.isEmpty()) {
                                        it.remove();
                                    }
                                    prevEmpty = l.isEmpty();
                                }
                                File destFile2 = this.absoluteTargetFilePath((GeneratedFile)tFile).toFile();
                                Files.createParentDirs((File)destFile2);
                                destFile2.createNewFile();
                                Files.write((CharSequence)Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).join((Iterable)lines2), (File)destFile2, (Charset)Charsets.UTF_8);
                                break;
                            }
                        }
                    }
                    for (GeneratedJavaFile tFile : t.getGeneratedXmlFiles()) {
                        lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)this.endLinePattern).split((CharSequence)tFile.getFormattedContent()));
                        for (int i = lines.size() - 2; i > 2; --i) {
                            lines.remove(i);
                        }
                        lines.add(lines.size() - 1, "");
                        destFile = this.absoluteTargetFilePath((GeneratedFile)tFile).toFile();
                        Files.createParentDirs((File)destFile);
                        destFile.createNewFile();
                        Files.write((CharSequence)Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).join((Iterable)lines), (File)destFile, (Charset)Charsets.UTF_8);
                    }
                }
                FileUtils.deleteQuietly((File)this.tmpDir);
            }
            catch (IOException ioex) {
                this.log.error((Object)ioex);
            }
        }
        return new ArrayList<GeneratedJavaFile>();
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.createMainFiles = Boolean.valueOf(properties.getProperty("createMainFiles"));
        this.genSuffix = properties.getProperty("gen.suffix");
        if (StringUtils.isEmpty((CharSequence)this.genSuffix)) {
            this.genSuffix = "_gen";
        }
        String projectDir = properties.getProperty("project.dir");
        Preconditions.checkNotNull((Object)projectDir);
        this.projectDir = new File(projectDir);
        String tmpDir = properties.getProperty("tmp.dir");
        Preconditions.checkNotNull((Object)tmpDir);
        this.tmpDir = new File(tmpDir);
        File javaDir = Paths.get(tmpDir, "src", "generated", "java").toFile();
        if (!javaDir.exists()) {
            FileUtils.deleteQuietly((File)javaDir);
        }
        javaDir.mkdirs();
        File resDir = Paths.get(tmpDir, "src", "generated", "resources").toFile();
        if (resDir.exists()) {
            FileUtils.deleteQuietly((File)resDir);
        }
        resDir.mkdirs();
    }

    private Path absoluteTargetFilePath(GeneratedFile tFile) {
        return Paths.get(this.projectDir.getAbsolutePath(), tFile.getTargetProject().replace(this.tmpDir.getAbsolutePath() + File.separatorChar, "").replace("generated", "main"), tFile.getTargetPackage().replace('.', File.separatorChar), tFile.getFileName());
    }

    private Path absoluteTargetFileGenPath(GeneratedFile tFile) {
        return Paths.get(this.projectDir.getAbsolutePath(), tFile.getTargetProject().replace(this.tmpDir.getAbsolutePath() + File.separatorChar, ""), (tFile.getTargetPackage() + this.genSuffix).replace('.', File.separatorChar), tFile.getFileName());
    }

    private static class FileTypeF
    implements Function<GeneratedJavaFile, GeneratedFileTypeSuffix> {
        private final IntrospectedTable introspectedTable;

        public FileTypeF(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
        }

        public GeneratedFileTypeSuffix apply(final GeneratedJavaFile file) {
            return (GeneratedFileTypeSuffix)((Object)Iterables.find((Iterable)GeneratedFileTypeSuffix.ALL, (Predicate)new Predicate<GeneratedFileTypeSuffix>(){

                public boolean apply(GeneratedFileTypeSuffix gfs) {
                    return StringUtils.equalsIgnoreCase((CharSequence)(FileTypeF.this.introspectedTable.getFullyQualifiedTable().getIntrospectedTableName().replace("_", "") + gfs.getSuffix()), (CharSequence)file.getFileName());
                }
            }));
        }
    }

    private static enum GeneratedFileTypeSuffix {
        CRITERIA("Criteria.java"),
        MAPPER("Mapper.java"),
        SQL_PROVIDER("SqlProvider.java"),
        KEY("Key.java"),
        MODEL(".java");

        private static Iterable<GeneratedFileTypeSuffix> ALL;
        private String suffix;

        private GeneratedFileTypeSuffix(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        static {
            ALL = EnumSet.allOf(GeneratedFileTypeSuffix.class);
        }
    }
}

