<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ns0="http://www.gov.pl/du/r2021/poz893/wywiad/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2021/poz893/wywiad/cz6"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

	<xsl:variable name="Obywatelstwo" select="document('../xml/Obywatelstwo.xml')/properties/entry" />
	<xsl:variable name="Plec" select="document('../xml/Plec.xml')/properties/entry" />
	<xsl:variable name="RodzajAdresu" select="document('../xml/RodzajAdresu.xml')/properties/entry" />
	<xsl:variable name="RodzajDochodu" select="document('../xml/RodzajDochodu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />
	<xsl:variable name="RodzajWyksztalcenia" select="document('../xml/RodzajWyksztalcenia.xml')/properties/entry" />
	<xsl:variable name="RodzajZasilku" select="document('../xml/RodzajZasilku.xml')/properties/entry" />
	<xsl:variable name="Schorzenie" select="document('../xml/Schorzenie.xml')/properties/entry" />
	<xsl:variable name="StanCywilny" select="document('../xml/StanCywilny.xml')/properties/entry" />
	<xsl:variable name="StopienPokrewienstwa" select="document('../xml/StopienPokrewienstwa.xml')/properties/entry" />
	<xsl:variable name="SytuacjaZdrowotna" select="document('../xml/SytuacjaZdrowotna.xml')/properties/entry" />
	<xsl:variable name="TakNie" select="document('../xml/TakNie.xml')/properties/entry" />
	<xsl:variable name="ZnajomoscJezyka" select="document('../xml/ZnajomoscJezyka.xml')/properties/entry" />

	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:template match="/">
		<xsl:variable name="OsobaGlowna" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']" />
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON powiatowego centrum pomocy rodzinie
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				<h2>
					CZĘŚĆ VI<br/>
					DOTYCZY CUDZOZIEMCÓW, O KTÓRYCH MOWA<br/>
					W ART. 91 UST. 1 USTAWY Z DNIA 12 MARCA 2004 R.<br/>
					O POMOCY SPOŁECZNEJ
				</h2>
				<br/>
				<section>
					<h3>A. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD, DANE O CZŁONKACH RODZINY PRZEBYWAJĄCYCH I ZAMIESZKUJĄCYCH NA TERYTORIUM RZECZYPOSPOLITEJ POLSKIEJ</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="width: 20mm;">Imię</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie2" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Nazwisko</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko2" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">3</td>
							<td>Obywatelstwo</td>
							<td>
								<ins>
									<xsl:variable name="_Obywatelstwo" select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:Obywatelstwo" />
									<xsl:value-of select="$Obywatelstwo[@key = $_Obywatelstwo]" />
								</ins>
							</td>
							<td style="width: 6mm;">3</td>
							<td>Narodowość</td>
							<td>
								<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Narodowosc" />
							</td>
						</tr>
					</table>

					<table>
						<tr>
							<td style="width: 6mm;">5</td>
							<td>Data urodzenia</td>
							<td>dzień</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 9, 1)" />
								</ins>
							</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 10, 1)" />
								</ins>
							</td>
							<td>miesiąc</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 6, 1)" />
								</ins>
							</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 7, 1)" />
								</ins>
							</td>
							<td>rok</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 1, 1)" />
								</ins>
							</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 2, 1)" />
								</ins>
							</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 3, 1)" />
								</ins>
							</td>
							<td style="width: 6mm; text-align: center;">
								<ins>
									<xsl:value-of select="substring($OsobaGlowna/ns1:DanePodstawowe/ns1:DataUr, 4, 1)" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">6</td>
							<td>
								Dokument tożsamości
								<br/>
								<ins>
									<xsl:variable name="_RodzajDokumentu" select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td>nr dokumentu podróży</td>
										<td>
											<ins>
												<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NumerDokumentuPodrozy" />
											</ins>
										</td>
									</tr>
									<tr>
										<td>nr karty pobytu</td>
										<td>
											<ins>
												<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NumerKartyPobytu" />
											</ins>
										</td>
									</tr>
									<tr>
										<td>nr decyzji nadającej status uchodźcy lub ochronę uzupełniającą</td>
										<td>
											<ins>
												<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NrDecyzjiUchodzcy" />
											</ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">7</td>
							<td>
								Data decyzji o nadaniu statusu uchodźcy lub ochrony uzupełniającej
								<br/>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:DataDecyzji" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td rowspan="2" style="width: 6mm;">8</td>
							<td style="width: 26mm;">Adres zameldowania cudzoziemca na terytorium Rzeczypospolitej Polskiej</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZameldowania/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZameldowania/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZameldowania/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZameldowania/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZameldowania/ns1:NrLok" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZameldowania/ns1:Telefon" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>Adres pobytu czasowego</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Ulica"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrDomu"/>
												<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrLok != ''">
													<xsl:text> </xsl:text>
													m. <xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrLok"/>
												</xsl:if>
												<br/>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Miejscowosc"/>
											</ins>
										</td>
										<td>
											Zameldowanie:
											<br/>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Zameldowanie = 'T'">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											1) tak
											<br/>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Zameldowanie = 'N'">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											2) nie
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">9</td>
							<td>
								Jak długo cudzoziemiec przebywa na terytorium Rzeczypospolitej Polskiej?
								<br/>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OkresPobytuWPolsce"/>
								</ins>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">10</td>
							<td>
								Czy cudzoziemiec jest w Rzeczypospolitej Polskiej?
								<span style="float: right;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzySam = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) sam
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzySam = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) z rodziną
								</span>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">11</td>
							<td>Czy cudzoziemiec utrzymuje kontakt z rodziną?</td>
							<td>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:JakiKontakt = '1'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
								</xsl:choose>
								1) mieszkającą na terytorium Rzeczypospolitej Polskiej
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:JakiKontakt = '2'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) mieszkającą w kraju pochodzenia
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:JakiKontakt = '3'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) mieszkającą poza granicami Rzeczypospolitej Polskiej, ale nie w kraju pochodzenia
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:JakiKontakt = '4'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								4) nie utrzymuje kontaktu
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">12</td>
							<td>Czy cudzoziemiec korzysta z pomocy?</td>
							<td>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '6']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) rodziny mieszkającej na terytorium Rzeczypospolitej Polskiej
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '7']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) rodziny mieszkającej poza granicami Rzeczypospolitej Polskiej
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '8']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) innych grup uchodźców
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '3']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								4) organizacji pozarządowych
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '4']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								5) związków wyznaniowych
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '9']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								6) innych - wskazać kogo:
								<br/>
								<div style="margin-left: 5mm;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo[./ns1:CzyjaPomoc = '9']/ns1:CzyjaPomocOpis"/>
								</ins>
								</div>
							</td>
						</tr>
					</table>
					<br/>
					<table>
						<tr>
							<td style="width: 6mm;">13</td>
							<td>Formy udzielanej pomocy</td>
							<td>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:FormaPomocy[./ns1:FormaRodzaj = '1']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) pomoc pieniężna
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:FormaPomocy[./ns1:FormaRodzaj = '2']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) pomoc w naturze
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:FormaPomocy[./ns1:FormaRodzaj = '9']">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) inna, wskazać jaka:
								<br/>
								<span class="textarea" style="display: block; margin-left: 6mm;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:InnaFormaOpis"/>
									</ins>
								</span>
							</td>
						</tr>
						<tr>
							<td rowspan="3" style="width: 6mm;">14</td>
							<td>Wielkość udzielanej pomocy</td>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:WielkoscUdzielanejPomocy"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>Zakres udzielanej pomocy</td>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:ZakresUdzielanejPomocy"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>Rodzaj udzielanej pomocy</td>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:RodzajUdzielanejPomocy"/></ins>
								</span>
							</td>
						</tr>
					</table>
 					<br/>
					<p style="page-break-before: always; padding: 2mm 0;">
						15. Informacja o członkach rodziny cudzoziemca zamieszkałych na terytorium Rzeczypospolitej Polskiej
					</p>
					<table>
						<thead>
							<tr>
								<th>1</th>
								<th>2</th>
								<th colspan="3">3</th>
								<th>4</th>
								<th>5</th>
								<th>6</th>
								<th>7</th>
								<th>8</th>
								<th>9</th>
								<th>10</th>
							</tr>
							<tr>
								<th rowspan="2">Lp.</th>
								<th rowspan="2">Imię i nazwisko</th>
								<th colspan="3">Data urodzenia</th>
								<th rowspan="2">Płeć</th>
								<th rowspan="2">Stan cywilny</th>
								<th rowspan="2">Stopień pokrewieństwa</th>
								<th rowspan="2">Wykształcenie</th>
								<th rowspan="2">Sytuacja zdrowotna</th>
								<th colspan="2">Źródło dochodu (utrzymania)</th>
							</tr>
							<tr>
								<th style="width: 10mm;">dzień</th>
								<th style="width: 10mm;">mies.</th>
								<th style="width: 10mm;">rok</th>
								<th>rodzaj</th>
								<th>wysokość</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
								<tr>
									<td>
										<xsl:value-of select="position()" />
									</td>
									<td>
										<ins>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
											<br/>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
										</ins>
									</td>
									<td style="text-align: center;">
										<ins>
											<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 9, 2)" />
										</ins>
									</td>
									<td style="text-align: center;">
										<ins>
											<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 6, 2)" />
										</ins>
									</td>
									<td style="text-align: center;">
										<ins>
											<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 1, 4)" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_Plec" select="ns1:DanePodstawowe/ns1:Plec" />
											<xsl:value-of select="$Plec[@key = $_Plec]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_StanCywilny" select="ns1:DanePodstawowe/ns1:StanCywilny" />
											<xsl:value-of select="$StanCywilny[@key = $_StanCywilny]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_StopienPokrewienstwa" select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa" />
											<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_Wyksztalcenie" select="ns1:DanePodstawowe/ns1:Wyksztalcenie" />
											<xsl:value-of select="$RodzajWyksztalcenia[@key = $_Wyksztalcenie]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_SytuacjaZdrowotna" select="ns1:DanePodstawowe/ns1:SytuacjaZdrowotna" />
											<xsl:value-of select="$SytuacjaZdrowotna[@key = $_SytuacjaZdrowotna]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
												<xsl:variable name="_Rodzaj" select="ns1:Rodzaj" />
												<xsl:value-of select="$RodzajDochodu[@key = $_Rodzaj]" />
												<br/>
											</xsl:for-each>
										</ins>
									</td>
									<td style="text-align: right;">
										<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
											<ins>
												<xsl:value-of select="format-number(ns1:Wysokosc, '0,00')" />
											</ins>
											<xsl:text> </xsl:text>
											zł
											<br/>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
					<small>
						* W przypadku większej liczy osób w rodzinie należy powielić stronę
					</small>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<xsl:variable name="cudzoziemiec" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']"/>
					<xsl:variable name="wspolmalzonekCudzoziemca" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = '15' or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = '16']"/>
					<h3>B. ZNAJOMOŚĆ JĘZYKA POLSKIEGO</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba/ns1:JezykPolski/ns1:Nauka) != 0">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba/ns1:JezykPolski/ns1:Nauka) = 0">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy i kto z członków rodziny cudzoziemca uczęszczał na zajęcia z języka polskiego w trakcie trwania procedury o nadanie statusu uchodźcy?
								<br/><br/>
								Jeżeli tak, wpisać:
								<br/><br/>
								<div style="float: left; width: 70mm; min-height: 20mm;">
									Kto:<br/>
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
										<xsl:if test="ns1:JezykPolski">
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
											<span class="textarea" style="display: block;">
												<ins><xsl:value-of select="ns1:JezykPolski/ns1:Nauka"/></ins>
											</span>
											<br/>
										</xsl:if>
									</xsl:for-each>
								</div>
								<div style="float: left; width: 70mm; min-height: 20mm;">
									Przez jaki okres?<br/>
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
										<xsl:if test="ns1:JezykPolski">
											<ins>
												<xsl:value-of select="ns1:JezykPolski/ns1:OkresNauki"/>
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
											<br/>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>
								Znajomość języka polskiego przez:
								<div style="min-height: 20mm;">
									- cudzoziemca:<br/>
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:Znajomosc = '1'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) nic nie rozumie
									<br/>
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:Znajomosc = '2'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) rozumie, ale słabo
									<br/>
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:Znajomosc = '3'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									3) rozumie wypowiedzi w języku polskim, ale posługuje się językiem ojczystym tj.
										<ins><xsl:value-of select="$cudzoziemiec/ns1:JezykPolski/ns1:JezykOjczysty"/></ins>
										lub innym tj.
										<ins><xsl:value-of select="$cudzoziemiec/ns1:JezykPolski/ns1:JezykInny"/></ins>
									<br/>
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:Znajomosc = '4'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									4) posługuje się językiem polskim wyłącznie w mowie
									<br/>
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:Znajomosc = '5'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									5) posługuje się językiem polskim w mowie i piśmie
								</div>
								<div style="min-height: 20mm;">
									- współmałżonka cudzoziemca:<br/>
									<xsl:choose>
										<xsl:when test="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:Znajomosc = '1'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) nic nie rozumie
									<br/>
									<xsl:choose>
										<xsl:when test="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:Znajomosc = '2'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) rozumie, ale słabo
									<br/>
									<xsl:choose>
										<xsl:when test="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:Znajomosc = '3'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									3) rozumie wypowiedzi w języku polskim, ale posługuje się językiem ojczystym tj.
										<ins><xsl:value-of select="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:JezykOjczysty"/></ins>
										lub innym tj.
										<ins><xsl:value-of select="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:JezykInny"/></ins>
									<br/>
									<xsl:choose>
										<xsl:when test="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:Znajomosc = '4'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									4) posługuje się językiem polskim wyłącznie w mowie
									<br/>
									<xsl:choose>
										<xsl:when test="$wspolmalzonekCudzoziemca/ns1:JezykPolski/ns1:Znajomosc = '5'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									5) posługuje się językiem polskim w mowie i piśmie
								</div>
							</td>
						</tr>
						<tr>
							<td>3</td>
							<td>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:CzySkierowanie = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$cudzoziemiec/ns1:JezykPolski/ns1:CzySkierowanie = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy cudzoziemiec wymaga skierowania na kurs nauki języka polskiego?
							</td>
						</tr>
						<tr>
							<td>4</td>
							<td>
								Znajomość języka polskiego przez dzieci cudzoziemca:
								<xsl:variable name="dzieckoCudzoziemca1" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna != 'T' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '15' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '16' and ./ns1:JezykPolski/ns1:Znajomosc = '1']"/>
								<xsl:variable name="dzieckoCudzoziemca2" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna != 'T' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '15' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '16' and ./ns1:JezykPolski/ns1:Znajomosc = '2']"/>
								<xsl:variable name="dzieckoCudzoziemca3" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna != 'T' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '15' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '16' and ./ns1:JezykPolski/ns1:Znajomosc = '3']"/>
								<xsl:variable name="dzieckoCudzoziemca4" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna != 'T' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '15' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '16' and ./ns1:JezykPolski/ns1:Znajomosc = '4']"/>
								<xsl:variable name="dzieckoCudzoziemca5" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna != 'T' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '15' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '16' and ./ns1:JezykPolski/ns1:Znajomosc = '5']"/>
								<div style="min-height: 20mm;">
									<xsl:choose>
										<xsl:when test="$dzieckoCudzoziemca1">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) nic nie rozumie
									<br/>
									<xsl:choose>
										<xsl:when test="$dzieckoCudzoziemca2">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) rozumie, ale słabo
									<br/>
									<xsl:choose>
										<xsl:when test="$dzieckoCudzoziemca3">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									3) rozumie wypowiedzi w języku polskim, ale posługuje się językiem ojczystym tj.
										<ins><xsl:value-of select="$dzieckoCudzoziemca3/ns1:JezykPolski/ns1:JezykOjczysty"/></ins>
										lub innym tj.
										<ins><xsl:value-of select="$dzieckoCudzoziemca3/ns1:JezykPolski/ns1:JezykInny"/></ins>
									<br/>
									<xsl:choose>
										<xsl:when test="$dzieckoCudzoziemca4">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									4) posługuje się językiem polskim wyłącznie w mowie
									<br/>
									<xsl:choose>
										<xsl:when test="$dzieckoCudzoziemca5">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									5) posługuje się językiem polskim w mowie i piśmie
								</div>
							</td>
						</tr>
						<tr>
							<td>5</td>
							<td>
								<xsl:variable name="dzieciZeSkierowaniem" select="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna != 'T' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '15' and ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa != '16' and ./ns1:JezykPolski/ns1:CzySkierowanie = 'T'])"/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$dzieciZeSkierowaniem > 0">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$dzieciZeSkierowaniem = 0">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								<div style="min-height: 10mm;">
									Czy dzieci cudzoziemca lub inni członkowie jego rodziny wymagają skierowania na kurs nauki języka polskiego?
								</div>
								<div style="min-height: 10mm;">
									Jeżeli tak - to ile dzieci?
									<br/>
									<ins><xsl:value-of select="$dzieciZeSkierowaniem" /></ins>
								</div>
							</td>
						</tr>
						<tr>
							<td>6</td>
							<td>
								<xsl:variable name="czyPomocNaNauke" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzyPomocNaNauke"/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$czyPomocNaNauke = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$czyPomocNaNauke = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								<div style="min-height: 15mm;">
									Czy cudzoziemiec lub jego rodzina wymagają pomocy w formie świadczenia pieniężnego
									na pokrycie wydatków związanych z nauką języka polskiego?
								</div>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>
						C. FUNKCJONOWANIE CUDZOZIEMCA I CZŁONKÓW JEGO RODZINY W NOWYM ŚRODOWISKU PO OPUSZCZENIU
						OŚRODKA DLA CUDZOZIEMCÓW UBIEGAJĄCYCH SIĘ O NADANIE STATUSU UCHODŹCY
					</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="height: 35mm;">
								Jak cudzoziemiec i członkowie jego rodziny czują się w nowym środowisku
								po opuszczeniu ośrodka dla cudzoziemców ubiegających się o nadanie statusu uchodźcy?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Opis"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">2</td>
							<td style="height: 35mm;">
								<xsl:variable name="czyZnajomi" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyZnajomi"/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$czyZnajomi = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$czyZnajomi = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy cudzoziemiec ma znajomych w nowym środowisku?
								<br/>
								<br/>
								<br/>
								Jeżeli tak, wpisać jakich:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Znajomi"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">3</td>
							<td style="height: 35mm;">
								<xsl:variable name="czyKlopoty" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyKlopoty"/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$czyKlopoty = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$czyKlopoty = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy mieszkańcy z najbliższego otoczenia sprawiają cudzoziemcowi lub jego rodzinie kłopoty?<br/>
								<br/>
								<br/>
								<br/>
								Jeżeli tak, wpisać jakie:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Klopoty"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">4</td>
							<td style="height: 35mm;">
								<xsl:variable name="czyGrupaWsparciaM" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyGrupaWsparciaSrodowiska"/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$czyGrupaWsparciaM = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$czyGrupaWsparciaM = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy cudzoziemiec lub jego rodzina mają grupę wsparcia w środowisku zamieszkania?<br/>
								Jeżeli tak, wpisać rodzaj wsparcia:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:GrupaWsparciaSrodowiska"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">5</td>
							<td style="height: 35mm;">
								<xsl:variable name="czyGrupaWsparciaC" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyGrupaWsparciaCudzoziemcow"/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="$czyGrupaWsparciaC = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="$czyGrupaWsparciaC = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy cudzoziemiec lub jego rodzina mają grupę wsparcia wśród cudzoziemców?<br/>
								Jeżeli tak, wpisać rodzaj wsparcia:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:GrupaWsparciaCudzoziemcow"/></ins>
								</span>
							</td>
						</tr>
					</table>
					<br/>
					<table style="page-break-before: always;">
						<tr>
							<td style="width: 6mm;">6</td>
							<td>
								Czy cudzoziemiec lub jego rodzina wiedzą, gdzie znajdują się podstawowe instytucje, takie jak:<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'OsrodekPomocySpolecznej'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) ośrodek pomocy społecznej
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'PowiatowyUrzadPracy'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) powiatowy urząd pracy
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'UrzadMiasta'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) urząd miasta
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'PrzychodniaOsrodekZdrowia'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								4) przychodnia/ośrodek zdrowia
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'SzpitalnyOdzialRatunkowy'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								5) szpitalny oddział ratunkowy
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'Szpital'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								6) szpital
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'Szkola'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								7) szkoła
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'Policja'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								8) policja
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje/ns1:Instytucja = 'Inne'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								9) inne (jakie?)
								<br/>
								<span class="textarea" style="display: block; margin-left: 4mm;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:InnaInstytucjaUwagi"/>
									</ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">7</td>
							<td>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyObowiazekSzkolny != ''">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyObowiazekSzkolny = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								<div style="min-height: 10mm;">
									Czy dzieci cudzoziemca realizują obowiązek szkolny?<br/>
								</div>
								<div style="min-height: 20mm;">
									Jeżeli tak to wpisać do jakiego rodzaju szkoły i do którego oddziału uczęszczają?<br/>
									<span class="textarea">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Szkoly"/></ins>
									</span>
								</div>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">8</td>
							<td style="height: 20mm;">
								Co sprawia najwięcej trudności w funkcjonowaniu w środowisku lokalnym?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Trudnosci"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">9</td>
							<td style="height: 20mm;">
								Zainteresowania cudzoziemca, formy spędzania wolnego czasu:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Zainteresowania"/></ins>
								</span>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>D. SYTUACJA MIESZKANIOWA</h3>
					<xsl:variable name="Mieszkanie" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie" />
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td>
								Mieszkanie:
								<div style="margin-left: 45mm;">
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '03'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) komunalne/kwaterunkowe
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '04'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) mieszkanie wynajęte
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '05'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									3) mieszkanie chronione
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '07'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									4) hotel
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '09'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									5) brak mieszkania
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '99'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									6) inne (jakie?)
									<br/>
									<span class="textarea" style="display: block; padding-left: 20px;">
										<ins><xsl:value-of select="$Mieszkanie/ns1:RodzajUwagi" /></ins>
									</span>
								</div>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">2</td>
							<td>
								<div>
									1) Stan utrzymania mieszkania:<br/>
									<xsl:if test="$Mieszkanie/ns1:StanMieszkania = '1x'">
										<ins>✓</ins>
									</xsl:if>
									a) czyste, zadbane
									&#160;&#160;
									<xsl:if test="$Mieszkanie/ns1:StanMieszkania = '2x'">
										<ins>✓</ins>
									</xsl:if>
									b) brudne, zaniedbane
									&#160;&#160;
									<xsl:if test="$Mieszkanie/ns1:StanMieszkania = '3'">
										<ins>✓</ins>
									</xsl:if>
									c) zdewastowane
								</div>
								<div style="margin-top: 2mm;">
									2) Dostęp do mediów:<br/>
									<div style="float: left; width: 30mm;">
										a) bieżąca woda:<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:WodaBiezaca = 'ZIMNA'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										zimna
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:WodaBiezaca = 'CIEPLA'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										ciepła
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:WodaBiezaca = 'BRAK'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										brak
									</div>
									<div style="float: left; width: 80mm;">
										b) ogrzewanie:<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '1'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										piece węglowe
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '2'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										ogrzewanie centralne
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '3'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										ogrzewanie centralne – gazowe
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '4'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										ogrzewanie elektryczne – akumulacyjne
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '5'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										brak ogrzewania
									</div>
									<div style="float: left; width: 30mm;">
										c) prąd:<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:Prad = 'DOSTEPNY'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										dostępny
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:Prad = 'BRAK'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										brak
									</div>
									<div style="clear: both;"></div>
								</div>
								<div style="margin-top: 2mm;">
									3) Wyposażenie mieszkania w niezbędne sprzęty gospodarstwa domowego:<br/>
									<xsl:if test="$Mieszkanie/ns1:CzySprzety = 'T'">
										<ins>✓</ins>
									</xsl:if>
									tak
									&#160;&#160;
									<xsl:if test="$Mieszkanie/ns1:CzySprzety = 'N'">
										<ins>✓</ins>
									</xsl:if>
									nie, brakuje:<br/>
									<span class="textarea">
										<ins>
											<xsl:value-of select="$Mieszkanie/ns1:BrakujaceSprzety"/>
										</ins>
									</span>
								</div>
								<div style="margin-top: 2mm;">
									4) Pozostałe informacje (np. dostęp do WC, łazienki, miejsca do spania):<br/>
									<span class="textarea">
										<ins><xsl:value-of select="$Mieszkanie/ns1:PozostaleInformacje" /></ins>
									</span>
								</div>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm; height: 20mm;">3</td>
							<td>
								Łączne stałe (miesięczne) wydatki związane z mieszkaniem – czynsz, światło, gaz itp.:<br/>
								<span class="textarea">
									<ins>
										<xsl:value-of select="$Mieszkanie/ns1:LaczneWydatki"/>
									</ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 20mm;">4</td>
							<td>
								Czy zachodzi konieczność zapewnienia mieszkania ze strony gminy?<br/>
								<span class="textarea">
									<ins>
										<xsl:value-of select="$Mieszkanie/ns1:CzyMieszkanieGminy"/>
									</ins>
								</span>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>E. SYTUACJA ZDROWOTNA</h3>
					<table>
						<tr>
							<td style="width: 6mm; height: 20mm;" rowspan="4">1</td>
							<td style="height: 20mm;">
								Czy cudzoziemiec lub członek jego rodziny byli leczeni w trakcie pobytu w ośrodku dla cudzoziemców
								ubiegających się o nadanie statusu uchodźcy?<br/>
								<xsl:variable name="czyLeczenie" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba/ns1:Choroby/ns1:CzyLeczenieWOsrodku[text() = 'T']" />
								<xsl:if test="$czyLeczenie">
									<ins>✓</ins>
								</xsl:if>
								tak
								&#160;&#160;
								<xsl:if test="not($czyLeczenie)">
									<ins>✓</ins>
								</xsl:if>
								nie
							</td>
						</tr>
						<tr>
							<td>
								Jeżeli tak, wpisać kto:
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
									<xsl:if test="ns1:Choroby/ns1:CzyLeczenieWOsrodku = 'T'">
										[#<xsl:value-of select="position()"/>]<xsl:text>, </xsl:text>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td>
								Czy wymaga dalszego leczenia?
								<br/>
								<br/>
								<xsl:variable name="czyDalszeLeczenie" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba/ns1:Choroby/ns1:CzyDalszeLeczenie" />
								<xsl:if test="$czyDalszeLeczenie = 'T'">
									<ins>✓</ins>
								</xsl:if>
								tak
								&#160;&#160;
								<xsl:if test="$czyDalszeLeczenie  = 'N'">
									<ins>✓</ins>
								</xsl:if>
								nie
							</td>
						</tr>
						<tr>
							<td style="height: 20mm;">
								 Jeżeli tak, wpisać jakiego<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
									<xsl:if test="ns1:Choroby/ns1:JakieDalszeLeczenie">
										<span class="textarea">
											<ins><xsl:value-of select="ns1:Choroby/ns1:JakieDalszeLeczenie"/></ins>
											[#<xsl:value-of select="position()"/>]
										</span>
										<br/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">2</td>
							<td>
								Jakie problemy zdrowotne zgłaszają cudzoziemiec lub członek jego rodziny?<br/>
								<div style="min-height: 15mm">
									- długotrwałe:<br/>
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
										<xsl:variable name="lp" select="position()"/>
										<xsl:for-each select="ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie">
											<xsl:variable name="_Schorzenie" select="." />
											<ins><xsl:value-of select="$Schorzenie[@key = $_Schorzenie]"/></ins>
											[#<xsl:value-of select="$lp"/>]
											<br/>
										</xsl:for-each>
									</xsl:for-each>
								</div>
								<div style="min-height: 15mm">
									- inne:<br/>
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
										<xsl:variable name="lp" select="position()"/>
										<xsl:if test="ns1:Choroby/ns1:Inne">
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Choroby/ns1:Inne"/></ins>
											</span>
											[#<xsl:value-of select="$lp"/>]
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 20mm;">3</td>
							<td style="height: 15mm;">
								Czy cudzoziemiec i jego rodzina podlegają ubezpieczeniu zdrowotnemu?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyUbezpieczenie" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 20mm;">4</td>
							<td style="height: 15mm;">
								Czy wymagają pomocy w formie opłacania składki na ubezpieczenie zdrowotne?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyPomocSkladka" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 20mm;">5</td>
							<td style="height: 15mm;">
								Kto opłaca składkę na ubezpieczenie zdrowotne?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:KtoOplaca" /></ins>
								</span>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>F. SYTUACJA ZAWODOWA</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="height: 25mm;">
								Czy cudzoziemiec lub członek jego rodziny mają wiedzę na temat możliwości zatrudnienia
								w swoim zawodzie i zgodnie z kwalifikacjami?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:Mozliwosci" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">2</td>
							<td style="height: 20mm;">
								Umiejętności i kwalifikacje wskazane przez cudzoziemca, które mogą być pomocne w poszukiwaniu pracy:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:Kwalifikacje" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">3</td>
							<td style="height: 15mm;">
								Czy cudzoziemiec lub członek jego rodziny otrzymali propozycję pracy z powiatowego urzędu pracy?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:PropozycjeUP" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">4</td>
							<td style="height: 30mm;">
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:CzyInnePrace = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:CzyInnePrace = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy cudzoziemiec podejmie inne prace, w tym np. jako wolontariusz?
								<br/>
								<br/>
								<br/>
								<span class="textarea">
									Jeżeli tak, wpisać jakie:<br/>
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:InnePrace" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">5</td>
							<td style="height: 45mm;">
								Potwierdzenie zawodu i zatrudnienia z kraju pochodzenia – posiadane dokumenty:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:PosiadaneDokumenty" /></ins>
								</span>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>G. SYTUACJA DOCHODOWA</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="height: 20mm;">
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:CzySrodkiFinansowe = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:CzySrodkiFinansowe = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								Czy cudzoziemiec lub członkowie jego rodziny dysponują środkami finansowymi?<br/>
								<br/>
								<br/>
								<span class="textarea">
									Jeśli tak, wpisać ich wielkość:
									<br/>
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:SrodkiFinansowe" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">2</td>
							<td style="height: 25mm;">
								Ewentualne zasoby przywiezione z kraju pochodzenia, którymi dysponują cudzoziemiec lub jego rodzina:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:ZasobyZKraju" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">3</td>
							<td>
								Czy cudzoziemiec lub członkowie jego rodziny posiadają źródła dochodu?<br/>
								<div style="float: right; width: 45mm;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:CzyZrodlaDochodu = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:CzyZrodlaDochodu = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
								<br/>
								<div style="min-height: 15mm;">
									<span class="textarea">
										Jeżeli tak, wpisać jakie:<br/>
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:ZrodlaDochodu" /></ins>
									</span>
								</div>
								Wielkość dochodu:<br/>
								<div style="min-height: 15mm;">
									<span class="textarea">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:WielkoscDochodu" /></ins>
									</span>
								</div>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section>
					<h3>H. POTRZEBY I OCZEKIWANIA OSOBY LUB RODZINY ZGŁOSZONE PODCZAS PRZEPROWADZANIA WYWIADU</h3>
					<div class="textarea" style="min-height: 40mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Potrzeby" /></ins>
					</div>
					<span style="float: left;">Data zgłoszenia:</span>
					<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataZgloszenia" /></ins></span>
					<br/>
					<span style="float: left;">Data przeprowadzenia wywiadu:</span>
					<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu" /></ins></span>
					<br/>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego przeprowadzającego wywiad:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br style="clear: both;"/>
							<br/>
							Oświadczam, że podane wyżej informacje są zgodne z prawdą.
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.5cm;">(data i podpis osoby, z którą przeprowadzono wywiad)</span>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br/>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					Informacja o warunkach bezpieczeństwa podczas przeprowadzania wywiadu:
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyDrugiPracownik/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) uczestnictwo drugiego pracownika socjalnego
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyAsystaPolicji/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) asysta funkcjonariusza Policji
								</td>
								<td>
									<table>
										<tbody>
											<tr>
												<td width="50%" style="border-right: 0px none;">
													Czy wystąpiły sytuacje
													<br/>zagrożenia podczas
													<br/>przeprowadzania wywiadu?
												</td>
												<td style="border-left: 0px none;">
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'T'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													1) tak - wskazać jakie:
													<br/>
													<span class="textarea" style="display: block; padding-left: 8mm;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:JakieSytuacjeZagrozenia"/></ins></span>
													<br/>
													<br/>
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'N'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													2) nie
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>I. DIAGNOZA PRACOWNIKA SOCJALNEGO</h3>
					<div class="textarea" style="min-height: 180mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:WnioskiOcena" /></ins>
					</div>
					<br/>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Miejscowosc" />
									<xsl:text>, </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
				</section>
				<br/>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan">
				<section style="page-break-before: always;">
					<h3>J. PLAN POMOCY I DZIAŁAŃ NA RZECZ OSOBY LUB RODZINY</h3>
					<table>
						<tr>
							<th>Formy i zakres proponowanej pomocy</th>
						</tr>
						<tr>
							<th>świadczenie pieniężne</th>
						</tr>
						<tr>
							<td style="padding: 0;">
								<table>
									<tr style="border: hidden;">
										<td>1. na utrzymanie</td>
										<td style="width: 30mm; border: hidden;">
											wysokość
											<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:NaUtrzymanie/ns1:Kwota, '0,00')"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											od
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:NaUtrzymanie/ns1:DataOd"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											do
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:NaUtrzymanie/ns1:DataDo"/></ins>
										</td>
									</tr>
									<tr style="border: hidden;">
										<td>2. na pokrycie wydatków związanych z nauką języka polskiego</td>
										<td style="width: 30mm; border: hidden;">
											wysokość
											<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:NaPokrycieWydatkowZwiazanychZNaukaPolskiego/ns1:Kwota, '0,00')"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											od
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:NaPokrycieWydatkowZwiazanychZNaukaPolskiego/ns1:DataOd"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											do
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:NaPokrycieWydatkowZwiazanychZNaukaPolskiego/ns1:DataDo"/></ins>
										</td>
									</tr>
									<tr style="border: hidden;">
										<td>3. opłacanie składki na ubezpieczenie zdrowotne określonej w odrębnych przepisach za:</td>
										<td colspan="3" style="border: hidden;"></td>
									</tr>
									<tr style="border: hidden;">
										<td style="padding-left: 4mm;">1) cudzoziemca</td>
										<td style="width: 30mm; border: hidden;">
											wysokość
											<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:OplacanieSkladkinaUbezpieczenieZdrowotneDlaCudzoziemca/ns1:Kwota, '0,00')"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											od
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:OplacanieSkladkinaUbezpieczenieZdrowotneDlaCudzoziemca/ns1:DataOd"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											do
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:OplacanieSkladkinaUbezpieczenieZdrowotneDlaCudzoziemca/ns1:DataDo"/></ins>
										</td>
									</tr>
									<tr style="border: hidden;">
										<td style="padding-left: 4mm;">2) członków jego rodziny</td>
										<td style="width: 30mm; border: hidden;">
											wysokość
											<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:OplacanieSkladkinaUbezpieczenieZdrowotneDlaCzlonkowRodziny/ns1:Kwota, '0,00')"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											od
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:OplacanieSkladkinaUbezpieczenieZdrowotneDlaCzlonkowRodziny/ns1:DataOd"/></ins>
										</td>
										<td style="width: 30mm; border: hidden;">
											do
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:OplacanieSkladkinaUbezpieczenieZdrowotneDlaCzlonkowRodziny/ns1:DataDo"/></ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<th>poradnictwo specjalistyczne</th>
						</tr>
						<tr>
							<td>
								rodzaj:
								<div style="min-height: 10mm;">
									<span class="textarea">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PoradnictwoSpecjalistyczne/ns1:Rodzaj"/></ins><br/>
									</span>
								</div>
								zakres:
								<div style="min-height: 10mm;">
									<span class="textarea">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PoradnictwoSpecjalistyczne/ns1:Zakres"/></ins><br/>
									</span>
								</div>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<th>praca socjalna</th>
						</tr>
						<tr>
							<td style="height: 45mm;">
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:ProponowanaPomoc">
									<ins>
										<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
										<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
									</ins>
									<xsl:if test="position() != last()">
										<br/>
									</xsl:if>
								</xsl:for-each>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:PracaSocjalna and ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:PracaSocjalna != ''">
									<br/>
									<span class="textarea">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:PracaSocjalna"/></ins>
									</span>
								</xsl:if>
							</td>
						</tr>
					</table>
					<br/>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika">
				<section style="page-break-before: always;">
					<h3>Uwagi kierownika jednostki organizacyjnej pomocy społecznej</h3>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_W_CALOSCI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					1) zatwierdzam plan w całości
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_Z_ZASTRZEZENIAMI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					2) zatwierdzam plan z następującymi zastrzeżeniami:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:ZastrzezeniaDoPlanuPomocy" /></ins>
					</div>
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ODRZUCENIE'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					3) odrzuca plan ze względu na:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:PowodOdrzuceniaPlanuPomocy" /></ins>
					</div>
					<br/>

					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko kierownika:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								Data
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć kierownika)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
				<br/>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						<span style="text-transform: uppercase;">
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
