﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:ns1="http://www.mpips.gov.pl/empatia/v4/wywiad/cz1i2" 
	xmlns:emp="http://www.mpips.gov.pl/empatia/v4/wywiad/wspolne" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
version="1.0">
<xsl:param name="wspolne" select="'../wspolne/empatia_wspolne_v4.xsd'"/>
<xsl:output method="html" version="1.0" encoding="utf-8" indent="no" omit-xml-declaration="yes" />
<xsl:template match="/">

<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1" />
<meta charset="utf-8" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" href="css/jquery.mobile.css" />
<link rel="stylesheet" href="../css/jquery.mobile.structure.css" />
<link rel="stylesheet" href="../css/themes/empatiaTest.css" />
<link rel="stylesheet" href="css/themes/wizualizacja.css"/>
<link rel="stylesheet" href="../css/ikony.css" type="text/css" />
<script src="css/jquery.js"/>
<script src="css/jquery.mobile.js"/>
<script type="text/javascript" src="wizualizacja_cz1.js"/>
</head>

<body>
<div id="header" style="height:150px; ">
		<form action="wizualizacja.html" id="wizualizacja">
			<div class="odstep"></div>
			<div style="margin-left: 40px; margin-right: 60px;" id="returnButton" data-role="button" data-icon="back"><a class="m" href="#" onclick="window.close()" > - zamknij to okno - </a></div>
			<div class="odstep"></div>
		</form>

		<div style="padding-left:20px; padding-right: 20px;"><p style="font: 24px monospace;  ">Suma kontrolna:&#160;<span style="text-transform: uppercase;"><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,0,9)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,9,8)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,17,8)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,25,8)"/></span>
		</p></div>
</div>
<div id="content" style="height:570px; overflow-y:scroll;">		
		
		
				<div>
					<table border="1" cellpadding="0" cellspacing="0" style="padding-right: 20px; padding-left:20px; width: 100%">
						<tbody>

							<tr>
								<td colspan="6" valign="top">
									<p align="center">KWESTIONARIUSZ RODZINNEGO WYWIADU ŚRODOWISKOWEGO</p>
									<p align="center">CZĘŚĆ I</p>
									<p align="center">DOTYCZY OSÓB UBIEGAJĄCYCH SIĘ O PRZYZNANIE ŚWIADCZEŃ POMOCY SPOŁECZNEJ</p>
								</td>
							</tr>
							<tr>
								<td colspan="6" valign="bottom">
									<p>I. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD, DANE O RODZINIE</p>
										<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']">
						</xsl:when>
						<xsl:otherwise>
							<p align="center"
								style="color: red; font-weight: bold;">BŁĄD
								DANYCH! NIE WYZNACZONO OSOBY GŁÓWNEJ!</p>
						</xsl:otherwise>
					</xsl:choose>
								</td>
							</tr>
							<tr>
								<td style="width: 30px;">
									<p>1</p>
								</td>
								<td>
									<p>Imię</p>
								</td>
								<td>
									<b>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Imie1"/> 
					&#160;
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Imie2"/>
									</b>
								</td>
								<td rowspan="2">
									<p>3</p>
								</td>
								<td rowspan="2">
									<p>Imiona rodziców</p>
								</td>
								<td>
									<b>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:ImieMatki"/>
									</b>
								</td>
							</tr>
							<tr>
								<td>
									<p>2</p>
								</td>
								<td>
									<p>Nazwisko</p>
								</td>
								<td>
									<b>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Nazwisko1"/> 
					&#160;
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Nazwisko2"/>
									</b>
								</td>
								<td>
									<b>
										<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:ImieOjca"/>
									</b>
								</td>
							</tr>
							<tr>
								<td>
									<p>4</p>
								</td>
								<td>
									<p>Obywatelstwo</p>
								</td>
								<td colspan="4">
									<b>
										<xsl:call-template name="Enumeracja">
											<xsl:with-param name="schema" select="$wspolne"/>
											<xsl:with-param name="typ" select="'Obywatelstwo'"/>
											<xsl:with-param name="kod" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:Obywatelstwo/text()"/>
										</xsl:call-template>
									</b>
								</td>
							</tr>
							<tr>
								<td>
									<p>5</p>
								</td>
								<td>
									<p>Seria i nr dokumentu <br />potwierdzającego tożsamość: 
									</p>
								</td>
								<td>
									<b>
										<xsl:call-template name="Enumeracja">
											<xsl:with-param name="schema" select="$wspolne"/>
											<xsl:with-param name="typ" select="'RodzajDokumentu'"/>
											<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:RodzajDokumentu/text()"/>
										</xsl:call-template>
										<br />
										<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:NumerDokumentu"/>
									</b>
								</td>
								<td>
									<p>6</p>
								</td>
								<td>
									<p>Nr PESEL: 
								</p>
								</td>
								<td>
									<b>
										<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:PESEL"/>
									</b>
								</td>
							</tr>
							<tr>
								<td rowspan="5">
									<p>7</p>
								</td>
								<td rowspan="4">
									<p>Adres zamieszkania *<br />  
										<b>
											<xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'RodzajAdresu'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Rodzaj/text()"/>
											</xsl:call-template>
										</b>
									</p>
								</td>
								<td colspan="2">
									<p>kod pocztowy: 
										<b>
										<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy != ''">
										<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),3,3)"/>
										</xsl:if>
										</b>
									</p>
								</td>
								<td colspan="2">
									<p>miejscowość: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Miejscowosc"/>
										</b>
									</p>
								</td>
							</tr>

							<tr>
								<td colspan="2">
									<p>ulica: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Ulica"/>
										</b>
									</p>
								</td>
								<td>
									<p>nr domu: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:NrDomu"/>
										</b>
									</p>
								</td>
								<td>
									<p>nr mieszkania: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:NrLok"/>
										</b>
									</p>
								</td>
							</tr>
							<tr>
								<td>
									<p>telefon: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Telefon"/>
										</b>
									</p>
								</td>
								<td colspan="3">
									<p>telefon najbliższej rodziny: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:TelefonRodziny"/>
										</b>
									</p>
								</td>
							</tr>
							<tr>
								<td colspan="4">
									<p>symbol terytorialny: <b>
											<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:SymbolTerytorialny"/>
										</b>
									</p>
								</td>
							</tr>
							<tr>
								<td>
									<p>Adres pobytu czasowego
									</p>
								</td>
								<td colspan="3">
									<b>
										<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Ulica"/>&#160; <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrDomu"/>
										<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrLok != ''">&#160;
						m.&#160;<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrLok"/>&#160;
										</xsl:if>
										<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy != ''">
										<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy/text(),3,3)"/>
										</xsl:if>
										&#160;<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Miejscowosc"/>
									</b>
								</td>
								<td>
									<p>zameldowanie: <b>
											<xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Zameldowanie/text()"/>
											</xsl:call-template>
										</b>
									</p>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>8</p>
								</td>
								<td valign="top">
									<p>Przyczyny wystąpienia
										<br/>z wnioskiem o udzielenie 
										<br/>pomocy albo udzielenia 
										<br/>pomocy z urzędu:
									</p>
								</td>
								<td colspan="4" valign="top">
									<ul>
										<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Przyczyny/ns1:Przyczyna">
											<li>
												<b>
													<xsl:call-template name="Enumeracja">
														<xsl:with-param name="schema" select="$wspolne"/>
														<xsl:with-param name="typ" select="'RodzajProblemu'"/>
														<xsl:with-param name="kod" select="text()"/>
													</xsl:call-template>
												</b>
											</li>
										</xsl:for-each>
									</ul>
								</td>
							</tr>
							<tr>
								<td rowspan="3" valign="top">
									<p>9</p>
								</td>
								<td colspan="4">
									<p>Czy osoba/rodzina korzystała ze świadczeń jednostki organizacyjnej pomocy
										<br/>społecznej?
									</p>
								</td>
								<td>
									<b>
										<xsl:call-template name="Enumeracja">
											<xsl:with-param name="schema" select="$wspolne"/>
											<xsl:with-param name="typ" select="'TakNie'"/>
											<xsl:with-param name="kod" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:CzyPomocJOPS/text()"/>
										</xsl:call-template>
									</b>
								</td>
							</tr>
							<tr>
								<td>
									<p>Data pierwszego zgłoszenia</p>
								</td>
								<td colspan="4">
									<b>
										<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataZgloszenia/text(),0,11)"/>
									</b>
								</td>
							</tr>
							<tr>
								<td>
									<p>Data ostatnio udzielonej pomocy</p>
								</td>
								<td colspan="4">
									<b>
										<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataPomocy/text(),0,11)"/>
									</b>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>10</p>
								</td>
								<td valign="top">
									<p>Czy osoba/rodzina
										<br/>korzystała lub korzysta
										<br/>z pomocy innych osób lub
										<br/>pomocy instytucji? 
									</p>
								</td>
								<td colspan="2" valign="top">
									<ul>
										<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocInnaOdKogo">
											<li>
												<b>
													<xsl:call-template name="Enumeracja">
														<xsl:with-param name="schema" select="$wspolne"/>
														<xsl:with-param name="typ" select="'ZrodloPomocy'"/>
														<xsl:with-param name="kod" select="text()"/>
													</xsl:call-template>
												</b>
											</li>
										</xsl:for-each>
									</ul>
								</td>
								<td colspan="2" valign="top">
									<ul>
										<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocInnaRodzaj">
											<li>
												<b>
													<xsl:call-template name="Enumeracja">
														<xsl:with-param name="schema" select="$wspolne"/>
														<xsl:with-param name="typ" select="'TypPomocy'"/>
														<xsl:with-param name="kod" select="text()"/>
													</xsl:call-template>
												</b>
											</li>
										</xsl:for-each>
									</ul>
								</td>
							</tr>
						</tbody>
					</table>
					<p>
						<em>* </em>
        W przypadku bezdomnego — ostatnie miejsce zameldowania na pobyt stały (w razie braku możliwości ustalenia — ostatni możliwy do
						<br/>
        potwierdzenia adres).
					</p>
				</div>



				<br clear="all"/>
				<div>
					<p>11. Informacje o członkach rodziny
				</p>
				
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
						<tbody>
							<tr>
								<td style="width: 30px;">
									<p align="center">1</p>
								</td>
								<td>
									<p align="center">2</p>
								</td>
								<td>
									<p align="center">3</p>
								</td>
								<td>
									<p align="center">4</p>
								</td>
								<td>
									<p align="center">5</p>
								</td>
								<td>
									<p align="center">6</p>
								</td>
								<td>
									<p align="center">7</p>
								</td>
								<td>
									<p align="center">8</p>
								</td>
								<td>
									<p align="center">9</p>
								</td>
								<td>
									<p align="center">10</p>
								</td>
								<td>
									<p align="center">11</p>
								</td>
								<td>
									<p align="center">12</p>
								</td>
								<td>
									<p align="center">13</p>
								</td>
							</tr>
							<tr>
								<td rowspan="2">
									<p align="center">Lp.</p>
								</td>
								<td rowspan="2">
									<p align="center">Imię i nazwisko</p>
								</td>
								<td rowspan="2">
									<p align="center">Data urodzenia</p>
								</td>
								<td rowspan="2">
									<p align="center">Płeć</p>
								</td>
								<td rowspan="2">
									<p align="center">Nr PESEL</p>
								</td>
								<td rowspan="2">
									<p align="center">Stan
										<br />cywilny
									</p>
								</td>
								<td rowspan="2">
									<p align="center">Stopień
										<br />pokrewień-
										<br />stwa
									</p>
								</td>
								<td rowspan="2" valign="top">
									<p align="center">Wykształcenie,
										<br/>wykonywany zawód
									</p>
								</td>
								<td rowspan="2" valign="top">
									<p align="center">Miejsce pracy lub nauki
										<br/>(szkoła, przedszkole)
									</p>
								</td>
								<td rowspan="2" valign="top">
									<p align="center">Pozycja
										<br/>na rynku
										<br/>pracy
									</p>
								</td>
								<td rowspan="2" valign="top">
									<p align="center">Sytuacja
										<br/>zdrowotna
									</p>
								</td>
								<td colspan="2" valign="top">
									<p align="center">Źródło dochodu (utrzymania)</p>
								</td>

							</tr>
							<tr>
								<td valign="top">
									<p align="center">rodzaj</p>
								</td>
								<td valign="top">
									<p align="center">wysokość</p>
								</td>
							</tr>

							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
								<xsl:variable name="GOSPODARSTWO"  select="position()"/>

								<xsl:for-each select="ns1:Osoba">
									<xsl:if test="position() = 1 and $GOSPODARSTWO != 1">
										<tr style="height: 2px; background: #000000;">
											<td colspan="13"/>
										</tr>
									</xsl:if>
									<xsl:variable name="POPRZEDNIE" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[(position() &lt; $GOSPODARSTWO)]/ns1:Osoba)"/>
									<tr>
										<td>
											<p align="center">
												<b>
													<xsl:value-of select="$POPRZEDNIE + position()" />
												</b>
											</p>
										</td>
										<td>
											<b>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											</b>
										</td>
										<td>
											<b>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr/text(),0,11)"/>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:call-template name="Enumeracja">
													<xsl:with-param name="schema" select="$wspolne"/>
													<xsl:with-param name="typ" select="'Plec'"/>
													<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:Plec/text()"/>
												</xsl:call-template>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:PESEL"/>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:call-template name="Enumeracja">
													<xsl:with-param name="schema" select="$wspolne"/>
													<xsl:with-param name="typ" select="'StanCywilny'"/>
													<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:StanCywilny/text()"/>
												</xsl:call-template>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:call-template name="Enumeracja">
													<xsl:with-param name="schema" select="$wspolne"/>
													<xsl:with-param name="typ" select="'StopienPokrewienstwa'"/>
													<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa/text()"/>
												</xsl:call-template>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:call-template name="Enumeracja">
													<xsl:with-param name="schema" select="$wspolne"/>
													<xsl:with-param name="typ" select="'RodzajWyksztalcenia'"/>
													<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:Wyksztalcenie/text()"/>
												</xsl:call-template>
												<br />
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Zawod"/>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:MiejscePracy"/>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:call-template name="Enumeracja">
													<xsl:with-param name="schema" select="$wspolne"/>
													<xsl:with-param name="typ" select="'PozycjaNaRynkuTyp'"/>
													<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:PozycjaNaRynku/text()"/>
												</xsl:call-template>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:call-template name="Enumeracja">
													<xsl:with-param name="schema" select="$wspolne"/>
													<xsl:with-param name="typ" select="'SytuacjaZdrowotna'"/>
													<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:SytuacjaZdrowotna/text()"/>
												</xsl:call-template>
											</b>&#160;
										</td>
										<td>
											<b>
												<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
													<xsl:if test="position() != 1">
														<br />
													</xsl:if>
													<xsl:call-template name="Enumeracja">
														<xsl:with-param name="schema" select="$wspolne"/>
														<xsl:with-param name="typ" select="'RodzajDochodu'"/>
														<xsl:with-param name="kod" select="ns1:Rodzaj/text()"/>
													</xsl:call-template>
												</xsl:for-each>
											</b>&#160;
										</td>
										<td align="right">
						&#160;<b>
												<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
													<xsl:if test="position() != 1">
														<br />
													</xsl:if>
													<xsl:value-of select="ns1:Wysokosc"/>
												</xsl:for-each>
											</b>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:for-each>
						</tbody>
					</table>
				</div>
				<br clear="all"/>

				<table border="1" cellpadding="3" cellspacing="0" style="width:100%">
					<tbody>
						<tr>
							<td rowspan="1" valign="top" style="width: 30px;">
								<p>12</p>
							</td>
							<td colspan="6">
								<p>Imię i nazwisko, stopień pokrewieństwa oraz adresy osób, o których mowa w art. 103 ustawy z dnia 12 marca 2004 r.<br />
			o pomocy społecznej, wielkość i forma świadczonej lub deklarowanej pomocy:</p>
								<br />
								<xsl:if test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Art103/ns1:Osoba) &gt; 0">
									<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
										<tbody>
											<tr>
												<td>
													<p align="center">Imię</p>
												</td>
												<td>
													<p align="center">Nazwisko</p>
												</td>
												<td >
													<p align="center">Stopień pokrewieństwa</p>
												</td>
												<td >
													<p align="center">Adres</p>
												</td>
												<td valign="top">
													<p align="center">Uwagi</p>
												</td>
												<td valign="top">
													<p align="center">Rodzaj pomocy</p>
												</td>
												<td valign="top">
													<p align="center">Wielkość pomocy</p>
												</td>
												<td valign="top">
													<p align="center">Kwota pomocy</p>
												</td>
											</tr>

											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Art103/ns1:Osoba">	

												<tr>
													<td>	
														<b>
															<xsl:value-of select="ns1:Imie1"/>&#160;<xsl:value-of select="ns1:Imie2"/>
														</b> 
													</td>
													<td>	
														<b>
															<xsl:value-of select="ns1:Nazwisko1"/>&#160;<xsl:value-of select="ns1:Nazwisko2"/>
														</b>
													</td>
													<td>	
														<b>
															<xsl:call-template name="Enumeracja">
																<xsl:with-param name="schema" select="$wspolne"/>
																<xsl:with-param name="typ" select="'StopienPokrewienstwa'"/>
																<xsl:with-param name="kod" select="ns1:StopienPokrewienstwa/text()"/>
															</xsl:call-template>
														</b>
													</td>
													<td>	
														<b>
															<xsl:call-template name="Adres1Linia"/>
														</b> 
													</td>	
													<td>	
														<b>
															<xsl:value-of select="ns1:Uwagi"/>
														</b> 
													</td>	
													<td>	
														<b>
															<xsl:value-of select="ns1:RodzajPomocy"/>
														</b> 
													</td>	
													<td>	
														<b>
															<xsl:value-of select="ns1:WielkoscPomocy"/>
														</b> 
													</td>	
													<td>	
														<b>
															<xsl:value-of select="ns1:KwotaPomocy"/>
														</b> 
													</td>
												</tr>
											</xsl:for-each>
										</tbody>
									</table>
								</xsl:if>

							</td>

						</tr>
					
						<tr>
							<td>
								<p>13</p>
							</td>
							<td colspan="5">
								<p>Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej) </p>
							</td>
							<td style="text-align: right;">
								<b>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochod"/> zł</b>
							</td>
						</tr>
					
						<tr>
							<td>
								<p>14</p>
							</td>
							<td colspan="4">
								<p>Stałe, miesięczne wydatki osoby/rodziny łącznie:</p>
							</td>
							<td colspan="2" style="text-align: right;">
								<p>
									<b>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Razem"/> zł</b>
								</p>
							</td>
						</tr>
						<tr>
							<td>
							</td>
							<td colspan="6">
								<p>w tym:</p>
							</td>
						</tr>
						<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek">	
							<tr>
								<td>
								</td>
								<td colspan="4">
									<b>
										<xsl:call-template name="Enumeracja">
											<xsl:with-param name="schema" select="$wspolne"/>
											<xsl:with-param name="typ" select="'RodzajWydatku'"/>
											<xsl:with-param name="kod" select="ns1:Rodzaj/text()"/>
										</xsl:call-template>
										<xsl:if test="ns1:Rodzaj = '99'">
						&#160;<xsl:value-of select="ns1:Uwagi"/>
										</xsl:if>
									</b>
								</td>
								<td colspan="2" style="text-align: right;">
									<b>
										<xsl:value-of select="ns1:Kwota"/> zł</b>
								</td>
							</tr>
						</xsl:for-each>
					
						<tr>
							<td>
								<p>15</p>
							</td>
							<td colspan="6">
								<p>Alimenty świadczone przez osobę, z którą jest przeprowadzany wywiad, lub innych członków rodziny:</p>

								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
									<xsl:variable name="GOSPODARSTWO"  select="position()"/>
									<xsl:for-each select="ns1:Osoba">
										<xsl:if test="count(ns1:Alimenty/ns1:NaKogo/ns1:Osoba/ns1:DanePodstawowe) &gt; 0">
										<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
									<tbody>
										<tr>
											<td>
												<p align="center">Przez kogo?</p>
											</td>
											<td colspan="2">
												<b>
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160; 
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>&#160;
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160; 
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
												</b>
											</td>
										</tr>
										<xsl:for-each select="ns1:Alimenty/ns1:NaKogo/ns1:Osoba">
											<tr>
												<td>
													<p align="center">Na czyją rzecz?
													</p>
												</td>
												<td>Imię:
														<b><xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
													&#160;
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
													</b>
													<br/>Nazwisko:
														<b><xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
													&#160;
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
													</b>
													<br/>Data urodzenia: <b>
														<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr/text(),0,11)"/>
													</b>
													<br/>Płeć: <b>
														<xsl:call-template name="Enumeracja">
															<xsl:with-param name="schema" select="$wspolne"/>
															<xsl:with-param name="typ" select="'Plec'"/>
															<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:Plec/text()"/>
														</xsl:call-template>
													</b>
													<br/>Numer PESEL: <b>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:PESEL"/>
													</b>
													<br/>Adres: <b><xsl:for-each select="ns1:AdresZamieszkania"><xsl:call-template name="Adres1Linia"/></xsl:for-each></b>
													<br/>Telefon: <b>
														<xsl:value-of select="ns1:AdresZamieszkania/ns1:Telefon"/>
													</b>
													<br/>Rodzaj adresu: <b>
														<xsl:call-template name="Enumeracja">
															<xsl:with-param name="schema" select="$wspolne"/>
															<xsl:with-param name="typ" select="'RodzajAdresu'"/>
															<xsl:with-param name="kod" select="ns1:AdresZamieszkania/ns1:Rodzaj/text()"/>
														</xsl:call-template>
													</b>
													<br/>
												</td>
												<td>
													<table width="100%" border="1" cellpadding="0" cellspacing="0">
														<tbody>
															<xsl:for-each select="ns1:SwiadczenieAlimentacjne">
																<tr>
																	<td>
																		<p>Wysokość</p>
																	</td>
																	<td>
																		<b>
																			<xsl:value-of select="ns1:Wysokosc/text()"/>
																		</b>
																	</td>
																	<td rowspan="2">
																		<xsl:if test="ns1:Rodzaj = 'dobrowolne'">
																			<b>dobrowolne</b>
																		</xsl:if>
																		<xsl:if test="ns1:Rodzaj = 'orzeczenie'">
																			<b>na podstawie orzeczenia sądu</b>
																		</xsl:if>
																	</td>
																</tr>
																<tr>
																	<td >
																		<p>Wysokość zaległych alimentów</p>
																	</td>
																	<td>
																		<b>
																			<xsl:value-of select="ns1:Zalegle/text()"/>
																		</b>
																	</td>
																</tr>
															</xsl:for-each>	
														</tbody>
													</table>
												</td>
											</tr>
										</xsl:for-each>	
									</tbody>
								</table>	
										</xsl:if>
									</xsl:for-each>
								</xsl:for-each>
							</td>





						</tr>
					</tbody>
				</table>

				<br clear="all"/>
				<div>
					<p>II. SYTUACJA MIESZKANIOWA OSOBY/RODZINY
				</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top" style="width: 30px;">
									<p>1</p>
								</td>
								<td colspan="6" valign="top">
									<p>Główny lokator lub właściciel mieszkania, domu (imię i nazwisko, adres)
								</p>
									<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:GlownyWlasciciel">
											<p>Imię: <b><xsl:value-of select="ns1:Imie1"/>&#160;<xsl:value-of select="ns1:Imie2"/></b>
											<br />Nazwisko: <b><xsl:value-of select="ns1:Nazwisko1"/>&#160;<xsl:value-of select="ns1:Nazwisko2"/></b>
											<br />Adres: <b><xsl:call-template name="Adres1Linia"/></b>
										</p>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>2</p>
								</td>
								<td colspan="2" valign="top">
									<p>Mieszkanie:</p>
								</td>
								<td colspan="4" valign="top">
									<p>
										<b>
										<xsl:call-template name="Enumeracja">
											<xsl:with-param name="schema" select="$wspolne"/>
											<xsl:with-param name="typ" select="'RodzajMieszkania'"/>
											<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Rodzaj"/>
										</xsl:call-template>
										<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:RodzajUwagi != ''">
											&#160;
											(<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:RodzajUwagi"/>)
										</xsl:if>
										</b>
									</p>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>3</p>
								</td>
								<td valign="top">
									<p>Liczba izb</p>
								</td>
								<td>
									<b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:LiczbaIzb"/></b>
								</td>
								<td valign="top">
									<p>4</p>
								</td>
								<td colspan="3" valign="top">
									<p>Oddzielna kuchnia: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:OddzielnaKuchnia/text()"/>
											</xsl:call-template></b></p>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>5</p>
								</td>
								<td valign="top">
									<p>Piętro</p>
								</td>
								<td>
									<b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Pietro"/></b>
								</td>
								<td valign="top">
									<p>6</p>
								</td>
								<td colspan="3" valign="top">
									<p>Winda: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Winda/text()"/>
											</xsl:call-template></b></p>
								</td>
							</tr>
							<tr>
								<td rowspan="5">
									<p>7</p>
								</td>
								<td colspan="6">
									<p>Wyposażenie mieszkania w instalacje:
								</p>
								</td>
							</tr>
							<tr>
								
								<td colspan="3" valign="top">
									<p>woda zimna: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'WyposazenieWodaZimna'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:WodaZimna/text()"/>
											</xsl:call-template></b></p>
								</td>
								<td colspan="3" valign="top">
									<p>woda ciepła: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'WyposazenieWodaCiepla'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:WodaCiepla/text()"/>
											</xsl:call-template></b></p>
								</td>
							</tr>
							<tr>
								
								<td colspan="3" valign="top">
									<p>łazienka: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'WyposazenieLazienka'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Lazienka/text()"/>
											</xsl:call-template></b></p>
								</td>
								<td colspan="3" valign="top">
									<p>WC: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'WyposazenieWC'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:WC/text()"/>
											</xsl:call-template></b></p>
								</td>
							</tr>
							<tr>
								
								<td colspan="6" valign="top">
									<p>ogrzewanie: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'WyposazenieOgrzewanie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Ogrzewanie/text()"/>
											</xsl:call-template></b></p>
								</td>
							</tr>
							<tr>
								
								<td colspan="3" valign="top">
									<p>gaz: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Gaz/text()"/>
											</xsl:call-template></b></p>
								</td>
								<td colspan="3" valign="top">
									<p>telefon: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Telefon/text()"/>
											</xsl:call-template></b></p>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>8</p>
								</td>
								<td colspan="6" valign="top">
									<p>Stan utrzymania mieszkania:  <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'StanMieszkania'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:StanMieszkania/text()"/>
											</xsl:call-template></b>
								</p>
								</td>
							</tr>
							<tr>
								<td valign="top" rowspan="2">
									<p>9</p>
								</td>
								<td colspan="6" valign="top">
									<p>Czy rodzina posiada podstawowe sprzęty gospodarstwa domowego*: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:CzySprzety/text()"/>
											</xsl:call-template></b>
								</p>
								</td>
							</tr>
							<tr>
								
								<td colspan="6" valign="top">
									<p>Jeżeli nie, to wymienić, jakich sprzętów brakuje:<br />
									<b>
										<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:BrakujaceSprzety/ns1:Sprzet">
											<xsl:value-of select="text()" /><br />
										</xsl:for-each>
									</b></p>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>10</p>
								</td>
								<td colspan="4" valign="top">
									<p>Liczba miejsc do spania
								</p>
								</td>
								<td colspan="2">
									<b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:MiejscaDoSpania"/></b>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>11</p>
								</td>
								<td colspan="6" valign="top">
									<p>Czy mieszkanie jest dostosowane do potrzeb osoby niepełnosprawnej: <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:CzyDostosowaneNiepeln/text()"/>
											</xsl:call-template></b>
								</p>
								</td>
							</tr>
							<tr>
								<td valign="top" rowspan="2">
									<p>12</p>
								</td>
								<td colspan="3" valign="top" rowspan="2">
									<p>Czy osoba niepełnosprawna posiada
								</p>
								</td>
								<td colspan="3" valign="top">
									<p>osobny pokój <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:OsobnyPokojNiepeln/text()"/>
											</xsl:call-template></b>
								</p>
								</td>
							</tr>
							<tr>
								
								<td colspan="3" valign="top">
									<p>samodzielne łóżko <b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:SamodzielneLozkoNiepeln/text()"/>
											</xsl:call-template></b>
								</p>
								</td>
							</tr>
						</tbody>
					</table>
					<p>* Tj. sprzęt niezbędny danej osobie lub rodzinie do prowadzenia, w miarę możliwości, samodzielnego gospodarstwa domowego.
				</p>
					<p>III. SYTUACJA RODZINNA OSÓB WSPÓLNIE ZAMIESZKUJĄCYCH
				</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top" style="width: 30px;">
									<p>1</p>
								</td>
								<td colspan="2" valign="top">
									<p>
                        Kto z członków rodziny i dlaczego, mimo wspólnego zamieszkiwania, prowadzi oddzielne gospodarstwo
										<br/>
                        domowe?
									</p>
									<xsl:if test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo) &gt; 1">
									
										<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:if test="count(ns1:PrzyczynaOsobnego) &gt; 0">
												<p>
													<b><xsl:value-of select="position()"/>)&#160;
													<xsl:for-each select="ns1:Osoba">
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>,&#160;
														
													</xsl:for-each><br />
													
													<xsl:value-of select="ns1:PrzyczynaOsobnego"/> 
													</b>
												</p>
											</xsl:if>
										</xsl:for-each>
									</xsl:if>
									
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>2</p>
								</td>
								<td valign="top">
									<p>Czy w rodzinie występują konflikty: 
										<b><xsl:if test="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Konflikty) &gt; 0">Tak</xsl:if>
										<xsl:if test="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Konflikty) = 0">Nie</xsl:if></b>
									</p>
								</td>
								<td>
									<p>Kogo dotyczą:
										<b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
												<xsl:if test="count(ns1:Konflikty) &gt; 0">
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>,&#160;
												</xsl:if>
											</xsl:for-each>
										</xsl:for-each></b>
									</p>
								</td>
							</tr>
							<tr>
								<td valign="top" rowspan="3">
									<p>3</p>
								</td>
								<td colspan="2" valign="top">
									<p>Przyczyny konfliktów:
										<b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
												<xsl:if test="count(ns1:Konflikty) &gt; 0">
													<xsl:value-of select="ns1:Konflikty/ns1:Przyczyna"/>,&#160;
												</xsl:if>
											</xsl:for-each>
										</xsl:for-each></b>
									</p>
								</td>
							</tr>
							<tr>

								<td colspan="2" valign="top">
									<p>Czy były podejmowane próby rozwiązania konfliktów: <b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
												<xsl:if test="count(ns1:Konflikty) &gt; 0">
													<xsl:call-template name="Enumeracja">
														<xsl:with-param name="schema" select="$wspolne"/>
														<xsl:with-param name="typ" select="'TakNie'"/>
														<xsl:with-param name="kod" select="ns1:Konflikty/ns1:CzyProbyRozwiazania/text()"/>
													</xsl:call-template>,&#160;
												</xsl:if>
											</xsl:for-each>
										</xsl:for-each></b>
								</p>
								</td>
							</tr>
							<tr>

								<td colspan="2" valign="top">
									<p>Możliwości rozwiązania konfliktów:
										<b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
												<xsl:if test="count(ns1:Konflikty) &gt; 0">
													<xsl:value-of select="ns1:Konflikty/ns1:Mozliwosci"/>,&#160;
												</xsl:if>
											</xsl:for-each>
										</xsl:for-each></b>
									</p>
								</td>
							</tr>
							<tr>
								<td valign="top" rowspan="3">
									<p>4</p>
								</td>
								<td colspan="2" valign="top">
									<p>Czy występują problemy opiekuńczo-wychowawcze z dziećmi? Jakie?
										<b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
											
												<xsl:if test="count(ns1:ProblemyWychowawcze) &gt; 0">
												<br />
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
													<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>,&#160;
													<xsl:value-of select="ns1:ProblemyWychowawcze/ns1:Opis"/>
												<br />
												</xsl:if>
												
											</xsl:for-each>
										</xsl:for-each></b>
									</p>
								</td>
							</tr>
							<tr>
							
								<td colspan="2" valign="top">
									<p>Jeżeli tak, to czy były lub są podejmowane próby ich rozwiązania. Jakie?
										<b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
												<xsl:if test="count(ns1:ProblemyWychowawcze) &gt; 0">
													<xsl:value-of select="ns1:ProblemyWychowawcze/ns1:ProbyRozwiazania"/>,&#160;
												</xsl:if>
											</xsl:for-each>
										</xsl:for-each></b>
								</p>
								</td>
							</tr>
							<tr>
								<td colspan="2" valign="top">
									<p>Czy rodzina lub dziecko są objęci nadzorem kuratora? <b><xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">	
											<xsl:for-each select="ns1:Osoba">
												<xsl:if test="count(ns1:ProblemyWychowawcze) &gt; 0">
													<xsl:call-template name="Enumeracja">
														<xsl:with-param name="schema" select="$wspolne"/>
														<xsl:with-param name="typ" select="'TakNie'"/>
														<xsl:with-param name="kod" select="ns1:ProblemyWychowawcze/ns1:Kurator/text()"/>
													</xsl:call-template>,&#160;
												</xsl:if>
											</xsl:for-each>
										</xsl:for-each>
									<xsl:if test="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:ProblemyWychowawcze) = 0">Nie</xsl:if>	
									</b>
								</p>
								</td>
							</tr>
							<tr>
								<td valign="top" rowspan="5">
									<p>5</p>
								</td>
								<td colspan="2" valign="top">
									<p>Czy w rodzinie występuje przemoc? <b>
									<b><xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Przemoc/ns1:CzyPrzemoc/text()"/>
											</xsl:call-template></b>
									</b>
								</p>
								</td>
							</tr>
							<tr>
								<td colspan="2" valign="top">
									<p>Przeciwko komu jest skierowana?
									
									<b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Przemoc/ns1:PrzeciwKomu"/></b>
								</p>
								</td>
							</tr>
							<tr>
								<td colspan="2" valign="top">
									<p>Kto jest sprawcą przemocy?
									<b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Przemoc/ns1:Sprawca"/></b>
								</p>
								</td>
							</tr>
							<tr>
								<td colspan="2" valign="top">
									<p>Jakie podjęto działania? 
									<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'PodjeteDzialania'"/>
										<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Przemoc/ns1:PodjeteDzialania/text()"/>
									</xsl:call-template></b>
									<br />(Czy wszczęto procedurę „Niebieskiej Karty”? Czy powołano w tej sprawie zespół interdyscyplinarny lub grupę roboczą?) 
									<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'TakNie'"/>
										<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Przemoc/ns1:NiebieskaKarta/text()"/>
									</xsl:call-template></b>
								</p>
								</td>
							</tr>
							<tr>
								<td colspan="2" valign="top">
									<p>Efekt podjętych działań:
									<b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Przemoc/ns1:Efekty"/></b>
									</p>
								</td>
							</tr>
						</tbody>
					</table>
					
					
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top" rowspan="2" style="width: 30px;">
									<p>6</p>
								</td>
								<td colspan="10" valign="top">
									<p>Funkcjonowanie rodziny w środowisku i zagrożenia ze strony środowiska<br />
									<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Srodowisko"/></b></p>
								</td>
							</tr>
							<tr>
								<td colspan="10" valign="top">
									<p>Możliwość uzyskania wsparcia ze strony środowiska <br />
									<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:WsparcieSrodowiska"/></b>
								</p>
								
								</td>
							</tr>
							<tr>
								<td valign="top" rowspan="4">
									<p>7</p>
								</td>
								<td colspan="10" valign="top">
									<p>Czy osoba/rodzina utrzymuje kontakty z krewnymi:&#160; </p>
									
								</td>
							</tr>
							<tr>
								<td colspan="10" valign="top">
									<p>Jeżeli tak, to z kim?<br />
									<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Krewni/ns1:ZKim"/></b>
								</p>
								
								</td>
							</tr>
							<tr>
								
								<td colspan="10" valign="top">
									<p>Jak często: &#160;<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Krewni/ns1:Czestotliwosc" /></b></p>
								</td>
							</tr>
							<tr>
								<td colspan="10" valign="top">
									<p>Jeżeli nie, to dlaczego? <br />
									<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny/ns1:Krewni/ns1:PrzyczynyBrakuKontaktu"/></b>
								</p>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p>8</p>
								</td>
								<td colspan="8" valign="top">
							
                        Czy ktoś z członków rodziny korzysta lub korzystał z usług ośrodka wsparcia, domu pomocy społecznej lub placówki opiekuńczo-wychowawczej, przebywa lub przebywał w zakładzie poprawczym, schronisku dla nieletnich, specjalnym ośrodku szkolno-wychowawczym, specjalnym ośrodku wychowawczym, młodzieżowym ośrodku wychowawczym, młodzieżowym ośrodku socjoterapii lub innej placówce systemu oświaty?

								</td>
								<td colspan="2" valign="top">
							<p>
									<b><xsl:if test="not ( count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Placowka) &gt; 0)">Nie
									</xsl:if>
									<xsl:if test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Placowka) &gt; 0">
									Tak
									</xsl:if></b>
								</p>
								</td>
							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="10" valign="bottom">
									<p>Jeżeli tak, to z jakiego rodzaju placówki?
								</p>
								</td>
								
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
							<xsl:for-each select="ns1:Osoba">
							
							<xsl:if test="count(ns1:Placowka) &gt; 0">
							<tr>
								<td valign="top">
								</td>
								<td colspan="10" valign="bottom">
									<p>	<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;
									</b>
								</p>
								</td>
								
							</tr>
							
							<xsl:for-each select="ns1:Placowka">
							<tr>
								<td valign="top">
								</td>
								<td colspan="12" valign="bottom">
									<p>Rodzaj:&#160; 
									
									<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'RodzajPlacowki'"/>
										<xsl:with-param name="kod" select="ns1:Rodzaj/text()"/>
									</xsl:call-template></b>
									</p>
								</td>

							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="12" valign="bottom">
									<p>Adres:&#160; <b><xsl:value-of select="ns1:Adres"/></b></p>
								</td>

							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="12" valign="bottom">
									<p>Czas pobytu i data zakończenia pobytu:&#160;<b>od&#160;<xsl:value-of select="substring(ns1:DataOd/text(),0,11)"/>&#160;do&#160;	<xsl:value-of select="substring(ns1:DataDo/text(),0,11)"/></b>
								</p>
								</td>		
							</tr>
							</xsl:for-each>	
						</xsl:if>
						</xsl:for-each>	
						</xsl:for-each>	
						
							<tr>
								<td valign="top">
									<p>9</p>
								</td>
								<td colspan="8" valign="top">
									<p>Czy ktoś z członków rodziny przebywa lub przebywał w zakładzie karnym:
								</p>
								</td>
								<td colspan="2" valign="top">
								<p>
									<b><xsl:if test="not ( count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:ZakladKarny) &gt; 0)">Nie
									</xsl:if>
									<xsl:if test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:ZakladKarny) &gt; 0">
									Tak
									</xsl:if></b>
								</p>
								</td>
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
							<xsl:for-each select="ns1:Osoba">
							
							<xsl:if test="count(ns1:ZakladKarny) &gt; 0">
							<tr>
								<td valign="top">
								</td>
								<td colspan="10" valign="bottom">
									<p>	<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;
									</b>
								</p>
								</td>
								
							</tr>

							<xsl:for-each select="ns1:ZakladKarny">
						
							<tr>
								<td valign="top">
								</td>
								<td colspan="12" valign="bottom">
									<p>Adres:&#160; <b><xsl:value-of select="ns1:Adres"/></b></p>
								</td>

							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="12" valign="bottom">
									<p>Czas pobytu i data zakończenia pobytu:&#160;<b>od&#160;<xsl:value-of select="substring(ns1:DataOd/text(),0,11)"/>&#160;do&#160;	<xsl:value-of select="substring(ns1:DataDo/text(),0,11)"/></b>
								</p>
								</td>		
							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="8" valign="top">
									<p>Jeżeli przebywa, to czy jest zatrudniony i czy jego zarobki są przekazywane rodzinie:
								</p>
								</td>
								<td colspan="2" valign="top">
									<p>
									<b><xsl:if test="not (ns1:CzyZatrudniony = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:CzyZatrudniony = 'T'">
									Tak
									</xsl:if></b>
								</p>
							
								</td>
							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="4" valign="top">
									<p>wysokość</p>
								</td>
								<td colspan="2">
									<b><xsl:value-of select="ns1:Wysokosc"/></b>
								</td>
								<td valign="top">
									<p>jak często
								</p>
								</td>
								<td colspan="3">
								<b><xsl:value-of select="ns1:Czestotliwosc"/></b>
								</td>
							</tr>
							</xsl:for-each>	
						</xsl:if>
						</xsl:for-each>	
						</xsl:for-each>	
							
							
						</tbody>
					</table>
				</div>
				<br clear="all"/>
				<div>
					<p>IV. SYTUACJA ZAWODOWA
				</p>
					<p>A. Sytuacja osoby bezrobotnej
				</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td>
									<p align="center">1</p>
								</td>
								<td>
									<p align="center">2</p>
								</td>
								<td>
									<p align="center">3</p>
								</td>
								<td>
									<p align="center">4</p>
								</td>
								<td colspan="2">
									<p align="center">5</p>
								</td>
								<td>
									<p align="center">6</p>
								</td>
								<td colspan="2">
									<p align="center">7</p>
								</td>
								<td>
									<p align="center">8</p>
								</td>
							</tr>
							<tr>
								<td rowspan="3" valign="top">
									<p align="center">Imię i nazwisko</p>
								</td>
								<td>
									<p align="center">
                        Zarejestrowany(na)<br /> w urzędzie pracy
									</p>
								</td>
								<td colspan="4">
									<p align="center">Pobiera zasiłek lub inne świadczenie</p>
								</td>
								<td colspan="3">
									<p align="center">Utracił(a) prawo do zasiłku<br />
									lub innego świadczenia</p>
								</td>
								<td>
									<p align="center">Brak prawa<br/>
									do zasiłku lub innego<br />
									świadczenia</p>
								</td>
							</tr>
							<tr>
								<td rowspan="2" valign="top">
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
								<td rowspan="2" valign="top">
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
								<td rowspan="2">
									<p align="center">rodzaj i wysokość zasiłku lub innego świadczenia</p>
								</td>
								<td colspan="2">
									<p align="center">od kiedy</p>
								</td>
								<td rowspan="2">
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
								<td colspan="2">
									<p align="center">od kiedy</p>
								</td>
								<td rowspan="2">
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
							</tr>
							<tr>
								<td>
									<p align="center">mies.</p>
								</td>
								<td>
									<p align="center">rok</p>
								</td>
								<td>
									<p align="center">mies.</p>
								</td>
								<td>
									<p align="center">rok</p>
								</td>
							</tr>
							<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Bezrobotny/*">
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
							<xsl:for-each select="ns1:Osoba">
							<xsl:if test="ns1:Bezrobotny/*">
							<tr>
								<td valign="top">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;
									</b>
								</td>
								<td valign="top">
									<b><xsl:if test="not (ns1:Bezrobotny/ns1:CzyZarejestrowanyUP = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Bezrobotny/ns1:CzyZarejestrowanyUP = 'T'">
									Tak
									</xsl:if></b>
								</td>
								<td valign="top">
									<b><xsl:if test="not (ns1:Bezrobotny/ns1:CzyPobieraZasilek = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Bezrobotny/ns1:CzyPobieraZasilek = 'T'">
									Tak
									</xsl:if></b>
								</td>
								<td valign="top">
								<b>							
							<xsl:value-of select="ns1:Bezrobotny/ns1:RodzajZasilku"/>
								<br />
								<xsl:value-of select="ns1:Bezrobotny/ns1:WysokoscZasilku"/>
								</b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyZasilek/text(),6,2)"/>
								</b>
								</td>
								<td valign="top">
								<b>
									<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyZasilek/text(),0,5)"/>
									</b>
								</td>
								<td valign="top">
									<b><xsl:if test="not (ns1:Bezrobotny/ns1:CzyUtracilZasilek = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Bezrobotny/ns1:CzyUtracilZasilek = 'T'">
									Tak
									</xsl:if></b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyUtracilZasilek/text(),6,2)"/>
								</b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyUtracilZasilek/text(),0,5)"/>
								</b>
								</td>
								<td valign="top">
								<b><xsl:if test="not (ns1:Bezrobotny/ns1:CzyBrakPrawaDoZasilku = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Bezrobotny/ns1:CzyBrakPrawaDoZasilku = 'T'">
									Tak
									</xsl:if></b>
								</td>
							</tr>
								</xsl:if>
							</xsl:for-each>
							</xsl:for-each>
							</xsl:when>
						<xsl:otherwise>
							<tr>
								<td valign="top">&#160;</td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
							
						</tbody>
					</table>
					<p>
        B. Kwalifikacje, umiejętności oraz doświadczenie zawodowe mogące być przydatne przy poszukiwaniu pracy
						<br/>
        (np. prawo jazdy, uprawnienia do wykonywania określonych prac)
					</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>						
							<tr>
								<td>

							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
							<xsl:for-each select="ns1:Osoba">
								<xsl:if test="count(ns1:Bezrobotny/ns1:Kwalifikacja) &gt; 0">
								<p><b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;
									:</b>
									<br />
								Rodzaj i opis kwalifikacji:
								<br />
								<xsl:for-each select="ns1:Bezrobotny/ns1:Kwalifikacja">
									<b>-&#160; <xsl:value-of select="ns1:Rodzaj"/>&#160;-&#160;<xsl:value-of select="ns1:Opis"/></b>
									<br />
								</xsl:for-each>
								
								</p>
								</xsl:if>
								</xsl:for-each>
							</xsl:for-each>
								</td>
							</tr>
						
						</tbody>
					</table>
				</div>
				<br clear="all"/>
				<div>
					<p>V. SYTUACJA ZDROWOTNA
				</p>
					<p>A. Sytuacja zdrowotna rodziny
				</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top">
									<p align="center">1</p>
								</td>
								<td colspan="3" valign="top">
									<p>Liczba osób długotrwale chorych:
								</p>
								</td>
								<td colspan="2" valign="top">
								<b> <xsl:value-of select="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Choroby/ns1:Dlugotrwale)"/></b>
								</td>
							
							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="3" valign="top">
									<p>w tym dzieci:
								</p>
								</td>
								<td colspan="2" valign="top">
								<b> <xsl:value-of select="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Choroby/ns1:CzyDziecko[.='T'])"/></b>
								</td>
								
								
						
							</tr>
							<tr>
							<td valign="top">
								</td>
							<td colspan="5">
									<p>Rodzaje schorzeń</p>
									
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
									
									<xsl:if test="count(ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie) &gt; 0">
									
								
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;
									:</b>
					
									
									<xsl:for-each select="ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie">
							<li>
								<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'Schorzenie'"/>
										<xsl:with-param name="kod" select="text()"/>
									</xsl:call-template></b>
									
									</li>
										</xsl:for-each>
										<br />
								</xsl:if>
								
								</xsl:for-each>
								</xsl:for-each>
									
									
								</td>
							</tr>
					
							
							
							
							<tr>
								<td>
									<p align="center">2</p>
								</td>
								<td colspan="5">
									<p>Inne problemy zdrowotne podane przez osobę/rodzinę
								</p>
								</td>
							</tr>
							<tr>	
								<td>
									<p align="center"></p>
								</td>
							<td colspan="5">
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
									
									<xsl:if test="count(ns1:Choroby/ns1:Inne) &gt; 0">
									
								
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;
									:</b>
					
									
									<xsl:for-each select="ns1:Choroby/ns1:Inne/ns1:Opis">
							<li>
								<b>	<xsl:value-of select="text()"/></b>
									
									</li>
										</xsl:for-each>
										<br />
								</xsl:if>
								
								</xsl:for-each>
								</xsl:for-each>
								
								</td>
							</tr>

							<tr>
								<td valign="top">
									<p align="center">3</p>
								</td>
								<td colspan="5" valign="top">
									<p>Czy osoba/rodzina podlega ubezpieczeniu zdrowotnemu?
								</p>
								</td>
								
							</tr>
							<tr>	
								<td>
									<p align="center"></p>
								</td>
							<td colspan="5">
							
									<b><xsl:if test="not (ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyUbezpieczenie = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyUbezpieczenie = 'T'">
									Tak
									</xsl:if></b>
							
								</td>
								</tr>
							
							
							<tr>
								<td valign="top">
									<p align="center">4</p>
								</td>
								<td colspan="5" valign="top">
									<p>Czy osoba/rodzina posiada dostęp do świadczeń zdrowotnych?</p>
								</td>
							
							</tr>
									<tr>	
								<td>
									<p align="center"></p>
								</td>
							<td colspan="5">
							
								<b><xsl:if test="not (ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyDostepDoSwiadczen = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyDostepDoSwiadczen = 'T'">
									Tak
									</xsl:if></b>
							
								</td>
								</tr>
							
							<tr>
								<td valign="top">
								</td>
								<td colspan="5" valign="top">
									<p>Jeżeli nie, to dlaczego?
								</p>
										<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:PrzyczynyBrakuDostepu"/></b>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p align="center">5</p>
								</td>
								<td colspan="5" valign="top">
									<p>Dane lekarza podstawowej opieki zdrowotnej (imię, nazwisko, adres miejsca udzielania świadczeń zdrowotnych, telefon):
								</p>
									<xsl:if test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:Lekarz) &gt; 0">
								<p>
								<center>
									<table border="1" cellpadding="0" cellspacing="0" style="width: 90%">
						<tbody>
							<tr>
							
							<td>
							Imię
							</td>
							<td>
							Nazwisko
							</td>
							
							<td>
							Adres miejsca udzielania świadczeń zdrowotnych
							</td>
							
							<td>
							Telefon
							</td>
							
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:Lekarz">	
							<tr>
							
							<td>
							<b><xsl:value-of select="ns1:Imie"/></b>
							</td>
							<td>
							<b><xsl:value-of select="ns1:Nazwisko"/></b>
							</td>
							
							<td>
<b><xsl:value-of select="ns1:Adres"/></b>
							</td>
							
							<td>
							<b><xsl:value-of select="ns1:Telefon"/></b>
							</td>
							
							</tr>
							
							</xsl:for-each>
							
							</tbody>
								</table>
								<br />
								</center>
									</p>
								</xsl:if>
							
								
								</td>
							</tr>
						
						</tbody>
					</table>
				</div>
				<br clear="all"/>
				<div>
					<p>B. Sytuacja osób niepełnosprawnych
				</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top">
									<p align="center">1</p>
								</td>
								<td valign="top">
									<p align="center">2</p>
								</td>
								<td valign="top">
									<p align="center">3</p>
								</td>
								<td valign="top">
									<p align="center">4</p>
								</td>
								<td colspan="2" valign="top">
									<p align="center">5</p>
								</td>
								<td colspan="2" valign="top">
									<p align="center">6</p>
								</td>
								<td valign="top">
									<p align="center">7</p>
								</td>
								<td valign="top">
									<p align="center">8</p>
								</td>
								<td valign="top">
									<p align="center">9</p>
								</td>
								
							</tr>
							<tr>
								<td rowspan="4">
									<p align="center">Imię i nazwisko</p>
								</td>
								<td rowspan="4">
									<p align="center">Rodzaj dysfunkcji</p>
								</td>
								<td rowspan="3">
									<p align="center">Ustalona grupa inwalidzka,<br /> stopień niepełno­sprawności, niezdolność do samodzielnej egzystencji<br /> lub niezdolność do pracy</p>
								</td>
								<td colspan="3">
									<p align="center">
                        Orzeczenie powiatowego zespołu ds. orzekania o niepełnosprawności
									</p>
								</td>
								<td colspan="2">
									<p align="center"> Termin kolejnego badania</p>
								</td>
								<td colspan="2">
									<p align="center">Wynik orzeczenia</p>
								</td>
								<td rowspan="4">
									<p align="center">Ograniczenia funkcjonalne</p>
								</td>
						
							</tr>
							<tr>
								<td rowspan="3">
									<p align="center">numer</p>
								</td>
								<td colspan="2" valign="bottom">
									<p align="center">data</p>
								</td>
								<td rowspan="3">
									<p align="center">mies.</p>
								</td>
								<td rowspan="3">
									<p align="center">rok</p>
								</td>
								<td rowspan="3">
									<p align="center">stopień niepełnosprawności</p>
								</td>
								<td rowspan="3" >
									<p align="center">wskazania do	pracy / brak wskazań</p>
								</td>

							</tr>
							<tr>
								<td rowspan="2">
									<p align="center">mies.</p>
								</td>
								<td rowspan="2">
									<p align="center">rok</p>
								</td>
						
							</tr>
							<tr>
								<td>
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
						
							</tr>
							
								<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Niepelnosprawny/*">
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
							<xsl:for-each select="ns1:Osoba">
							<xsl:if test="ns1:Niepelnosprawny/*">
							<tr>
								<td valign="top">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/></b>
								</td>
								<td valign="top">
									<xsl:for-each select="ns1:Niepelnosprawny/ns1:Dysfunkcje/ns1:Dysfunkcja">
								<li><b>
								<xsl:value-of select="text()"/>
								</b>
								</li>
								</xsl:for-each>
								</td>
								<td valign="top">
								<b>
							 grupa inwalidzka:&#160; <xsl:if test="not (ns1:Niepelnosprawny/ns1:CzyGrupaInwalidzka = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Niepelnosprawny/ns1:CzyGrupaInwalidzka = 'T'">
									Tak
									</xsl:if></b>
									<br />
										<b>
							 stopień niepłnosprawności:&#160; <xsl:if test="not (ns1:Niepelnosprawny/ns1:CzyStopienNiepeln = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Niepelnosprawny/ns1:CzyStopienNiepeln = 'T'">
									Tak
									</xsl:if></b>
									<br />
										<b>
							 niezdolność do samodzielnej egzystencji:&#160; <xsl:if test="not (ns1:Niepelnosprawny/ns1:CzyNiezdolnoscDoSamEgzyst = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Niepelnosprawny/ns1:CzyNiezdolnoscDoSamEgzyst = 'T'">
									Tak
									</xsl:if></b>
								</td>
								<td valign="top">
										<b><xsl:value-of select="ns1:Niepelnosprawny/ns1:NumerOrzeczenia"/></b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Niepelnosprawny/ns1:DataOrzeczenia/text(),6,2)"/>
								</b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Niepelnosprawny/ns1:DataOrzeczenia/text(),0,5)"/>
								</b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Niepelnosprawny/ns1:TerminKolejnegoBadania/text(),6,2)"/>
								</b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Niepelnosprawny/ns1:TerminKolejnegoBadania/text(),0,5)"/>
								</b>
								</td>
								<td valign="top">
									<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'StopienNiepelnosprawnosci'"/>
										<xsl:with-param name="kod" select="ns1:Niepelnosprawny/ns1:StopienNiepeln/text()"/>
									</xsl:call-template></b>
								</td>
								<td valign="top">
									<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'ZaleceniaWZakresiePracy'"/>
										<xsl:with-param name="kod" select="ns1:Niepelnosprawny/ns1:WskazaniaDoPracy/text()"/>
									</xsl:call-template></b>
								</td>
								<td valign="top">
									<b><xsl:value-of select="ns1:Niepelnosprawny/ns1:OgraniczeniaFunkcjonalne"/></b>
								</td>
								
							</tr>
							
							</xsl:if>
						</xsl:for-each>
						</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td valign="top">&#160;</td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
							
						</tbody>
					</table>
				</div>
				<br clear="all"/>
				<div>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td>
									<p align="center">1</p>
								</td>
								<td colspan="5">
									<p>Która z osób niepełnosprawnych wymieniona w części B wymaga:
								</p>
								</td>
								
							</tr>
							<tr>
								<td>
								</td>
								<td colspan="1">
									<p>
                        1) skierowania do ośrodka wsparcia (rodzaj)
									</p>
								</td>
								<td colspan="4">
								
										<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:SkierowanieDoOsrodka) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
										<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'OsrodekWsparcia'"/>
										<xsl:with-param name="kod" select="ns1:Niepelnosprawny/ns1:SkierowanieDoOsrodka/text()"/>
									</xsl:call-template></b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
							</tr>

							<tr>
								<td>
								</td>
								<td colspan="1">
									<p>
                        2) skierowania do mieszkania chronionego
									</p>
								</td>
									<td colspan="4">
									
												<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:SkierowanieDoMieszkania) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
										<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'MieszkanieChronione'"/>
										<xsl:with-param name="kod" select="ns1:Niepelnosprawny/ns1:SkierowanieDoMieszkania/text()"/>
									</xsl:call-template></b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
							</tr>

							<tr>
								<td>
								</td>
								<td colspan="1">
									<p>3) usług opiekuńczych (zakres)
								</p>
								</td>
								
									<td colspan="4">		
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:UslugiOpiekuncze) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
										<b>	<xsl:value-of select="ns1:Niepelnosprawny/ns1:UslugiOpiekuncze"/></b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
							</tr>
					
							<tr>
								<td rowspan="2" valign="top">
									<p align="center">2</p>
								</td>
								<td colspan="5" valign="top">
									<p>Czy osoba niepełnosprawna wymaga umieszczenia w domu pomocy społecznej:
								</p>
								</td>
							</tr>
							<tr>
								<td colspan="5" valign="top">
											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:DomPomocy) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
									<b>
							 <xsl:if test="not (ns1:Niepelnosprawny/ns1:DomPomocy = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Niepelnosprawny/ns1:DomPomocy = 'T'">
									Tak
									</xsl:if></b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
						
							</tr>
							<tr>
								<td valign="top">
									<p align="center">3</p>
								</td>
								<td colspan="5" valign="top">
									<p>Możliwość zapewnienia pomocy ze strony rodziny (forma i zakres pomocy):
								</p>
												<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:PomocRodziny) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
									<b>	<xsl:value-of select="ns1:Niepelnosprawny/ns1:PomocRodziny"/>
							 </b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								
								</td>
							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="5" valign="top">
									<p>Jeżeli nie, to dlaczego?
								</p>
								
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyRodziny) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
									<b>	<xsl:value-of select="ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyRodziny"/>
							 </b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p align="center">4</p>
								</td>
								<td colspan="5" valign="top">
									<p>
                        Możliwość zapewnienia pomocy ze strony jednostek organizacyjnych pomocy społecznej gminy i powiatu (forma i zakres pomocy):
									</p>
									
												<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:PomocJOPS) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
									<b>	<xsl:value-of select="ns1:Niepelnosprawny/ns1:PomocJOPS"/>
							 </b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td valign="top">
								</td>
								<td colspan="5" valign="top">
									<p>Jeżeli nie, to dlaczego?
								</p>
											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyJOPS) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									
									<b>	<xsl:value-of select="ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyJOPS"/>
							 </b>
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<p align="center">5</p>
								</td>
								<td colspan="5" valign="top">
									<p>Stan zaopatrzenia w wyroby medyczne oraz potrzeby w tym zakresie:
								</p>
								
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								
								<xsl:if test="count(ns1:Niepelnosprawny/ns1:PosiadaneZaopatrzenieMedyczne) &gt; 0 or count(ns1:Niepelnosprawny/ns1:WymaganeZaopatrzenieMedyczne) &gt; 0">
								<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
									<br />stan zaopatrzenia: <br />
									<b>	<xsl:value-of select="ns1:Niepelnosprawny/ns1:PosiadaneZaopatrzenieMedyczne"/>
							 </b>
							 <br />potrzeby: <br /><b>
							 <xsl:value-of select="ns1:Niepelnosprawny/ns1:WymaganeZaopatrzenieMedyczne"/></b>
											<br />
											<br />
								</xsl:if>			
						</xsl:for-each>
						</xsl:for-each>
								
								</td>
							</tr>
						
						</tbody>
					</table>
							<br clear="all"/>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top">
									<p align="center">1</p>
								</td>
								<td valign="top">
									<p>Która z osób wymienionych w części B jest ubezwłasnowolniona:
								</p>
							
								</td>
							</tr>
							<tr>
							<td valign="top">
									<p align="center"></p>
								</td>
								<td valign="top">
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
								<xsl:for-each select="ns1:Osoba">
								<xsl:if test="count(ns1:Ubezwlasnowolnienie) &gt; 0">
										<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>:&#160;</b>
										<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'StatusPrawny'"/>
										<xsl:with-param name="kod" select="ns1:Ubezwlasnowolnienie/ns1:Rodzaj/text()"/>
									</xsl:call-template></b>
								
							<p>Dane opiekuna prawnego (imię, nazwisko, adres, telefon):
								</p>
								Imię:<b>
									<xsl:value-of select="ns1:Ubezwlasnowolnienie/ns1:ImieOpiekuna"/></b>&#160;<br />
									Nazwisko:<b>
									<xsl:value-of select="ns1:Ubezwlasnowolnienie/ns1:NazwiskoOpiekuna"/></b>&#160;<br />
									Adres:<b>
									<xsl:value-of select="ns1:Ubezwlasnowolnienie/ns1:AdresOpiekuna"/></b>&#160;<br />
									Telefon:<b>
									<xsl:value-of select="ns1:Ubezwlasnowolnienie/ns1:TelefonOpiekuna"/></b>&#160;<br />
								<br />
							</xsl:if>
						</xsl:for-each>
						</xsl:for-each>
								</td>
							
							</tr>
							
						</tbody>
					</table>
				</div>
				<br clear="all"/>
				<div>
					<p>C. Sytuacja osób uzależnionych od alkoholu lub narkotyków
				</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td valign="top">
									<p align="center">1</p>
								</td>
								<td valign="top">
									<p align="center">2</p>
								</td>
								<td valign="top">
									<p align="center">3</p>
								</td>
								<td colspan="2" valign="top">
									<p align="center">4</p>
								</td>
								<td valign="top">
									<p align="center">5</p>
								</td>
								<td valign="top">
									<p align="center">6</p>
								</td>
								<td valign="top">
									<p align="center">7</p>
								</td>
								
							</tr>
							<tr>
								<td rowspan="4">
									<p align="center">Imię i nazwisko</p>
								</td>
								<td rowspan="4">
									<p align="center">Rodzaj i stopień uzależnienia</p>
								</td>
								<td rowspan="2">
									<p align="center">
                        Czy podjęto
										<br/>
                        leczenie
										<br/>
                        odwykowe?
									</p>
								</td>
								<td colspan="2">
									<p align="center">Kiedy podjęto leczenie?</p>
								</td>
								<td rowspan="3">
									<p align="center">
                        Czy osoba
										<br/>
                        uzależniona
										<br/>
                        wyraża zgodę
										<br/>
                        na podjęcie
										<br/>
                        leczenia?
									</p>
								</td>
								<td rowspan="4">
									<p align="center">Jeżeli nie, to dlaczego?</p>
								</td>
								<td rowspan="4">
									<p align="center">Uwagi</p>
								</td>
							</tr>
							<tr>
								<td rowspan="3">
									<p align="center">mies.</p>
								</td>
								<td rowspan="3">
									<p align="center">rok</p>
								</td>
								
							</tr>
							<tr>
								<td rowspan="2">
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
								
							</tr>
							<tr>
								<td>
									<p align="center">1) tak</p>
									<p align="center">2) nie</p>
								</td>
							
							</tr>
							
							<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Uzaleznienia/*">
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">		
							<xsl:for-each select="ns1:Osoba">
							<xsl:if test="ns1:Uzaleznienia/*">
							<tr>
								<td valign="top">
									<b>
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>&#160;
									<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>&#160;</b>
								</td>
								<td valign="top">
								<b><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'RodzajUzaleznienia'"/>
										<xsl:with-param name="kod" select="ns1:Uzaleznienia/ns1:Rodzaj/text()"/>
									</xsl:call-template></b>
								</td>
								<td valign="top">
									<b>
							 <xsl:if test="not (ns1:Uzaleznienia/ns1:CzyLeczenie = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Uzaleznienia/ns1:CzyLeczenie = 'T'">
									Tak
									</xsl:if></b>
								</td>
									<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Uzaleznienia/ns1:KiedyLeczenie/text(),6,2)"/>
								</b>
								</td>
								<td valign="top">
								<b>
								<xsl:value-of select="substring(ns1:Uzaleznienia/ns1:KiedyLeczenie/text(),0,5)"/>
								</b>
								</td>
								<td valign="top">
									<b>
							 <xsl:if test="not (ns1:Uzaleznienia/ns1:ZgodaNaLeczenie = 'T')">Nie
									</xsl:if>
									<xsl:if test="ns1:Uzaleznienia/ns1:ZgodaNaLeczenie = 'T'">
									Tak
									</xsl:if></b>
								</td>
								<td valign="top">
								<b>
									<xsl:value-of select="ns1:Uzaleznienia/ns1:PrzyczynyBrakuZgody"/></b>
								</td>
								<td valign="top">
									<b>
									<xsl:value-of select="ns1:Uzaleznienia/ns1:Uwagi"/></b>
								</td>
							
							</tr>
							</xsl:if>
						</xsl:for-each>
						</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td valign="top">&#160;</td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
								<td valign="top"></td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
							
						</tbody>
					</table>
				</div>
				<br clear="all"/>
				<div>
					<p>
        VI. POTRZEBY I OCZEKIWANIA OSOBY/RODZINY ZGŁOSZONE PODCZAS PRZEPROWADZANIA WYWIADU
					</p>
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td>
								
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Potrzeby/ns1:Potrzeba">		
				potrzeba:&#160; 	<b>
									<xsl:value-of select="ns1:Rodzaj"/></b><br/>
				oczekiwanie:&#160; 	<b>
									<xsl:value-of select="ns1:Opis"/></b><br/><br/>
								
						</xsl:for-each>
								</td>
							</tr>
						
						</tbody>
					</table>
				
				<br clear="all"/>
				
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Miejscowość:&#160;<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu"/></b>
								</p>
								</td>
								
							</tr>
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Data zgłoszenia:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataZgloszenia/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
							<tr>
								<td colspan="5" valign="bottom">
									<p>Data przeprowadzenia wywiadu:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
						</tbody>
					</table>
	
				</div>

				</div>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Enumeracja">
		<xsl:param name="schema"/>
		<xsl:param name="typ"/>
		<xsl:param name="kod"/>
		<xsl:variable name="wschema" select="document($schema)"/>
		<xsl:value-of select="$wschema//xs:simpleType[@name=$typ]//xs:enumeration[@value = $kod]//xs:documentation"/>
	</xsl:template>
	<xsl:template name="Adres1Linia">
			<xsl:if test="ns1:KodPocztowy != ''">
			&#160;<xsl:value-of select="substring(ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:KodPocztowy/text(),3,3)"/>
			</xsl:if>
			&#160;<xsl:value-of select="ns1:Miejscowosc"/>
			&#160;<xsl:value-of select="ns1:Ulica"/>
			&#160;<xsl:value-of select="ns1:NrDomu"/>
			<xsl:if test="ns1:NrLok != ''">
			&#160;m.<xsl:value-of select="ns1:NrLok"/>
			</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>