﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:emp="http://www.mpips.gov.pl/empatia/v4/wywiad/wspolne" xmlns:ns1="http://www.mpips.gov.pl/empatia/v4/wywiad/cz6" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">
   <xsl:param name="wspolne" select="'../wspolne/empatia_wspolne_v4.xsd'" />
   <xsl:output method="html" version="1.0" encoding="utf-8" indent="no" omit-xml-declaration="yes" />
   <xsl:template match="/">
      <html>
         <head>
            <meta name="viewport" content="width=device-width, initial-scale=1" />
            <meta charset="utf-8" />
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <link rel="stylesheet" href="css/jquery.mobile.css" />
            <link rel="stylesheet" href="../css/jquery.mobile.structure.css" />
            <link rel="stylesheet" href="../css/themes/empatiaTest.css" />
			<link rel="stylesheet" href="css/themes/wizualizacja.css"/>
            <link rel="stylesheet" href="../css/ikony.css" type="text/css" />
            <script src="css/jquery.js" />
            <script src="css/jquery.mobile.js" />
            <script type="text/javascript" src="wizualizacja_cz6.js" />
         </head>
		 
         <body>
     
	 <div id="header" style="height:150px; ">
		<form action="wizualizacja.html" id="wizualizacja">
			<div class="odstep"></div>
			<div style="margin-left: 40px; margin-right: 60px;" id="returnButton" data-role="button" data-icon="back"><a class="m" href="#" onclick="window.close()" > - zamknij to okno - </a></div>
			<div class="odstep"></div>
		</form>

		<div style="padding-left:20px; padding-right: 20px;"><p style="font: 24px monospace;  ">Suma kontrolna:&#160;<span style="text-transform: uppercase;"><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,0,9)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,9,8)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,17,8)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,25,8)"/></span>
		</p></div>
</div>
	 
<div id="content" style="height:570px; overflow-y:scroll;">		
          
<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
		<tbody>
			<tr>
				<td colspan="9" valign="top">
					<p align="center">CZĘŚĆ VI</p>
					<p align="center">DOTYCZY CUDZOZIEMCÓW, KTÓRZY UZYSKALI</p>
					<p align="center">W RZECZYPOSPOLITEJ POLSKIEJ STATUS UCHODŹCY
						LUB OCHRONĘ</p>
					<p align="center">UZUPEŁNIAJĄCĄ</p></td>
			</tr>
			<tr>
				<td colspan="9" valign="top"><br/>
				I. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD, DANE O
						CZŁONKACH RODZINY PRZEBYWAJĄCYCH I ZAMIESZKUJĄCYCH NA TERYTORIUM
						RZECZYPOSPOLITEJ POLSKIEJ
						<br/><br/>
					<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']">
						</xsl:when>
						<xsl:otherwise>
							<p align="center"
								style="color: red; font-weight: bold;">BŁĄD
								DANYCH! NIE WYZNACZONO OSOBY GŁÓWNEJ!</p>
						</xsl:otherwise>
					</xsl:choose>
</td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td width="20px">
					<p>1</p></td>
				<td>
					<p>Imię</p></td>
				<td colspan="7"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Imie1" />
						&#160; <xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Imie2" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td>
					<p>2</p></td>
				<td>
					<p>Nazwisko</p></td>
				<td colspan="7"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Nazwisko1" />
						&#160; <xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Nazwisko2" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>3</p></td>
				<td>
					<p>Obywatelstwo</p></td>
				<td><b><xsl:call-template name="Enumeracja">
						<xsl:with-param name="schema" select="$wspolne"/>
						<xsl:with-param name="typ" select="'Obywatelstwo'"/>
						<xsl:with-param name="kod" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:Obywatelstwo/text()"/>
						</xsl:call-template>
				</b></td>
				<td valign="top">
					<p>4</p></td>
				<td>
					<p>Narodowość</p></td>
				<td colspan="5"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:Narodowosc" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>
						5 <br />
					</p></td>
								<td>
					<p>Data urodzenia</p></td>
				<td colspan="2">dzień:<b><xsl:value-of
							select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:DataUr/text(),9,2)" />
				</b></td>
				<td colspan="2">miesiąc:<b><xsl:value-of
							select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:DataUr/text(),6,2)" />
				</b></td>
				<td colspan="3">rok:<b><xsl:value-of
							select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:DataUr/text(),0,5)" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td rowspan="4" valign="top">
					<p>
						6 <br />  
					</p></td>
				<td rowspan="3" valign="top">
					<p>
						Dokument tożsamości <br />  
					</p></td>
				<td>nr dokumentu podróży</td>
				<td colspan="6"><b><xsl:value-of
							select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
				</b></td>
			</tr>
			<tr>
				<td>nr karty pobytu</td>
				<td colspan="6"><b><xsl:value-of
							select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:NumerKartyPobytu" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">nr decyzji nadającej status uchodźcy lub
					ochronę uzupełniającą</td>
				<td colspan="6" valign="top"><b><xsl:value-of
							select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:NrDecyzjiUchodzcy" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">inne dokumenty</td>
				<td colspan="7" valign="top">
					<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[1]/ns1:DaneDodatkowe/ns1:InneDokumenyObcokrajowca/ns1:Dokument">
						<b><xsl:value-of
							select="emp:RodzajDokumentu" />&#160;<xsl:value-of
							select="emp:NumerISeria" />
						</b><br />
					</xsl:for-each>
				</td>
			</tr>
			
			
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>7</p></td>
				<td valign="top">
					<p>Data decyzji o nadaniu statusu uchodźcy lub ochrony
						uzupełniającej</p></td>
				<td colspan="7" valign="top"><b><xsl:value-of
							select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:DataDecyzji/text(),0,11)" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td rowspan="6" valign="top">
					<p>
						8 <br />
					</p></td>
				<td rowspan="3" valign="top">
					<p>Adres zameldowania cudzoziemca na terytorium
						Rzeczypospolitej Polskiej</p></td>
				<td>
					<p>
						kod pocztowy: <b>
								<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy != ''">
						<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),3,3)"/>
						</xsl:if>
						</b>
					</p></td>
				<td colspan="7">
					<p>
						miejscowość: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Miejscowosc" />
						</b>    
					</p></td>
			</tr>
			<tr>
				<td>
					<p>
						ulica: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Ulica" />
						</b>  
					</p></td>
				<td colspan="5">
					<p>
						nr domu: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:NrDomu" />
						</b> 
					</p></td>
				<td style="width: 160px">
					<p>
						nr mieszkania: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:NrLok" />
						</b>  
					</p></td>
			</tr>
			<tr>
				<td colspan="7">telefon: <b><xsl:value-of
							select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Telefon" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="2">Adres pobytu czasowego</td>
				<td>
					<p>
						kod pocztowy: <b><xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy != ''">
						<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:KodPocztowy/text(),3,3)"/>
						</xsl:if>
						</b>
					</p></td>
				<td colspan="7">
					<p>
						miejscowość: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Miejscowosc" />
						</b>    
					</p></td>
			</tr>
			<tr>
				<td>
					<p>
						ulica: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:Ulica" />
						</b>  
					</p></td>
				<td colspan="5">
					<p>
						nr domu: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrDomu" />
						</b> 
					</p></td>
				<td style="width: 160px">
					<p>
						nr mieszkania: <b><xsl:value-of
								select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresPobytu/ns1:NrLok" />
						</b>  
					</p></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>9</p></td>
				<td valign="top">
					<p>Jak długo cudzoziemiec przebywa na terytorium
						Rzeczypospolitej Polskiej?</p></td>
				<td colspan="7" valign="top"><b><xsl:value-of
							select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OkresPobytuWPolsce/text(),0,11)" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>10</p></td>
				<td valign="top">Czy cudzoziemiec jest w Rzeczypospolitej
					Polskiej?</td>
				<td colspan="7" valign="top"><b> <xsl:if
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzySam = 'T'">
										sam
								</xsl:if> <xsl:if
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzySam = 'N'">
										z rodziną
								</xsl:if> </b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>11</p></td>
				<td valign="top">Czy cudzoziemiec utrzymuje kontakt z rodziną?
				</td>
				<td colspan="7" valign="top"><b><xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'KontaktRodzina'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:JakiKontakt/text()" />
						</xsl:call-template>
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>12</p></td>
				<td valign="top">Czy cudzoziemiec korzysta z pomocy?? Czyja
					pomoc:</td>
				<td colspan="7" valign="top"><b>
				
					<xsl:for-each
				select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo">
				<li> <xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZrodloPomocy'" />
							<xsl:with-param name="kod"
								select="ns1:CzyjaPomoc" />
						</xsl:call-template></li>
					</xsl:for-each>	
				<xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:PomocOdKo/ns1:CzyjaPomocOpis" />	
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top">
					<p>13</p></td>
				<td valign="top">Formy udzielanej pomocy</td>
				<td colspan="7" valign="top"><b>
				<xsl:for-each
				select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:FormaPomocy">
				<li> <xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TypPomocy'" />
							<xsl:with-param name="kod"
								select="ns1:FormaRodzaj" />
						</xsl:call-template></li>
					</xsl:for-each>	
				<xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:FormaPomocy/ns1:FormaRodzajOpis" />
				</b></td>
			</tr>
		</tbody>
		<tbody>
			<tr>
				<td valign="top" rowspan="3">
					<p>14</p></td>
				<td valign="top">Wielkość udzielanej pomocy</td>
				<td colspan="7" valign="top"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:WielkoscUdzielanejPomocy" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">Zakres udzielanej pomocy</td>
				<td colspan="7" valign="top"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:ZakresUdzielanejPomocy" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">Rodzaj udzielanej pomocy</td>
				<td colspan="7" valign="top"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:RodzajUdzielanejPomocy" />
				</b></td>
			</tr>
		</tbody>
	</table>
	<br /> 15. Informacja o członkach rodziny cudzoziemca zamieszkałych na
	terytorium Rzeczypospolitej Polskiej
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td style="width: 30px;">
					<p align="center">1</p></td>
				<td>
					<p align="center">2</p></td>
				<td>
					<p align="center">3</p></td>
				<td>
					<p align="center">4</p></td>
				<td>
					<p align="center">5</p></td>
				<td>
					<p align="center">6</p></td>
				<td>
					<p align="center">7</p></td>
				<td>
					<p align="center">8</p></td>
				<td>
					<p align="center">9</p></td>
				<td>
					<p align="center">10</p></td>
			</tr>
			<tr>
				<td rowspan="2">
					<p align="center">Lp.</p></td>
				<td rowspan="2">
					<p align="center">Imię i nazwisko</p></td>
				<td rowspan="2">
					<p align="center">Data urodzenia</p></td>
				<td rowspan="2">
					<p align="center">Płeć</p></td>
				<td rowspan="2">
					<p align="center">
						Stan <br />cywilny
					</p></td>
				<td rowspan="2">
					<p align="center">
						Stopień <br />pokrewień- <br />stwa
					</p></td>
				<td rowspan="2" valign="top">
					<p align="center">Wykształcenie</p></td>
				<td rowspan="2" valign="top">
					<p align="center">
						Sytuacja <br />zdrowotna
					</p></td>
				<td colspan="2" valign="top">
					<p align="center">Źródło dochodu (utrzymania)</p></td>

			</tr>
			<tr>
				<td valign="top">
					<p align="center">rodzaj</p></td>
				<td valign="top">
					<p align="center">wysokość</p></td>
			</tr>

			<xsl:for-each
				select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
				<tr>
					<td class="tab-center"><b> <xsl:value-of select="position()" /> </b></td>
					<td><b> <xsl:value-of
								select="ns1:DanePodstawowe/ns1:Imie1" />&#160; <xsl:value-of
								select="ns1:DanePodstawowe/ns1:Nazwisko1" /> </b></td>
					<td><b> <xsl:value-of
								select="substring(ns1:DanePodstawowe/ns1:DataUr/text(),0,11)" />
					</b></td>
					<td><b> <xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne" />
								<xsl:with-param name="typ" select="'Plec'" />
								<xsl:with-param name="kod"
									select="ns1:DanePodstawowe/ns1:Plec/text()" />
							</xsl:call-template> </b></td>
					<td><b> <xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne" />
								<xsl:with-param name="typ" select="'StanCywilny'" />
								<xsl:with-param name="kod"
									select="ns1:DanePodstawowe/ns1:StanCywilny/text()" />
							</xsl:call-template> </b></td>
					<td><b> <xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne" />
								<xsl:with-param name="typ" select="'StopienPokrewienstwa'" />
								<xsl:with-param name="kod"
									select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa/text()" />
							</xsl:call-template> </b></td>
					<td><b> <xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne" />
								<xsl:with-param name="typ" select="'RodzajWyksztalcenia'" />
								<xsl:with-param name="kod"
									select="ns1:DanePodstawowe/ns1:Wyksztalcenie/text()" />
							</xsl:call-template> <xsl:value-of select="ns1:DanePodstawowe/ns1:Zawod" /> </b></td>
					<td><b> <xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne" />
								<xsl:with-param name="typ" select="'SytuacjaZdrowotna'" />
								<xsl:with-param name="kod"
									select="ns1:DanePodstawowe/ns1:SytuacjaZdrowotna/text()" />
							</xsl:call-template> </b></td>
					<td><b> <xsl:for-each
								select="ns1:DanePodstawowe/ns1:Dochod">
								<xsl:if test="position() != 1">
									<br />
								</xsl:if>
								<xsl:call-template name="Enumeracja">
									<xsl:with-param name="schema" select="$wspolne" />
									<xsl:with-param name="typ" select="'RodzajDochodu'" />
									<xsl:with-param name="kod" select="ns1:Rodzaj/text()" />
								</xsl:call-template>
							</xsl:for-each> </b>&#160;</td>
					<td align="right">&#160;<b> <xsl:for-each
								select="ns1:DanePodstawowe/ns1:Dochod">
								<xsl:if test="position() != 1">
									<br />
								</xsl:if>
								<xsl:value-of select="ns1:Wysokosc" />
							</xsl:for-each> </b></td>
				</tr>
			</xsl:for-each>
		</tbody>
	</table>
	<br /> II. ZNAJOMOŚĆ JĘZYKA POLSKIEGO
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td rowspan="1" valign="top">1</td>
				<td>Czy i kto z członków rodziny cudzoziemca uczęszczał na
					zajęcia z języka polskiego w trakcie trwania procedury o nadanie
					statusu uchodźcy?<br /> <b>
						<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:JezykPolski/ns1:Nauka= 'TAK']">
					<xsl:for-each
						select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:JezykPolski/ns1:Nauka= 'TAK']">
						<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1" />&#160;
						<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1" />&#160;
						<xsl:value-of select="ns1:JezykPolski/ns1:OkresNauki" />&#160;<br/>
						</xsl:for-each>
					</xsl:when>
						<xsl:otherwise>
						</xsl:otherwise>
					</xsl:choose>
				</b></td>
			</tr>

			<tr>
				<td rowspan="1" valign="top">2</td>
				<td>Znajomość języka polskiego przez:<br /> - cudzoziemca: <b>
				<xsl:for-each
						select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
						<xsl:if test="ns1:DanePodstawowe/ns1:OsobaGlowna = 'T'">
				<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template>
				</xsl:if>
				</xsl:for-each>
				</b><br /> - współmałżonka cudzoziemca: <b>
				<xsl:for-each
						select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
				<xsl:if test="ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 15">
				<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template>
				</xsl:if>
				<xsl:if test="ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 16">
				<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template>
				</xsl:if>
				</xsl:for-each>
				</b></td>
			</tr>

			<tr>
				<td valign="top">3</td>
				<td>Czy cudzoziemiec wymaga skierowania na kurs nauki języka
					polskiego?<br /> <b> <xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:JezykPolski/ns1:CzySkierowanie/text()" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
<td valign="top">4</td>
				<td>Znajomość języka polskiego przez dzieci cudzoziemca:<br />
					<b>				
				<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
				<xsl:if test="ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 03">
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1" />&#160;
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1" />&#160;
			<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template><br/>
				</xsl:if>
				<xsl:if test="ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 04">
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1" />&#160;
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1" />&#160;
				<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template><br/>
				</xsl:if>
				<xsl:if test="ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 24">
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1" />&#160;
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1" />&#160;
				<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template><br/>
				</xsl:if>
				<xsl:if test="ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 91">
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1" />&#160;
				<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1" />&#160;
				<xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'ZnajomoscJezyka'" />
							<xsl:with-param name="kod"
								select="ns1:JezykPolski/ns1:Znajomosc/text()" />
						</xsl:call-template><br/>
				</xsl:if>
				</xsl:for-each>
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="2">5</td>
				<td>Czy dzieci cudzoziemca wymagają skierowania na kurs nauki
					języka polskiego?<br /> <b>

					<xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:JezykPolski/ns1:CzySkierowanie = 'T' and (./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 03 or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 04 or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 24 or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 91) ]">
							Tak
						</xsl:when>
						<xsl:otherwise>
							Nie
						</xsl:otherwise>
					</xsl:choose>


				</b></td>
			</tr>
			<tr>
				<td>Jeśli tak – to ile dzieci?<br /> <b> <xsl:value-of select="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:JezykPolski/ns1:CzySkierowanie = 'T' and (./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 03 or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 04 or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 24 or ./ns1:DanePodstawowe/ns1:StopienPokrewienstwa = 91) ])" /></b></td>
			</tr>
			<tr>
				<td valign="top">6</td>
				<td>Czy cudzoziemiec lub jego rodzina wymagają pomocy w formie
					świadczenia pieniężnego na pokrycie wydatków związanych z nauką
					języka polskiego?<br /> <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzyPomocNaNauke/text()" />
						</xsl:call-template>
				</b>
				</td>
			</tr>
		</tbody>
	</table>
	<br /> III. FUNKCJONOWANIE CUDZOZIEMCA I CZŁONKÓW JEGO RODZINY
	<br /> W NOWYM ŚRODOWISKU PO OPUSZCZENIU OŚRODKA DLA CUDZOZIEMCÓW
	<br /> UBIEGAJĄCYCH SIĘ O NADANIE STATUSU UCHODŹCY
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top">1</td>
				<td>Jak cudzoziemiec i członkowie jego rodziny czują się w
					nowym środowisku po opuszczeniu ośrodka dla cudzoziemców
					ubiegających się o nadanie statusu uchodźcy?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Opis" />
				</b></td>
			</tr>

			<tr>
				<td valign="top">2</td>
				<td>Czy cudzoziemiec ma znajomych w nowym środowisku? Jakich?<br />
					<b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Znajomi" />
				</b></td>
			</tr>

			<tr>
				<td valign="top">3</td>
				<td>Czy mieszkańcy z najbliższego otoczenia sprawiają
					cudzoziemcowi lub jego rodzinie kłopoty? Jakie?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Klopoty" />
				</b></td>
			</tr>

			<tr>
				<td valign="top">4</td>
				<td>Czy cudzoziemiec lub jego rodzina mają grupę wsparcia w
					środowisku zamieszkania? Rodzaj wsparacia:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:GrupaWsparciaSrodowiska" />
				</b></td>
			</tr>

			<tr>
				<td valign="top">5</td>
				<td>Czy cudzoziemiec lub jego rodzina mają grupę wsparcia wśród
					cudzoziemców? Rodzaj wsparacia:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:GrupaWsparciaCudzoziemcow" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">6</td>
				<td>Cudzoziemiec lub jego rodzina wiedzą, gdzie znajdują
					się podstawowe instytucje, takie jak:<br /> <xsl:for-each
						select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Instytucje">
						<xsl:for-each select="ns1:Instytucja">
							<b><li><xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne" />
										<xsl:with-param name="typ" select="'RodzajInstytucji'" />
										<xsl:with-param name="kod" select="text()" />
									</xsl:call-template>
							</li>
							</b>
						</xsl:for-each>
						<b><xsl:value-of select="ns1:InstytucjaUwagi" />
						</b>
					</xsl:for-each></td>
			</tr>
			<tr>
				<td valign="top" rowspan="2">7</td>
				<td>Czy dzieci cudzoziemca realizują obowiązek szkolny?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:CzyObowiazekSzkolny" />
				</b></td>
			</tr>
			<tr>
				<td>Do jakiego rodzaju szkoły i do której klasy uczęszczają?<br />
					<b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Szkoly" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">8</td>
				<td>Co sprawia najwięcej trudności w funkcjonowaniu w
					środowisku lokalnym?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Trudnosci" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">9</td>
				<td>Zainteresowania cudzoziemca, formy spędzania wolnego czasu:<br />
					<b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:NoweSrodowisko/ns1:Zainteresowania" />
				</b></td>
			</tr>
		</tbody>
	</table>
	<br /> IV. SYTUACJA MIESZKANIOWA
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top">1</td>
				<td colspan="3">Mieszkanie:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Rodzaj" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">2</td>
				<td>Liczba izb: <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:LiczbaIzb" />
				</b></td>
				<td valign="top">3</td>
				<td>Oddzielna kuchnia: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:OddzielnaKuchnia" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td valign="top">4</td>
				<td>Piętro: <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Pietro" />
				</b></td>
				<td valign="top">5</td>
				<td>Winda: <b> <xsl:call-template name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Winda" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="5">6</td>
				<td colspan="4">Wyposażenie mieszkania w instalacje:<br /></td>
			</tr>
			<tr>
				<td colspan="2">woda zimna: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'WyposazenieWodaZimna'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:WodaZimna" />
						</xsl:call-template>
				</b></td>
				<td colspan="2">woda ciepła: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'WyposazenieWodaCiepla'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:WodaCiepla" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td colspan="2">łazienka: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'WyposazenieLazienka'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Lazienka" />
						</xsl:call-template>
				</b></td>
				<td colspan="2">WC: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'WyposazenieWC'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:WC" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td colspan="4">ogrzewanie: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'WyposazenieOgrzewanie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Ogrzewanie" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td colspan="2">gaz: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Gaz" />
						</xsl:call-template>
				</b></td>
				<td colspan="2">telefon: <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:Telefon" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td valign="top">7</td>
				<td colspan="4">Stan utrzymania mieszkania:<br /> <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'StanMieszkania'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:StanMieszkania" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="2">8</td>
				<td colspan="4">Czy rodzina posiada podstawowe sprzęty
					gospodarstwa domowego:<br /> <b> <xsl:call-template
							name="Enumeracja">
							<xsl:with-param name="schema" select="$wspolne" />
							<xsl:with-param name="typ" select="'TakNie'" />
							<xsl:with-param name="kod"
								select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:CzySprzety" />
						</xsl:call-template>
				</b></td>
			</tr>
			<tr>
				<td colspan="4">Jeżeli nie, to wymienić, jakich sprzętów
					brakuje:<br /> <xsl:for-each
						select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:BrakujaceSprzety/ns1:Sprzet">
						<b><li><xsl:value-of select="text()" />
						</li>
						</b>
					</xsl:for-each></td>
			</tr>
			<tr>
				<td valign="top">9</td>
				<td>Liczba miejsc do spania:<br /></td>
				<td colspan="3"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:MiejscaDoSpania" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">10</td>
				<td>Łączne stałe (miesięczne) wydatki związane mieszkaniem –
					czynsz, światło, gaz itp.:<br /></td>
				<td colspan="3"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:LaczneWydatki" />
				</b></td>
			</tr>
			<tr>
				<td valign="top">11</td>
				<td>Czy zachodzi konieczność zapewnienia mieszkania ze strony
					gminy?<br /></td>
				<td colspan="3"><b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie/ns1:CzyMieszkanieGminy" />
				</b></td>
			</tr>
		</tbody>
	</table>
	<br /> V. SYTUACJA ZDROWOTNA
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top" rowspan="4">1</td>
				<td>Czy cudzoziemiec lub członek jego rodziny byli leczeni w
					trakcie pobytu w ośrodku dla cudzoziemców ubiegających się o
					nadanie statusu uchodźcy?<br /> <b> <xsl:choose>
						<xsl:when
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:Choroby/ns1:CzyLeczenieWOsrodku = 'T']">
							TAK
						</xsl:when>
						<xsl:otherwise>
							NIE
						</xsl:otherwise>
					</xsl:choose>
				</b></td>
			</tr>
			<tr>
					<td>Jeśli tak, to kto?<br /> <b> 
				
							<xsl:for-each
				select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba">
				<xsl:if test="ns1:Choroby/ns1:CzyLeczenieWOsrodku = 'T'">
							<xsl:value-of
								select="ns1:DanePodstawowe/ns1:Imie1" />&#160;
		 <xsl:value-of
								select="ns1:DanePodstawowe/ns1:Imie2" />&#160;
		 <xsl:value-of
								select="ns1:DanePodstawowe/ns1:Nazwisko1" />&#160;
		 <xsl:value-of
								select="ns1:DanePodstawowe/ns1:Nazwisko2" /><br/>
      </xsl:if>
	  </xsl:for-each>
	  
				</b></td>
			</tr>
			<tr>
				<td>Czy wymaga dalszego leczenia?<br /> <b> <xsl:if
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Choroby/ns1:CzyDalszeLeczenie != ''">
									Tak
									 </xsl:if> <xsl:if
							test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Choroby/ns1:CzyDalszeLeczenie = ''">
									Nie
									 </xsl:if>
				</b></td>
			</tr>
			<tr>
				<td>Jeśli tak, to jakiego?<br /> <b> <xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Choroby/ns1:CzyDalszeLeczenie" />
				</b></td>
			</tr>
			<tr>

				<td valign="top" rowspan="1">2</td>
				<td>Jakie problemy zdrowotne zgłaszają cudzoziemiec lub członek
					jego rodziny?<br /> <b> <xsl:for-each
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie">
							<xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne" />
								<xsl:with-param name="typ" select="'Schorzenie'" />
								<xsl:with-param name="kod" select="text()" />
							</xsl:call-template>
							<br />
						</xsl:for-each>
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">3</td>
				<td>Czy cudzoziemiec i jego rodzina podlegają ubezpieczeniu
					zdrowotnemu?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyUbezpieczenie" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">4</td>
				<td>Czy wymagają pomocy w formie opłacania składki na
					ubezpieczenie zdrowotne?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyPomocSkladka" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">5</td>
				<td>Kto opłaca składkę na ubezpieczenie zdrowotne?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:KtoOplaca" />
				</b></td>
			</tr>
		</tbody>
	</table>
	<br /> VI. SYTUACJA ZAWODOWA
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top" rowspan="1">1</td>
				<td>Czy cudzoziemiec lub członek jego rodziny mają wiedzę na
					temat możliwości zatrudnienia w swoim zawodzie i zgodnie z
					kwalifikacjami?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:Mozliwosci" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">2</td>
				<td>Umiejętności i kwalifikacje wskazane przez cudzoziemca,
					które mogą być pomocne w poszukiwaniu pracy:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:Kwalifikacje" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">3</td>
				<td>Czy cudzoziemiec lub członek jego rodziny otrzymali
					propozycję pracy z powiatowego urzędu pracy?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:PropozycjeUP" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">4</td>
				<td>Czy cudzoziemiec podejmie inne prace, w tym np. jako
					wolontariusz?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:InnePrace" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">5</td>
				<td>Potwierdzenie zawodu i zatrudnienia z kraju pochodzenia –
					posiadane dokumenty:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Praca/ns1:PosiadaneDokumenty" />
				</b></td>
			</tr>
		</tbody>
	</table>
	<br /> VII. SYTUACJA DOCHODOWA
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%;">
		<tbody>
			<tr>
				<td valign="top" rowspan="1">1</td>
				<td>Czy cudzoziemiec lub członkowie jego rodziny dysponują
					środkami finansowymi i jaka jest ich wielkość?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:SrodkiFinansowe" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="1">2</td>
				<td>Ewentualne zasoby przywiezione z kraju pochodzenia, którymi
					dysponuje cudzoziemiec lub jego rodzina:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:ZasobyZKraju" />
				</b></td>
			</tr>
			<tr>
				<td valign="top" rowspan="2">3</td>
				<td>Czy cudzoziemiec lub członkowie jego rodziny posiadają
					źródła dochodu? Jakie?<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:ZrodlaDochodu" />
				</b></td>
			</tr>
			<tr>
				<td>Podać wielkość dochodu:<br /> <b><xsl:value-of
							select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochody/ns1:WielkoscDochodu" />
				</b></td>
			</tr>
		</tbody>
	</table>
	<br /> VIII. POTRZEBY I OCZEKIWANIA ZGŁOSZONE PODCZAS PRZEPROWADZANIA
	WYWIADU
	<br />
	<br />
	<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
		<tbody>
			<tr>
				<td><xsl:for-each
						select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Potrzeby/ns1:Potrzeba">		
				potrzeba:&#160; 	<b> <xsl:value-of select="ns1:Rodzaj" />
						</b>
						<br />
				oczekiwanie:&#160; 	<b> <xsl:value-of select="ns1:Opis" />
						</b>
						<br />
						<br />

					</xsl:for-each></td>
			</tr>

		</tbody>
	</table>		  
		<br clear="all"/>
				
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Miejscowość:&#160;<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu"/></b>
								</p>
								</td>
								
							</tr>
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Data zgłoszenia:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataZgloszenia/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
							<tr>
								<td colspan="5" valign="bottom">
									<p>Data przeprowadzenia wywiadu:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
						</tbody>
					</table>
		</div>
         </body>
      </html>
   </xsl:template>
   <xsl:template name="Enumeracja">
      <xsl:param name="schema" />
      <xsl:param name="typ" />
      <xsl:param name="kod" />
      <xsl:variable name="wschema" select="document($schema)" />
      <xsl:value-of select="$wschema//xs:simpleType[@name=$typ]//xs:enumeration[@value = $kod]//xs:documentation" />
   </xsl:template>
   <xsl:template name="Adres1Linia">
      <xsl:value-of select="ns1:KodPocztowy" />
       
      <xsl:value-of select="ns1:Miejscowosc" />
       
      <xsl:value-of select="ns1:Ulica" />
       
      <xsl:value-of select="ns1:NrDomu" />
      <xsl:if test="ns1:NrLok != ''">
          m.
         <xsl:value-of select="ns1:NrLok" />
      </xsl:if>
   </xsl:template>
</xsl:stylesheet>