﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:emp="http://www.mpips.gov.pl/empatia/v4/wywiad/wspolne" xmlns:ns1="http://www.mpips.gov.pl/empatia/v4/wywiad/cz5" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">
   <xsl:param name="wspolne" select="'../wspolne/empatia_wspolne_v4.xsd'" />
   <xsl:output method="html" version="1.0" encoding="utf-8" indent="no" omit-xml-declaration="yes" />
   <xsl:template match="/">
		
		   <table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
                  <tbody>
                     <tr>
                        <td colspan="9" valign="top">
                           <p align="center">CZĘŚĆ V</p>
                           <p align="center">DOTYCZY OSÓB UBIEGAJĄCYCH SIĘ O POMOC</p>
                           <p align="center">PIENIĘŻNĄ NA USAMODZIELNIENIE, POMOC PIENIĘŻNĄ</p>
							<p align="center">NA KONTYNUOWANIE NAUKI</p>                       
					   </td>
                     </tr>
                     <tr>
                        <td colspan="9" valign="top">
                           <p>I. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD</p>
                           <p> </p>
                        </td>
                     </tr>
                  </tbody>
                  <tbody>
                     <tr>
                        <td>
                           <p>1</p>
                        </td>
                        <td>
                           <p>Imię</p>
                        </td>
                        <td colspan="7">
                           <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie1"/> &#160;
							<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie2"/></b>
                        </td>
                     </tr>
                  </tbody>
                  <tbody>
                     <tr>
                        <td>
                           <p>2</p>
                        </td>
                        <td>
                           <p>Nazwisko</p>
                        </td>
                        <td colspan="7">
                        <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko1"/> &#160;
						<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko2"/></b>
                        </td>
                     </tr>
                  </tbody>
				   <tbody>
					 <tr>
                        <td>
                           <p>
                              3
                              <br />
                           </p>
                        </td>
						<td>
                        <p>Data urodzenia</p>
                     </td>
                     <td colspan="2">
                      dzień:<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:DataUr/text(),9,2)"/></b>
                     </td>
                     <td colspan="2">
                      miesiąc:<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:DataUr/text(),6,2)"/></b>
                     </td>
                     <td colspan="3">
                      rok:<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:DataUr/text(),0,5)"/></b>
                     </td>
					 </tr>
				    </tbody>
                  <tbody>
                     <tr>
                        <td>
                           <p>
                              4
                              <br />
                               
                           </p>
                        </td>
                        <td >
                           <p>
                              Seria i nr dokumentu potwierdzającego tożsamość
                              <br />
                               
                           </p>
                        </td>
                        <td colspan="7">
                          <b>
										<xsl:call-template name="Enumeracja">
											<xsl:with-param name="schema" select="$wspolne"/>
											<xsl:with-param name="typ" select="'RodzajDokumentu'"/>
											<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:RodzajDokumentu/text()"/>
										</xsl:call-template>
										<br />
										<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:NumerDokumentu"/>
									</b>
                        </td>
                     </tr>
                  </tbody>
                  <tbody>
                     <tr>
                        <td>
                           <p>5</p>
                        </td>
                        <td>
                           <p>Nr PESEL</p>
                        </td>
                        <td colspan="7">
                          <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:PESEL"/></b>
                        </td>
                     </tr>
                  </tbody>
                  <tbody>
                     <tr>
                        <td rowspan="4" valign="top">
                           <p>
                              6
                              <br />
                               
                           </p>
                        </td>
                        <td rowspan="4" valign="top">
                           <p>Adres</p>
                           <p> </p>
                        </td>
                        <td colspan="3">
                           <p>kod pocztowy: <b> <xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy != ''">
						<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),3,3)"/>
						</xsl:if>
										</b></p>
                        </td>
                        <td colspan="4">
                           <p>miejscowość: <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc"/>
										</b>    </p>
                        </td>
                     </tr>
                     <tr>
                        <td colspan="5">
                           <p>ulica: <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica"/>
										</b>  </p>
                        </td>
                        <td>
                           <p>nr domu: <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu"/>
										</b> </p>
                        </td>
                        <td style="width:160px">
                           <p>nr mieszkania: <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok"/>
										</b>  </p>
                        </td>
                     </tr>
                     <tr>
                        <td colspan="7">
                           <p>telefon: <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon"/>
										</b>  </p>
                        </td>
                     </tr>
                     <tr>
                        <td colspan="7">
                           <p>symbol terytorialny: <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny"/></b>  </p>
                        </td>
                     </tr>
                  </tbody>
				  <tbody>
                  <tr>
                     <td valign="top">
                        <p>7</p>
                     </td>
                     <td colspan="8">Sytuacja rodzinna:<br/>
					<b><xsl:call-template name="Enumeracja">
					<xsl:with-param name="schema" select="$wspolne"/>
					<xsl:with-param name="typ" select="'SytuacjaRodzinnaUsamodzielnienie'"/>
					<xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodzinna/text()"/>
					</xsl:call-template></b>
				  </td>
                  </tr>
               </tbody>		
			<tbody>
                  <tr>
                     <td valign="top">
                        <p>8</p>
                     </td>
                     <td colspan="8">
                        <p>
                          Z jakiego rodzaju opieki osoba usamodzielniana korzystała?<br/>
                        </p>
						<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
									<tr>
								 <td>
								 Rodzaj
								  </td>
									<td>
								 Okres
								  </td>
								  </tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka">
								<xsl:for-each select="ns1:Osrodek">
								<tr>
								 <td><b>
								<xsl:call-template name="Enumeracja">
										<xsl:with-param name="schema" select="$wspolne"/>
										<xsl:with-param name="typ" select="'RodzajPlacowki'"/>
										<xsl:with-param name="kod" select="ns1:Rodzaj/text()"/>
									</xsl:call-template></b>
								  </td>
									<td>
								  <b><xsl:value-of select="ns1:Okres"/></b>
								  </td>
								  </tr>
								</xsl:for-each>
							</xsl:for-each>
							<tr>
								 <td>
								 <b>Łączny czas pobytu poza rodziną (pkt 1—8)</b>
								  </td>
									<td>
								  <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Razem"/></b>
								  </td>
								  </tr>
								  <tr>
								 <td colspan="2">
								 <br/>
								 </td>
								 </tr>
								  <tr>
								 <td>
								 Ostatnie miejsce pobytu przed usamodzielnieniem <br/>(nazwa
i adres placówki, którą opuściła osoba ubiegająca się o pomoc pieniężną na usamodzielnienie, pomoc pieniężną na kontynuowanie nauki)
								  </td>
									<td>
								  <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:OstatnaPlacowka/ns1:Nazwa"/></b> <br/>
								  <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:OstatnaPlacowka/ns1:Adres"/></b>
								  </td>
								  </tr>
						</tbody>
					</table>
                     </td>
                  </tr>
				  </tbody>
					<tbody>
				    <tr>
                     <td valign="top">
                        <p>9</p>
                     </td>
                     <td colspan="8">Czy osoba usamodzielniana uczy się?: <b> <xsl:call-template name="Enumeracja">
												<xsl:with-param name="schema" select="$wspolne"/>
												<xsl:with-param name="typ" select="'TakNie'"/>
												<xsl:with-param name="kod" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:CzyNauka/text()"/>
											</xsl:call-template></b> 
				  </td>
                  </tr>
               </tbody>
			   <tbody>
				    <tr>
                     <td valign="top">
                        <p>10</p>
                     </td>
                     <td colspan="8">Typ szkoły?: <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:TypSzkoly"/></b> 
				<table >
					<tbody>
						<tr>
							<td>
							klasa/rok studiów: 
							  </td>
									<td>
								 <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:KlasaRok"/></b> 
								  </td>
								   <td>
								semestr: 
								  </td>
									<td>
								 <b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:Semestr"/></b> 
								  </td>
								  </tr>
					</tbody>
					</table>
					</td>            
			</tr>
               </tbody>
			    <tbody>
                  <tr>
                     <td valign="top">
                        <p>11</p>
                     </td>
                     <td colspan="7">
                        <p>
                         Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)<br/>
                        </p>
                     </td>
					 <td align="right">
					    <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochod"/></b>
					 </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td valign="top">
                        <p>12</p>
                     </td>
                     <td colspan="7">
                        <p>
                         Dochód na osobę w rodzinie<br/>
                        </p>
                     </td>
					 <td align="right">
					    <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DochodNaOsobe"/></b>
					 </td>
                  </tr>
               </tbody>
				<tbody>
                  <tr>
                     <td valign="top">
                        <p>13</p>
                     </td>
                     <td colspan="7">
                        <p>
                         Kryterium dochodowe dla danej osoby/rodziny(wynikające z art. 8 ustawy
						z dnia 12 marca 2004 r. o pomocy społecznej)<br/>
                        </p>
                     </td>
					 <td align="right">
					 <b><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:KryteriumDochodowe"/></b>
					 </td>
                  </tr>
				  
               </tbody>
            </table>
			
				<br clear="all"/>
				
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
						
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Miejscowość:&#160;<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu"/></b>
								</p>
								</td>
								
							</tr>

							<tr>
								<td colspan="5" valign="bottom">
									<p>Data przeprowadzenia wywiadu:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
						</tbody>
					</table>
		
		
		
	
   </xsl:template>
   <xsl:template name="Enumeracja">
      <xsl:param name="schema" />
      <xsl:param name="typ" />
      <xsl:param name="kod" />
      <xsl:variable name="wschema" select="document($schema)" />
      <xsl:value-of select="$wschema//xs:simpleType[@name=$typ]//xs:enumeration[@value = $kod]//xs:documentation" />
   </xsl:template>
   <xsl:template name="Adres1Linia">
      <xsl:value-of select="ns1:KodPocztowy" />
       
      <xsl:value-of select="ns1:Miejscowosc" />
       
      <xsl:value-of select="ns1:Ulica" />
       
      <xsl:value-of select="ns1:NrDomu" />
      <xsl:if test="ns1:NrLok != ''">
          m.
         <xsl:value-of select="ns1:NrLok" />
      </xsl:if>
   </xsl:template>
</xsl:stylesheet>