﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:emp="http://www.mpips.gov.pl/empatia/v5/wywiad/wspolne" xmlns:ns1="http://www.mpips.gov.pl/empatia/v5/wywiad/cz1i2" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">
   <xsl:param name="wspolne" select="'../wspolne/empatia_wspolne_v5.xsd'" />
   <xsl:output method="html" version="1.0" encoding="utf-8" indent="no" omit-xml-declaration="yes" />
   <xsl:template match="/">
      <html>
         <head>
            <meta name="viewport" content="width=device-width, initial-scale=1" />
            <meta charset="utf-8" />
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <link rel="stylesheet" href="css/jquery.mobile.css" />
            <link rel="stylesheet" href="../css/jquery.mobile.structure.css" />
            <link rel="stylesheet" href="../css/themes/empatiaTest.css" />
			<link rel="stylesheet" href="css/themes/wizualizacja.css"/>
            <link rel="stylesheet" href="../css/ikony.css" type="text/css" />
            <script src="css/jquery.js" />
            <script src="css/jquery.mobile.js" />
            <script type="text/javascript" src="wizualizacja_cz2.js" />
         </head>
         <body>
		 
<div id="header" style="height:150px; ">
		<form action="wizualizacja.html" id="wizualizacja">
			<div class="odstep"></div>
			<div style="margin-left: 40px; margin-right: 60px;" id="returnButton" data-role="button" data-icon="back"><a class="m" href="#" onclick="window.close()" > - zamknij to okno - </a></div>
			<div class="odstep"></div>
		</form>

		<div style="padding-left:20px; padding-right: 20px;"><p style="font: 24px monospace;  ">Suma kontrolna:&#160;<span style="text-transform: uppercase;"><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,0,9)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,9,8)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,17,8)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/emp:SumaKontrolna,25,8)"/></span>
		</p></div>
</div>
<div id="content" style="height:570px; overflow-y:scroll;">		
            <table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
               <tbody>
                  <tr>
                     <td colspan="9" valign="top">
                        <p align="center">CZĘŚĆ II</p>
                        <p align="center">DOTYCZY MAŁŻONKA, ZSTĘPNYCH LUB WSTĘPNYCH, O KTÓRYCH MOWA </p>
                        <p align="center">W ART. 103 USTAWY Z DNIA 12 MARCA 2004 R. O POMOCY SPOŁECZNEJ </p>
                     </td>
                  </tr>
                  <tr>
                     <td colspan="9" valign="bottom">
                        <p>I. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD</p>
                        <p />
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td>
                        <p>1</p>
                     </td>
                     <td>
                        <p>Imię</p>
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Imie1" />
                            
                           <xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Imie2" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td>
                        <p>2</p>
                     </td>
                     <td>
                        <p>Nazwisko</p>
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Nazwisko1" />
                            
                           <xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:Nazwisko2" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td>
                        <p>
                           3
                           <br />
                        </p>
                     </td>
                     <td>
                        <p>
                           Seria i nr dokumentu potwierdzającego tożsamość
                           <br />
                        </p>
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:call-template name="Enumeracja">
                              <xsl:with-param name="schema" select="$wspolne" />
                              <xsl:with-param name="typ" select="'RodzajDokumentu'" />
                              <xsl:with-param name="kod" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:RodzajDokumentu/text()" />
                           </xsl:call-template>
                           <br />
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td>
                        <p>4</p>
                     </td>
                     <td>
                        <p>Nr PESEL</p>
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:DanePodstawowe/ns1:PESEL" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td rowspan="4" valign="top">
                        <p>
                           5
                           <br />
                        </p>
                     </td>
                     <td rowspan="4" valign="top">
                        <p>Adres zamieszkania </p>
                        <p />
                     </td>
                     <td colspan="3">
                        <p>
                           kod pocztowy:
                           <b>
                             			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy != ''">
										<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),3,3)"/>
										</xsl:if>
                           </b>
                        </p>
                     </td>
                     <td colspan="4">
                        <p>
                           miejscowość:
                           <b>
                              <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Miejscowosc" />
                           </b>
                        </p>
                     </td>
                  </tr>
                  <tr>
                     <td colspan="5">
                        <p>
                           ulica:
                           <b>
                              <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Ulica" />
                           </b>
                        </p>
                     </td>
                     <td>
                        <p>
                           nr domu:
                           <b>
                              <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:NrDomu" />
                           </b>
                        </p>
                     </td>
                     <td style="width:160px">
                        <p>
                           nr mieszkania:
                           <b>
                              <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:NrLok" />
                           </b>
                        </p>
                     </td>
                  </tr>
                  <tr>
                     <td colspan="7">
                        <p>
                           telefon:
                           <b>
                              <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:Telefon" />
                           </b>
                        </p>
                     </td>
                  </tr>
                  <tr>
                     <td colspan="7">
                        <p>
                           symbol terytorialny:
                           <b>
                              <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Adres/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" />
                           </b>
                        </p>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td valign="top">
                        <p>6</p>
                     </td>
                     <td colspan="7">
                        <p>
                           Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r.
                           <br />
                           o pomocy społecznej)
                        </p>
                     </td>
                     <td align="right">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochod" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td valign="top">
                        <p>7</p>
                     </td>
                     <td colspan="7">
                        <p>Dochód na osobę w rodzinie</p>
                     </td>
                     <td align="right">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DochodNaOsobe" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td valign="top">
                        <p>8</p>
                     </td>
                     <td colspan="7">
                        <p>Kryterium dochodowe dla danej osoby/rodziny (wynikające z art. 8 ust. 1 lub 2 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</p>
                     </td>
                     <td align="right">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:KryteriumDochodowe" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td valign="top">
                        <p>9</p>
                     </td>
                     <td colspan="7">
                        <p>
                           Obciążenia finansowe rodziny
                           <br />
                           (stałe np. czynsz, opłaty za dom pomocy społecznej, internat, bursę;
                           <br />
                           okresowe np. spłata zadłużenia;
                           <br />
                           jednorazowe np. remont mieszkania)
                        </p>
                     </td>
                     <td align="right">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Razem" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td valign="top">
                        <p>10</p>
                     </td>
                     <td colspan="8">
                        Dane osoby lub rodziny ubiegającej się o przyznanie świadczenia:
                        <br />
                        Imię:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Imie1" />
                            
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Imie2" />
                           <br />
                        </b>
                        Nazwisko:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Nazwisko1" />
                            
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Nazwisko2" />
                           <br />
                        </b>
                        Kod pocztowy:
                        <b>
						<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:KodPocztowy != ''">
						<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:KodPocztowy/text(),3,3)"/>
						</xsl:if>
                           <br />
                        </b>
                        Miejscowość:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Miejscowosc" />
                           <br />
                        </b>
                        Ulica:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Ulica" />
                           <br />
                        </b>
                        Numer domu:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:NrDomu" />
                           <br />
                        </b>
                        Numer lokalu:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:NrLok" />
                           <br />
                        </b>
                        Uwagi:
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie/ns1:Uwagi" />
                           <br />
                        </b>
                     </td>
                  </tr>
               </tbody>
            </table>
			<br clear="all"/>
			
            <p>II. INFORMACJE O CZŁONKACH RODZINY I INNYCH OSOBACH WSPÓLNIE ZAMIESZKUJĄCYCH</p>
            <table border="1" cellpadding="0" cellspacing="0" style="width:100%">
               <tbody>
                  <tr>
                     <td>
                        <p>1</p>
                     </td>
                     <td>
                        <p>2</p>
                     </td>
                     <td colspan="3">
                        <p>3</p>
                     </td>
                     <td>
                        <p>4</p>
                     </td>
                     <td>
                        <p>5</p>
                     </td>
                     <td>
                        <p>6</p>
                     </td>
                     <td>
                        <p>7</p>
                     </td>
                     <td>
                        <p>8</p>
                     </td>
                     <td>
                        <p>9</p>
                     </td>
                     <td>
                        <p>10</p>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td rowspan="2">
                        <p>Lp.</p>
                        <p />
                        <p />
                     </td>
                     <td rowspan="2">
                        <p>Imię i nazwisko</p>
                     </td>
                     <td colspan="3">
                        <p>
                           Data
                           <br />
                           urodzenia
                        </p>
                     </td>
                     <td rowspan="2">
                        <p>Płeć</p>
                     </td>
                     <td rowspan="2">
                        <p>Stan cywilny</p>
                     </td>
                     <td rowspan="2">
                        <p>Stopień pokrewieństwa**</p>
                     </td>
                     <td rowspan="2">
                        <p>
                           Nr
                           <br />
                           PESEL
                        </p>
                     </td>
                     <td rowspan="2">
                        <p>Miejsce pracy</p>
                        <p>
                           lub nauki
                           <br />
                           (szkoła, przed-szkole)
                        </p>
                        <p />
                        <p />
                     </td>
                     <td colspan="2">
                        <p>Źródło dochodu (utrzymania)</p>
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <p>dzień</p>
                     </td>
                     <td>
                        <p>mies.</p>
                     </td>
                     <td>
                        <p>rok</p>
                     </td>
                     <td>
                        <p>rodzaj</p>
                     </td>
                     <td>
                        <p>wysokość</p>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">
                     <xsl:variable name="GOSPODARSTWO" select="position()" />
                     <xsl:for-each select="ns1:Osoba">
                        <xsl:if test="position() = 1 and $GOSPODARSTWO != 1">
                           <tr style="height: 2px; background: #000000;">
                              <td colspan="13" />
                           </tr>
                        </xsl:if>
                        <xsl:variable name="POPRZEDNIE" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[(position() &lt; $GOSPODARSTWO)]/ns1:Osoba)" />
                        <tr>
                           <td>
                              <p align="center">
                                 <b>
                                    <xsl:value-of select="$POPRZEDNIE + position()" />
                                 </b>
                              </p>
                           </td>
                           <td>
                              <b>
                                 <xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1" />
                                  
                                 <xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1" />
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr/text(),9,2)" />
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr/text(),6,2)" />
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr/text(),0,5)" />
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:call-template name="Enumeracja">
                                    <xsl:with-param name="schema" select="$wspolne" />
                                    <xsl:with-param name="typ" select="'Plec'" />
                                    <xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:Plec/text()" />
                                 </xsl:call-template>
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:call-template name="Enumeracja">
								<xsl:with-param name="schema" select="$wspolne"/>
								<xsl:with-param name="typ" select="'StanCywilny'"/>
								<xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:StanCywilny/text()"/>
								</xsl:call-template>
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:call-template name="Enumeracja">
                                    <xsl:with-param name="schema" select="$wspolne" />
                                    <xsl:with-param name="typ" select="'StopienPokrewienstwa'" />
                                    <xsl:with-param name="kod" select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa/text()" />
                                 </xsl:call-template>
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:value-of select="ns1:DanePodstawowe/ns1:PESEL" />
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:value-of select="ns1:DanePodstawowe/ns1:MiejscePracy" />
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
                                    <xsl:if test="position() != 1">
                                       <br />
                                    </xsl:if>
                                    <xsl:call-template name="Enumeracja">
                                       <xsl:with-param name="schema" select="$wspolne" />
                                       <xsl:with-param name="typ" select="'RodzajDochodu'" />
                                       <xsl:with-param name="kod" select="ns1:Rodzaj/text()" />
                                    </xsl:call-template>
                                 </xsl:for-each>
                              </b>
                           </td>
                           <td>
                              <b>
                                 <xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
                                    <xsl:if test="position() != 1">
                                       <br />
                                    </xsl:if>
                                    <xsl:value-of select="ns1:Wysokosc" />
                                 </xsl:for-each>
                              </b>
                           </td>
                        </tr>
                     </xsl:for-each>
                  </xsl:for-each>
               </tbody>
            </table>
			
			<br clear="all"/>
            <p>III. POMOC OSOBY/RODZINY UDZIELANA OSOBIE LUB RODZINIE UBIEGAJĄCEJ SIĘ O PRZYZNANIE ŚWIADCZENIA</p>
            <table border="1" cellpadding="7" cellspacing="0" style="width: 100%">
               <tbody>
                  <tr>
                     <td>
                        <p>1</p>
                     </td>
                     <td colspan="7">
                        <p>Dotychczas udzielana pomoc osobie/rodzinie ubiegającej się o przyznanie świadczenia</p>
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <p />
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:DotychczasowaPomoc" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td>
                        <p>2</p>
                     </td>
                     <td colspan="7">
                        <p>Stosunek do osoby/rodziny ubiegającej się o przyznanie świadczenia</p>
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <p />
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:StosunekDoOsoby" />
                        </b>
                     </td>
                  </tr>
               </tbody>
               <tbody>
                  <tr>
                     <td>
                        <p>3</p>
                     </td>
                     <td colspan="7">
                        <p>Ustalona z osobą/rodziną forma i wielkość pomocy</p>
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <p />
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:RodzajPomocy" />
                        </b>
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <p />
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:WielkoscPomocy" />
                        </b>
                     </td>
                  </tr>
                  <tr>
                     <td>
                        <p />
                     </td>
                     <td colspan="7">
                        <b>
                           <xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:KwotaPomocy" />
                        </b>
                     </td>
                  </tr>
               </tbody>
            </table>
			
			
			<br clear="all"/>
				
					<table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
						<tbody>
						
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Miejscowość:&#160;<b><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu"/></b>
								</p>
								</td>
								
							</tr>
							<tr>
								<td  colspan="5" valign="bottom">
									<p>Data zgłoszenia:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataZgloszenia/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
							<tr>
								<td colspan="5" valign="bottom">
									<p>Data przeprowadzenia wywiadu:&#160;<b><xsl:value-of select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu/text(),0,11)"/></b>
								</p>
								</td>
								
							</tr>
						</tbody>
					</table>
			
			</div>
         </body>
      </html>
   </xsl:template>
   <xsl:template name="Enumeracja">
      <xsl:param name="schema" />
      <xsl:param name="typ" />
      <xsl:param name="kod" />
      <xsl:variable name="wschema" select="document($schema)" />
      <xsl:value-of select="$wschema//xs:simpleType[@name=$typ]//xs:enumeration[@value = $kod]//xs:documentation" />
   </xsl:template>
   <xsl:template name="Adres1Linia">
      <xsl:value-of select="ns1:KodPocztowy" />
      <xsl:value-of select="ns1:Miejscowosc" />
      <xsl:value-of select="ns1:Ulica" />
      <xsl:value-of select="ns1:NrDomu" />
      <xsl:if test="ns1:NrLok != ''">
         m.
         <xsl:value-of select="ns1:NrLok" />
      </xsl:if>
   </xsl:template>
</xsl:stylesheet>