﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:emp="http://www.mpips.gov.pl/empatia/v5/wywiad/wspolne"
                xmlns:ns1="http://www.mpips.gov.pl/empatia/v5/wywiad/cz9" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                version="1.0">
    <xsl:param name="wspolne" select="'../wspolne/empatia_wspolne_v5.xsd'"/>
    <xsl:output method="html" version="1.0" encoding="utf-8" indent="no" omit-xml-declaration="yes"/>
    <xsl:template match="/">

                    <table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
                        <tbody>
                            <tr>
                                <td colspan="9" valign="top">
                                    <p align="center">CZĘŚĆ IX</p>
                                    <p align="center">DOTYCZY WYWIADU, O KTÓRYM MOWA W ART. 23 UST. 4AA LUB 4B USTAWY </p>
                                    <p align="center">Z DNIA 28 LISTOPADA 2003 R. O ŚWIADCZENIACH RODZINNYCH ALBO</p>
                                    <p align="center">W ART. 15 UST. 1 LUB 2 USTAWY Z DNIA 11 LUTEGO 2016 R. O POMOCY PAŃSTWA</p>
                                    <p align="center">W WYCHOWYWANIU DZIECI</p>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="9" valign="bottom">
                                    I. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr>
                                <td width="20px">
                                    <p>1</p>
                                </td>
                                <td>
                                    <p>Imię</p>
                                </td>
                                <td colspan="7">
                                    <b>
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie1"/>
                                        &#160;
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie2"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr>
                                <td>
                                    <p>2</p>
                                </td>
                                <td>
                                    <p>Nazwisko</p>
                                </td>
                                <td colspan="7">
                                    <b>
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko1"/>
                                        &#160;
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko2"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr>
                                <td>
                                    <p>
                                        3
                                        <br/>
                                    </p>
                                </td>
                                <td>
                                    <p>Data urodzenia</p>
                                </td>
                                <td colspan="2">
                                    dzień:
                                    <b>
                                        <xsl:value-of
                                                select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:DataUr/text(),9,2)"/>
                                    </b>
                                </td>
                                <td colspan="2">
                                    miesiąc:
                                    <b>
                                        <xsl:value-of
                                                select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:DataUr/text(),6,2)"/>
                                    </b>
                                </td>
                                <td colspan="3">
                                    rok:
                                    <b>
                                        <xsl:value-of
                                                select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:DataUr/text(),0,5)"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr>
                                <td>
                                    <p>
                                        4
                                        <br/>
                                         
                                    </p>
                                </td>
                                <td>
                                    <p>
                                        Seria i nr dokumentu potwierdzającego tożsamość
                                        <br/>
                                         
                                    </p>
                                </td>
                                <td colspan="7">
                                    <b>
                                        <xsl:call-template name="Enumeracja">
                                            <xsl:with-param name="schema" select="$wspolne"/>
                                            <xsl:with-param name="typ" select="'RodzajDokumentu'"/>
                                            <xsl:with-param name="kod"
                                                            select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:RodzajDokumentu/text()"/>
                                        </xsl:call-template>
                                        <br/>
                                        <xsl:value-of
                                                select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:NumerDokumentu"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr>
                                <td>
                                    <p>5</p>
                                </td>
                                <td>
                                    <p>Nr PESEL</p>
                                </td>
                                <td colspan="7">
                                    <b>
                                        <xsl:value-of
                                                select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:PESEL"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr>
                                <td rowspan="4" valign="top">
                                    <p>
                                        6
                                        <br/>
                                         
                                    </p>
                                </td>
                                <td rowspan="4" valign="top">
                                    <p>Adres</p>
                                    <p> </p>
                                </td>
                                <td colspan="3">
                                    <p>kod pocztowy:
                                        <b>
                                            <xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy != ''">
                                                <xsl:value-of
                                                        select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),0,3)"/>-<xsl:value-of
                                                    select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy/text(),3,3)"/>
                                            </xsl:if>
                                        </b>
                                    </p>
                                </td>
                                <td colspan="4">
                                    <p>miejscowość:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc"/>
                                        </b>
                                            
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5">
                                    <p>ulica:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica"/>
                                        </b>
                                          
                                    </p>
                                </td>
                                <td>
                                    <p>nr domu:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu"/>
                                        </b>
                                         
                                    </p>
                                </td>
                                <td style="width:160px">
                                    <p>nr mieszkania:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok"/>
                                        </b>
                                          
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3">
                                    <p>telefon:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon"/>
                                        </b>
                                          
                                    </p>
                                </td>
                                <td colspan="4">
                                    <p>telefon najbliższej rodziny:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:TelefonRodziny"/>
                                        </b>
                                          
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="7">
                                    <p>symbol terytorialny:
                                        <b>
                                            <xsl:value-of
                                                    select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny"/>
                                        </b>
                                          
                                    </p>
                                </td>
                            </tr>
                        </tbody>


                    </table>
                    <br/>
                    II. USTALENIA PRACOWNIKA SOCJALNEGO WERYFIKUJĄCE WĄTPLIWOŚCI, O KTÓRYCH MOWA
                    W ART. 23 UST. 4AA USTAWY Z DNIA 28 LISTOPADA 2003 R. O ŚWIADCZENIACH RODZINNYCH ALBO
                    W ART. 15 UST. 1 USTAWY Z DNIA 11 LUTEGO 2016 R. O POMOCY PAŃSTWA W WYCHOWYWANIU
                    DZIECI
                    <br/>
                    <br/>

                    <table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
                        <tbody>
                            <tr>
                                <td>
                                    <b>
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:UstaleniaPracownikaSocjalnegoWeryfikujace"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>

                    </table>
                    <br />
                    III. USTALENIA PRACOWNIKA SOCJALNEGO DOKONANE NA PODSTAWIE INFORMACJI, O KTÓRYCH
                    MOWA W ART. 23 UST. 4B USTAWY Z DNIA 28 LISTOPADA 2003 R. O ŚWIADCZENIACH
                    RODZINNYCH ALBO W ART. 15 UST. 2 USTAWY Z DNIA 11 LUTEGO 2016 R. O POMOCY PAŃSTWA
                    W WYCHOWYWANIU DZIECI
                    <br/>
                    <br/>

                    <table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
                        <tbody>
                            <tr>
                                <td>
                                    <b>
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:UstaleniaPracownikaSocjalnegoDokonane"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>

                            <tr>
                                <td colspan="5" valign="bottom">
                                    <p>Miejscowość:&#160;
                                        <b>
                                            <xsl:value-of
                                                    select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu"/>
                                        </b>
                                    </p>
                                </td>

                            </tr>

                            <tr>
                                <td colspan="5" valign="bottom">
                                    <p>Data przeprowadzenia wywiadu:&#160;
                                        <b>
                                            <xsl:value-of
                                                    select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu/text(),0,11)"/>
                                        </b>
                                    </p>
                                </td>

                            </tr>
                        </tbody>
                    </table>

                    <br/>
                    IV. WNIOSKI PRACOWNIKA SOCJALNEGO PRZEPROWADZAJĄCEGO WYWIAD NA PODSTAWIE ART. 23
                    UST. 4AA LUB 4B USTAWY Z DNIA 28 LISTOPADA 2003 R. O ŚWIADCZENIACH RODZINNYCH ALBO
                    NA PODSTAWIE ART. 15 UST. 1 LUB 2 USTAWY Z DNIA 11 LUTEGO 2016 R. O POMOCY PAŃSTWA
                    W WYCHOWYWANIU DZIECI
                    <br/>
                    <br/>

                    <table border="1" cellpadding="0" cellspacing="0" style="width: 100%">
                        <tbody>
                            <tr>
                                <td>
                                    <b>
                                        <xsl:value-of
                                                select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:Wnioski"/>
                                    </b>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>


                            <tr>
                                <td colspan="5" valign="bottom">
                                    <p>Data przeprowadzenia wywiadu:&#160;
                                        <b>
                                            <xsl:value-of
                                                    select="substring(ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:Data/text(),0,11)"/>
                                        </b>
                                    </p>
                                </td>

                            </tr>
                        </tbody>
                    </table>

    </xsl:template>
    <xsl:template name="Enumeracja">
        <xsl:param name="schema"/>
        <xsl:param name="typ"/>
        <xsl:param name="kod"/>
        <xsl:variable name="wschema" select="document($schema)"/>
        <xsl:value-of select="$wschema//xs:simpleType[@name=$typ]//xs:enumeration[@value = $kod]//xs:documentation"/>
    </xsl:template>
    <xsl:template name="Adres1Linia">
        <xsl:value-of select="ns1:KodPocztowy"/>
         
        <xsl:value-of select="ns1:Miejscowosc"/>
         
        <xsl:value-of select="ns1:Ulica"/>
         
        <xsl:value-of select="ns1:NrDomu"/>
        <xsl:if test="ns1:NrLok != ''">
             m.
            <xsl:value-of select="ns1:NrLok"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>