<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'650'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    .reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: right;
											width: <xsl:value-of select="$width"/>px;
										}
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: center;
										}
					.nadawca_label {font-size: 11px; text-align: right; width:70px;}
					.dane_jedn_label {font-size: 11px;}
					.nadawca_dane {font-size: 11px; text-align: left; font-weight: bold; padding: 5px 0 5px 10px;}
					.nazwa			 {font-size: 12px; font-weight: bold;}
					.przekazac_termin {font-size: 11px; text-align: center; font-weight: bold;}
					.tytul {font-size: 14px; text-align: center; font-weight: bold;}
					.metryczka	{font-family: Tahoma, Verdana; border: 1px solid black; border-collapse: collapse; width: <xsl:value-of select="$width"/>px;}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_row_no	{padding: 5px; text-align: left; border: 1px solid black; width: 37px;}
					.contents		{padding: 5px; text-align: right; border: 1px solid black; width: 89px;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="Sprawozdanie"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Sprawozdanie">
		<xsl:apply-templates select="Z1-CBB-PS"/>
		<xsl:call-template name="EncryptedDataInfo"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Z1-CBB-PS">
		<xsl:apply-templates select="Metryczka"/>
		<!--
		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		-->
		<xsl:apply-templates select="Część_A"/>
		<!--
		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<table border="1" cellpadding="5" class="metryczka">
			<thead>
				<tr>
					<th colspan="3">
						<span class="nazwa">
							MINISTERSTWO RODZINY, PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa<br/>Departament Pomocy i Integracji Społecznej
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="190">
						<span class="dane_jedn_label">
							Dane jednostki sprawozdawczej:
						</span>
						<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
							<table cellspacing="0" cellpadding="0">
								<tr>
									<td class="nadawca_label">Nazwa:</td>
									<td class="nadawca_dane">
										<xsl:value-of select="Pełna-nazwa"/>
									</td>
								</tr>
								<xsl:for-each select="Adres-pocztowy">
									<tr>
										<td class="nadawca_label">Adres:</td>
										<td class="nadawca_dane">
											<xsl:value-of select="Ulica-i-numer"/>
											<br/>
											<xsl:value-of select="Kod-i-poczta"/>
										</td>
									</tr>
								</xsl:for-each>
								<tr>
									<td class="nadawca_label">Tel:</td>
									<td class="nadawca_dane">
										<xsl:value-of select="Telefon"/>
									</td>
								</tr>
								<tr>
									<td class="nadawca_label">Fax:</td>
									<td class="nadawca_dane">
										<xsl:value-of select="Faks"/>
									</td>
								</tr>
							</table>
						</xsl:for-each>
					</td>
					<td rowspan="2" class="tytul">
						Usługa Z1-CBB - Sprawozdanie<br/>z weryfikacji danych za okres<br/>
						<xsl:for-each select="Za-okres">
							od <xsl:value-of select="Data-od"/> do <xsl:value-of select="Data-do"/>
						</xsl:for-each>
					</td>
					<td width="190">
						<span class="nadawca_label">
							Adresat:<br/>
						</span>
						<div class="nadawca_dane" style="text-align: center;">
							<xsl:call-template name="wyznaczOdbiorce"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<table cellspacing="0" cellpadding="0">
							<tr>
								<td class="nadawca_label">Nr raportu:</td>
								<td class="nadawca_dane" style="font-weight: normal;">
									<xsl:value-of select="Numer-raportu"/>
								</td>
							</tr>
							<tr>
								<td class="nadawca_label">Nr wykonania:</td>
								<td class="nadawca_dane" style="font-weight: normal;">
									<xsl:value-of select="Numer-sprawozdania"/>
								</td>
							</tr>
						</table>
					</td>
					<td>
						<div class="przekazac_termin">
							Przekazać w terminie do:<br/>
							<br/>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:if test="Nagłówek">
			<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
			<table class="stopka">
				<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
				<tr>
					<td>imię i nazwisko:</td>
					<td>
						<xsl:value-of select="$kto/Imię-i-nazwisko"/>
					</td>
				</tr>
				<tr>
					<td>telefon służbowy:</td>
					<td>
						<xsl:value-of select="$kto/Telefon"/>
					</td>
				</tr>
				<tr>
					<td>e-mail służbowy:</td>
					<td>
						<xsl:value-of select="$kto/E-mail"/>
					</td>
				</tr>
				<tr>
					<td>Data sporządzenia sprawozdania:</td>
					<td>
						<xsl:value-of select="$kto/Data-wykonania"/>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="EncryptedDataInfo">
		<xsl:if test="not(Z1-CBB-PS)">
			<div>W celu zastosowania transformaty, odszyfruj dane znajdujące się w pliku.</div>
		</xsl:if>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A_1'">Po weryfikacji przez jednostkę okazało się, że informacja <span style="font-weight: bold">ma wpływ</span> na podjętą wcześniej decyzję</xsl:when>
			<xsl:when test="$row_name = 'A_1.1'">w tym:<br/>liczba decyzji zmieniających</xsl:when>
			<xsl:when test="$row_name = 'A_2'">Po weryfikacji przez jednostkę okazało się, że informacja <span style="font-weight: bold">nie ma wpływu</span> na podjętą wcześniej decyzję</xsl:when>
			<xsl:when test="$row_name = 'A_3'">Informacja uzyskana <span style="font-weight: bold">nie ma wpływu</span> na podjętą wcześniej decyzję, ponieważ jednostka <span style="font-weight: bold">miała już wcześniej informację</span> o zmianie i obsługuje ją niezależnie od informacji uzyskanej w ramach monitoringu</xsl:when>
			<xsl:when test="$row_name = 'A_3.1'">w tym:<br/>liczba decyzji zmieniających</xsl:when>
			<xsl:when test="$row_name = 'A_4'"><span style="font-weight: bold">Nie ma wpływu,</span> informacja po weryfikacji przez jednostkę okazała się nieprawdziwa</xsl:when>
			<xsl:when test="$row_name = 'A_5'"><span style="font-weight: bold">Sprawa w toku</span> (jednostka jest w trakcie weryfikacji uzyskanej informacji)</xsl:when>
			<xsl:when test="$row_name = 'A_6'"><span style="font-weight: bold">Przypadek nie został sprawdzony przez jednostkę</span></xsl:when>
			<xsl:when test="$row_name = 'A_7'"><span style="font-weight: bold">Liczba otrzymanych informacji z ZUS</span></xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:if test="not(contains(name(),'.'))">
				<xsl:value-of select="substring-after(name(), '_')"/>
			</xsl:if>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-head"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Część-A-content"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--	
	=============================================================================================	
	-->
	<xsl:template name="Table-head">
		<thead>
			<tr>
				<th>Status</th>
				<th>OBSZAR PS</th>
				<th>Przesył - 2</th>
				<th>Przesył - 1</th>
				<th>Obecny przesył</th>
			</tr>
		</thead>
	</xsl:template>
	<!--	
	=============================================================================================	
	-->
	<xsl:template name="Część-A-content">
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wartość-2'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wartość-1'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wartość-0'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="subtree_item" select="*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="contents">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<td class="contents">
			<xsl:choose>
				<xsl:when test="string(number($contents)) = 'NaN'">
					<div style="color: red; text-align: center;">???</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($contents, $format)"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="wyznaczOdbiorce">
		<xsl:choose>
			<xsl:when test="string-length(Odbiorca) > 0">
				<xsl:value-of select="Odbiorca"/>
			</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="kodWojew" select="substring(Odbiorca/@Kod-NTS,3,2)"/>
					<xsl:choose>
						<xsl:when test="$kodWojew = '02'">Dolnośląski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '04'">Kujawsko-Pomorski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '06'">Lubelski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '08'">Lubuski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '10'">Łódzki Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '12'">Małopolski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '14'">Mazowiecki Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '16'">Opolski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '18'">Podkarpacki Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '20'">Podlaski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '22'">Pomorski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '24'">Śląski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '26'">Świętokrzyski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '28'">Warmińsko-Mazurski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '30'">Wielkopolski Urząd Wojewódzki</xsl:when>
						<xsl:when test="$kodWojew = '32'">Zachodniopomorski Urząd Wojewódzki</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
