package pl.topteam.pomost.integracja.eopieka.v1_10.api;

import pl.topteam.pomost.integracja.eopieka.v1_10.ApiException;
import pl.topteam.pomost.integracja.eopieka.v1_10.ApiClient;
import pl.topteam.pomost.integracja.eopieka.v1_10.ApiResponse;
import pl.topteam.pomost.integracja.eopieka.v1_10.Configuration;
import pl.topteam.pomost.integracja.eopieka.v1_10.Pair;

import javax.ws.rs.core.GenericType;

import pl.topteam.pomost.integracja.eopieka.v1_10.model.Slowniki;
import pl.topteam.pomost.integracja.eopieka.v1_10.model.TOdpowiedz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SlownikiApi {
  private ApiClient apiClient;

  public SlownikiApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SlownikiApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get the API client
   *
   * @return API client
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /**
   * Set the API client
   *
   * @param apiClient an instance of API client
   */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Zapis słowników dla danych wywaiadu środowiskowego i zlecenia
   * 
   * @param slowniki Słowniki do zapisu w systemie E-Opieka (required)
   * @return TOdpowiedz
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Brak autoryzacji </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Dostęp zabroniony </td><td>  -  </td></tr>
       <tr><td> 405 </td><td> Nieprawidłowe dane - błąd walidacji </td><td>  -  </td></tr>
       <tr><td> 0 </td><td> OK </td><td>  -  </td></tr>
     </table>
   */
  public TOdpowiedz zapisSlownikow(Slowniki slowniki) throws ApiException {
    return zapisSlownikowWithHttpInfo(slowniki).getData();
  }

  /**
   * Zapis słowników dla danych wywaiadu środowiskowego i zlecenia
   * 
   * @param slowniki Słowniki do zapisu w systemie E-Opieka (required)
   * @return ApiResponse&lt;TOdpowiedz&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Brak autoryzacji </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Dostęp zabroniony </td><td>  -  </td></tr>
       <tr><td> 405 </td><td> Nieprawidłowe dane - błąd walidacji </td><td>  -  </td></tr>
       <tr><td> 0 </td><td> OK </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TOdpowiedz> zapisSlownikowWithHttpInfo(Slowniki slowniki) throws ApiException {
    Object localVarPostBody = slowniki;
    
    // verify the required parameter 'slowniki' is set
    if (slowniki == null) {
      throw new ApiException(400, "Missing the required parameter 'slowniki' when calling zapisSlownikow");
    }
    
    // create path and map variables
    String localVarPath = "/slowniki";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "OAuth2" };

    GenericType<TOdpowiedz> localVarReturnType = new GenericType<TOdpowiedz>() {};

    return apiClient.invokeAPI("SlownikiApi.zapisSlownikow", localVarPath, "POST", localVarQueryParams, localVarPostBody,
                               localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType,
                               localVarAuthNames, localVarReturnType, false);
  }
}
