package pl.topteam.pomost.integracja.eopieka.v1_10.api;

import pl.topteam.pomost.integracja.eopieka.v1_10.ApiException;
import pl.topteam.pomost.integracja.eopieka.v1_10.ApiClient;
import pl.topteam.pomost.integracja.eopieka.v1_10.ApiResponse;
import pl.topteam.pomost.integracja.eopieka.v1_10.Configuration;
import pl.topteam.pomost.integracja.eopieka.v1_10.Pair;

import javax.ws.rs.core.GenericType;

import pl.topteam.pomost.integracja.eopieka.v1_10.model.TIdentyfikatorZlecenia;
import pl.topteam.pomost.integracja.eopieka.v1_10.model.TOdpowiedz;
import pl.topteam.pomost.integracja.eopieka.v1_10.model.Zlecenie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ZlecenieApi {
  private ApiClient apiClient;

  public ZlecenieApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ZlecenieApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get the API client
   *
   * @return API client
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /**
   * Set the API client
   *
   * @param apiClient an instance of API client
   */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Zapis danych zlecenia świadczenia usług opiekuńczych, specjalistycznych usług opiekuńczych, teleopiki, diety. Rezultatem meody jest identyfikator GUID zlecenia zarejestrowany w sysytemie eOpieka
   * 
   * @param zlecenie Zlecenie wydane przez Ośrodek Opieki Społecznej do zapisu w systemie eOpieka (required)
   * @return TIdentyfikatorZlecenia
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Brak autoryzacji </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Dostęp zabroniony </td><td>  -  </td></tr>
       <tr><td> 405 </td><td> Nieprawidłowe dane - błąd walidacji </td><td>  -  </td></tr>
       <tr><td> 0 </td><td> OK </td><td>  -  </td></tr>
     </table>
   */
  public TIdentyfikatorZlecenia zapisZlecenia(Zlecenie zlecenie) throws ApiException {
    return zapisZleceniaWithHttpInfo(zlecenie).getData();
  }

  /**
   * Zapis danych zlecenia świadczenia usług opiekuńczych, specjalistycznych usług opiekuńczych, teleopiki, diety. Rezultatem meody jest identyfikator GUID zlecenia zarejestrowany w sysytemie eOpieka
   * 
   * @param zlecenie Zlecenie wydane przez Ośrodek Opieki Społecznej do zapisu w systemie eOpieka (required)
   * @return ApiResponse&lt;TIdentyfikatorZlecenia&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Brak autoryzacji </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Dostęp zabroniony </td><td>  -  </td></tr>
       <tr><td> 405 </td><td> Nieprawidłowe dane - błąd walidacji </td><td>  -  </td></tr>
       <tr><td> 0 </td><td> OK </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TIdentyfikatorZlecenia> zapisZleceniaWithHttpInfo(Zlecenie zlecenie) throws ApiException {
    Object localVarPostBody = zlecenie;
    
    // verify the required parameter 'zlecenie' is set
    if (zlecenie == null) {
      throw new ApiException(400, "Missing the required parameter 'zlecenie' when calling zapisZlecenia");
    }
    
    // create path and map variables
    String localVarPath = "/zlecenie";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "OAuth2" };

    GenericType<TIdentyfikatorZlecenia> localVarReturnType = new GenericType<TIdentyfikatorZlecenia>() {};

    return apiClient.invokeAPI("ZlecenieApi.zapisZlecenia", localVarPath, "POST", localVarQueryParams, localVarPostBody,
                               localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType,
                               localVarAuthNames, localVarReturnType, false);
  }
}
