/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.pomost.integracja.eopieka.v1_12;

import com.github.scribejava.core.model.OAuth2AccessToken;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.pomost.integracja.eopieka.v1_12.ApiClient;
import pl.topteam.pomost.integracja.eopieka.v1_12.ApiException;
import pl.topteam.pomost.integracja.eopieka.v1_12.ApiResponse;
import pl.topteam.pomost.integracja.eopieka.v1_12.Pair;
import pl.topteam.pomost.integracja.eopieka.v1_12.ServerConfiguration;
import pl.topteam.pomost.integracja.eopieka.v1_12.auth.Authentication;
import pl.topteam.pomost.integracja.eopieka.v1_12.auth.TTOAuth;

public class TTApiClient
extends ApiClient {
    private static final Logger log = LoggerFactory.getLogger((String)TTApiClient.class.getName());

    public TTApiClient() {
        this(null);
    }

    public TTApiClient(Map<String, Authentication> authMap) {
        super(authMap);
        this.authentications = new HashMap();
        Authentication auth = null;
        if (authMap != null) {
            auth = authMap.get("OAuth2");
        }
        if (auth instanceof TTOAuth) {
            this.authentications.put("OAuth2", auth);
        } else {
            this.authentications.put("OAuth2", new TTOAuth(this.basePath, "https://idp.peum.waw.pl/oauth2/token"));
        }
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    @Override
    public TTApiClient setHttpClient(Client httpClient) {
        super.setHttpClient(httpClient);
        return this;
    }

    @Override
    public TTApiClient setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setOauthBasePath(basePath);
        return this;
    }

    @Override
    public TTApiClient setServers(List<ServerConfiguration> servers) {
        super.setServers(servers);
        return this;
    }

    @Override
    public TTApiClient setServerIndex(Integer serverIndex) {
        super.setServerIndex(serverIndex);
        return this;
    }

    @Override
    public TTApiClient setServerVariables(Map<String, String> serverVariables) {
        super.setServerVariables(serverVariables);
        return this;
    }

    private void setOauthBasePath(String basePath) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).setBasePath(basePath);
        }
    }

    @Override
    public TTApiClient setUsername(String username) {
        super.setUsername(username);
        return this;
    }

    @Override
    public TTApiClient setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public TTApiClient setApiKey(String apiKey) {
        super.setApiKey(apiKey);
        return this;
    }

    @Override
    public TTApiClient configureApiKeys(Map<String, String> secrets) {
        super.configureApiKeys(secrets);
        return this;
    }

    @Override
    public TTApiClient setApiKeyPrefix(String apiKeyPrefix) {
        super.setApiKeyPrefix(apiKeyPrefix);
        return this;
    }

    @Override
    public TTApiClient setBearerToken(String bearerToken) {
        super.setBearerToken(bearerToken);
        return this;
    }

    @Override
    public TTApiClient setAccessToken(String accessToken) {
        super.setAccessToken(accessToken);
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).setAccessToken(accessToken);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    @Override
    public TTApiClient setOauthCredentials(String clientId, String clientSecret) {
        super.setOauthCredentials(clientId, clientSecret);
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).setCredentials(clientId, clientSecret, this.isDebugging());
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    @Override
    public TTApiClient setOauthCredentialsForPublicClient(String clientId) {
        super.setOauthCredentialsForPublicClient(clientId);
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).setCredentialsForPublicClient(clientId, this.isDebugging());
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    @Override
    public TTApiClient setOauthPasswordFlow(String username, String password) {
        super.setOauthPasswordFlow(username, password);
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).usePasswordFlow(username, password);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    @Override
    public TTApiClient setOauthAuthorizationCodeFlow(String code) {
        super.setOauthAuthorizationCodeFlow(code);
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).useAuthorizationCodeFlow(code);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    @Override
    public TTApiClient setOauthScope(String scope) {
        super.setOauthScope(scope);
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof TTOAuth)) continue;
            ((TTOAuth)auth).setScope(scope);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    @Override
    public TTApiClient setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public TTApiClient addDefaultHeader(String key, String value) {
        super.addDefaultHeader(key, value);
        return this;
    }

    @Override
    public TTApiClient addDefaultCookie(String key, String value) {
        super.addDefaultCookie(key, value);
        return this;
    }

    @Override
    public TTApiClient setClientConfig(ClientConfig clientConfig) {
        super.setClientConfig(clientConfig);
        return this;
    }

    @Override
    public TTApiClient setDebugging(boolean debugging) {
        super.setDebugging(debugging);
        return this;
    }

    @Override
    public TTApiClient setTempFolderPath(String tempFolderPath) {
        super.setTempFolderPath(tempFolderPath);
        return this;
    }

    @Override
    public TTApiClient setConnectTimeout(int connectionTimeout) {
        super.setConnectTimeout(connectionTimeout);
        return this;
    }

    @Override
    public TTApiClient setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        return this;
    }

    @Override
    public TTApiClient setDateFormat(DateFormat dateFormat) {
        super.setDateFormat(dateFormat);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> ApiResponse<T> invokeAPI(String operation, String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType, boolean isBodyNullable) throws ApiException {
        Object value;
        String targetURL;
        List serverConfigurations;
        if (this.serverIndex != null && (serverConfigurations = (List)this.operationServers.get(operation)) != null) {
            int index = this.operationServerIndex.getOrDefault(operation, this.serverIndex);
            Map variables = this.operationServerVariables.getOrDefault(operation, this.serverVariables);
            if (index < 0 || index >= serverConfigurations.size()) {
                throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", index, serverConfigurations.size()));
            }
            targetURL = ((ServerConfiguration)serverConfigurations.get(index)).URL(variables) + path;
        } else {
            targetURL = this.basePath + path;
        }
        WebTarget target = this.httpClient.target(targetURL);
        if (queryParams != null) {
            for (Pair pair : queryParams) {
                if (pair.getValue() == null) continue;
                target = target.queryParam(pair.getName(), new Object[]{this.escapeString(pair.getValue())});
            }
        }
        Invocation.Builder invocationBuilder = target.request();
        if (accept != null) {
            invocationBuilder = invocationBuilder.accept(new String[]{accept});
        }
        for (Map.Entry<String, String> entry : cookieParams.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), (String)value);
        }
        for (Map.Entry entry : this.defaultCookieMap.entrySet()) {
            value = (String)entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie((String)entry.getKey(), (String)value);
        }
        Entity<?> entity = this.serialize(body, formParams, contentType, isBodyNullable);
        HashMap<String, String> hashMap = new HashMap<String, String>(this.defaultHeaderMap);
        hashMap.putAll(headerParams);
        if (authNames != null) {
            this.updateParamsForAuth(authNames, queryParams, hashMap, cookieParams, null, method, target.getUri());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String value2 = (String)entry.getValue();
            if (value2 == null) continue;
            invocationBuilder = invocationBuilder.header((String)entry.getKey(), (Object)value2);
        }
        Response response = null;
        try {
            response = this.sendRequest(method, invocationBuilder, entity);
            log.info("(invokeAPI) HTTP status: " + response.getStatusInfo().getStatusCode());
            if (authNames != null && response.getStatusInfo().getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                for (String authName : authNames) {
                    Authentication authentication = (Authentication)this.authentications.get(authName);
                    if (!(authentication instanceof TTOAuth)) continue;
                    OAuth2AccessToken accessToken = ((TTOAuth)authentication).renewAccessToken();
                    if (accessToken == null) break;
                    invocationBuilder.header("Authorization", null);
                    invocationBuilder.header("Authorization", (Object)("Bearer " + accessToken.getAccessToken()));
                    response = this.sendRequest(method, invocationBuilder, entity);
                    log.info("(invokeAPI) HTTP status (resend after refresh token): " + response.getStatusInfo().getStatusCode());
                    break;
                }
            }
            Map<String, List<String>> map = this.buildResponseHeaders(response);
            if (response.getStatusInfo().getStatusCode() == Response.Status.NO_CONTENT.getStatusCode()) {
                ApiResponse value2 = new ApiResponse(response.getStatusInfo().getStatusCode(), map);
                return value2;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (returnType == null) {
                    ApiResponse value2 = new ApiResponse(response.getStatusInfo().getStatusCode(), map);
                    return value2;
                }
                ApiResponse<T> value2 = new ApiResponse<T>(response.getStatusInfo().getStatusCode(), map, this.deserialize(response, returnType));
                return value2;
            }
            String message = "error";
            String respBody = null;
            if (!response.hasEntity()) throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
                throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    private Response sendRequest(String method, Invocation.Builder invocationBuilder, Entity<?> entity) {
        Response response = "POST".equals(method) ? invocationBuilder.post(entity) : ("PUT".equals(method) ? invocationBuilder.put(entity) : ("DELETE".equals(method) ? invocationBuilder.method("DELETE", entity) : ("PATCH".equals(method) ? invocationBuilder.method("PATCH", entity) : invocationBuilder.method(method))));
        return response;
    }
}

