/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.pomost.integracja.eopieka.v1_12.auth;

import java.net.URI;
import java.util.List;
import java.util.Map;
import pl.topteam.pomost.integracja.eopieka.v1_12.ApiException;
import pl.topteam.pomost.integracja.eopieka.v1_12.Pair;
import pl.topteam.pomost.integracja.eopieka.v1_12.auth.Authentication;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private String bearerToken;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        if (this.bearerToken == null) {
            return;
        }
        headerParams.put("Authorization", (this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + this.bearerToken);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

