/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.pomost.integracja.eopieka.v1_12.auth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.pomost.integracja.eopieka.v1_12.ApiException;
import pl.topteam.pomost.integracja.eopieka.v1_12.Pair;
import pl.topteam.pomost.integracja.eopieka.v1_12.auth.Authentication;
import pl.topteam.pomost.integracja.eopieka.v1_12.auth.OAuthFlow;

public class TTOAuth
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger((String)TTOAuth.class.getName());
    private String tokenUrl;
    private String absoluteTokenUrl;
    private OAuthFlow flow = OAuthFlow.APPLICATION;
    private OAuth20Service service;
    private DefaultApi20 authApi;
    private String scope;
    private String username;
    private String password;
    private String code;
    private volatile OAuth2AccessToken accessToken;

    public TTOAuth(String basePath, String tokenUrl) {
        this.tokenUrl = tokenUrl;
        this.absoluteTokenUrl = TTOAuth.createAbsoluteTokenUrl(basePath, tokenUrl);
        this.authApi = new DefaultApi20(){

            public String getAccessTokenEndpoint() {
                return TTOAuth.this.absoluteTokenUrl;
            }

            protected String getAuthorizationBaseUrl() {
                throw new UnsupportedOperationException("Shouldn't get there !");
            }
        };
    }

    private static String createAbsoluteTokenUrl(String basePath, String tokenUrl) {
        if (!URI.create(tokenUrl).isAbsolute()) {
            try {
                return UriBuilder.fromPath((String)basePath).path(tokenUrl).build(new Object[0]).toURL().toString();
            }
            catch (MalformedURLException e) {
                log.error("Couldn't create absolute token URL", (Throwable)e);
            }
        }
        return tokenUrl;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        if (this.accessToken == null) {
            this.obtainAccessToken(null);
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken.getAccessToken());
        }
    }

    public OAuth2AccessToken renewAccessToken() throws ApiException {
        String refreshToken = null;
        if (this.accessToken != null) {
            refreshToken = this.accessToken.getRefreshToken();
            this.accessToken = null;
        }
        return this.obtainAccessToken(refreshToken);
    }

    public synchronized OAuth2AccessToken obtainAccessToken(String refreshToken) throws ApiException {
        if (this.service == null) {
            log.error("service is null in obtainAccessToken.");
            return null;
        }
        try {
            if (refreshToken != null) {
                this.accessToken = this.service.refreshAccessToken(refreshToken);
                this.log(this.accessToken, true);
                return this.accessToken;
            }
        }
        catch (OAuthException | IOException | InterruptedException | ExecutionException e) {
            this.accessToken = null;
        }
        try {
            switch (this.flow) {
                case PASSWORD: {
                    if (this.username == null || this.password == null) break;
                    this.accessToken = this.service.getAccessTokenPasswordGrant(this.username, this.password, this.scope);
                    this.log(this.accessToken, false);
                    break;
                }
                case ACCESS_CODE: {
                    if (this.code == null) break;
                    this.accessToken = this.service.getAccessToken(this.code);
                    this.log(this.accessToken, false);
                    this.code = null;
                    break;
                }
                case APPLICATION: {
                    this.accessToken = this.service.getAccessTokenClientCredentialsGrant(this.scope);
                    this.log(this.accessToken, false);
                    break;
                }
                default: {
                    log.error("Invalid flow in obtainAccessToken: " + (Object)((Object)this.flow));
                }
            }
            return this.accessToken;
        }
        catch (OAuthException | IOException | InterruptedException | ExecutionException e) {
            throw new ApiException(e);
        }
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public TTOAuth setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public TTOAuth setAccessToken(String accessToken) {
        this.accessToken = new OAuth2AccessToken(accessToken);
        return this;
    }

    public TTOAuth setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public TTOAuth setCredentials(String clientId, String clientSecret, Boolean debug) {
        this.service = Boolean.TRUE.equals(debug) ? new ServiceBuilder(clientId).apiSecret(clientSecret).debug().build(this.authApi) : new ServiceBuilder(clientId).apiSecret(clientSecret).build(this.authApi);
        return this;
    }

    public TTOAuth setCredentialsForPublicClient(String clientId, Boolean debug) {
        this.service = Boolean.TRUE.equals(debug) ? new ServiceBuilder(clientId).apiSecretIsEmptyStringUnsafe().debug().build(this.authApi) : new ServiceBuilder(clientId).apiSecretIsEmptyStringUnsafe().build(this.authApi);
        return this;
    }

    public TTOAuth usePasswordFlow(String username, String password) {
        this.flow = OAuthFlow.PASSWORD;
        this.username = username;
        this.password = password;
        return this;
    }

    public TTOAuth useAuthorizationCodeFlow(String code) {
        this.flow = OAuthFlow.ACCESS_CODE;
        this.code = code;
        return this;
    }

    public TTOAuth setFlow(OAuthFlow flow) {
        this.flow = flow;
        return this;
    }

    public void setBasePath(String basePath) {
        this.absoluteTokenUrl = TTOAuth.createAbsoluteTokenUrl(basePath, this.tokenUrl);
    }

    private void log(OAuth2AccessToken token, boolean refreshed) {
        log.info("OAuth2AccessToken (" + (refreshed ? "refreshed" : "new") + ")");
        log.info("\taccessToken = {}", (Object)this.accessToken.getAccessToken());
        log.info("\ttokenType = {}", (Object)this.accessToken.getTokenType());
        log.info("\texpiresIn = {}", (Object)this.accessToken.getExpiresIn());
        log.info("\trefreshToken = {}", (Object)this.accessToken.getRefreshToken());
        log.info("\tscope = {}", (Object)this.accessToken.getScope());
    }
}

