package pl.gov.gus.slowniki;

import com.google.auto.value.AutoValue;

@AutoValue
public abstract class Obywatelstwo {
	public abstract String kodNumeryczny();
	public abstract String kodAlfa2();
	public abstract String kodAlfa3();
	public abstract String nazwaPanstwa();
	
	public static Builder builder() {
		return new AutoValue_Obywatelstwo.Builder();
	}
	
	@AutoValue.Builder
	public abstract static class Builder {
		public abstract Builder setKodNumeryczny(String kodNumeryczny);
		public abstract Builder setKodAlfa2(String kodAlfa2);
		public abstract Builder setKodAlfa3(String kodAlfa3);
		public abstract Builder setNazwaPanstwa(String nazwaPanstwa);
		public abstract Obywatelstwo build();
	}
}
