package pl.gov.gus.slowniki;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Set;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;

public class Obywatelstwa {
	public static Set<Obywatelstwo> wczytaj() throws Exception {
		URL url = Resources.getResource("csv/gus/slowniki/Obywatelstwo.csv");
		try (CSVParser parser = CSVParser.parse(url, StandardCharsets.UTF_8, CSVFormat.DEFAULT)) {
			ImmutableSet.Builder<Obywatelstwo> obywatelstwa = ImmutableSet.builder();
			for (CSVRecord rekord : parser) {
				Obywatelstwo.Builder obywatelstwo = Obywatelstwo.builder();
				obywatelstwo.setKodNumeryczny(rekord.get(0));
				obywatelstwo.setKodAlfa2(rekord.get(1));
				obywatelstwo.setKodAlfa3(rekord.get(2));
				obywatelstwo.setNazwaPanstwa(rekord.get(3));
				obywatelstwa.add(obywatelstwo.build());
			}
			return obywatelstwa.build();
		}
	}
}
