/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.pomost.integracja;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.pomost.integracja.DateUtils;

public class LocalDateAdapter
extends XmlAdapter<String, LocalDate> {
    private static final Logger log = LoggerFactory.getLogger(LocalDateAdapter.class);

    public String marshal(LocalDate value) {
        return DateUtils.DATE_FORMATTER.print((ReadablePartial)value);
    }

    public LocalDate unmarshal(String value) {
        try {
            return DateUtils.DATE_FORMATTER.parseLocalDate(value);
        }
        catch (IllegalArgumentException iaex) {
            log.error("{}", (Throwable)iaex);
            try {
                return DateUtils.DATE_GREGORIAN_CALENDAR_FORMATTER.parseLocalDate(value);
            }
            catch (IllegalArgumentException iaex2) {
                log.error("{}", (Throwable)iaex2);
                return null;
            }
        }
    }
}

