<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ns0="http://www.gov.pl/du/r2021/poz893/wywiad/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2021/poz893/wywiad/cz5"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

	<xsl:variable name="RodzajAdresu" select="document('../xml/RodzajAdresu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />

	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:template match="/">
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON powiatowego centrum pomocy rodzinie
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				<h2>
					CZĘŚĆ V<br/>
					DOTYCZY OSÓB UBIEGAJĄCYCH SIĘ O POMOC<br/>
					PIENIĘŻNĄ NA USAMODZIELNIENIE, POMOC PIENIĘŻNĄ<br/>
					NA KONTYNUOWANIE NAUKI*
				</h2>
				<br/>
				<section>
					<h3>A. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="width: 20mm;">Imię</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie2" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Nazwisko</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko2" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">3</td>
							<td style="width: 76mm;">Seria i nr dokumentu potwierdzającego tożsamość</td>
							<td>
								<ins>
									<xsl:variable name="_RodzajDokumentu" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">4</td>
							<td>Nr PESEL</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:PESEL" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>5</td>
							<td style="width: 26mm;">
								Adres
								<br/>
								<ins>
									<xsl:variable name="_Rodzaj" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Rodzaj" />
									<xsl:value-of select="$RodzajAdresu[@key = $_Rodzaj]" />
								</ins>
							</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>symbol terytorialny: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>6</td>
							<td>Adres do korespondencji</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrLok" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">7</td>
							<td>
								Sytuacja rodzinna
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodzinna = '1'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) osoba samotnie gospodarująca
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodzinna = '2'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) osoba wspólnie zamieszkująca i gospodarująca z rodziną
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodzinna = '3'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) inne - wskazać jakie:
								<br/>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodzinnaInnaOpis">
									<span class="textarea" style="display: block; padding-left: 25px;">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodzinnaInnaOpis"/></ins>
									</span>
								</xsl:if>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td rowspan="2" style="width: 6mm;">8</td>
							<td>Z jakiego rodzaju opieki osoba usamodzielniana korzystała?</td>
						</tr>
						<tr>
							<td style="padding: 0;">
								<table>
									<tr>
										<th>Rodzaj opieki</th>
										<th>Okres przebywania</th>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'DPS']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											1) dom pomocy społecznej dla dzieci i młodzieży niepełnosprawnych intelektualnie
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'DPS']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'OsrodekWsparcia']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											2) dom dla matek z małoletnimi dziećmi i kobiet w ciąży
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'OsrodekWsparcia']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'ZaklPopr']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											3) zakład poprawczy
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'ZaklPopr']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'SchrDlaNielet']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											4) schronisko dla nieletnich
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'SchrDlaNielet']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'MlodziezOsrWych']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											5) młodzieżowy ośrodek wychowawczy
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'MlodziezOsrWych']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'SpecOsrSzkolWych']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											6) specjalny ośrodek szkolno-wychowawczy
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'SpecOsrSzkolWych']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'SpecOsrWych']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											7) specjalny ośrodek wychowawczy
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'SpecOsrWych']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'MlodzOsrSocjo']">
													<ins>✓</ins>
												</xsl:when>
												<xsl:otherwise>
													&#160;&#160;&#160;
												</xsl:otherwise>
											</xsl:choose>
											8) młodzieżowy ośrodek socjoterapii
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Osrodek[./ns1:Rodzaj = 'MlodzOsrSocjo']/ns1:Okres"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td style="font-weight: bold;">Łączny czas pobytu poza rodziną (pkt 1-8)</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:Razem"/>
											</ins>
										</td>
									</tr>
									<tr>
										<td>
											Ostatnie miejsce pobytu przed usamodzielnieniem (nazwa i adres placówki,
											którą opuściła osoba ubiegająca się o pomoc pieniężną na usamodzielnienie,
											pomoc pieniężną na kontynuowanie nauki)
										</td>
										<td style="width: 80mm;">
											<span>
												<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:OstatnaPlacowka/ns1:Nazwa"/></ins>
											</span>
											<br/>
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Opieka/ns1:OstatnaPlacowka/ns1:Adres"/></ins>
											</span>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">9</td>
							<td>
								Czy osoba usamodzielniana uczy się?
								<div style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:CzyNauka = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) tak
									&#160;&#160;&#160;
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:CzyNauka = 'N'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) nie
								</div>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td rowspan="2" style="width: 6mm;">10</td>
							<td>
								Typ szkoły:<br/>
								<span class="textarea">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:NazwaSzkoly"/>
										<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:TypSzkoly">
											(<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:TypSzkoly"/>)
										</xsl:if>
									</ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="padding: 0">
								<table>
									<tr>
										<td>klasa / rok studiów</td>
										<td style="width: 10mm;">
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:KlasaRok"/>
											</ins>
										</td>
										<td>semestr</td>
										<td style="width: 10mm;">
											<ins>
												<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Nauka/ns1:Semestr"/>
											</ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<br/>
					<table>
						<tr>
							<td style="width: 6mm; height: 60mm;">11</td>
							<td>Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right; width: 40mm;">
								<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:LacznyDochodWRodzinie, '0,00')"/></ins><xsl:text> </xsl:text>zł
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 12mm;">12</td>
							<td>Dochód na osobę w rodzinie</td>
							<td style="text-align: right; width: 40mm;">
								<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DochodNaOsobe, '0,00')"/></ins><xsl:text> </xsl:text>zł
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 12mm;">13</td>
							<td>Kryterium dochodowe dla danej osoby/rodziny (wynikające z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right; width: 40mm;">
								<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:KryteriumDochodowe, '0,00')"/></ins><xsl:text> </xsl:text>zł
							</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego przeprowadzającego wywiad:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br style="clear: both;"/>
							<br/>
							<br/>
							<span style="float: left;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: left; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br/>
							<br/>
							<br/>
							<br/>
							Oświadczam, że podane wyżej informacje są zgodne z prawdą.
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.5cm;">(data i podpis osoby, z którą przeprowadzono wywiad)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					Informacja o warunkach bezpieczeństwa podczas przeprowadzania wywiadu:
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyDrugiPracownik/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) uczestnictwo drugiego pracownika socjalnego
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyAsystaPolicji/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) asysta funkcjonariusza Policji
								</td>
								<td>
									<table>
										<tbody>
											<tr>
												<td width="50%" style="border-right: 0px none;">
													Czy wystąpiły sytuacje
													<br/>zagrożenia podczas
													<br/>przeprowadzania wywiadu?
												</td>
												<td style="border-left: 0px none;">
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'T'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													1) tak - wskazać jakie:
													<br/>
													<span class="textarea" style="display: block; padding-left: 8mm;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:JakieSytuacjeZagrozenia"/></ins></span>
													<br/>
													<br/>
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'N'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													2) nie
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<br/><br/>
					<span>
						Miejscowość
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu" /></ins>
						&#160;&#160;&#160;&#160;&#160;&#160;
						Data
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu" /></ins>
					</span>
					<br/>
					<br/>
					<br/>
					<br/>
					<br/>
					<br/>
					<br/>
					<div><small>* Należy dołączyć kopię programu usamodzielnienia.</small></div>
				</section>
				<section style="page-break-before: always;">
					<h3>B. WNIOSKI PRACOWNIKA SOCJALNEGO</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="height: 16mm;">
								Wysokość pomocy pieniężnej na usamodzielnienie
								<span style="float: right;">
									<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PomocNaUsamodzielnienieSie/ns1:Kwota">
										<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PomocNaUsamodzielnienieSie/ns1:Kwota, '0,00')"/></ins><xsl:text> </xsl:text>zł
									</xsl:if>
								</span>
								<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PomocNaUsamodzielnienieSie/ns1:Opis" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">2</td>
							<td style="height: 16mm;">
								Wysokość pomocy pieniężnej na kontynuowanie nauki
								<span style="float: right;">
									<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PomocNaKontynuowanieNauki/ns1:Kwota">
										<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PomocNaKontynuowanieNauki/ns1:Kwota, '0,00')"/></ins><xsl:text> </xsl:text>zł
									</xsl:if>
								</span>
								<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PomocNaKontynuowanieNauki/ns1:Opis" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:WnioskiPracownikaSocjalnego/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
						</xsl:otherwise>
					</xsl:choose>
				</section>
				<br/>
				<br/>
				<br/>
				<br/>
				<br/>
				<section style="page-break-before: auto;">
					<h3>C. INFORMACJA O DECYZJI O PRZYZNANIU POMOCY</h3>
					<div class="textarea" style="min-height: 100mm;">
						<ins>
							<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Tresc" />
						</ins>
					</div>
					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko kierownika:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br style="clear: both;"/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć kierownika powiatowego centrum pomocy rodzinie)</span>
							<br style="clear: both;"/>
							<br/>
							<br/>
							<br/>
							<span style="float: left;">
								Miejscowość
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Miejscowosc" />
								</ins>
								&#160;&#160;&#160;&#160;&#160;&#160;
								Data
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjaODecyzji/ns1:Data" />
								</ins>
							</span>
							<br/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
				<br/>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						<span style="text-transform: uppercase;">
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
