<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ns0="http://www.gov.pl/du/r2021/poz893/wywiad/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2021/poz893/wywiad/cz7"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

	<xsl:variable name="RodzajAdresu" select="document('../xml/RodzajAdresu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />
	<xsl:variable name="RodzajZasilku" select="document('../xml/RodzajZasilku.xml')/properties/entry" />
	<xsl:variable name="TakNie" select="document('../xml/TakNie.xml')/properties/entry" />

	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:template match="/">
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON jednostki organizacyjnej pomocy społecznej lub
										<br/>podmiotu udzielającego świadczeń zdrowotnych
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				<h2>
					CZĘŚĆ VII<br/>
					DOTYCZY OSÓB I RODZIN POSZKODOWANYCH W WYNIKU SYTUACJI<br/>
					KRYZYSOWEJ WYSTĘPUJĄCEJ NA SKALĘ MASOWĄ, A TAKŻE KLĘSKI<br/>
					ŻYWIOŁOWEJ BĄDŹ ZDARZENIA LOSOWEGO<br/>
				</h2>
				<br/>
				<section>
					<h3>A. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="width: 20mm;">Imię</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie2" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Nazwisko</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko2" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">3</td>
							<td style="width: 76mm;">Seria i nr dokumentu potwierdzającego tożsamość</td>
							<td>
								<ins>
									<xsl:variable name="_RodzajDokumentu" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">4</td>
							<td>Nr PESEL</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:PESEL" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>5</td>
							<td style="width: 26mm;">
								Adres
								<br/>
								<ins>
									<xsl:variable name="_Rodzaj" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Rodzaj" />
									<xsl:value-of select="$RodzajAdresu[@key = $_Rodzaj]" />
								</ins>
							</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon" /></ins></td>
										<td>telefon najbliższej rodziny: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:TelefonRodziny" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>symbol terytorialny: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>6</td>
							<td>Adres do korespondencji</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:AdresDoKorespondencji/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:AdresDoKorespondencji/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:AdresDoKorespondencji/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:AdresDoKorespondencji/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:AdresDoKorespondencji/ns1:NrLok" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<br/>
					<br/>
					<table>
						<tr>
							<td style="width: 6mm;" rowspan="2">7</td>
							<td>
								Dotychczas otrzymywane świadczenia:<br/>
								<xsl:variable name="_CzyDotychczasoweSwiadczenia" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:CzyDotychczasoweSwiadczenia"/>
								<span class="textarea">
									<ins><xsl:value-of select="$TakNie[@key = $_CzyDotychczasoweSwiadczenia]" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>
								Jeżeli tak, wpisać jakie:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DotychczasoweSwiadczenia" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;" rowspan="3">8</td>
							<td>
								Aktualna wysokość dochodu na osobę
								<br/>w rodzinie / liczba osób w rodzinie
							</td>
							<td style="text-align: right;">
								<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DochodNaOsobe, '0,00')" /></ins>
								/
								<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:LiczbaOsob" /></ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;" rowspan="6">9</td>
							<td>Aktualna sytuacja:</td>
						</tr>
						<tr>
							<td>
								rodzinna<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Sytuacja/ns1:Rodzinna" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>
								mieszkaniowa<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Sytuacja/ns1:Mieszkaniowa" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>
								zawodowa<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Sytuacja/ns1:Zawodowa" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>
								zdrowotna<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Sytuacja/ns1:Zdrowotna" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>
								majątkowa<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Sytuacja/ns1:Majatkowa" /></ins>
								</span>
							</td>
						</tr>
					</table>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>B. STRATY PONIESIONE W WYNIKU SYTUACJI KRYZYSOWEJ WYSTĘPUJĄCEJ NA SKALĘ MASOWĄ, A TAKŻE KLĘSKI ŻYWIOŁOWEJ BĄDŹ ZDARZENIA LOSOWEGO</h3>
					<div class="textarea" style="min-height: 170mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Straty" /></ins>
					</div>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>C. POTRZEBY I OCZEKIWANIA OSOBY LUB RODZINY ZGŁOSZONE PODCZAS PRZEPROWADZANIA WYWIADU</h3>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Potrzeby" /></ins>
					</div>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego przeprowadzającego wywiad:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br style="clear: both;"/>
							<br/>
							<br/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br/>
							<br/><br/>
							Oświadczam, że podane wyżej informacje są zgodne z prawdą.
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.5cm;">(data i podpis osoby, z którą przeprowadzono wywiad)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					Informacja o warunkach bezpieczeństwa podczas przeprowadzania wywiadu:
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyDrugiPracownik/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) uczestnictwo drugiego pracownika socjalnego
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyAsystaPolicji/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) asysta funkcjonariusza Policji
								</td>
								<td>
									<table>
										<tbody>
											<tr>
												<td width="50%" style="border-right: 0px none;">
													Czy wystąpiły sytuacje
													<br/>zagrożenia podczas
													<br/>przeprowadzania wywiadu?
												</td>
												<td style="border-left: 0px none;">
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'T'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													1) tak - wskazać jakie:
													<br/>
													<span class="textarea" style="display: block; padding-left: 8mm;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:JakieSytuacjeZagrozenia"/></ins></span>
													<br/>
													<br/>
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'N'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													2) nie
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<br/><br/>
					<span>
						Miejscowość
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu" /></ins>
						&#160;&#160;&#160;&#160;&#160;&#160;
						Data
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu" /></ins>
					</span>
					<br/><br/>
				</section>
				<br/>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan">
				<section style="page-break-before: always;">
					<h3>D. PLAN POMOCY I DZIAŁAŃ NA RZECZ OSOBY LUB RODZINY</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td>Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="width: 60mm; text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:LacznyDochodWRodzinie">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:LacznyDochodWRodzinie, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Dochód na osobę w rodzinie</td>
							<td style="text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:DochodNaOsobe">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:DochodNaOsobe, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>3</td>
							<td>Kryterium dochodowe dla danej osoby/rodziny (wynikające z art. 8 ust. 1 lub 2 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:KryteriumDochodowe">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:KryteriumDochodowe, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>4</td>
							<td colspan="2">Formy i zakres proponowanej pomocy</td>
						</tr>
					</table>
					<table>
						<thead>
							<tr>
								<th>rodzaj i zakres</th>
								<th style="width: 60mm;">źródło finansowania</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>świadczenia pieniężne</td>
								<td></td>
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:ProponowanaPomoc">
								<tr>
									<td>
										<ins>
											<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
											<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
										</ins>
									</td>
									<td>
										<span class="textarea">
											<ins><xsl:value-of select="ns0:ZrodloFinansowania" /></ins>
										</span>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:Opis != ''">
								<tr>
									<td colspan="2">
										<span class="textarea">
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:Opis" /></ins>
										</span>
									</td>
								</tr>
							</xsl:if>
						</tbody>
						<tbody>
							<tr>
								<td>świadczenia niepieniężne</td>
								<td></td>
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:ProponowanaPomoc">
								<tr>
									<td>
										<ins>
											<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
											<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
										</ins>
									</td>
									<td>
										<span class="textarea">
											<ins><xsl:value-of select="ns0:ZrodloFinansowania" /></ins>
										</span>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:Opis != ''">
								<tr>
									<td colspan="2">
										<span class="textarea">
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:Opis" /></ins>
										</span>
									</td>
								</tr>
							</xsl:if>
						</tbody>
						<tbody>
							<tr>
								<td>świadczenia niepieniężne w formie usług opiekuńczych</td>
								<td></td>
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:ProponowanaPomoc">
								<tr>
									<td>
										<ins>
											<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
											<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
										</ins>
									</td>
									<td>
										<span class="textarea">
											<ins><xsl:value-of select="ns0:ZrodloFinansowania" /></ins>
										</span>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:Opis != ''">
								<tr>
									<td colspan="2">
										<span class="textarea">
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:Opis" /></ins>
										</span>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
					<table>
						<tr>
							<td>inne formy wsparcia</td>
						</tr>
						<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:ProponowanaPomoc">
							<tr>
								<td>
									<ins>
										<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
										<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
									</ins>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:Opis != ''">
							<tr>
								<td colspan="2">
									<span class="textarea">
										<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:Opis" /></ins>
									</span>
								</td>
							</tr>
						</xsl:if>
					</table>
					<br/>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Miejscowość:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Miejscowosc" /></ins></span>
							<br/>
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Miejscowosc" />
									<xsl:text>, </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: left; border-top: 1px solid black; margin-top: 0.2cm;">(miejscowość i data)</span>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika">
				<section style="page-break-before: always;">
					<h3>Uwagi kierownika jednostki organizacyjnej pomocy społecznej</h3>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_W_CALOSCI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					1) zatwierdzam plan w całości
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_Z_ZASTRZEZENIAMI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					2) zatwierdzam plan z następującymi zastrzeżeniami:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:ZastrzezeniaDoPlanuPomocy" /></ins>
					</div>
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ODRZUCENIE'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					3) odrzuca plan ze względu na:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:PowodOdrzuceniaPlanuPomocy" /></ins>
					</div>
					<br/>

					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko kierownika:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								Data
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć kierownika)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
				<br/>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						<span style="text-transform: uppercase;">
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
