<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ns0="http://www.gov.pl/du/r2021/poz893/wywiad/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2021/poz893/wywiad/cz1i2"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

	<xsl:variable name="Plec" select="document('../xml/Plec.xml')/properties/entry" />
	<xsl:variable name="RodzajAdresu" select="document('../xml/RodzajAdresu.xml')/properties/entry" />
	<xsl:variable name="RodzajDochodu" select="document('../xml/RodzajDochodu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />
	<xsl:variable name="StanCywilny" select="document('../xml/StanCywilny.xml')/properties/entry" />
	<xsl:variable name="StopienPokrewienstwa" select="document('../xml/StopienPokrewienstwa.xml')/properties/entry" />

	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:template match="/">
		<xsl:variable name="OsobaGlowna" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']" />
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON jednostki organizacyjnej pomocy społecznej lub
										<br/>podmiotu udzielającego świadczeń zdrowotnych
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				<h2>
					CZĘŚĆ II<br/>
					DOTYCZY MAŁŻONKA, ZSTĘPNYCH LUB WSTĘPNYCH, O KTÓRYCH MOWA<br/>
					W ART. 103 USTAWY Z DNIA 12 MARCA 2004 R. O POMOCY SPOŁECZNEJ
				</h2>
				<br/>
				<section>
					<h3>A. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="width: 20mm;">Imię</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie2" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Nazwisko</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko2" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">3</td>
							<td style="width: 76mm;">Seria i nr dokumentu potwierdzającego tożsamość</td>
							<td>
								<ins>
									<xsl:variable name="_RodzajDokumentu" select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">4</td>
							<td>Nr PESEL</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:PESEL" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>5</td>
							<td style="width: 26mm;">
								Adres
								<br/>
								<ins>
									<xsl:variable name="_Rodzaj" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Rodzaj" />
									<xsl:value-of select="$RodzajAdresu[@key = $_Rodzaj]" />
								</ins>
							</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>symbol terytorialny: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>6</td>
							<td>Adres do korespondencji</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrLok" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm; height: 20mm;">7</td>
							<td>Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right; width: 52mm;"><ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochod, '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 13mm;">8</td>
							<td>Dochód na osobę w rodzinie</td>
							<td style="text-align: right; width: 52mm;"><ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DochodNaOsobe, '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 16mm;">9</td>
							<td>Kryterium dochodowe dla danej osoby/rodziny (wynikające z art. 8 ust. 1 lub 2 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right; width: 52mm;"><ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:KryteriumDochodowe, '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 16mm;">10</td>
							<td>Obciążenia finansowe rodziny (stałe np. czynsz, opłaty za dom pomocy społecznej, internat, bursę; okresowe – np. spłata zadłużenia; jednorazowe – np. remont mieszkania)</td>
							<td style="text-align: right; width: 52mm;"><ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Razem, '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm; height: 28mm;">11</td>
							<td>
								Dane osoby lub rodziny ubiegającej się o przyznanie świadczenia (imię, nazwisko, adres zamieszkania)
								<br/>
								<xsl:variable name="OsobaUbiegajacaSie" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OsobaUbiegajacaSie" />
								<ins>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Imie1"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Imie2"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Nazwisko1"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Nazwisko2"/>
									<br/>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Ulica"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:NrDomu"/>
									<xsl:if test="$OsobaUbiegajacaSie/ns1:NrLok != ''">
										<xsl:text> </xsl:text>
										m. <xsl:value-of select="$OsobaUbiegajacaSie/ns1:NrLok"/>
									</xsl:if>
									<br/>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:KodPocztowy"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Miejscowosc"/>
									<br/>
									<xsl:value-of select="$OsobaUbiegajacaSie/ns1:Uwagi"/>
								</ins>
							</td>
						</tr>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>B. INFORMACJE O CZŁONKACH RODZINY I INNYCH OSOBACH WSPÓLNIE ZAMIESZKUJĄCYCH</h3>
					<table>
						<thead>
							<tr>
								<th>1</th>
								<th>2</th>
								<th colspan="3">3</th>
								<th>4</th>
								<th>5</th>
								<th>6</th>
								<th>7</th>
								<th>8</th>
								<th>9</th>
								<th>10</th>
							</tr>
							<tr>
								<th style="width: 6mm;" rowspan="2">Lp.</th>
								<th style="width: 30mm;" rowspan="2">Imię i nazwisko</th>
								<th colspan="3">Data urodzenia</th>
								<th rowspan="2">Płeć</th>
								<th rowspan="2">Stan cywilny</th>
								<th rowspan="2">Stopień pokrewieństwa</th>
								<th rowspan="2">Nr PESEL</th>
								<th rowspan="2">Miejsce pracy lub nauki (placówka i oddział)</th>
								<th colspan="2">Źródło dochodu (utrzymania)</th>
							</tr>
							<tr>
								<th style="width: 10mm;">dzień</th>
								<th style="width: 10mm;">mies.</th>
								<th style="width: 10mm;">rok</th>
								<th>rodzaj</th>
								<th>wysokość</th>
							</tr>
						</thead>
						<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">
							<tbody class="gospodarstwo">
								<xsl:for-each select="ns1:Osoba">
									<tr>
										<td>
											<xsl:value-of select="count(parent::ns1:Gospodarstwo/preceding-sibling::ns1:Gospodarstwo/ns1:Osoba) + position()" />
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
												<br/>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 9, 2)" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 6, 2)" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 1, 4)" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_Plec" select="ns1:DanePodstawowe/ns1:Plec" />
												<xsl:value-of select="$Plec[@key = $_Plec]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_StanCywilny" select="ns1:DanePodstawowe/ns1:StanCywilny" />
												<xsl:value-of select="$StanCywilny[@key = $_StanCywilny]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_StopienPokrewienstwa" select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa" />
												<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:PESEL"/>
											</ins>
										</td>
										<td>
											<span class="textarea">
												<ins>
													<xsl:value-of select="ns1:DanePodstawowe/ns1:MiejscePracy"/>
												</ins>
											</span>
										</td>
										<td>
											<ins>
												<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
													<xsl:variable name="_Rodzaj" select="ns1:Rodzaj" />
													<xsl:value-of select="$RodzajDochodu[@key = $_Rodzaj]" />
													<br/>
												</xsl:for-each>
											</ins>
										</td>
										<td style="text-align: right;">
											<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
												<ins>
													<xsl:value-of select="format-number(ns1:Wysokosc, '0,00')" />
												</ins>
												<xsl:text> </xsl:text>
												zł
												<br/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</xsl:for-each>
					</table>
					<small>
						* Należy wpisać dane osoby, z którą przeprowadzono wywiad.
						<br/>** W stosunku do osoby, z którą przeprowadzono wywiad.
						<br/>Uwaga: Oddzielne gospodarstwa domowe należy oddzielić poziomą kreską
					</small>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>C. POMOC OSOBY/RODZINY UDZIELANA OSOBIE LUB RODZINIE UBIEGAJĄCEJ SIĘ O PRZYZNANIE ŚWIADCZENIA</h3>
					<table>
						<tr>
							<td style="width: 6mm; height: 20mm;">1</td>
							<td>
								Dotychczas udzielana pomoc osobie/rodzinie ubiegającej się o przyznanie świadczenia
								<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:DotychczasowaPomoc"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 20mm;">2</td>
							<td>
								Stosunek do osoby/rodziny ubiegającej się o przyznanie świadczenia
								<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:StosunekDoOsoby"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 20mm;">3</td>
							<td>
								Ustalona z osobą/rodziną forma i wielkość pomoc
								<br/>
								rodzaj:<br/>
								<span class="textarea" style="display: block; padding-left: 5px;">
									 <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:RodzajPomocy"/></ins>
								</span>
								<br/>
								wielkość:<br/>
								<span class="textarea" style="display: block; padding-left: 5px;">
									 <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:WielkoscPomocy"/></ins>
								</span>
								<br/>
								kwota:<br/>
								<span class="textarea" style="display: block; padding-left: 5px;">
									<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PomocUbiegajacejSie/ns1:KwotaPomocy, '0,00')" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<xsl:if test="not($Suma)">
						<br style="clear: both;"/>
						Oświadczam, że podane wyżej informacje są zgodne z prawdą.
						<br style="clear: both;"/>
						<span style="float: right; border-top: 1px solid black; margin-top: 0.5cm;">(podpis osoby, z którą przeprowadzono wywiad)</span>
						<br style="clear: both;"/>
					</xsl:if>

					<br style="clear: both;"/>
					<span>Miejscowość:</span>
					<span><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu" /></ins></span>
					<span>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>
					<span>Data:</span>
					<span><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu" /></ins></span>
				</section>
				<section style="margin-top: 10mm;">
					<h3>D. OSOBA, Z KTÓRĄ PRZEPROWADZONO WYWIAD, WSKAZAŁA INNE OSOBY, O KTÓRYCH MOWA W ART. 103 USTAWY Z DNIA 12 MARCA 2004 R. O POMOCY SPOŁECZNE</h3>
					<table>
						<thead>
							<tr>
								<th>Imię i nazwisko</th>
								<th>Adres</th>
								<th>Telefon</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:InneOsobyArt103/ns1:Osoba">
								<tr>
									<td>
										<ins>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
										</ins>
									</td>
									<td>
										<ins>
											<xsl:value-of select="ns1:AdresZamieszkania/ns1:Ulica"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:AdresZamieszkania/ns1:NrDomu"/>
											<xsl:if test="ns1:AdresZamieszkania/ns1:NrLok != ''">
												<xsl:text> </xsl:text>
												m. <xsl:value-of select="ns1:AdresZamieszkania/ns1:NrLok"/>
											</xsl:if>
											<br/>
											<xsl:value-of select="ns1:AdresZamieszkania/ns1:KodPocztowy"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:AdresZamieszkania/ns1:Miejscowosc"/>
										</ins>
									</td>
									<td>
										<ins>
											<xsl:value-of select="ns1:Telefon"/>
										</ins>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</section>
				<section style="margin-top: 10mm;">
					<h3>E. WNIOSKI PRACOWNIKA SOCJALNEGO</h3>
					<div class="textarea" style="min-height: 20mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:WnioskiOcena" /></ins>
					</div>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br style="clear: both;"/>
							<br/>
							<br/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					Informacja o warunkach bezpieczeństwa podczas przeprowadzania wywiadu:
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyDrugiPracownik/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) uczestnictwo drugiego pracownika socjalnego
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyAsystaPolicji/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) asysta funkcjonariusza Policji
								</td>
								<td>
									<table>
										<tbody>
											<tr>
												<td width="50%" style="border-right: 0px none;">
													Czy wystąpiły sytuacje
													<br/>zagrożenia podczas
													<br/>przeprowadzania wywiadu?
												</td>
												<td style="border-left: 0px none;">
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'T'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													1) tak - wskazać jakie:
													<br/>
													<span class="textarea" style="display: block; padding-left: 8mm;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:JakieSytuacjeZagrozenia"/></ins></span>
													<br/>
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'N'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													2) nie
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<br/><br/>
					<span>
						Miejscowość
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Miejscowosc" /></ins>
						&#160;&#160;&#160;&#160;&#160;&#160;
						Data
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Data" /></ins>
					</span>
					<br/><br/>
				</section>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						🔒
						<span>
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
