<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:slo="http://top-team.pl/otm/slowo/r1"
	xmlns:ns0="http://www.gov.pl/du/r2021r3/poz893/wywiad/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2021r3/poz893/wywiad/cz3i4"
	xmlns:wis-m="http://top-team.pl/otm/wis/v20221101/metryczka"
	xmlns:wis-p="http://top-team.pl/otm/wis/v20221101/profile"
	xmlns:wis-pk="http://top-team.pl/otm/wis/v20221101/pakiet"
	xmlns:wis-r="http://top-team.pl/otm/wis/v20221101/rozszerzenia"
	xmlns:wis-k="http://top-team.pl/otm/wis/v20221101/kwestionariusz"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

	<xsl:variable name="InnaFormaWsparcia" select="document('../xml/InnaFormaWsparcia.xml')/properties/entry" />
	<xsl:variable name="RodzajAdresu" select="document('../xml/RodzajAdresu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />
	<xsl:variable name="RodzajUrzadzenia" select="document('../xml/RodzajUrzadzenia.xml')/properties/entry" />
	<xsl:variable name="TypPosilku" select="document('../xml/TypPosilku.xml')/properties/entry" />
	<xsl:variable name="ZrodloFinansowania" select="document('../xml/ZrodloFinansowania.xml')/properties/entry" />
	
	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:variable name="ns0-e" select="document('wspolne/wspolne.xsd')" />

	<xsl:template match="/">
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON jednostki organizacyjnej pomocy społecznej lub
										<br/>podmiotu udzielającego świadczeń zdrowotnych
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				<h2>
					CZĘŚĆ IV<br/>
					DOTYCZY OSÓB LUB RODZIN KORZYSTAJĄCYCH ZE ŚWIADCZEŃ<br/>
					POMOCY SPOŁECZNEJ<br/>
					(AKTUALIZACJA WYWIADU)
				</h2>
				<br/>
				<section>
					<h3>A. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="width: 20mm;">Imię</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Imie2" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Nazwisko</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:Nazwisko2" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">3</td>
							<td style="width: 76mm;">Seria i nr dokumentu potwierdzającego tożsamość</td>
							<td>
								<ins>
									<xsl:variable name="_RodzajDokumentu" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">4</td>
							<td>Nr PESEL</td>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DanePodstawowe/ns1:PESEL" />
								</ins>
							</td>
						</tr>
						<tr>
							<td rowspan="2">5</td>
							<td style="width: 26mm;">
								Adres
								<br/>
								<ins>
									<xsl:variable name="_Rodzaj" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Rodzaj" />
									<xsl:value-of select="$RodzajAdresu[@key = $_Rodzaj]" />
								</ins>
							</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>symbol terytorialny: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>Miejsce pobytu<br/>osoby bezdomnej</td>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscePobytuOsobyBezdomnej"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>6</td>
							<td>Adres do korespondencji</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrLok" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">7</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
													Dane <ins>opiekuna prawnego / <del>kuratora</del></ins>
												</xsl:when>
												<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
													Dane <ins><del>opiekuna prawnego</del> / kuratora</ins>
												</xsl:when>
												<xsl:otherwise>
													Dane <ins><del>opiekuna prawnego</del> / <del>kuratora</del></ins>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td style="width: 20mm;">Imię</td>
										<td>
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:Imie2"/>
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:Imie2"/>
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
									<tr>
										<td>Nazwisko</td>
										<td>
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:Nazwisko2"/>
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:Nazwisko2"/>
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>
											Obywatelstwo
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:Obywatelstwo/slo:Opis" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:Obywatelstwo/slo:Opis" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td style="width: 66mm;">
											Seria i nr dokumentu potwierdzającego tożsamość:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:variable name="_RodzajDokumentu" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:RodzajDokumentu" />
														<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:NumerDokumentu" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:variable name="_RodzajDokumentu" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:RodzajDokumentu" />
														<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:NumerDokumentu" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td>
											Nr PESEL:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:PESEL" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:PESEL" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">8</td>
							<td style="width: 26mm;">Adres zamieszkania</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 40mm;">
											kod pocztowy:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:KodPocztowy" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:KodPocztowy" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td>
											miejscowość:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Miejscowosc" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:Miejscowosc" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>
											ulica:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Ulica" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:Ulica" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td style="width: 32mm;">
											nr domu:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrDomu" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:NrDomu" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td style="width: 32mm;">
											nr mieszkania:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrLok" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:NrLok" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Telefon" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:Telefon" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>
											symbol terytorialny:
											<ins>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" />
													</xsl:when>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator">
														<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Kurator/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm; height: 20mm;">9</td>
							<td>
								Dotychczas otrzymywane świadczenia – na podstawie ostatniej decyzji
								<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DotychczasoweSwiadczenia" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm; height: 12mm;">10</td>
							<td>Aktualna łączna wysokość dochodu (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right;">
								<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochod, '0,00')"/></ins><xsl:text> </xsl:text>zł
							</td>
						</tr>
						<tr>
							<td style="width: 6mm; height: 12mm;">11</td>
							<td>Aktualna wysokość dochodu na osobę w rodzinie</td>
							<td style="text-align: right;">
								<ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DochodNaOsobe, '0,00')"/></ins><xsl:text> </xsl:text>zł
							</td>
						</tr>
					</table>
					<small>
						* W przypadku bezdomnego - ostatnie miejsce zameldowania na pobyt stały (w przypadku braku możliwości ustawienia - ostatni możliwy do potwierdzenia adres)
						<br/>** Niepotrzebne skreślić
					</small>
				</section>
				<br/>
				<table style="page-break-before: always;">
					<tr>
						<td rowspan="6" style="width: 6mm;">12</td>
						<td>Aktualizacja sytuacji:</td>
					</tr>
					<tr>
						<td style="height: 16mm;">
							rodzinnej<br/>
							<span class="textarea">
								<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualizacjaSytuacji/ns1:Rodzinna" /></ins>
							</span>
						</td>
					</tr>
					<tr>
						<td style="height: 16mm;">
							mieszkaniowej<br/>
							<span class="textarea">
								<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualizacjaSytuacji/ns1:Mieszkaniowa" /></ins>
							</span>
						</td>
					</tr>
					<tr>
						<td style="height: 16mm;">
							zawodowej<br/>
							<span class="textarea">
								<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualizacjaSytuacji/ns1:Zawodowa" /></ins>
							</span>
						</td>
					</tr>
					<tr>
						<td style="height: 16mm;">
							zdrowotnej<br/>
							<span class="textarea">
								<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualizacjaSytuacji/ns1:Zdrowotna" /></ins>
							</span>
						</td>
					</tr>
					<tr>
						<td style="height: 16mm;">
							innej<br/>
							<span class="textarea">
								<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualizacjaSytuacji/ns1:Inne" /></ins>
							</span>
						</td>
					</tr>
				</table>
				<br/>
				<section>
					<h3>B. POTRZEBY I OCZEKIWANIA OSOBY LUB RODZINY ZGŁOSZONE PODCZAS PRZEPROWADZANIA WYWIADU</h3>
					<div class="textarea" style="min-height: 20mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Potrzeby" /></ins>
					</div>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego przeprowadzającego wywiad:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br style="clear: both;"/>
							<br/>
							<br/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br/>
							<br/><br/>
							Oświadczam, że podane wyżej informacje są zgodne z prawdą.
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.5cm;">(data i podpis osoby, z którą przeprowadzono wywiad)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					Informacja o warunkach bezpieczeństwa podczas przeprowadzania wywiadu:
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyDrugiPracownik/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) uczestnictwo drugiego pracownika socjalnego
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyAsystaPolicji/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) asysta funkcjonariusza Policji
								</td>
								<td>
									<table>
										<tbody>
											<tr>
												<td width="50%" style="border-right: 0px none;">
													Czy wystąpiły sytuacje
													<br/>zagrożenia podczas
													<br/>przeprowadzania wywiadu?
												</td>
												<td style="border-left: 0px none;">
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'T'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													1) tak - wskazać jakie:
													<br/>
													<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:SytuacjaZagrozenia">
														<ins style="display: block; padding-left: 8mm;">
															<xsl:call-template name="ns0-enumeracja">
																<xsl:with-param name="nazwa" select="'Zagrozenie'"/>
																<xsl:with-param name="wartosc" select="current()"/>
															</xsl:call-template>
														</ins>
													</xsl:for-each>
													<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:Uwagi">
														<span class="textarea" style="display: block; padding-left: 8mm;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:Uwagi"/></ins></span>
													</xsl:if>
													<br/>
													<br/>
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'N'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													2) nie
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<br/><br/>
					<span>
						Miejscowość
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscowoscWywiadu" /></ins>
						&#160;&#160;&#160;&#160;&#160;&#160;
						Data
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu" /></ins>
					</span>
					<br/>
					<br/>
				</section>
				<br/>
				<section style="page-break-before: always;">
					<h3>C. DIAGNOZA SYTUACJI OSOBY LUB RODZINY, WNIOSKI PRACOWNIKA SOCJALNEGO</h3>
					<div class="textarea" style="min-height: 180mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:WnioskiOcena" /></ins>
					</div>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
				</section>

			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan">
				<section style="page-break-before: always;">
					<h3>D. PLAN POMOCY I DZIAŁAŃ NA RZECZ OSOBY LUB RODZINY</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td>Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="width: 60mm; text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:LacznyDochodWRodzinie">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:LacznyDochodWRodzinie, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Dochód na osobę w rodzinie</td>
							<td style="text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:DochodNaOsobe">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:DochodNaOsobe, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>3</td>
							<td>Kryterium dochodowe dla danej osoby/rodziny (wynikające z art. 8 ust. 1 lub 2 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:KryteriumDochodowe">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:KryteriumDochodowe, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>4</td>
							<td colspan="2">Formy i zakres proponowanej pomocy</td>
						</tr>
					</table>
					<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy">
						<xsl:variable name="osoba-ze-skladu-klucz" select="ns1:Osoba"/>
						<xsl:variable name="osoba-ze-skladu" select="key('osobyWgId', $osoba-ze-skladu-klucz)"/>
						<table>
							<thead>
								<tr>
									<th colspan="5">
										<ins>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie1" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie2" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko2" />
										</ins>
										<xsl:text> </xsl:text>
										(Świadczenia)
									</th>
								</tr>
								<tr>
									<th>rodzaj i zakres</th>
									<th>okres</th>
									<th>plan</th>
									<th style="width: 60mm;">źródło finansowania</th>
									<th>procent należności</th>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="./ns1:ProponowanaPomoc">
									<tr>
										<td>
											<ins><xsl:value-of select="ns0:Rodzaj/ns0:RodzajSwiadczenia/slo:Opis" /></ins>
											<ins><xsl:value-of select="ns0:Rodzaj/ns0:RodzajSwiadczeniaPozaustawowego/slo:Opis" /></ins>
											<xsl:if test="ns0:Posilek/ns0:TypPosilku">
												<br/>
												<xsl:variable name="_TypPosilku" select="ns0:Posilek/ns0:TypPosilku" />
												<ins><xsl:value-of select="$TypPosilku[@key = $_TypPosilku]" /></ins>
											</xsl:if>
											<xsl:if test="ns0:Teleopieka and ns0:Teleopieka/ns0:RodzajUrzadzenia">
												<br/>
												<ins>
													Teleopieka
													<xsl:for-each select="ns0:Teleopieka/ns0:RodzajUrzadzenia">
														<xsl:variable name="_RodzajUrzadzenia" select="current()" /><xsl:if test="position() = 1"><xsl:text>: </xsl:text></xsl:if><xsl:value-of select="$RodzajUrzadzenia[@key = $_RodzajUrzadzenia]" /><xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
													</xsl:for-each>
												</ins>
											</xsl:if>
											<xsl:if test="ns0:Uwagi">
												<br/><br/><small><span class="textarea"><ins><xsl:value-of select="ns0:Uwagi"/></ins></span></small>
											</xsl:if>
										</td>
										<td>
											<ins>
												od <xsl:choose><xsl:when test="ns0:Okres/ns0:DataOd"><xsl:value-of select="ns0:Okres/ns0:DataOd"/></xsl:when><xsl:otherwise>____-__-__</xsl:otherwise></xsl:choose>
												<br/>do <xsl:choose><xsl:when test="ns0:Okres/ns0:DataDo"><xsl:value-of select="ns0:Okres/ns0:DataDo"/></xsl:when><xsl:otherwise>____-__-__</xsl:otherwise></xsl:choose>
											</ins>
										</td>
										<td>
											<ins>
												<xsl:choose><xsl:when test="ns0:Plan/ns0:Licznik"><xsl:value-of select="ns0:Plan/ns0:Licznik"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose>/<xsl:choose><xsl:when test="ns0:Plan/ns0:Mianownik"><xsl:value-of select="ns0:Plan/ns0:Mianownik"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose>
												<xsl:if test="ns0:Plan/ns0:Szczegoly">
													<br/><xsl:value-of select="ns0:Plan/ns0:Szczegoly"/>
												</xsl:if>
												<br/>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Poniedzialek = 'true'">pn<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Wtorek = 'true'">wt<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Sroda = 'true'">śr<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Czwartek = 'true'">czw<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Piatek = 'true'">pt<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Sobota = 'true'">sb<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Niedziela = 'true'">ndz</xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Poniedzialek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Wtorek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Sroda = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Czwartek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Piatek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Sobota = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Niedziela = 'false'">---</xsl:if>
	
												<xsl:if test="ns0:Plan/ns0:DniSwiateczne = 'true'"><br/>w dni świąteczne</xsl:if>
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_ZrodloFinansowania" select="ns0:ZrodloFinansowania" />
												<xsl:value-of select="$ZrodloFinansowania[@key = $_ZrodloFinansowania]" />
												<xsl:if test="ns0:Kwota">
													<br/><xsl:value-of select="format-number(ns0:Kwota, '0,00')" />
												</xsl:if>
											</ins>
										</td>
										<td style="text-align: right;">
											<ins>
												<xsl:value-of select="ns0:ProcentNaleznosci" />
											</ins>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
						<xsl:if test="./ns1:InnaFormaWsparcia">
							<br/>
							<ins>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie1" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie2" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko2" />
								<xsl:text> </xsl:text>
								(Inne formy wsparcia)
							</ins>
							<table>
								<xsl:for-each select="./ns1:InnaFormaWsparcia">
									<tr>
										<td>
											<ins>
												<xsl:variable name="_InnaFormaWsparcia" select="current()" />
												<xsl:value-of select="$InnaFormaWsparcia[@key = $_InnaFormaWsparcia]" />
											</ins>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:if>
						<xsl:if test="./ns1:Opis">
							<br/>
							<ins>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie1" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie2" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko2" />
							</ins>
							<div class="textarea" style="min-height: 50mm;">
								<ins>
									<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:Opis" />
								</ins>
							</div>
						</xsl:if>
					</xsl:for-each>
					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Miejscowość:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Miejscowosc" /></ins></span>
							<br/>
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Miejscowosc" />
									<xsl:text>, </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: left; border-top: 1px solid black; margin-top: 0.2cm;">(miejscowość i data)</span>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika">
				<section style="page-break-before: always;">
					<h3>Uwagi kierownika jednostki organizacyjnej pomocy społecznej</h3>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_W_CALOSCI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					1) zatwierdzam plan w całości
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_Z_ZASTRZEZENIAMI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					2) zatwierdzam plan z następującymi zastrzeżeniami:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:ZastrzezeniaDoPlanuPomocy" /></ins>
					</div>
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ODRZUCENIE'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					3) odrzuca plan ze względu na:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:PowodOdrzuceniaPlanuPomocy" /></ins>
					</div>
					<br/>

					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko kierownika:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								Data
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć kierownika)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
				<br/>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						🔒
						<span>
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="ns0-enumeracja">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of select="$ns0-e//xsd:simpleType[@name=$nazwa]//xsd:enumeration[@value = $wartosc]//xsd:documentation" />
	</xsl:template>
</xsl:stylesheet>
