<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ns0="http://www.gov.pl/du/r2022/poz583/pomoc/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2022/poz583/pomoc/kwalifikacja"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

	<xsl:variable name="Obywatelstwo" select="document('../xml/Obywatelstwo.xml')/properties/entry" />
	<xsl:variable name="Plec" select="document('../xml/Plec.xml')/properties/entry" />
	<xsl:variable name="RodzajDochodu" select="document('../xml/RodzajDochodu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />
	<xsl:variable name="RodzajZasilku" select="document('../xml/RodzajZasilku.xml')/properties/entry" />
	<xsl:variable name="StanCywilny" select="document('../xml/StanCywilny.xml')/properties/entry" />
	<xsl:variable name="StopienPokrewienstwa" select="document('../xml/StopienPokrewienstwa.xml')/properties/entry" />
	<xsl:variable name="SytuacjaZdrowotna" select="document('../xml/SytuacjaZdrowotna.xml')/properties/entry" />

	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:template match="/">
		<xsl:variable name="OsobaGlowna" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']" />
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<!--
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td style="text-align: center;">
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON powiatowego centrum pomocy rodzinie
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				-->
				<h2>
					FORMULARZ KWALIFIKUJĄCY DO PRZYZNANIA POMOCY<br/>
			    	na podstawie art. 29 ust. 2 ustawy o pomocy obywatelom Ukrainy w związku z konfliktem<br/>
					zbrojnym na terytorium tego państwa
				</h2>
				<br/>
				<section>
					<h3>I. OŚWIADCZENIE OSOBY WNIOSKUJĄCEJ O PRZYZNANIE POMOCY</h3>
					<table class="no-border">
						<tr>
							<td>1. Imię i nazwisko osoby składającej oświadczenie</td>
						</tr>
						<tr>
							<td>
								<ins class="indent">
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:if test="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie2 != ''">
										<xsl:text> </xsl:text>
										<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie2" />
									</xsl:if>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:if test="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko2 != ''">
										<xsl:text> </xsl:text>
										<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko2" />
									</xsl:if>
								</ins>
							</td>
						</tr>
					</table>
					<table class="no-border">
						<tr>
							<td style="width: 50%;">2. Obywatelstwo</td>
							<td>3. Data wjazdu na terytorium RP</td>
						</tr>
						<tr>
							<td>
								<ins class="indent">
									<xsl:variable name="_Obywatelstwo" select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:Obywatelstwo" />
									<xsl:value-of select="$Obywatelstwo[@key = $_Obywatelstwo]" />
								</ins>
							</td>
							<td>
								<ins class="indent">
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:DataWjazduRP" />
								</ins>
							</td>
						</tr>
					</table>
					<table class="no-border">
						<tr>
							<td>4. Dokument stanowiącypodstawę przekroczenia granicy (rodzaj, seria numer)</td>
						</tr>
						<tr>
							<td>
								<ins class="indent">
									<xsl:variable name="_RodzajDokumentu" select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>5. Adres pobytu czasowego, dane kontaktowe (tel., mail)</td>
						</tr>
						<tr>
							<td>
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:AdresPobytu/ns1:Ulica" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:AdresPobytu/ns1:NrDomu" />
									<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:AdresPobytu/ns1:NrLok != ''">
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:AdresPobytu/ns1:NrLok" />
									</xsl:if>
									<br/>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:AdresPobytu/ns1:KodPocztowy" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:AdresPobytu/ns1:Miejscowosc" />
								</ins>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:Telefon != ''">
									<br/>
									<br/>
									telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:Telefon" /></ins>
								</xsl:if>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:E-Mail != ''">
									<xsl:if test="not(ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:Telefon)">
										<br/>
									</xsl:if>
									<br/>
									e-mail: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:DaneKontaktowe/ns1:E-Mail" /></ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>6. Skład rodziny wymagającej wsparcia:</td>
						</tr>
					</table>
					<br/>
					<table>
						<thead>
							<tr>
								<th rowspan="2">Lp.</th>
								<th rowspan="2">Imię i nazwisko</th>
								<th colspan="3">Data urodzenia</th>
								<th rowspan="2">Płeć</th>
								<th rowspan="2">Stan cywilny</th>
								<th rowspan="2">Stopień pokrewieństwa</th>
								<th rowspan="2">Sytuacja zdrowotna</th>
								<th colspan="2">Źródło dochodu (utrzymania)</th>
							</tr>
							<tr>
								<th style="width: 10mm;">dzień</th>
								<th style="width: 10mm;">mies.</th>
								<th style="width: 10mm;">rok</th>
								<th>rodzaj</th>
								<th>wysokość</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:Osoba">
								<tr>
									<td>
										<xsl:value-of select="position()" />
									</td>
									<td>
										<ins>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
											<br/>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
										</ins>
									</td>
									<td style="text-align: center;">
										<ins>
											<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 9, 2)" />
										</ins>
									</td>
									<td style="text-align: center;">
										<ins>
											<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 6, 2)" />
										</ins>
									</td>
									<td style="text-align: center;">
										<ins>
											<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 1, 4)" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_Plec" select="ns1:DanePodstawowe/ns1:Plec" />
											<xsl:value-of select="$Plec[@key = $_Plec]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_StanCywilny" select="ns1:DanePodstawowe/ns1:StanCywilny" />
											<xsl:value-of select="$StanCywilny[@key = $_StanCywilny]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_StopienPokrewienstwa" select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa" />
											<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:variable name="_SytuacjaZdrowotna" select="ns1:DanePodstawowe/ns1:SytuacjaZdrowotna" />
											<xsl:value-of select="$SytuacjaZdrowotna[@key = $_SytuacjaZdrowotna]" />
										</ins>
									</td>
									<td>
										<ins>
											<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
												<xsl:variable name="_Rodzaj" select="ns1:Rodzaj" />
												<xsl:value-of select="$RodzajDochodu[@key = $_Rodzaj]" />
												<br/>
											</xsl:for-each>
										</ins>
									</td>
									<td style="text-align: right;">
										<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
											<ins>
												<xsl:value-of select="format-number(ns1:Wysokosc, '0,00')" />
											</ins>
											<xsl:text> </xsl:text>
											zł
											<br/>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
					<br/>
					<table class="no-border">
						<tr>
							<td>7. Sytuacja osobista:</td>
						</tr>
					</table>
					<br/>
					<table>
						<tr>
							<td style="width: 60mm; padding-left: 4mm;">
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '010'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) ubóstwo
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '020'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) sieroctwo
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '030'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) bezdomność
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '050'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								4) bezrobocie
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '060'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								5) niepełnosprawność
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '070X'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								6) długotrwała lub ciężka choroba
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '150'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								7) przemoc w rodzinie
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '042'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								9a) potrzeba ochrony macierzyństwa
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '043x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								9b) potrzeba ochrony wielodzietności
							</td>
							<td style="width: 60mm; padding-left: 4mm;">
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '080'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								10) bezradność w sprawach opiekuńczo-wychowawczych i w prowadzeniu gospodarstwa domowego
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '081x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								&#160;&#160;a) rodzina niepełna
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '082x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								&#160;&#160;b) rodzina wielodzietna
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '170x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								11) trudności w integracji osób, które otrzymały status uchodźcy lub ochronę uzupełniającą
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '090'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								13a) alkoholizm
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '100'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								13b) narkomania
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '132'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								14) sytuacja kryzysowa
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:Przyczyny/ns1:Przyczyna = '131'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								16) inna - wskazać jaka:<br/>
								<div style="padding-left: 5mm;">
									<span class="textarea" style="min-height: 15mm;">
										<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaOsobista/ns1:PrzyczynyInne" /></ins>
									</span>
								</div>
							</td>
						</tr>
					</table>
					<table class="no-border">
						<tr>
							<td>8. Sytuacja majątkowa:</td>
						</tr>
						<tr>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Oswiadczenie/ns1:SytuacjaMajatkowa" /></ins>
								</span>
							</td>
						</tr>
					</table>
				</section>
				<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy">
					<section style="page-break-before: always;">
						<h3>II.ZAKRES POMOCY NA RZECZ OSOBY/RODZINY1(rodzaj, okres świadczenia, wysokość)</h3>
						<table>
							<thead>
								<tr>
									<th>rodzaj i zakres</th>
									<th style="width: 60mm;">źródło finansowania</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>świadczenia pieniężne</td>
									<td></td>
								</tr>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:ProponowanaPomoc">
									<tr>
										<td>
											<ins>
												<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
												<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
											</ins>
										</td>
										<td>
											<span class="textarea">
												<ins><xsl:value-of select="ns0:ZrodloFinansowania" /></ins>
											</span>
										</td>
									</tr>
								</xsl:for-each>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:Opis != ''">
									<tr>
										<td colspan="2">
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaPieniezne/ns1:Opis" /></ins>
											</span>
										</td>
									</tr>
								</xsl:if>
							</tbody>
							<tbody>
								<tr>
									<td>świadczenia niepieniężne</td>
									<td></td>
								</tr>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:ProponowanaPomoc">
									<tr>
										<td>
											<ins>
												<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
												<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
											</ins>
										</td>
										<td>
											<span class="textarea">
												<ins><xsl:value-of select="ns0:ZrodloFinansowania" /></ins>
											</span>
										</td>
									</tr>
								</xsl:for-each>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:Opis != ''">
									<tr>
										<td colspan="2">
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezne/ns1:Opis" /></ins>
											</span>
										</td>
									</tr>
								</xsl:if>
							</tbody>
							<tbody>
								<tr>
									<td>świadczenia niepieniężne w formie usług opiekuńczych</td>
									<td></td>
								</tr>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:ProponowanaPomoc">
									<tr>
										<td>
											<ins>
												<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
												<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
											</ins>
										</td>
										<td>
											<span class="textarea">
												<ins><xsl:value-of select="ns0:ZrodloFinansowania" /></ins>
											</span>
										</td>
									</tr>
								</xsl:for-each>
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:Opis != ''">
									<tr>
										<td colspan="2">
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:SwiadczeniaNiepieniezneUslugiOpiekuncze/ns1:Opis" /></ins>
											</span>
										</td>
									</tr>
								</xsl:if>
							</tbody>
						</table>
						<table>
							<tr>
								<td>inne formy wsparcia</td>
							</tr>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:ProponowanaPomoc">
								<tr>
									<td>
										<ins>
											<xsl:variable name="_RodzajIZakres" select="ns0:RodzajIZakres" />
											<xsl:value-of select="$RodzajZasilku[@key = $_RodzajIZakres]" />
										</ins>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:Opis and ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:Opis != ''">
								<tr>
									<td colspan="2">
										<span class="textarea">
											<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:ZakresPomocy/ns1:FormyIZakresPomocy/ns1:PracaSocjalna/ns1:Opis" /></ins>
										</span>
									</td>
								</tr>
							</xsl:if>
						</table>
						<br/>
						<xsl:choose>
							<xsl:when test="$Suma">
								<br style="clear: both;"/>
								<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
								<span style="float: right;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Metryczka/ns1:PracownikSocjalny/ns0:Imie" />
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Metryczka/ns1:PracownikSocjalny/ns0:Nazwisko" />
									</ins>
								</span>
								<br style="clear: both;"/>
							</xsl:when>
							<xsl:otherwise>
								<br/>
								<span style="float: left;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Metryczka/ns1:Miejscowosc" />
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Metryczka/ns1:Data" />
									</ins>
								</span>
								<span style="float: right;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Metryczka/ns1:PracownikSocjalny/ns0:Imie" />
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Metryczka/ns1:PracownikSocjalny/ns0:Nazwisko" />
									</ins>
								</span>
								<br style="clear: both;"/>
								<span style="float: left; border-top: 1px solid black; margin-top: 0.2cm;">(miejscowość i data)</span>
								<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
								<br style="clear: both;"/>
							</xsl:otherwise>
						</xsl:choose>
					</section>
				</xsl:if>
				<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika">
					<br/>
					<section>
						<h3>Opinia kierownika jednostki organizacyjnej pomocy społecznej:</h3>
						<div class="textarea" style="min-height: 40mm;">
							<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Tresc" /></ins>
						</div>
						<xsl:choose>
							<xsl:when test="$Suma">
								<span style="float: left;">Data:</span>
								<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Data" /></ins></span>
								<br/>
								<span style="float: left;">Imię i nazwisko kierownika:</span>
								<span style="float: right;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Kierownik/ns0:Imie" />
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Kierownik/ns0:Nazwisko" />
									</ins>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<br/>
								<br style="clear: both;"/>
								<span style="float: left;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Miejscowosc" />
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Data" />
									</ins>
								</span>
								<span style="float: right;">
									<ins>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Kierownik/ns0:Imie" />
										<xsl:text> </xsl:text>
										<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:OpiniaKierownika/ns1:Kierownik/ns0:Nazwisko" />
									</ins>
								</span>
								<br style="clear: both;"/>
								<span style="float: left; border-top: 1px solid black; margin-top: 0.2cm;">(miejscowość i data)</span>
								<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć kierownika)</span>
								<br style="clear: both;"/>
							</xsl:otherwise>
						</xsl:choose>
					</section>
				</xsl:if>
				<br/>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						🔒
						<span>
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
