<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:wis-e="http://top-team.pl/otm/wis/v20221101/enumeracje"
		xmlns:wis-m="http://top-team.pl/otm/wis/v20221101/metryczka"
		xmlns:wis-r="http://top-team.pl/otm/wis/v20221101/rozszerzenia">

	<xsl:output method="html" encoding="utf-8"/>

	<xsl:variable name="wis-e" select="document('../enumeracje/enumeracje.xsd')" />

	<xsl:template match="/">
		<html>
			<head>
				<meta charset="utf-8"/>
				<style>
					<xsl:value-of select="document('../../../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../../../css/styles.html')/html/head/style"/>
				</style>
				<style type="text/css">
					.center {
						text-align: center;
					}
					.bold {
						font-weight: bold;
					}
				</style>
				<style type="text/css" media="print">
					.print-break {
						page-break-after: always;
					}
				</style>
			</head>
			<body>
				<xsl:choose>
					<xsl:when test="not(//wis-r:DodatkoweInformacje)">
						<div class="text-warning">NIE ZNALEZIONO DODATKOWYCH INFORMACJI</div>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="//wis-r:DodatkoweInformacje"/>
					</xsl:otherwise>
				</xsl:choose>
				
			</body>
		</html>
	</xsl:template>

	<xsl:template match="wis-r:DodatkoweInformacje">
		<xsl:if test="position() > 1">
			<br/>
			<div class="print-break"></div>
		</xsl:if>
		<xsl:if test="../wis-m:Metryczka">
			<xsl:apply-templates select="../wis-m:Metryczka"/>
			<br/>
		</xsl:if>
		<xsl:apply-templates select="wis-r:Zgody"/>
		<xsl:apply-templates select="wis-r:Bliscy"/>
		<xsl:if test="wis-r:Bliscy and wis-r:Zwierzeta"><br/></xsl:if>
		<xsl:apply-templates select="wis-r:Zwierzeta"/>
		<xsl:if test="wis-r:Zwierzeta and wis-r:Posilki"><br/></xsl:if>
		<xsl:apply-templates select="wis-r:Posilki"/>
	</xsl:template>
	
	<xsl:template match="wis-m:Metryczka">
		<section>
			Dodatkowe informacje dla
			<xsl:text> </xsl:text>
			<ins>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Nazwisko1"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Nazwisko2"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Imie1"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Imie2"/>
			</ins>
			z dnia
			<ins><xsl:value-of select="wis-m:Data"/></ins>
		</section>
	</xsl:template>
	
	<xsl:template match="wis-r:Bliscy">
		Osoby bliskie
		<table>
			<thead>
				<tr>
					<th>Lp.</th>
					<th>Imię</th>
					<th>Nazwisko/Nazwa podmiotu</th>
					<th>Numery telefonów</th>
					<th>Relacja z odbiorcą</th>
					<th>Posiada klucz do mieszkania odbiorcy</th>
					<th>Dekladowana pomoc</th>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="wis-r:Osoba">
					<xsl:variable name="Lp" select="position()" />
					<tr>
						<td><ins><xsl:value-of select="$Lp"/></ins></td>
						<td>
							<ins>
								<xsl:value-of select="wis-r:DanePodstawowe/wis-r:Imie1"/>
								<xsl:text> </xsl:text>
								<xsl:value-of select="wis-r:DanePodstawowe/wis-r:Imie2"/>
							</ins>
						</td>
						<td>
							<ins>
								<xsl:value-of select="wis-r:DanePodstawowe/wis-r:Nazwisko1"/>
								<xsl:text> </xsl:text>
								<xsl:value-of select="wis-r:DanePodstawowe/wis-r:Nazwisko2"/>
							</ins>
						</td>
						<td>
							<ins><xsl:value-of select="wis-r:Telefon"/></ins>
						</td>
						<td>
							<ins>
								<xsl:if test="wis-r:Relacja/wis-r:StopienPokrewienstwa">
									<xsl:call-template name="wis-e-enumeracja">
										<xsl:with-param name="nazwa" select="'StopienPokrewienstwa'"/>
										<xsl:with-param name="wartosc" select="wis-r:Relacja/wis-r:StopienPokrewienstwa"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="wis-r:Relacja/wis-r:RelacjaZOdbiorcaUslug">
									<xsl:if test="wis-r:Relacja/wis-r:StopienPokrewienstwa"><br/></xsl:if>
									<xsl:call-template name="wis-e-enumeracja">
										<xsl:with-param name="nazwa" select="'RelacjaZOdbiorcaUslug'"/>
										<xsl:with-param name="wartosc" select="wis-r:Relacja/wis-r:RelacjaZOdbiorcaUslug"/>
									</xsl:call-template>
								</xsl:if>
							</ins>
						</td>
						<td>
							<ins>
								<xsl:call-template name="wis-e-enumeracja">
									<xsl:with-param name="nazwa" select="'TakNie'"/>
									<xsl:with-param name="wartosc" select="wis-r:KluczDoMieszkania"/>
								</xsl:call-template>
							</ins>
						</td>
						<td>
							<span class="textarea" style="display: block;">
								<ins><xsl:value-of select="wis-r:DeklarowanaPomoc"/></ins>
							</span>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template match="wis-r:Zwierzeta">
		Informacje o posiadaniu zwierzęcia przez odbiorcę usług:
		<xsl:if test="wis-r:PosiadaneZwierze">
			<span class="textarea" style="display: block; margin-left: 3mm;">
				<ins>
				<xsl:for-each select="wis-r:PosiadaneZwierze">
					<xsl:call-template name="wis-e-enumeracja">
						<xsl:with-param name="nazwa" select="'PosiadaneZwierze'"/>
						<xsl:with-param name="wartosc" select="current()"/>
					</xsl:call-template>
					<xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
				</xsl:for-each>
				</ins>
			</span>
			<xsl:if test="wis-r:PosiadaneZwierzeInne">
				<span class="textarea" style="display: block; margin-left: 3mm;">
					<ins><xsl:value-of select="wis-r:PosiadaneZwierzeInne"/></ins>
				</span>
			</xsl:if>
		</xsl:if>
		<xsl:if test="wis-r:Uwagi">
			<xsl:if test="wis-r:PosiadaneZwierze"><br/></xsl:if>
			<span class="textarea" style="display: block; margin-left: 3mm;">
				Uwagi:<br/>
				<ins><xsl:value-of select="wis-r:Uwagi"/></ins>
			</span>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="wis-r:Posilki">
		Posiłek, adres odbioru:
		<span class="textarea" style="display: block; margin-left: 3mm;">
			<ins>
				<xsl:value-of select="wis-r:Adres/wis-r:KodPocztowy"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-r:Adres/wis-r:Miejscowosc"/>
				<xsl:if test="wis-r:Adres/wis-r:KodPocztowy or wis-r:Adres/wis-r:Miejscowosc">
					<xsl:text>, </xsl:text>
				</xsl:if>
				<xsl:value-of select="wis-r:Adres/wis-r:Ulica"/>
				<xsl:if test="wis-r:Adres/wis-r:Budynek != ''">
					<xsl:text> </xsl:text>
					bud. <xsl:value-of select="wis-r:Adres/wis-r:Budynek"/>
				</xsl:if>
				<xsl:if test="wis-r:Adres/wis-r:Lokal != ''">
					<xsl:text> </xsl:text>
					m. <xsl:value-of select="wis-r:Adres/wis-r:Lokal"/>
				</xsl:if>
			</ins>
		</span>
	</xsl:template>
	
	<xsl:template match="wis-r:Zgody">
		<xsl:if test="wis-r:NaklejkaNFC = 'T'">
			<ins>Zgoda na naklejkę NFC</ins>
			<br/><br/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="wis-e-enumeracja">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of select="$wis-e//xsd:simpleType[@name=$nazwa]//xsd:enumeration[@value = $wartosc]//xsd:documentation" />
	</xsl:template>
</xsl:stylesheet>
