package pl.gov.du.r2021.poz893.wywiad.cz5;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_SINGLETON;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import pl.topteam.otm.utils.Processor;

/**
 * DOKŁADNA KOPIA z projektu otm
 * @author michal
 */

@Service
@Scope(SCOPE_SINGLETON)
public class Expander {
	@Autowired
	private pl.gov.du.r2021.poz893.wywiad.wspolne.Expander expander;

	public Dokument expand(Dokument dokument) {
		Processor.expand(dokument);
		expander.expand(dokument.getDaneDokumentu());
		expander.expand(dokument.getTrescDokumentu().getWywiad().getPracownikSocjalny());
		expander.expand(dokument.getTrescDokumentu().getWnioskiPracownikaSocjalnego().getPracownikSocjalny());
		expander.expand(dokument.getTrescDokumentu().getInformacjaODecyzji().getKierownik());
		return dokument;
	}
}
