package pl.gov.du.r2021.poz893.wywiad.cz6;

import static java.util.stream.Collectors.toList;
import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_SINGLETON;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

import pl.gov.du.r2021.poz893.wywiad.cz6.Dokument.TrescDokumentu.Wywiad.Osoba;
import pl.gov.du.r2021.poz893.wywiad.cz6.Dokument.TrescDokumentu.Wywiad.Osoba.DanePodstawowe;
import pl.gov.du.r2021.poz893.wywiad.wspolne.TakNie;
import pl.topteam.otm.utils.Processor;

/**
 * DOKŁADNA KOPIA z projektu otm
 * @author michal
 */

@Service
@Scope(SCOPE_SINGLETON)
public class Expander {
	@Autowired
	private pl.gov.du.r2021.poz893.wywiad.wspolne.Expander expander;

	public Dokument expand(Dokument dokument) {
		Processor.expand(dokument);
		expander.expand(dokument.getDaneDokumentu());
		expander.expand(dokument.getTrescDokumentu().getWywiad().getPracownikSocjalny());
		expander.expand(dokument.getTrescDokumentu().getDiagnozaSytuacjiOsoby().getPracownikSocjalny());
		expander.expand(dokument.getTrescDokumentu().getPlanPomocyIDzialan().getPracownikSocjalny());
		expander.expand(dokument.getTrescDokumentu().getUwagiKierownika().getKierownik());
		expand(dokument.getTrescDokumentu().getWywiad().getOsoba());
		return dokument;
	}

	private List<Osoba> expand(List<Osoba> osoby) {
		// przynajmniej jedna osoba
		if (osoby.isEmpty()) {
			Osoba osoba = new Osoba();
			osoby.add(osoba);
		}
		for (Osoba osoba : osoby) {
			expand(osoba);
		}
		List<Osoba> osobyGlowneT = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.T).collect(toList());
		List<Osoba> osobyGlowneN = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.N).collect(toList());
		Preconditions.checkState(osobyGlowneT.size() <= 1, "Wywiad zawiera więcej niż 1 osobę główną");
		// osoba główna na pierwszym miejscu
		osoby.clear();
		osoby.addAll(osobyGlowneT);
		osoby.addAll(osobyGlowneN);
		// przynajmniej jedna osoba główna
		for (Osoba osoba : Iterables.limit(osoby, 1)) {
			osoba.getDanePodstawowe().setOsobaGlowna(TakNie.T);
		}
		return osoby;
	}

	public Osoba expand(Osoba osoba) {
		Processor.expand(osoba);
		expand(osoba.getDanePodstawowe());
		return osoba;
	}

	private DanePodstawowe expand(DanePodstawowe danePodstawowe) {
		if (danePodstawowe.getOsobaGlowna() == null) {
			danePodstawowe.setOsobaGlowna(TakNie.N);
		}
		return danePodstawowe;
	}
}
