package pl.topteam.otm.sd;

import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedSet;

public enum WersjaFormularzy {
	/** Wersja 1 MPiPS (Dz.U. 2012 poz. 712), nieobsługiwana wersja formularzy z początków projektu Emp@tia, 2012 */
	WERSJA_1(1, null, "2012"),

	/** Wersja 4 MPiPS (Dz.U. 2016 poz. 1406) */
	WERSJA_4(4, "pl.gov.mpips.empatia.v4", "2016"),

	/** Wersja 5 MRPiPS (Dz.U. 2016 poz. 1406) */
	WERSJA_5(5, "pl.gov.mpips.empatia.v5", "2016"),

	/** Wersja 1 TT (Dz.U. 2021 poz. 893) */
	WERSJA_2021_893(-1, "pl.gov.du.r2021.poz893", "2021");

	private static final Map<Integer, WersjaFormularzy> BY_WARTOSC = EnumSet.allOf(WersjaFormularzy.class).stream()
		.collect(Collectors.toMap(WersjaFormularzy::getWartosc, Functions.identity()));

	// dla wymiany z oprogramowaniem OTM/MSD
	private int wartosc;

	// określa rozmieszczenie dokumentów xsd oraz xsl
	private String pakiet;

	// user-friendly nazwa wersji formularzy
	private String opis;

	WersjaFormularzy(int wartosc, String pakiet, String opis) {
		this.wartosc = wartosc;
		this.pakiet = pakiet;
		this.opis = opis;
	}

	public int getWartosc() {
		return wartosc;
	}

	public String getPakiet() {
		return pakiet;
	}

	public String getOpis() {
		return opis;
	}

	public static WersjaFormularzy valueOf(int wartosc) {
		return BY_WARTOSC.get(Integer.valueOf(wartosc));
	}

	public static ImmutableSortedSet<WersjaFormularzy> kolejnoscObslugi() {
		return ImmutableSortedSet.copyOf(WersjaFormularzy.values()).descendingSet();
	}
}
