/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.otm.sd;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Collectors;

public enum WersjaFormularzy {
    WERSJA_1(1, null, "2012"),
    WERSJA_4(4, "pl.gov.mpips.empatia.v4", "2016"),
    WERSJA_5(5, "pl.gov.mpips.empatia.v5", "2016"),
    WERSJA_2021_893(-1, "pl.gov.du.r2021.poz893", "2021");

    private static final Map<Integer, WersjaFormularzy> BY_WARTOSC;
    private int wartosc;
    private String pakiet;
    private String opis;

    private WersjaFormularzy(int wartosc, String pakiet, String opis) {
        this.wartosc = wartosc;
        this.pakiet = pakiet;
        this.opis = opis;
    }

    public int getWartosc() {
        return this.wartosc;
    }

    public String getPakiet() {
        return this.pakiet;
    }

    public String getOpis() {
        return this.opis;
    }

    public static WersjaFormularzy valueOf(int wartosc) {
        return BY_WARTOSC.get(wartosc);
    }

    public static ImmutableSortedSet<WersjaFormularzy> kolejnoscObslugi() {
        return ImmutableSortedSet.copyOf((Comparable[])WersjaFormularzy.values()).descendingSet();
    }

    static {
        BY_WARTOSC = EnumSet.allOf(WersjaFormularzy.class).stream().collect(Collectors.toMap(WersjaFormularzy::getWartosc, Functions.identity()));
    }
}

