/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.du.r2021r3.poz893.wywiad.cz1i2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import pl.gov.du.r2021r3.poz893.wywiad.cz1i2.Dokument;
import pl.gov.du.r2021r3.poz893.wywiad.wspolne.ProponowanaPomoc;
import pl.gov.du.r2021r3.poz893.wywiad.wspolne.TakNie;
import pl.topteam.otm.utils.Processor;

@Service
@Scope(value="singleton")
public class Expander {
    @Autowired
    private pl.gov.du.r2021r3.poz893.wywiad.wspolne.Expander expander;

    public Dokument expand(Dokument dokument) {
        Processor.expand(dokument);
        this.expander.expand(dokument.getDaneDokumentu());
        this.expand(dokument.getTrescDokumentu());
        return dokument;
    }

    public Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie expand(Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie osoba) {
        Processor.expand(osoba);
        if (osoba.getIdXML() == null) {
            osoba.setIdXML("uuid-" + UUID.randomUUID().toString());
        }
        this.expand(osoba.getDanePodstawowe());
        return osoba;
    }

    private Dokument.TrescDokumentu expand(Dokument.TrescDokumentu trescDokumentu) {
        this.expand(trescDokumentu.getWywiad());
        trescDokumentu.getInneOsobyArt103().forEach(this::expand);
        this.expand(trescDokumentu.getDiagnozaSytuacjiOsoby());
        this.expand(trescDokumentu.getPlanPomocyIDzialan());
        this.expand(trescDokumentu.getUwagiKierownika());
        return trescDokumentu;
    }

    private Dokument.TrescDokumentu.Wywiad expand(Dokument.TrescDokumentu.Wywiad wywiad) {
        this.expander.expand(wywiad.getPracownikSocjalny());
        this.expand(wywiad.getGospodarstwo());
        return wywiad;
    }

    private List<Dokument.TrescDokumentu.Wywiad.Gospodarstwo> expand(List<Dokument.TrescDokumentu.Wywiad.Gospodarstwo> gospodarstwa) {
        List<Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie> osoby;
        if (gospodarstwa.isEmpty()) {
            Dokument.TrescDokumentu.Wywiad.Gospodarstwo gospodarstwo = new Dokument.TrescDokumentu.Wywiad.Gospodarstwo();
            gospodarstwa.add(gospodarstwo);
        }
        for (Dokument.TrescDokumentu.Wywiad.Gospodarstwo gospodarstwo : Iterables.limit(gospodarstwa, (int)1)) {
            osoby = gospodarstwo.getOsoba();
            if (!osoby.isEmpty()) continue;
            Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie osoba2 = new Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie();
            osoby.add(osoba2);
        }
        for (Dokument.TrescDokumentu.Wywiad.Gospodarstwo gospodarstwo : gospodarstwa) {
            Processor.expand(gospodarstwo);
            osoby = gospodarstwo.getOsoba();
            for (Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie osoba3 : osoby) {
                this.expand(osoba3);
            }
        }
        for (Dokument.TrescDokumentu.Wywiad.Gospodarstwo gospodarstwo : Iterables.limit(gospodarstwa, (int)1)) {
            osoby = gospodarstwo.getOsoba();
            List osobyGlowneT = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.T).collect(Collectors.toList());
            List osobyGlowneN = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.N).collect(Collectors.toList());
            Preconditions.checkState((osobyGlowneT.size() <= 1 ? 1 : 0) != 0, (Object)"Gospodarstwo zawiera wi\u0119cej ni\u017c 1 osob\u0119 g\u0142\u00f3wn\u0105");
            osoby.clear();
            osoby.addAll(osobyGlowneT);
            osoby.addAll(osobyGlowneN);
            for (Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie osoba4 : Iterables.limit(osoby, (int)1)) {
                osoba4.getDanePodstawowe().setOsobaGlowna(TakNie.T);
            }
        }
        return gospodarstwa;
    }

    private Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie.DanePodstawowe expand(Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie.DanePodstawowe danePodstawowe) {
        if (danePodstawowe.getOsobaGlowna() == null) {
            danePodstawowe.setOsobaGlowna(TakNie.N);
        }
        return danePodstawowe;
    }

    private void expand(Dokument.TrescDokumentu.Osoba osoba) {
        Processor.expand(osoba);
    }

    private Dokument.TrescDokumentu.DiagnozaSytuacjiOsoby expand(Dokument.TrescDokumentu.DiagnozaSytuacjiOsoby diagnozaSytuacjiOsoby) {
        this.expander.expand(diagnozaSytuacjiOsoby.getPracownikSocjalny());
        return diagnozaSytuacjiOsoby;
    }

    private Dokument.TrescDokumentu.PlanPomocyIDzialan expand(Dokument.TrescDokumentu.PlanPomocyIDzialan planPomocyIDzialan) {
        for (Dokument.TrescDokumentu.PlanPomocyIDzialan.FormyIZakresPomocy formyIZakresPomocy : planPomocyIDzialan.getFormyIZakresPomocy()) {
            this.expand(formyIZakresPomocy);
        }
        this.expander.expand(planPomocyIDzialan.getPracownikSocjalny());
        return planPomocyIDzialan;
    }

    private void expand(Dokument.TrescDokumentu.PlanPomocyIDzialan.FormyIZakresPomocy formyIZakresPomocy) {
        for (ProponowanaPomoc proponowanaPomoc : formyIZakresPomocy.getProponowanaPomoc()) {
            Processor.expand(proponowanaPomoc);
        }
    }

    private Dokument.TrescDokumentu.UwagiKierownika expand(Dokument.TrescDokumentu.UwagiKierownika uwagiKierownika) {
        this.expander.expand(uwagiKierownika.getKierownik());
        return uwagiKierownika;
    }
}

