﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:ns0="http://www.gov.pl/du/r2021r3/poz893/wywiad/wspolne"
	xmlns:ns1="http://www.gov.pl/du/r2021r3/poz893/wywiad/cz1i2"
	xmlns:slo="http://top-team.pl/otm/slowo/r1"
	xmlns:wis-m="http://top-team.pl/otm/wis/v20221101/metyczka"
	xmlns:wis-p="http://top-team.pl/otm/wis/v20221101/profile"
	xmlns:wis-r="http://top-team.pl/otm/wis/v20221101/rozszerzenia"
	xmlns:wis-k="http://top-team.pl/otm/wis/v20221101/kwestionariusz"
>
	<xsl:output method="html" encoding="utf-8"/>
	<xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>
	
	<xsl:include href="../../../../../topteam/otm/wis/v20221101/rozszerzenia/rozszerzenia.xslt"/>

	<xsl:key name="osobyWgId" match="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba" use="ns1:idXML"/>

	<xsl:variable name="CzestotliwoscKontaktow" select="document('../xml/CzestotliwoscKontaktow.xml')/properties/entry" />
	<xsl:variable name="InnaFormaWsparcia" select="document('../xml/InnaFormaWsparcia.xml')/properties/entry" />
	<xsl:variable name="MieszkanieChronione" select="document('../xml/MieszkanieChronione.xml')/properties/entry" />
	<xsl:variable name="OsrodekWsparcia" select="document('../xml/OsrodekWsparcia.xml')/properties/entry" />
	<xsl:variable name="Plec" select="document('../xml/Plec.xml')/properties/entry" />
	<xsl:variable name="PozycjaNaRynkuPracy" select="document('../xml/PozycjaNaRynkuPracy.xml')/properties/entry" />
	<xsl:variable name="RodzajAdresu" select="document('../xml/RodzajAdresu.xml')/properties/entry" />
	<xsl:variable name="RodzajDochodu" select="document('../xml/RodzajDochodu.xml')/properties/entry" />
	<xsl:variable name="RodzajDokumentu" select="document('../xml/RodzajDokumentu.xml')/properties/entry" />
	<xsl:variable name="RodzajPlacowki" select="document('../xml/RodzajPlacowki.xml')/properties/entry" />
	<xsl:variable name="RodzajUrzadzenia" select="document('../xml/RodzajUrzadzenia.xml')/properties/entry" />
	<xsl:variable name="RodzajUzaleznienia" select="document('../xml/RodzajUzaleznienia.xml')/properties/entry" />
	<xsl:variable name="RodzajWyksztalcenia" select="document('../xml/RodzajWyksztalcenia.xml')/properties/entry" />
	<xsl:variable name="StanCywilny" select="document('../xml/StanCywilny.xml')/properties/entry" />
	<xsl:variable name="StatusPrawny" select="document('../xml/StatusPrawny.xml')/properties/entry" />
	<xsl:variable name="StopienNiepelnosprawnosci" select="document('../xml/StopienNiepelnosprawnosci.xml')/properties/entry" />
	<xsl:variable name="StopienPokrewienstwa" select="document('../xml/StopienPokrewienstwa.xml')/properties/entry" />
	<xsl:variable name="SytuacjaZdrowotna" select="document('../xml/SytuacjaZdrowotna.xml')/properties/entry" />
	<xsl:variable name="TakNie" select="document('../xml/TakNie.xml')/properties/entry" />
	<xsl:variable name="TypPosilku" select="document('../xml/TypPosilku.xml')/properties/entry" />
	<xsl:variable name="ZaleceniaWZakresiePracy" select="document('../xml/ZaleceniaWZakresiePracy.xml')/properties/entry" />
	<xsl:variable name="ZrodloFinansowania" select="document('../xml/ZrodloFinansowania.xml')/properties/entry" />

	<xsl:variable name="Suma" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:SumaKontrolna" />

	<xsl:variable name="ns0-e" select="document('wspolne/wspolne.xsd')" />

	<xsl:template match="/">
		<xsl:variable name="OsobaGlowna" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo[./ns1:Osoba/ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']/ns1:Osoba[./ns1:DanePodstawowe/ns1:OsobaGlowna = 'T']" />
		<html>
			<head>
				<meta charset="utf-8" />
				<style>
					<xsl:value-of select="document('../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika and string(ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika/@xsi:nil) != 'true' and ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika != ''">
					<section id="notatki" style="page-break-after: always;">
						<span class="textarea">
							<ins>
								<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:NotatkiUzytkownika"/>
							</ins>
						</span>
						<span class="ukryty-na-wydruku">
							<br/>
							<a href="#" onclick="event.preventDefault(); document.getElementById('notatki').classList.add('ukryty');">(ukryj)</a>
							<br/>
							<br/>
						</span>
					</section>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="not($Suma)">
						<table style="width: 70mm;">
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec">
											<xsl:attribute name="style">text-align: left;</xsl:attribute>
											<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia1"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia2"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia3"/>
											<br/><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Autoryzacja/ns0:Pieczec/ns0:Linia4"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">text-align: center;</xsl:attribute>
											<br/>................................................................................
											<br/><br/>................................................................................
											<br/><br/>................................................................................
										</xsl:otherwise>
									</xsl:choose>
									<br/>
									<small>
										Pieczęć lub nadruk zawierający: nazwę, adres, NIP
										<br/>lub REGON jednostki organizacyjnej pomocy społecznej lub
										<br/>podmiotu udzielającego świadczeń zdrowotnych
									</small>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<br/>
						<br/>
						<br/>
					</xsl:otherwise>
				</xsl:choose>
				<h1>KWESTIONARIUSZ<br/>RODZINNEGO WYWIADU ŚRODOWISKOWEGO</h1>
				<h2>CZĘŚĆ I<br/>DOTYCZY OSÓB UBIEGAJĄCYCH SIĘ O PRZYZNANIE ŚWIADCZEŃ POMOCY SPOŁECZNEJ</h2>
				<br/>
				<section>
					<h3>A. DANE OSOBY, Z KTÓRĄ PRZEPROWADZONO WYWIAD, DANE O RODZINIE</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="width: 20mm;">Imię</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Imie2" />
								</ins>
							</td>
							<td style="width: 6mm;">3</td>
							<td style="width: 58mm; border-bottom: none;">Imiona rodziców</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:ImieOjca" />
									<xsl:text>, </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:ImieMatki" />
								</ins>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Nazwisko</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko1" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:Nazwisko2" />
								</ins>
							</td>
							<td>4</td>
							<td>Obywatelstwo</td>
							<td>
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:Obywatelstwo/slo:Opis" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">5</td>
							<td style="width: 180mm;">
								Seria i nr dokumentu potwierdzającego tożsamość:
								<ins>
									<xsl:variable name="_RodzajDokumentu" select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:RodzajDokumentu" />
									<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="$OsobaGlowna/ns1:DaneDodatkowe/ns1:NumerDokumentu" />
								</ins>
							</td>
							<td style="width: 6mm;">6</td>
							<td>
								Nr PESEL:
								<ins>
									<xsl:value-of select="$OsobaGlowna/ns1:DanePodstawowe/ns1:PESEL" />
								</ins>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td rowspan="2" style="width: 6mm;">7</td>
							<td style="width: 26mm;">
								Adres
								<br/>
								<ins>
									<xsl:variable name="_Rodzaj" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Rodzaj" />
									<xsl:value-of select="$RodzajAdresu[@key = $_Rodzaj]" />
								</ins>
							</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:NrLok" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:Telefon" /></ins></td>
									</tr>
								</table>
								<table>
									<tr>
										<td>symbol terytorialny: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>Miejsce pobytu<br/>osoby bezdomnej</td>
							<td colspan="2">
								<span class="textarea">
									<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:MiejscePobytuOsobyBezdomnej"/></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>8</td>
							<td>Adres do korespondencji</td>
							<td style="padding: 0px;">
								<table>
									<tr>
										<td style="width: 32mm;">kod pocztowy: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:KodPocztowy" /></ins></td>
										<td>miejscowość: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Miejscowosc" /></ins></td>
									</tr>
								</table>
								<table style="padding: 0px;">
									<tr>
										<td>ulica: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:Ulica" /></ins></td>
										<td style="width: 32mm;">nr domu: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrDomu" /></ins></td>
										<td style="width: 32mm;">nr mieszkania: <ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AdresDoKorespondencji/ns1:NrLok" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">9</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
													Dane <ins>opiekuna prawnego / <del>kuratora</del></ins>
												</xsl:when>
												<xsl:when test="$OsobaGlowna/ns1:Kurator">
													Dane <ins><del>opiekuna prawnego</del> / kuratora</ins>
												</xsl:when>
												<xsl:otherwise>
													Dane <ins><del>opiekuna prawnego</del> / <del>kuratora</del></ins>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td style="width: 20mm;">Imię</td>
										<td>
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:Imie2"/>
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:Imie2"/>
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
									<tr>
										<td>Nazwisko</td>
										<td>
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:Nazwisko2"/>
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:Nazwisko2"/>
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>
											Obywatelstwo
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:Obywatelstwo/slo:Opis" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:Obywatelstwo/slo:Opis" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td style="width: 66mm;">
											Seria i nr dokumentu potwierdzającego tożsamość:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:variable name="_RodzajDokumentu" select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:RodzajDokumentu" />
														<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:NumerDokumentu" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:variable name="_RodzajDokumentu" select="$OsobaGlowna/ns1:Kurator/ns1:RodzajDokumentu" />
														<xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:NumerDokumentu" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td>
											Nr PESEL:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:PESEL" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:PESEL" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">10</td>
							<td style="width: 26mm;">Adres zamieszkania</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td style="width: 40mm;">
											kod pocztowy:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:KodPocztowy" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:KodPocztowy" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td>
											miejscowość:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Miejscowosc" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:Miejscowosc" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>
											ulica:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Ulica" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:Ulica" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td style="width: 32mm;">
											nr domu:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrDomu" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:NrDomu" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
										<td style="width: 32mm;">
											nr mieszkania:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrLok" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:NrLok" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>telefon:
											<ins>
												<xsl:choose>
													<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
														<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Telefon" />
													</xsl:when>
													<xsl:when test="$OsobaGlowna/ns1:Kurator">
														<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:Telefon" />
													</xsl:when>
												</xsl:choose>
											</ins>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>
											symbol terytorialny:
										<ins>
											<xsl:choose>
												<xsl:when test="$OsobaGlowna/ns1:OpiekunPrawny">
													<xsl:value-of select="$OsobaGlowna/ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" />
												</xsl:when>
												<xsl:when test="$OsobaGlowna/ns1:Kurator">
													<xsl:value-of select="$OsobaGlowna/ns1:Kurator/ns1:AdresZamieszkania/ns1:SymbolTerytorialny" />
												</xsl:when>
											</xsl:choose>
										</ins>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">10</td>
							<td style="padding: 0;">
								<table>
									<tr>
										<td>
											<div style="float: left; width: 120mm;">
												Czy osoba/rodzina korzystała ze świadczeń jednostki organizacyjnej pomocy społecznej?
											</div>
											<div style="float: right; width: 20mm">
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:CzyPomocJOPS = 'T'">
														<ins>✓</ins>
													</xsl:when>
													<xsl:otherwise>
														&#160;&#160;&#160;
													</xsl:otherwise>
												</xsl:choose>
												1) tak
												<br/>
												<xsl:choose>
													<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:CzyPomocJOPS = 'N'">
														<ins>✓</ins>
													</xsl:when>
													<xsl:otherwise>
														&#160;&#160;&#160;
													</xsl:otherwise>
												</xsl:choose>
												2) nie
											</div>
										</td>
									</tr>
								</table>
								<table>
									<tr>
										<td>Data pierwszego zgłoszenia</td>
										<td style="width: 30mm;">miesiąc</td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataZgloszenia, 6, 1)" /></ins></td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataZgloszenia, 7, 1)" /></ins></td>
										<td style="width: 15mm;">rok</td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataZgloszenia, 1, 2)" /></ins></td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataZgloszenia, 3, 2)" /></ins></td>
									</tr>
									<tr>
										<td>Data ostatnio udzielonej pomocy</td>
										<td>miesiąc</td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataPomocy, 6, 1)" /></ins></td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataPomocy, 7, 1)" /></ins></td>
										<td>rok</td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataPomocy, 1, 2)" /></ins></td>
										<td style="width: 10mm; text-align: center;"><ins><xsl:value-of select="substring(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:DataPomocy, 3, 2)" /></ins></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td rowspan="2" style="width: 6mm;">12</td>
							<td>Korzystanie z pomocy innych instytucji</td>
							<td>pomoc pieniężna</td>
							<td>pomoc w naturze</td>
							<td>pomoc usługowa</td>
						</tr>
						<tr>
							<td>
								<ol>
									<li>rodziny</li>
									<li>osób obcych</li>
									<li>organizacji samopomocowych, pozarządowych</li>
									<li>kościołów lub związków wyznaniowych</li>
									<li>innych instytucji</li>
								</ol>
							</td>
							<td style="margin-left: auto; margin-right: auto;">
								<ul style="list-style-type: none;">
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '1' and ../ns1:Rodzaj/text() = '1']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '2' and ../ns1:Rodzaj/text() = '1']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '3' and ../ns1:Rodzaj/text() = '1']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '4' and ../ns1:Rodzaj/text() = '1']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '9' and ../ns1:Rodzaj/text() = '1']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
								</ul>
							</td>
							<td>
								<ul style="list-style-type: none;">
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '1' and ../ns1:Rodzaj/text() = '2']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '2' and ../ns1:Rodzaj/text() = '2']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '3' and ../ns1:Rodzaj/text() = '2']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '4' and ../ns1:Rodzaj/text() = '2']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '9' and ../ns1:Rodzaj/text() = '2']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
								</ul>
							</td>
							<td>
								<ul style="list-style-type: none;">
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '1' and ../ns1:Rodzaj/text() = '3']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '2' and ../ns1:Rodzaj/text() = '3']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '3' and ../ns1:Rodzaj/text() = '3']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '4' and ../ns1:Rodzaj/text() = '3']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
									<li><xsl:choose><xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:AktualnaPomoc/ns1:Pomoc//ns1:OdKogo[text() = '9' and ../ns1:Rodzaj/text() = '3']"><ins>✓</ins></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose></li>
								</ul>
							</td>
						</tr>
					</table>
					_____________________________<br/>
					<small>
						* W przypadku bezdomnego - ostatnie miejsce zameldowania na pobyt stały (w przypadku braku możliwości ustawienia - ostatni możliwy do potwierdzenia adres)
						<br/>** Niepotrzebne skreślić
					</small>
					<p style="page-break-before: always; padding: 2mm 0;">
						13. Informacje o członkach rodziny
					</p>
					<table>
						<thead>
							<tr>
								<th>1</th>
								<th>2</th>
								<th colspan="3">3</th>
								<th>4</th>
								<th>5</th>
								<th>6</th>
								<th>7</th>
							</tr>
							<tr>
								<th style="width: 6mm;" rowspan="2">Lp.</th>
								<th style="width: 60mm;" rowspan="2">Imię i nazwisko</th>
								<th colspan="3">Data urodzenia</th>
								<th rowspan="2">Płeć</th>
								<th rowspan="2">Nr PESEL</th>
								<th rowspan="2">Stan cywilny</th>
								<th rowspan="2">Stopień pokrewieństwa</th>
							</tr>
							<tr>
								<th style="width: 10mm;">dzień</th>
								<th style="width: 10mm;">mies.</th>
								<th style="width: 10mm;">rok</th>
							</tr>
						</thead>
						<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">
							<tbody class="gospodarstwo">
								<xsl:for-each select="ns1:Osoba">
									<tr>
										<td>
											<xsl:value-of select="count(parent::ns1:Gospodarstwo/preceding-sibling::ns1:Gospodarstwo/ns1:Osoba) + position()" />
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
												<br/>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 9, 2)" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 6, 2)" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:DanePodstawowe/ns1:DataUr, 1, 4)" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_Plec" select="ns1:DanePodstawowe/ns1:Plec" />
												<xsl:value-of select="$Plec[@key = $_Plec]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:PESEL"/>
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_StanCywilny" select="ns1:DanePodstawowe/ns1:StanCywilny" />
												<xsl:value-of select="$StanCywilny[@key = $_StanCywilny]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_StopienPokrewienstwa" select="ns1:DanePodstawowe/ns1:StopienPokrewienstwa" />
												<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />
											</ins>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</xsl:for-each>
					</table>
					<small>
						* Należy wpisać dane osoby, z którą przeprowadzono wywiad.
						<br/>Uwaga: 1. Oddzielne gospodarstwa domowe należy oddzielić poziomą kreską
						<br/><span style="margin-left: 9mm;">2. W przypadku większej liczy osób w rodzinie należy dołączyć dodatkowe strony</span>
					</small>
					<br />
					<p style="page-break-before: always; padding: 2mm 0;"></p>
					<table>
						<thead>
							<tr>
								<th></th>
								<th>8</th>
								<th>9</th>
								<th>10</th>
								<th>11</th>
								<th>12</th>
								<th>13</th>
							</tr>
							<tr>
								<th style="width: 6mm;" rowspan="2">Lp.</th>
								<th rowspan="2">Wykształcenie, wykonywany zawód</th>
								<th rowspan="2">Miejsce pracy lub nauki><br/>(placówka i oddział)</th>
								<th rowspan="2">Pozycja<br/>na rynku<br/>pracy</th>
								<th rowspan="2">Sytuacja<br/>zdrowotna</th>
								<th colspan="2">Źródło dochodu (utrzymania)</th>
							</tr>
							<tr>
								<th style="width: 36mm;">rodzaj</th>
								<th style="width: 22mm;">wysokość</th>
							</tr>
						</thead>
						<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo">
							<tbody class="gospodarstwo">
								<xsl:for-each select="ns1:Osoba">
									<tr>
										<td>
											<xsl:value-of select="count(parent::ns1:Gospodarstwo/preceding-sibling::ns1:Gospodarstwo/ns1:Osoba) + position()" />
										</td>
										<td>
											<span class="textarea">
											<ins>
												<xsl:variable name="_Wyksztalcenie" select="ns1:DanePodstawowe/ns1:Wyksztalcenie" />
												<xsl:value-of select="$RodzajWyksztalcenia[@key = $_Wyksztalcenie]" />
												<br/>
												(<xsl:value-of select="ns1:DanePodstawowe/ns1:Zawod/slo:Kod"/>) <xsl:value-of select="ns1:DanePodstawowe/ns1:Zawod/slo:Opis"/>
											</ins>
											</span>
										</td>
										<td>
											<span class="textarea">
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:MiejscePracy"/>
											</ins>
											</span>
										</td>
										<td>
											<ins>
												<xsl:variable name="_PozycjaNaRynku" select="ns1:DanePodstawowe/ns1:PozycjaNaRynku" />
												<xsl:value-of select="$PozycjaNaRynkuPracy[@key = $_PozycjaNaRynku]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_SytuacjaZdrowotna" select="ns1:DanePodstawowe/ns1:SytuacjaZdrowotna" />
												<xsl:value-of select="$SytuacjaZdrowotna[@key = $_SytuacjaZdrowotna]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
													<xsl:variable name="_Rodzaj" select="ns1:Rodzaj" />
													<xsl:value-of select="$RodzajDochodu[@key = $_Rodzaj]" />
													<br/>
												</xsl:for-each>
											</ins>
										</td>
										<td style="text-align: right;">
											<xsl:for-each select="ns1:DanePodstawowe/ns1:Dochod">
												<ins>
													<xsl:value-of select="format-number(ns1:Wysokosc, '0,00')" />
												</ins>
												<xsl:text> </xsl:text>
												zł
												<br/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</xsl:for-each>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>B. ANALIZA SYTUACJI MATERIALNEJ</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td style="height: 48mm;">
								Imię i nazwisko, stopień pokrewieństwa oraz adresy małżonka, zstępnych lub wstępnych, o których mowa w art. 103
								ustawy z dnia 12 marca 2004 r. o pomocy społecznej, wielkość i forma świadczonej lub deklarowanej pomocy:<br/>
								<br/>
								<table>
									<thead>
										<tr>
											<th>Lp.</th>
											<th>Imię</th>
											<th>Nazwisko</th>
											<th>Adres</th>
											<th>Numery telefonów</th>
											<th>Stopień pokrewieństwa</th>
											<th>Forma i wielkość świadczonej lub deklarowanej pomocy</th>
										</tr>
									</thead>
									<tbody>
										<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Art103/ns1:Osoba">
											<xsl:variable name="Lp" select="position()" />
											<tr>
												<td><ins><xsl:value-of select="$Lp"/></ins></td>
												<td>
													<ins>
														<xsl:value-of select="ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Imie2"/>
													</ins>
												</td>
												<td>
													<ins>
														<xsl:value-of select="ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Nazwisko2"/>
													</ins>
												</td>
												<td>
													<ins>
														<xsl:value-of select="ns1:KodPocztowy"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:Miejscowosc"/>
														<xsl:if test="ns1:KodPocztowy or ns1:Miejscowosc">
															<xsl:text>, </xsl:text>
														</xsl:if>
														<xsl:value-of select="ns1:Ulica"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:NrDomu"/>
														<xsl:if test="ns1:NrLok != ''">
															<xsl:text> </xsl:text>
															m. <xsl:value-of select="ns1:NrLok"/>
														</xsl:if>
													</ins>
												</td>
												<td>
													<ins><xsl:value-of select="ns1:Telefon"/></ins>
												</td>
												<td>
													<ins>
														<xsl:variable name="_StopienPokrewienstwa" select="ns1:StopienPokrewienstwa" />
														<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />
													</ins>
												</td>
												<td>
													<ins>
														<xsl:call-template name="ns0-enumeracja">
															<xsl:with-param name="nazwa" select="'TypPomocy'"/>
															<xsl:with-param name="wartosc" select="ns1:RodzajPomocy"/>
														</xsl:call-template>
														<br/><xsl:value-of select="ns1:WielkoscPomocy"/>
														<br/><xsl:value-of select="format-number(ns1:KwotaPomocy, '0,00')" />
														<xsl:if test="ns1:Uwagi">
															<span class="textarea" style="display: block;">
																<ins><xsl:value-of select="ns1:Uwagi"/></ins>
															</span>
														</xsl:if>
													</ins>
												</td>
											</tr>
										</xsl:for-each>
									</tbody>
								</table>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">2</td>
							<td colspan="2">Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Dochod, '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td style="width: 6mm;" rowspan="13">3</td>
							<td colspan="2">Stałe, miesięczne wydatki osoby/rodziny łącznie</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Razem, '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td style="width: 12mm;" rowspan="12">w tym</td>
							<td>czynsz</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '01']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>energia elektryczna</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '02']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>gaz</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '03']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>alimenty</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '04']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>opłaty za dom pomocy społecznej</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '05']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>opłaty za szkołę/bursę/internat</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '06']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>opłaty za przedszkole</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '07']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>opłaty rodziców/opiekunów prawnych za pobyt dziecka<br/>w placówce dziennej lub całodobowej</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '10']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>opłaty rodziców za pobyt dziecka w pieczy zastępczej</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '11']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>wydatki na leki i leczenie</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '08']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
						<tr>
							<td>
								inne
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '99']">
										<br/>
										<span class="textarea">
										<ins>
											<xsl:value-of select="ns1:Uwagi" /><br/>
										</ins>
										</span>
									</xsl:for-each>
							</td>
							<td style="text-align: right;"><ins><xsl:value-of select="format-number(sum(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Wydatki/ns1:Wydatek[./ns1:Rodzaj = '99']/ns1:Kwota), '0,00')"/></ins><xsl:text> </xsl:text>zł</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;" rowspan="2">4</td>
							<td>Alimenty świadczone przez osobę, z którą jest przeprowadzany wywiad, lub innych członków rodziny:</td>
						</tr>
						<tr>
							<td style="padding: 0;">
								<table>
									<thead>
										<tr>
											<th>Kto?</th>
											<th>Na czyją rzecz?</th>
											<th>Wysokość</th>
											<th>Wysokość zaległych<br/>alimentów</th>
											<th>
												<ol>
													<li>dobrowolne</li>
													<li>na podstawie<br/>orzeczenia sądu</li>
												</ol>
											</th>
										</tr>
									</thead>
									<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Alimenty/ns1:NaKogo/ns1:Osoba">
									<tbody>
										<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Alimenty/ns1:NaKogo/ns1:Osoba">
											<xsl:variable name="Alimenty" select="ancestor::ns1:Alimenty" />
											<xsl:variable name="Kto" select="ancestor::ns1:Osoba" />
											<xsl:variable name="NaKogo" select="self::ns1:Osoba" />
											<tr>
												<td>
													<ins>
														<xsl:value-of select="$Kto/ns1:DanePodstawowe/ns1:Imie1" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$Kto/ns1:DanePodstawowe/ns1:Imie2" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$Kto/ns1:DanePodstawowe/ns1:Nazwisko1" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$Kto/ns1:DanePodstawowe/ns1:Nazwisko2" />
													</ins>
												</td>
												<td>
													<ins>
														<xsl:value-of select="$NaKogo/ns1:DanePodstawowe/ns1:Imie1" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$NaKogo/ns1:DanePodstawowe/ns1:Imie2" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$NaKogo/ns1:DanePodstawowe/ns1:Nazwisko1" />
														<xsl:text> </xsl:text>
														<xsl:value-of select="$NaKogo/ns1:DanePodstawowe/ns1:Nazwisko2" />
														<br/>
														<xsl:if test="$NaKogo/ns1:StopienPokrewienstwa">
															<xsl:variable name="_StopienPokrewienstwa" select="$NaKogo/ns1:StopienPokrewienstwa" />
															(<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />)
															<br/>
														</xsl:if>
														<xsl:value-of select="$NaKogo/ns1:AdresZamieszkania/ns1:KodPocztowy"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="$NaKogo/ns1:AdresZamieszkania/ns1:Miejscowosc"/>
														<xsl:if test="$NaKogo/ns1:AdresZamieszkania/ns1:Ulica != '' or $NaKogo/ns1:AdresZamieszkania/ns1:NrDomu != '' or $NaKogo/ns1:AdresZamieszkania/ns1:NrLok != ''">
															<xsl:text>, </xsl:text>
														</xsl:if>
														<xsl:value-of select="$NaKogo/ns1:AdresZamieszkania/ns1:Ulica"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="$NaKogo/ns1:AdresZamieszkania/ns1:NrDomu"/>
														<xsl:if test="$NaKogo/ns1:AdresZamieszkania/ns1:NrLok != ''">
															<xsl:text> </xsl:text>
															m. <xsl:value-of select="$NaKogo/ns1:AdresZamieszkania/ns1:NrLok"/>
														</xsl:if>
													</ins>
												</td>
												<td style="text-align: right;">
													<ins>
														<xsl:value-of select="format-number($NaKogo/ns1:SwiadczenieAlimentacyjne/ns1:Wysokosc, '0,00')" />
													</ins>
													<xsl:text> </xsl:text>
													zł
												</td>
												<td style="text-align: right;">
													<ins>
														<xsl:value-of select="format-number($NaKogo/ns1:SwiadczenieAlimentacyjne/ns1:Zalegle, '0,00')" />
													</ins>
													zł
												</td>
												<td>
													<xsl:if test="$NaKogo/ns1:SwiadczenieAlimentacyjne/ns1:Rodzaj = 'dobrowolne'">
														<ins>dobrowolne</ins>
													</xsl:if>
													<xsl:if test="$NaKogo/ns1:SwiadczenieAlimentacyjne/ns1:Rodzaj = 'orzeczenie'">
														<ins>na podstawie<br/>orzeczenia sądu</ins>
													</xsl:if>
												</td>
											</tr>
										</xsl:for-each>
									</tbody>
									</xsl:if>
								</table>
							</td>
						</tr>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>C. SYTUACJA MIESZKANIOWA OSOBY LUB RODZINY</h3>
					<xsl:variable name="Mieszkanie" select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Mieszkanie" />
					<xsl:variable name="SytuacjaRodziny" select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:SytuacjaRodziny" />
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td>
								<div>
									Charakter prawa do lokalu mieszkalnego / domu (np. własność, wynajem):
								</div>
								<div style="float: left; width: 49%;">
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '01X'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) lokatorskie spółdzielcze prawo do lokalu mieszkalnego
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '02X'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) własnościowe spółdzielcze prawo do lokalu mieszkalnego
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '11x'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									3) własność lokalu/domu
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '03'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									4) komunalne/kwaterunkowe
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '04'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									5) mieszkanie wynajęte
								</div>
								<div style="float: right; width: 49%;">
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '05'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									6) mieszkanie chronione
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '10'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									7) prawo do domu jednorodzinnego/jego części w spółdzielni mieszkaniowej
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '07'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									8) hotel
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '08'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									9) barak
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '09'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									10) brak mieszkania
									<br/>
									<xsl:choose>
										<xsl:when test="$Mieszkanie/ns1:Rodzaj = '99'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									11) inne (jakie?)
									<br/>
									<span class="textarea" style="padding-left: 8mm;">
										<ins><xsl:value-of select="$Mieszkanie/ns1:RodzajUwagi" /></ins>
									</span>
								</div>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">2</td>
							<td>
								<div>
									1) Stan utrzymania mieszkania:<br/>
									<xsl:if test="$Mieszkanie/ns1:StanMieszkania = '1x'">
										<ins>✓</ins>
									</xsl:if>
									a) czyste, zadbane
									&#160;&#160;
									<xsl:if test="$Mieszkanie/ns1:StanMieszkania = '2x'">
										<ins>✓</ins>
									</xsl:if>
									b) brudne, zaniedbane
									&#160;&#160;
									<xsl:if test="$Mieszkanie/ns1:StanMieszkania = '3'">
										<ins>✓</ins>
									</xsl:if>
									c) zdewastowane
								</div>
								<xsl:if test="$Mieszkanie/ns1:StanMieszkaniaOpis">
									<span class="textarea">
										<ins><xsl:value-of select="$Mieszkanie/ns1:StanMieszkaniaOpis"/></ins>
									</span>
								</xsl:if>
								<div style="margin-top: 2mm;">
									2) Dostęp do mediów:<br/>
									<div style="float: left; width: 30mm;">
										a) bieżąca woda:<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:WodaBiezaca = 'ZIMNA'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										zimna
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:WodaBiezaca = 'CIEPLA'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										ciepła
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:WodaBiezaca = 'BRAK'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										brak
									</div>
									<div style="float: left; width: 80mm;">
										b) ogrzewanie:<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '1'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										piece węglowe
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '2'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										ogrzewanie centralne
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '3'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										ogrzewanie centralne – gazowe
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '4'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										ogrzewanie elektryczne – akumulacyjne
										<br/>
										<ins>
										<xsl:choose>
											<xsl:when test="$Mieszkanie/ns1:Ogrzewanie = '5'">✓</xsl:when>
											<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
										</xsl:choose>
										</ins>
										brak ogrzewania
									</div>
									<div style="float: left; width: 30mm;">
										c) prąd:<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:Prad = 'DOSTEPNY'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										dostępny
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:Prad = 'BRAK'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										brak
									</div>
									<div style="float: left; width: 30mm;">
										d) gaz:<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:Gaz = 'DOSTEPNY'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										dostępny
										<br/>
										<ins>
											<xsl:choose>
												<xsl:when test="$Mieszkanie/ns1:Gaz = 'BRAK'">✓</xsl:when>
												<xsl:otherwise>&#160;&#160;&#160;</xsl:otherwise>
											</xsl:choose>
										</ins>
										brak
									</div>
									<div style="clear: both;"></div>
								</div>
								<div style="margin-top: 2mm;">
									3) Wyposażenie mieszkania w niezbędne sprzęty gospodarstwa domowego:<br/>
									<xsl:if test="$Mieszkanie/ns1:WyposazenieAGD">
										<ul>
										<xsl:for-each select="$Mieszkanie/ns1:WyposazenieAGD">
											<li><ins>
												<xsl:call-template name="ns0-enumeracja">
													<xsl:with-param name="nazwa" select="'SprzetAGD'"/>
													<xsl:with-param name="wartosc" select="ns1:sprzet"/>
												</xsl:call-template>
												<xsl:text> </xsl:text>
												<xsl:choose>
													<xsl:when test="ns1:dostepnosc = 'T'">(dostępna)</xsl:when>
													<xsl:otherwise>(brak)</xsl:otherwise>
												</xsl:choose>
												<xsl:if test="ns1:uwagi">
													<span class="textarea" style="display: block; padding-left: 3mm;"><ins><xsl:value-of select="ns1:uwagi"/></ins></span>
												</xsl:if>
												</ins>
											</li>
										</xsl:for-each>
										</ul>
									</xsl:if>
								</div>
								<div style="margin-top: 2mm;">
									4) Pozostałe informacje (np. dostęp do WC, łazienki, miejsca do spania):<br/>
									<xsl:if test="$Mieszkanie/ns1:Lazienka">
										<ins>
										łazienka
										(<xsl:call-template name="ns0-enumeracja">
											<xsl:with-param name="nazwa" select="'WyposazenieLazienka'"/>
											<xsl:with-param name="wartosc" select="$Mieszkanie/ns1:Lazienka"/>
										</xsl:call-template>)
										</ins>
									</xsl:if>
									<xsl:if test="$Mieszkanie/ns1:WC">
										<xsl:if test="$Mieszkanie/ns1:Lazienka"><br/></xsl:if>
										<ins>
										WC
										(<xsl:call-template name="ns0-enumeracja">
											<xsl:with-param name="nazwa" select="'WyposazenieWC'"/>
											<xsl:with-param name="wartosc" select="$Mieszkanie/ns1:WC"/>
										</xsl:call-template>)
										</ins>
									</xsl:if>
									<xsl:if test="$Mieszkanie/ns1:Lazienka or $Mieszkanie/ns1:WC"><br/></xsl:if>
									<span class="textarea">
										<ins><xsl:value-of select="$Mieszkanie/ns1:PozostaleInformacje" /></ins>
									</span>
								</div>
							</td>
						</tr>
					</table>
					<table>
						<xsl:variable name="liczbaPrzemoc" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:CzyPrzemoc[text() = 'T'])"/>
						<xsl:variable name="liczbaKonfliktow" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:CzyKonflikty[text() = 'T'])"/>
						<xsl:variable name="liczbaProblemowOW" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:CzyProblemyOW[text() = 'T'])"/>
						<xsl:variable name="liczbaInnychProblemow" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:Inne[text() != ''])"/>
						<xsl:variable name="liczbaWszystkichProblemow" select="$liczbaPrzemoc + $liczbaKonfliktow + $liczbaProblemowOW + $liczbaInnychProblemow"/>
						<tr>
							<td style="width: 6mm;">3</td>
							<td>
								Czy występują problemy w relacjach między wspólnie zamieszkającymi członkami rodziny?<br/>
								1) nie
								<xsl:choose><xsl:when test="$liczbaWszystkichProblemow = 0"><ins>✓</ins></xsl:when><xsl:otherwise>&#160;&#160;</xsl:otherwise></xsl:choose>
								<br/>
								2) tak:
								<xsl:if test="$liczbaPrzemoc > 0"><ins>✓</ins></xsl:if>przemoc&#160;&#160;
								<xsl:if test="$liczbaProblemowOW > 0"><ins>✓</ins></xsl:if>problemy opiekuńczo-wychowawcze&#160;&#160;
								<xsl:if test="$liczbaKonfliktow > 0"><ins>✓</ins></xsl:if>konflikty&#160;&#160;
								<xsl:if test="$liczbaInnychProblemow > 0"><ins>✓</ins></xsl:if>inne - wskazać
								<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:Inne[text() != '']">
									<br/><span class="textarea"><ins><xsl:value-of select="text()" /></ins></span><xsl:if test="position() != last()">;<br/></xsl:if>
								</xsl:for-each>
							</td>
							<td style="width: 20mm; white-space: nowrap;">
								Kogo dotyczą?
								<xsl:if test="$liczbaPrzemoc > 0">
									<br/>
									<ins>przemoc</ins>
									<div style="padding-left: 4mm">
										<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:CzyPrzemoc[text() = 'T']">
											<xsl:variable name="Lp" select="position()" />
											<ins>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Nazwisko1" />
												<xsl:text> </xsl:text>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Imie1" />
											</ins>
											<xsl:text> </xsl:text>[#<xsl:value-of select="$Lp"/>]<xsl:if test="position() != last()">,<br/></xsl:if>
										</xsl:for-each>
									</div>
								</xsl:if>
								<xsl:if test="$liczbaProblemowOW > 0">
									<br/>
									<ins>problemy opiekuńczo-wychowawcze</ins>
									<div style="padding-left: 4mm">
										<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:CzyProblemyOW[text() = 'T']">
											<xsl:variable name="Lp" select="position()" />
											<ins>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Nazwisko1" />
												<xsl:text> </xsl:text>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Imie1" />
											</ins>
											<xsl:text> </xsl:text>[#<xsl:value-of select="$Lp"/>]<xsl:if test="position() != last()">,<br/></xsl:if>
										</xsl:for-each>
									</div>
								</xsl:if>
								<xsl:if test="$liczbaKonfliktow > 0">
									<br/>
									<ins>konflikty</ins>
									<div style="padding-left: 4mm">
										<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:CzyKonflikty[text() = 'T']">
											<xsl:variable name="Lp" select="position()" />
											<ins>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Nazwisko1" />
												<xsl:text> </xsl:text>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Imie1" />
											</ins>
											<xsl:text> </xsl:text>[#<xsl:value-of select="$Lp"/>]<xsl:if test="position() != last()">,<br/></xsl:if>
										</xsl:for-each>
									</div>
								</xsl:if>
								<xsl:if test="$liczbaInnychProblemow > 0">
									<br/>
									<ins>inne</ins>
									<div style="padding-left: 4mm">
										<xsl:for-each select="/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo//ns1:Osoba/ns1:ProblemyWRelacjach/ns1:Inne[text() != '']">
											<xsl:variable name="Lp" select="position()" />
											<ins>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Nazwisko1" />
												<xsl:text> </xsl:text>
												<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Imie1" />
											</ins>
											<xsl:text> </xsl:text>[#<xsl:value-of select="$Lp"/>]<xsl:if test="position() != last()">,<br/></xsl:if>
										</xsl:for-each>
									</div>
								</xsl:if>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">4</td>
							<td>
								Charakterystyka problemu (m.in. przyczyny, podjęte działania i ich efekty):<br/>
								<span class="textarea">
									<ins><xsl:value-of select="$SytuacjaRodziny/ns1:CharakterystykaProblemu" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">5</td>
							<td>
								Funkcjonowanie rodziny w środowisku i zagrożenia ze strony środowiska:<br/>
								<span class="textarea">
									<ins><xsl:value-of select="$SytuacjaRodziny/ns1:Srodowisko" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<div></div>
					<table style="page-break-before: always;">
						<tr>
							<td style="width: 6mm;">6</td>
							<td>
								Relacje osoby/rodziny z krewnymi, którzy mieszkają oddzielnie:<br/>
								<br/>
								<table>
									<thead>
										<tr>
											<th>Lp.</th>
											<th>Imię</th>
											<th>Nazwisko/Nazwa podmiotu</th>
											<th>Adres</th>
											<th>Numery telefonów</th>
											<th>Stopień pokrewieństwa</th>
											<th>Uwagi</th>
										</tr>
									</thead>
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
										<xsl:if test="ns1:KrewniMieszkajacyOddzielnie/ns1:Osoba">
										<tbody>
											<tr>
												<td colspan="7" style="text-align: left;">
													<ins>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
													</ins>
													[#<xsl:value-of select="position()"/>]
												</td>
											</tr>
											<xsl:for-each select="ns1:KrewniMieszkajacyOddzielnie/ns1:Osoba">
												<xsl:variable name="Lp" select="position()" />
												<tr>
													<td><ins><xsl:value-of select="$Lp"/></ins></td>
													<td>
														<ins>
															<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
															<xsl:text> </xsl:text>
															<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
														</ins>
													</td>
													<td>
														<ins>
															<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
															<xsl:text> </xsl:text>
															<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
														</ins>
													</td>
													<td>
														<ins>
															<xsl:value-of select="ns1:AdresZamieszkania/ns1:KodPocztowy"/>
															<xsl:text> </xsl:text>
															<xsl:value-of select="ns1:AdresZamieszkania/ns1:Miejscowosc"/>
															<xsl:if test="ns1:AdresZamieszkania/ns1:KodPocztowy or ns1:AdresZamieszkania/ns1:Miejscowosc">
																<xsl:text>, </xsl:text>
															</xsl:if>
															<xsl:value-of select="ns1:AdresZamieszkania/ns1:Ulica"/>
															<xsl:text> </xsl:text>
															<xsl:value-of select="ns1:AdresZamieszkania/ns1:NrDomu"/>
															<xsl:if test="ns1:AdresZamieszkania/ns1:NrLok != ''">
																<xsl:text> </xsl:text>
																m. <xsl:value-of select="ns1:AdresZamieszkania/ns1:NrLok"/>
															</xsl:if>
														</ins>
													</td>
													<td>
														<ins><xsl:value-of select="ns1:Telefon"/></ins>
													</td>
													<td>
														<ins>
															<xsl:variable name="_StopienPokrewienstwa" select="ns1:StopienPokrewienstwa" />
															<xsl:value-of select="$StopienPokrewienstwa[@key = $_StopienPokrewienstwa]" />
														</ins>
													</td>
													<td>
														<ins>
															<xsl:if test="ns1:Uwagi">
																<span class="textarea" style="display: block;">
																	<ins><xsl:value-of select="ns1:Uwagi"/></ins>
																</span>
															</xsl:if>
														</ins>
													</td>
												</tr>
											</xsl:for-each>
										</tbody>
										</xsl:if>
									</xsl:for-each>
								</table>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">7</td>
							<td>
								<div>
									Czy osoba/rodzina jest objęta wsparciem asystenta rodziny?
									<div style="float: right; width: 30mm;">
										<xsl:choose>
											<xsl:when test="$SytuacjaRodziny/ns1:AsystentRodziny/ns1:CzyAsystent = 'T'">
												<ins>✓</ins>
											</xsl:when>
											<xsl:otherwise>
												&#160;&#160;&#160;
											</xsl:otherwise>
										</xsl:choose>
										1) tak
										<br/>
										<xsl:choose>
											<xsl:when test="$SytuacjaRodziny/ns1:AsystentRodziny/ns1:CzyAsystent = 'N'">
												<ins>✓</ins>
											</xsl:when>
											<xsl:otherwise>
												&#160;&#160;&#160;
											</xsl:otherwise>
										</xsl:choose>
										2) nie
									</div>
									<div style="clear: both;"></div>
									Jeżeli tak, wpisać od kiedy: <ins><xsl:value-of select="$SytuacjaRodziny/ns1:AsystentRodziny/ns1:OdKiedy" /></ins>
								</div>
								<div style="margin-top: 2mm;">
									Czy osoba/rodzina jest objęta nadzorem kuratora?
									<div style="float: right; width: 30mm;">
										<xsl:choose>
											<xsl:when test="$SytuacjaRodziny/ns1:Kurator/ns1:CzyKurator = 'T'">
												<ins>✓</ins>
											</xsl:when>
											<xsl:otherwise>
												&#160;&#160;&#160;
											</xsl:otherwise>
										</xsl:choose>
										1) tak
										<br/>
										<xsl:choose>
											<xsl:when test="$SytuacjaRodziny/ns1:Kurator/ns1:CzyKurator = 'N'">
												<ins>✓</ins>
											</xsl:when>
											<xsl:otherwise>
												&#160;&#160;&#160;
											</xsl:otherwise>
										</xsl:choose>
										2) nie
									</div>
									<div style="clear: both;"></div>
									Jeżeli tak, wpisać od kiedy: <ins><xsl:value-of select="$SytuacjaRodziny/ns1:Kurator/ns1:OdKiedy" /></ins>
								</div>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm;">8</td>
							<td>
								<table>
									<tr>
										<td>
											<div style="float: right; width: 45mm;">
												<xsl:choose>
													<xsl:when test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Placowka) != 0">
														<ins>✓</ins>
													</xsl:when>
													<xsl:otherwise>
														&#160;&#160;&#160;
													</xsl:otherwise>
												</xsl:choose>
												1) tak
												<br/>
												<xsl:choose>
													<xsl:when test="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba/ns1:Placowka) = 0">
														<ins>✓</ins>
													</xsl:when>
													<xsl:otherwise>
														&#160;&#160;&#160;
													</xsl:otherwise>
												</xsl:choose>
												2) nie
											</div>
											Czy któryś ze wspólnie zamieszkujących członków rodziny w ciągu ostatnich 5 lat korzystał
					                        lub aktualnie korzysta z usług ośrodka wsparcia, domu pomocy społecznej, przebywa/przebywał
					                        w rodzinnej lub instytucjonalnej pieczy zastępczej czy innej instytucji całodobowego pobytu
					                        (np. specjalnym ośrodku szkolno-wychowawczym, zakładzie poprawczym, zakładzie karnym itp.)?
										</td>
									</tr>
									<tr>
										<td>
											Jeżeli tak, to wpisać:<br/>
											Kto:
											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Gospodarstwo/ns1:Osoba">
												<xsl:if test="ns1:Placowka or ns1:ZakladKarny">
													<ins>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
													</ins>
													<xsl:text> </xsl:text>
													[#<xsl:value-of select="position()"/>]
												</xsl:if>
											</xsl:for-each>
											<br/>
											Kiedy:
											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Gospodarstwo/ns1:Osoba">
												<xsl:if test="ns1:Placowka">
													<ins>
														od&#160;<xsl:value-of select="substring(ns1:Placowka/ns1:DataOd/text(),0,11)"/>
														do&#160;<xsl:value-of select="substring(ns1:Placowka/ns1:DataDo/text(),0,11)"/>
													</ins>
													<xsl:text> </xsl:text>
													[pl#<xsl:value-of select="position()"/>]
												</xsl:if>
												<xsl:if test="ns1:ZakladKarny">
													<ins>
														od&#160;<xsl:value-of select="substring(ns1:ZakladKarny/ns1:DataOd/text(),0,11)"/>
														do&#160;<xsl:value-of select="substring(ns1:ZakladKarny/ns1:DataDo/text(),0,11)"/>
													</ins>
													<xsl:text> </xsl:text>
													[zk#<xsl:value-of select="position()"/>]
												</xsl:if>
											</xsl:for-each>
											<br/>
											Rodzaj placówki:
											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Gospodarstwo/ns1:Osoba">
												<xsl:if test="ns1:Placowka/ns1:Rodzaj">
													<ins>
														<xsl:variable name="_Rodzaj" select="ns1:Placowka/ns1:Rodzaj"/>
														<xsl:value-of select="$RodzajPlacowki[@key = $_Rodzaj]"/>
													</ins>
													<xsl:text> </xsl:text>
													[pl#<xsl:value-of select="position()"/>]
													<br/>
												</xsl:if>
											</xsl:for-each>
											<br/>
											Kontakty z rodziną (np. częstotliwość pobytu w domu rodzinnym, współpraca rodziców z placówką, w której przebywa dziecko):<br/>
											<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Gospodarstwo/ns1:Osoba">
												<xsl:if test="ns1:Placowka">
													[pl#<xsl:value-of select="position()"/>]
													<br/>
													<span class="textarea">
														<ins>
															<xsl:variable name="_CzestotliwoscKontaktow" select="ns1:Placowka/ns1:CzestotliwoscKontaktow"/>
															<xsl:value-of select="$CzestotliwoscKontaktow[@key = $_CzestotliwoscKontaktow]"/>
														</ins>
													</span>
													<br/><span class="textarea"><ins><xsl:value-of select="ns1:Placowka/ns1:ZakresWspolpracy"/></ins></span>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:variable name="liczbaZarobkowZK" select="count(/ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Gospodarstwo/ns1:Osoba/ns1:ZakladKarny/ns1:Wysokosc[text() > 0])"/>
											<div style="float: right; width: 45mm;">
												<xsl:choose>
													<xsl:when test="$liczbaZarobkowZK > 0">
														<ins>✓</ins>
													</xsl:when>
													<xsl:otherwise>
														&#160;&#160;&#160;
													</xsl:otherwise>
												</xsl:choose>
												1) tak
												<br/>
												<xsl:choose>
													<xsl:when test="$liczbaZarobkowZK = 0">
														<ins>✓</ins>
													</xsl:when>
													<xsl:otherwise>
														&#160;&#160;&#160;
													</xsl:otherwise>
												</xsl:choose>
												2) nie
											</div>
											Czy członek rodziny przebywający w zakładzie karnym jest zatrudniony i czy jego zarobki są przekazywane rodzinie:
										</td>
									</tr>
								</table>
								<table>
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad//ns1:Gospodarstwo/ns1:Osoba">
										<xsl:if test="ns1:ZakladKarny/ns1:Wysokosc">
											<tr>
												<td>wysokość</td>
												<td>
													<ins>
														<xsl:value-of select="format-number(ns1:ZakladKarny/ns1:Wysokosc, '0,00')"/>
													</ins>
													<xsl:text> </xsl:text>
													zł
												</td>
												<td>jak często</td>
												<td>
													<span class="textarea">
														<ins>
															<xsl:value-of select="ns1:ZakladKarny/ns1:Czestotliwosc"/>
														</ins>
													</span>
													<xsl:text> </xsl:text>
													[#<xsl:value-of select="position()"/>]
												</td>
											</tr>
										</xsl:if>
									</xsl:for-each>
								</table>
							</td>
						</tr>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>D. ANALIZA SYTUACJI ZAWODOWEJ</h3>
					<table>
						<thead>
							<tr>
								<th>1</th>
								<th>2</th>
								<th>3</th>
								<th>4</th>
								<th colspan="2">5</th>
								<th>6</th>
								<th colspan="2">7</th>
								<th>8</th>
							</tr>
							<tr>
								<th rowspan="3">Imię i nazwisko</th>
								<th style="width: 20mm;">Zareje-strowany/na w urzędzie pracy</th>
								<th colspan="4">Pobiera zasiłek lub inne świadczenie</th>
								<th colspan="3">Utracił(a) prawo do zasiłku lub innego świadczenia</th>
								<th style="width: 20mm;">Brak prawa do zasiłku lub innego świadczenia</th>
							</tr>
							<tr>
								<th rowspan="2" style="width: 20mm;">1) tak<br/>2) nie</th>
								<th rowspan="2" style="width: 20mm;">1) tak<br/>2) nie</th>
								<th rowspan="2" style="width: auto;">rodzaj i wysokość zasiłku lub innego świadczenia</th>
								<th colspan="2">od kiedy</th>
								<th rowspan="2" style="width: 20mm;">1) tak<br/>2) nie</th>
								<th colspan="2">od kiedy</th>
								<th rowspan="2" style="width: 20mm;">1) tak<br/>2) nie</th>
							</tr>
							<tr>
								<th style="width: 15mm;">mies.</th>
								<th style="width: 15mm;">rok</th>
								<th style="width: 15mm;">mies.</th>
								<th style="width: 15mm;">rok</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
								<xsl:if test="ns1:Bezrobotny">
									<tr>
										<td>
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:variable name="_CzyZarejestrowanyUP" select="ns1:Bezrobotny/ns1:CzyZarejestrowanyUP" />
												<xsl:value-of select="$TakNie[@key = $_CzyZarejestrowanyUP]" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:variable name="_CzyPobieraZasilek" select="ns1:Bezrobotny/ns1:CzyPobieraZasilek" />
												<xsl:value-of select="$TakNie[@key = $_CzyPobieraZasilek]" />
											</ins>
										</td>
										<td>
											<ins>
												<xsl:value-of select="ns1:Bezrobotny/ns1:RodzajZasilku" />
												<xsl:text> </xsl:text>
												<xsl:value-of select="format-number(ns1:Bezrobotny/ns1:WysokoscZasilku, '0,00')" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyZasilek, 6, 2)"/>
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyZasilek, 1, 4)"/>
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:variable name="_CzyUtracilZasilek" select="ns1:Bezrobotny/ns1:CzyUtracilZasilek" />
												<xsl:value-of select="$TakNie[@key = $_CzyUtracilZasilek]" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyUtracilZasilek, 6, 2)"/>
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:Bezrobotny/ns1:OdKiedyUtracilZasilek, 1, 4)"/>
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:variable name="_CzyBrakPrawaDoZasilku" select="ns1:Bezrobotny/ns1:CzyBrakPrawaDoZasilku" />
												<xsl:value-of select="$TakNie[@key = $_CzyBrakPrawaDoZasilku]" />
											</ins>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</tbody>
					</table>
					<table>
						<tr>
							<td>
								Działania aktywizacji społeczno-zawodowej podjęte wobec osoby/rodziny w ciągu ostatniego roku (m.in. instytucja, zakres)<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Bezrobotny/ns1:Aktywizacja">
										<ins style="white-space: normal;">
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
										</ins>
										<xsl:text> </xsl:text>
										[#<xsl:value-of select="position()"/>]
										<span class="textarea" style="display: block;">
											<ins><xsl:value-of select="ns1:Bezrobotny/ns1:Aktywizacja" /></ins>
										</span>
										<hr/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td>
								Kwalifikacje, umiejętności oraz doświadczenie zawodowe, które mają być przydatne przy poszukiwaniu pracy (np. prawo jazdy, uprawnienia do wykonywania określonych prac)<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Bezrobotny/ns1:Kwalifikacja">
										<ins style="white-space: normal;">
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
										</ins>
										<xsl:text> </xsl:text>
										[#<xsl:value-of select="position()"/>]
										<br/>
										<xsl:for-each select="ns1:Bezrobotny/ns1:Kwalifikacja">
											<span>
												<ins><xsl:value-of select="ns1:Rodzaj" /></ins>
											</span>
											<br/>
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Opis" /></ins>
											</span>
											<br/>
										</xsl:for-each>
										<hr/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>E. OGÓLNA ANALIZA SYTUACJI ZDROWOTNEJ</h3>
					<table>
						<tr>
							<td style="width: 6mm" rowspan="2">1</td>
							<td>Liczba osób długotrwale chorych</td>
							<td>Rodzaje schorzeń</td>
						</tr>
						<tr>
							<td style="height: 30mm;">
								razem:
								<ins>
									<xsl:value-of select="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba[./ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie])"/>
								</ins>
								<br/>
								w tym dzieci:
								<ins>
									<xsl:value-of select="count(ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba[./ns1:DanePodstawowe/ns1:CzyDziecko='T'][./ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie])"/>
								</ins>
							</td>
							<td>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie">
										<ins>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
										</ins>
										<xsl:text> </xsl:text>
										[#<xsl:value-of select="position()"/>]
										<br/>
										<xsl:for-each select="ns1:Choroby/ns1:Dlugotrwale/ns1:Schorzenie">
											<ins>
												<xsl:variable name="_RodzajSchorzenia" select="."/>
												- <xsl:call-template name="ns0-enumeracja">
													<xsl:with-param name="nazwa" select="'RodzajSchorzenia'"/>
													<xsl:with-param name="wartosc" select="$_RodzajSchorzenia"/>
												</xsl:call-template>
											</ins>
											<br/>
										</xsl:for-each>
										<br/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm" rowspan="2">2</td>
							<td>Inne problemy zdrowotne podane przez osobę/rodzinę:</td>
						</tr>
						<tr>
							<td style="height: 45mm;">
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Choroby/ns1:DlugotrwaleInne or ns1:Choroby/ns1:DlugotrwaleJeszczeInne">
										<span class="textarea">
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
											</ins>
										</span>
										<xsl:text> </xsl:text>
										[#<xsl:value-of select="position()"/>]
										<span class="textarea">
											<xsl:for-each select="ns1:Choroby/ns1:DlugotrwaleInne/ns1:Problem">
												<br/>
												<ins>
													<xsl:call-template name="ns0-enumeracja">
														<xsl:with-param name="nazwa" select="'ProblemZdrowotny'"/>
														<xsl:with-param name="wartosc" select="current()"/>
													</xsl:call-template>
												</ins>
											</xsl:for-each>
											<xsl:for-each select="ns1:Choroby/ns1:DlugotrwaleJeszczeInne/ns1:Opis">
												<br/><ins><xsl:value-of select="current()" /></ins>
											</xsl:for-each>
										</span>
										<br/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm">3</td>
							<td>Czy osoba/rodzina podlega ubezpieczeniu zdrowotnemu?</td>
							<td>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyUbezpieczenie = 'T'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) tak
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyUbezpieczenie = 'N'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) nie
							</td>
						</tr>
						<tr>
							<td rowspan="2">4</td>
							<td>Czy osoba/rodzina posiada dostęp do świadczeń zdrowotnych?</td>
							<td>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyDostepDoSwiadczen = 'T'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) tak
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:CzyDostepDoSwiadczen = 'N'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) nie
							</td>
						</tr>
						<tr>
							<td style="min-height: 40mm;" colspan="2">
								Jeżeli nie, to dlaczego?<br/>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:PrzyczynyBrakuDostepu" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm">5</td>
							<td style="min-height: 40mm;">
								Dane lekarza podstawowej opieki zdrowotnej (imię, nazwisko, adres miejsca udzielania świadczeń zdrowotnych, telefon):<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:Lekarz">
									<span class="textarea">
										<ins>
											<xsl:value-of select="." />
										</ins>
									</span>
									<xsl:if test="position() != last()"><br/><br/></xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td style="width: 6mm">6</td>
							<td style="min-height: 40mm;">
								Dane pielęgniarki, położnej podstawowej opieki zdrowotnej (imię, nazwisko, adres miejsca udzielania świadczeń zdrowotnych, telefon):<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Zdrowie/ns1:Pielegniarka">
									<span class="textarea">
										<ins>
											<xsl:value-of select="." />
										</ins>
									</span>
									<xsl:if test="position() != last()"><br/></xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h4>F. ANALIZA SYTUACJI OSÓB Z NIEPEŁNOSPRAWNOŚCIAMI</h4>
					<table>
						<thead>
							<tr>
								<th>1</th>
								<th>2</th>
								<th>3</th>
								<th>4</th>
								<th colspan="2">5</th>
								<th colspan="2">6</th>
								<th>7</th>
								<th>8</th>
								<th>9</th>
								<th>10</th>
							</tr>
							<tr>
								<th rowspan="3">Imię i nazwisko</th>
								<th rowspan="3">Rodzaj dysfunkcji</th>
								<th style="width: 20mm;">Ustalona grupa inwalidzka, stopień niepełno­sprawności, niezdolność do samodzielnej egzystencji lub niezdolność do pracy</th>
								<th colspan="4">Orzeczenie o niepełnosprawności</th>
								<th colspan="2">Termin kolejnego badania</th>
								<th colspan="2">Wynik orzeczenia</th>
								<th rowspan="3">Ograniczenia funkcjonalne</th>
							</tr>
							<tr>
								<th rowspan="2">1) tak<br/>2) nie</th>
								<th rowspan="2" style="width: 30mm;">numer</th>
								<th colspan="2">data</th>
								<th rowspan="2">organ<br/>wydający</th>
								<th rowspan="2" style="width: 10mm;">mies.</th>
								<th rowspan="2" style="width: 10mm;">rok</th>
								<th rowspan="2">stopień niepełnosprawności</th>
								<th rowspan="2">wskazania do pracy / brak wskazań</th>
							</tr>
							<tr>
								<th style="width: 10mm;">mies.</th>
								<th style="width: 10mm;">rok</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
								<xsl:variable name="_liczba_orzeczen" select="count(ns1:Niepelnosprawny/ns1:Orzeczenie)" />
								<xsl:variable name="Lp" select="position()" />
								<xsl:if test="ns1:Niepelnosprawny/ns1:Orzeczenie">
									<xsl:for-each select="ns1:Niepelnosprawny/ns1:Orzeczenie">
										<tr>
											<xsl:if test="position() = 1">
												<td>
													<xsl:attribute name="rowspan"><xsl:value-of select="$_liczba_orzeczen" /></xsl:attribute>
													<ins>
														<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Imie1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Imie2"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Nazwisko1"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="../../ns1:DanePodstawowe/ns1:Nazwisko2"/>
													</ins>
													<xsl:text> </xsl:text>
													[#<xsl:value-of select="$Lp"/>]
												</td>
											</xsl:if>
											<td>
												<xsl:for-each select="ns1:Dysfunkcje/ns1:Dysfunkcja">
													<ins>
														<xsl:call-template name="ns0-enumeracja">
															<xsl:with-param name="nazwa" select="'RodzajDysfunkcji'"/>
															<xsl:with-param name="wartosc" select="current()"/>
														</xsl:call-template>
													</ins>
													<br/>
												</xsl:for-each>
											</td>
											<td>
												<ins>
													<xsl:variable name="_CzyGrupaInwalidzka" select="ns1:CzyGrupaInwalidzka" />
													<xsl:variable name="_CzyStopienNiepeln" select="ns1:CzyStopienNiepeln" />
													<xsl:variable name="_CzyNiezdolnoscDoSamEgzyst" select="ns1:CzyNiezdolnoscDoSamEgzyst" />
													<xsl:variable name="_CzyNiezdolnoscDoPracy" select="ns1:CzyNiezdolnoscDoPracy" />
													<xsl:value-of select="$TakNie[@key = $_CzyGrupaInwalidzka]" /><br/>
													<xsl:value-of select="$TakNie[@key = $_CzyStopienNiepeln]" /><br/>
													<xsl:value-of select="$TakNie[@key = $_CzyNiezdolnoscDoSamEgzyst]" /><br/>
													<xsl:value-of select="$TakNie[@key = $_CzyNiezdolnoscDoPracy]" />
												</ins>
											</td>
											<td>
												<ins>
													<xsl:value-of select="ns1:NumerOrzeczenia"/>
												</ins>
											</td>
											<td style="text-align: center;">
												<ins>
													<xsl:value-of select="substring(ns1:DataOrzeczenia, 6, 2)"/>
												</ins>
											</td>
											<td style="text-align: center;">
												<ins>
													<xsl:value-of select="substring(ns1:DataOrzeczenia, 1, 4)"/>
												</ins>
											</td>
											<td>
												<span class="textarea">
													<ins>
														<xsl:call-template name="ns0-enumeracja">
															<xsl:with-param name="nazwa" select="'OrganWydajacy'"/>
															<xsl:with-param name="wartosc" select="ns1:OrganWydajacy"/>
														</xsl:call-template>
													</ins>
												</span>
											</td>
											<td style="text-align: center;">
												<ins>
													<xsl:value-of select="substring(ns1:TerminKolejnegoBadania, 6, 2)"/>
												</ins>
											</td>
											<td style="text-align: center;">
												<ins>
													<xsl:value-of select="substring(ns1:TerminKolejnegoBadania, 1, 4)"/>
												</ins>
											</td>
											<td>
												<ins>
													<xsl:variable name="_StopienNiepeln" select="ns1:StopienNiepeln" />
													<xsl:value-of select="$StopienNiepelnosprawnosci[@key = $_StopienNiepeln]" />
												</ins>
											</td>
											<td>
												<ins>
													<xsl:variable name="_WskazaniaDoPracy" select="ns1:WskazaniaDoPracy" />
													<xsl:value-of select="$ZaleceniaWZakresiePracy[@key = $_WskazaniaDoPracy]" />
												</ins>
											</td>
											<td>
												<span class="textarea">
													<ins><xsl:value-of select="ns1:OgraniczeniaFunkcjonalne"/></ins>
												</span>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>
							</xsl:for-each>
						</tbody>
					</table>
					<p style="page-break-before: always;">&#160;</p>
					<table style="margin-top: 0;">
						<tr>
							<td style="width: 6mm;">1</td>
							<td>
								Która z osób niepełnosprawnych wspólnie zamieszkujących wymaga:<br/>
								1) skierowania do ośrodka wsparcia (rodzaj)<br/>
								<div style="min-height: 10mm;">
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
										<xsl:if test="ns1:Niepelnosprawny/ns1:SkierowanieDoOsrodka">
											<xsl:text>- </xsl:text>
											<ins>
												<xsl:variable name="_SkierowanieDoOsrodka" select="ns1:Niepelnosprawny/ns1:SkierowanieDoOsrodka" />
												<xsl:value-of select="$OsrodekWsparcia[@key = $_SkierowanieDoOsrodka]" />
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
											<br/>
										</xsl:if>
									</xsl:for-each>
								</div>
								2) skierowania do mieszkania chronionego<br/>
								<div style="min-height: 10mm;">
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
										<xsl:if test="ns1:Niepelnosprawny/ns1:SkierowanieDoMieszkania">
											<xsl:text>- </xsl:text>
											<ins>
												<xsl:variable name="_SkierowanieDoMieszkania" select="ns1:Niepelnosprawny/ns1:SkierowanieDoMieszkania" />
												<xsl:value-of select="$MieszkanieChronione[@key = $_SkierowanieDoMieszkania]" />
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
											<br/>
										</xsl:if>
									</xsl:for-each>
								</div>
								3) usług opiekuńczych (zakres)<br/>
								<div style="min-height: 10mm;">
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
										<xsl:if test="ns1:Niepelnosprawny/ns1:UslugiOpiekuncze">
											<xsl:text>- </xsl:text>
											<span class="textarea">
												<ins>
													<xsl:value-of select="ns1:Niepelnosprawny/ns1:UslugiOpiekuncze" />
												</ins>
												<xsl:text> </xsl:text>
												[#<xsl:value-of select="position()"/>]
											</span>
											<br/>
										</xsl:if>
									</xsl:for-each>
								</div>
								4) umieszczenia w domu pomocy społecznej
								<div style="min-height: 10mm;">
									<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
										<xsl:if test="ns1:Niepelnosprawny/ns1:DomPomocy[text() = 'T']">
											<xsl:text>- </xsl:text>
											<ins>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Imie2"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko1"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="ns1:DanePodstawowe/ns1:Nazwisko2"/>
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
											<br/>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td style="height: 20mm;">
								Możliwość zapewnienia pomocy ze strony rodziny (forma i zakres pomocy. Jeżeli nie, wpisać dlaczego:<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Niepelnosprawny/ns1:PomocRodziny">
										<xsl:text>- </xsl:text>
										<span class="textarea">
											<ins>
												<xsl:value-of select="ns1:Niepelnosprawny/ns1:PomocRodziny" />
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
										</span>
										<br/>
									</xsl:if>
									<xsl:if test="ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyRodziny">
										<xsl:text>- </xsl:text>
										<span class="textarea">
											<ins>
												<xsl:value-of select="ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyRodziny" />
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
										</span>
										<br/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td>3</td>
							<td style="height: 20mm;">
								Możliwość zapewnienia pomocy ze strony jednostek organizacyjnych pomocy społecznej gminy i powiatu (forma i zakres pomocy).
							 	Jeżeli nie, wpisać dlaczego:<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Niepelnosprawny/ns1:PomocJOPS">
										<xsl:text>- </xsl:text>
										<span class="textarea">
											<ins>
												<xsl:value-of select="ns1:Niepelnosprawny/ns1:PomocJOPS" />
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
										</span>
										<br/>
									</xsl:if>
									<xsl:if test="ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyJOPS">
										<xsl:text>- </xsl:text>
										<span class="textarea">
											<ins>
												<xsl:value-of select="ns1:Niepelnosprawny/ns1:PrzyczynyBrakuPomocyJOPS" />
											</ins>
											<xsl:text> </xsl:text>
											[#<xsl:value-of select="position()"/>]
										</span>
										<br/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td>4</td>
							<td style="height: 15mm;">
								Stan zaopatrzenia w wyroby medyczne oraz potrzeby w tym zakresie:<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Niepelnosprawny/ns1:StanZaopatrzeniaMieszkania">
										<xsl:text>- </xsl:text>
										<xsl:if test="ns1:Niepelnosprawny/ns1:StanZaopatrzeniaMieszkania">
											<ins>
												<xsl:call-template name="ns0-enumeracja">
													<xsl:with-param name="nazwa" select="'StanZaopatrzeniaMieszkania'"/>
													<xsl:with-param name="wartosc" select="ns1:Niepelnosprawny/ns1:StanZaopatrzeniaMieszkania"/>
												</xsl:call-template>
											</ins>
										</xsl:if>
										[#<xsl:value-of select="position()"/>]
										<xsl:if test="ns1:Niepelnosprawny/ns1:StanZaopatrzeniaMieszkaniaOpis">
											<span class="textarea" style="display: block; padding-left: 3mm;">
												<ins>
													<xsl:value-of select="ns1:Niepelnosprawny/ns1:StanZaopatrzeniaMieszkaniaOpis" />
												</ins>
											</span>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td>5</td>
							<td style="height: 15mm;">
								Stan dostosowania mieszkania do potrzeb osób niepełnosprawnych:<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Niepelnosprawny/ns1:StanDostosowaniaMieszkania">
										<xsl:text>- </xsl:text>
										<xsl:if test="ns1:Niepelnosprawny/ns1:StanDostosowaniaMieszkania">
											<ins>
												<xsl:call-template name="ns0-enumeracja">
													<xsl:with-param name="nazwa" select="'StanDostosowaniaMieszkania'"/>
													<xsl:with-param name="wartosc" select="ns1:Niepelnosprawny/ns1:StanDostosowaniaMieszkania"/>
												</xsl:call-template>
											</ins>
										</xsl:if>
										[#<xsl:value-of select="position()"/>]
										<xsl:if test="ns1:Niepelnosprawny/ns1:StanDostosowaniaMieszkaniaOpis">
											<span class="textarea" style="display: block; padding-left: 3mm;">
												<ins>
													<xsl:value-of select="ns1:Niepelnosprawny/ns1:StanDostosowaniaMieszkaniaOpis" />
												</ins>
											</span>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table>
						<tr>
							<td style="width: 6mm;">6</td>
							<td style="height: 20mm;">
								Która z osób wymienionych wspólnie zamieszkujących jest ubezwłasnowolniona:<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Ubezwlasnowolnienie/ns1:Rodzaj and ns1:Ubezwlasnowolnienie/ns1:Rodzaj != '01'">
										<xsl:text>- </xsl:text>
										<ins>
											<xsl:variable name="_Rodzaj" select="ns1:Ubezwlasnowolnienie/ns1:Rodzaj" />
											<xsl:value-of select="$StatusPrawny[@key = $_Rodzaj]" />
										</ins>
										<xsl:text> </xsl:text>
										[#<xsl:value-of select="position()"/>]
										<br/>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td>
								Dane opiekuna prawnego (imię, nazwisko, adres, telefon):<br/>
								<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
									<xsl:if test="ns1:Ubezwlasnowolnienie/ns1:Rodzaj = '02'">
										<ins>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:Imie1" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:Imie2" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:Nazwisko1" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:Nazwisko2" />
											<br/>
											Nr PESEL: <xsl:value-of select="ns1:OpiekunPrawny/ns1:PESEL" />
											<br/>
											Nr dok.: <xsl:value-of select="ns1:OpiekunPrawny/ns1:NumerDokumentu" />
											<br/>
											Adres:
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:KodPocztowy"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Miejscowosc"/>
											<xsl:if test="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Ulica != '' or ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrDomu != '' or ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrLok != ''">
												<xsl:text>, </xsl:text>
											</xsl:if>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:Ulica"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrDomu"/>
											<xsl:if test="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrLok != ''">
												<xsl:text> </xsl:text>
												m. <xsl:value-of select="ns1:OpiekunPrawny/ns1:AdresZamieszkania/ns1:NrLok"/>
											</xsl:if>
											<br/>
										</ins>
										opiekun prawny dla [#<xsl:value-of select="position()"/>]
									</xsl:if>
									<xsl:if test="ns1:Ubezwlasnowolnienie/ns1:Rodzaj = '03'">
										<ins>
											Imię i nazwisko:
											<xsl:value-of select="ns1:Kurator/ns1:Imie1" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:Kurator/ns1:Imie2" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:Kurator/ns1:Nazwisko1" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:Kurator/ns1:Nazwisko2" />
											<br/>
											Adres:
											<xsl:value-of select="ns1:Kurator/ns1:AdresZamieszkania/ns1:KodPocztowy"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:Kurator/ns1:AdresZamieszkania/ns1:Miejscowosc"/>
											<xsl:if test="ns1:Kurator/ns1:AdresZamieszkania/ns1:Ulica != '' or ns1:Kurator/ns1:AdresZamieszkania/ns1:NrDomu != '' or ns1:Kurator/ns1:AdresZamieszkania/ns1:NrLok != ''">
												<xsl:text>, </xsl:text>
											</xsl:if>
											<xsl:value-of select="ns1:Kurator/ns1:AdresZamieszkania/ns1:Ulica"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="ns1:Kurator/ns1:AdresZamieszkania/ns1:NrDomu"/>
											<xsl:if test="ns1:Kurator/ns1:AdresZamieszkania/ns1:NrLok != ''">
												<xsl:text> </xsl:text>
												m. <xsl:value-of select="ns1:Kurator/ns1:AdresZamieszkania/ns1:NrLok"/>
											</xsl:if>
											<br/>
											Telefon:
											<xsl:value-of select="ns1:Kurator/ns1:AdresZamieszkania/ns1:Telefon"/>
											<br/>
										</ins>
										kurator dla [#<xsl:value-of select="position()"/>]
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>G. ANALIZA SYTUACJI OSOB Z SYMPTOMAMI UŻYWANIA SUBSTANCJI PSYCHOAKTYWNYCH I/LUB UZALEŻNIEŃ BEHAWIORALNYCH</h3>
					<table>
						<thead>
							<tr>
								<th>1</th>
								<th>2</th>
								<th colspan="3">3</th>
								<th>4</th>
								<th>5</th>
							</tr>
							<tr>
								<th rowspan="4">Imię i nazwisko</th>
								<th rowspan="4">Rodzaj i stopień uzależnienia</th>
								<th colspan="4">Czy podjęto leczenie odwykowe?</th>
								<th rowspan="4">Uwagi</th>
							</tr>
							<tr>
								<th colspan="3">Tak</th>
								<th>Nie</th>
							</tr>
							<tr>
								<th colspan="2">Kiedy?</th>
								<th rowspan="2">Rezultaty leczenia</th>
								<th rowspan="2">Przyczyny</th>
							</tr>
							<tr>
								<th style="width: 10mm;">miesiąc</th>
								<th style="width: 10mm;">rok</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Gospodarstwo/ns1:Osoba">
								<xsl:variable name="Osoba" select="." />
								<xsl:variable name="Lp" select="position()" />
								<xsl:for-each select="ns1:Uzaleznienie">
									<tr>
										<xsl:if test="position() = 1">
											<xsl:element name="td">
												<xsl:attribute name="rowspan">
													<xsl:value-of select="count($Osoba/ns1:Uzaleznienie)"/>
												</xsl:attribute>
												<ins>
													<xsl:value-of select="$Osoba/ns1:DanePodstawowe/ns1:Imie1"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$Osoba/ns1:DanePodstawowe/ns1:Imie2"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$Osoba/ns1:DanePodstawowe/ns1:Nazwisko1"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$Osoba/ns1:DanePodstawowe/ns1:Nazwisko2"/>
												</ins>
												<xsl:text> </xsl:text>
												[#<xsl:value-of select="$Lp"/>]
											</xsl:element>
										</xsl:if>
										<td>
											<xsl:variable name="_Rodzaj" select="ns1:Rodzaj" />
											<ins>
												<xsl:value-of select="$RodzajUzaleznienia[@key = $_Rodzaj]" />
											</ins>
											<xsl:text>; </xsl:text>
											<ins>
												<xsl:value-of select="ns1:Stopien" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:CzyPodjetoLeczenie/ns1:Tak/ns1:KiedyLeczenie, 6, 2)" />
											</ins>
										</td>
										<td style="text-align: center;">
											<ins>
												<xsl:value-of select="substring(ns1:CzyPodjetoLeczenie/ns1:Tak/ns1:KiedyLeczenie, 1, 4)" />
											</ins>
										</td>
										<td>
											<span class="textarea">
												<ins>
													<xsl:call-template name="ns0-enumeracja">
														<xsl:with-param name="nazwa" select="'RezultatyLeczenia'"/>
														<xsl:with-param name="wartosc" select="ns1:CzyPodjetoLeczenie/ns1:Tak/ns1:RezultatyLeczenia"/>
													</xsl:call-template>
												</ins>
											</span>
										</td>
										<td>
											<span class="textarea">
												<ins>
													<xsl:call-template name="ns0-enumeracja">
														<xsl:with-param name="nazwa" select="'PrzyczynyBrakuLeczenia'"/>
														<xsl:with-param name="wartosc" select="ns1:CzyPodjetoLeczenie/ns1:Nie/ns1:PrzyczynyBrakuLeczenia"/>
													</xsl:call-template>
												</ins>
											</span>
										</td>
										<td>
											<span class="textarea">
												<ins><xsl:value-of select="ns1:Uwagi" /></ins>
											</span>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:for-each>
						</tbody>
					</table>
				</section>
				<section style="page-break-before: always;">
					<h3>H. POTRZEBY I OCZEKIWANIA OSOBY LUB RODZINY ZGŁOSZONE PODCZAS PRZEPROWADZANIA WYWIADU</h3>
					<div class="textarea" style="min-height: 70mm;">
						<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:Potrzeby" /></ins>
					</div>
					<br/>
					<span style="float: left;">Data zgłoszenia:</span>
					<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataZgloszenia" /></ins></span>
					<br/>
					<span style="float: left;">Data przeprowadzenia wywiadu:</span>
					<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:DataWywiadu" /></ins></span>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego przeprowadzającego wywiad:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br style="clear: both;"/>
							<br/>
							<br/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:Wywiad/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br/>
							<br/><br/>
							Oświadczam, że podane wyżej informacje są zgodne z prawdą.
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.5cm;">(data i podpis osoby, z którą przeprowadzono wywiad)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					Informacja o warunkach bezpieczeństwa podczas przeprowadzania wywiadu:
					<table>
						<tbody>
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyDrugiPracownik/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									1) uczestnictwo drugiego pracownika socjalnego
									<br/>
									<xsl:choose>
										<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzyAsystaPolicji/text() = 'T'">
											<ins>✓</ins>
										</xsl:when>
										<xsl:otherwise>
											&#160;&#160;&#160;
										</xsl:otherwise>
									</xsl:choose>
									2) asysta funkcjonariusza Policji
								</td>
								<td>
									<table>
										<tbody>
											<tr>
												<td width="50%" style="border-right: 0px none;">
													Czy wystąpiły sytuacje
													<br/>zagrożenia podczas
													<br/>przeprowadzania wywiadu?
												</td>
												<td style="border-left: 0px none;">
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'T'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													1) tak - wskazać jakie:
													<br/>
													<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:SytuacjeZagrozenia/ns1:SytuacjaZagrozenia">
														<ins style="display: block; padding-left: 8mm;">
															<xsl:call-template name="ns0-enumeracja">
																<xsl:with-param name="nazwa" select="'Zagrozenie'"/>
																<xsl:with-param name="wartosc" select="current()"/>
															</xsl:call-template>
														</ins>
													</xsl:for-each>
													<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:Uwagi">
														<span class="textarea" style="display: block; padding-left: 8mm;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:Uwagi"/></ins></span>
													</xsl:if>
													<br/>
													<br/>
													<xsl:choose>
														<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOWarunkachBezpieczenstwa/ns1:CzySytuacjeZagrozenia/text() = 'N'">
															<ins>✓</ins>
														</xsl:when>
														<xsl:otherwise>
															&#160;&#160;&#160;
														</xsl:otherwise>
													</xsl:choose>
													2) nie
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<br/><br/>
					Informacja o zgłaszającym problem*:
					<table>
						<tr>
							<td>1</td>
							<td>
								Z urzędu – zgłoszenie:
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOZglaszajacymProblem/ns1:ZgloszenieZUrzedu/ns1:KtoZglasza = '01'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) pracownika socjalnego,
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOZglaszajacymProblem/ns1:ZgloszenieZUrzedu/ns1:KtoZglasza = '02'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) instytucji lub organizacji (nazwa, adres, telefon)
							</td>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOZglaszajacymProblem/ns1:ZgloszenieZUrzedu/ns1:Opis" /></ins>
								</span>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>
								Na wniosek:
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOZglaszajacymProblem/ns1:ZgloszenieNaWniosek/ns1:KtoZglasza = '01'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) osoby obcej,
								<br/>
								<xsl:choose>
									<xsl:when test="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOZglaszajacymProblem/ns1:ZgloszenieNaWniosek/ns1:KtoZglasza = '02'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) członka rodziny
								<br/>
								<br/>
								Imię, nazwisko, adres i telefon oraz stopień
								pokrewieństwa z osobą potrzebującą pomocy**
							</td>
							<td>
								<span class="textarea">
									<ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:InformacjeOZglaszajacymProblem/ns1:ZgloszenieNaWniosek/ns1:Opis" /></ins>
								</span>
							</td>
						</tr>
					</table>
					<br/>
					<small>* W przypadku gdy problem zgłasza osoba zainteresowana, nie wypełnia się.</small>
					<br/>
					<small>** Wypełnia się za zgodą osoby zgłaszającej.</small>
				</section>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby">
				<section style="page-break-before: always;">
					<h3>I. DIAGNOZA SYTUACJI OSOBY LUB RODZINY I WNIOSKI PRACOWNIKA SOCJALNEGO</h3>
					<table>
						<tr>
							<td colspan="2">Zasadność udzielania pomocy</td>
						</tr>
						<tr>
							<td style="width: 60mm; padding-left: 4mm;">
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '010'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								1) ubóstwo
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '020'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								2) sieroctwo
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '030'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								3) bezdomność
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '050'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								4) bezrobocie
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '060'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								5) niepełnosprawność
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '070X'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								6) długotrwała lub ciężka choroba
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '150'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								7) przemoc w rodzinie
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '180'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								8) potrzeba ochrony ofiar handlu ludźmi
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '042'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								9a) potrzeba ochrony macierzyństwa
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '043x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								9b) potrzeba ochrony wielodzietności
							</td>
							<td style="width: 60mm; padding-left: 4mm;">
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '080'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								10) bezradność w sprawach opiekuńczo-wychowawczych i w prowadzeniu gospodarstwa domowego
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '081x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								&#160;&#160;a) rodzina niepełna
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '082x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								&#160;&#160;b) rodzina wielodzietna
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '170x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								11) trudności w integracji osób, które otrzymały status uchodźcy lub ochronę uzupełniającą
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '110X'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								12) trudności w przystosowaniu do życia po opuszczeniu zakładu karnego
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '090'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								13a) alkoholizm
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '100'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								13b) narkomania
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '132'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								14) sytuacja kryzysowa
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '120x'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								15) klęska ekologiczna
								<br/>
								<xsl:choose>
									<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Przyczyny/ns1:Przyczyna = '131'">
										<ins>✓</ins>
									</xsl:when>
									<xsl:otherwise>
										&#160;&#160;&#160;
									</xsl:otherwise>
								</xsl:choose>
								16) zdarzenie losowe
							</td>
						</tr>
					</table>
					<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:WnioskiOcena">
						<br/>
						<br/>
						<h3>Wnioski i ocena:</h3>
						<div class="textarea" style="min-height: 40mm;">
							<ins>
								<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:WnioskiOcena"/>
							</ins>
						</div>
					</xsl:if>
					<h3>Dodatkowe informacje:</h3>
					<div class="textarea" style="min-height: 40mm;">
						<xsl:if test="/ns1:Dokument/ns1:Zalaczniki//wis-r:DodatkoweInformacje">
							<xsl:apply-templates select="/ns1:Dokument/ns1:Zalaczniki//wis-r:DodatkoweInformacje"/>
							<br/>
						</xsl:if>
						<ins>
							<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:DodatkoweInformacje"/>
						</ins>
					</div>
					<span style="float: left;">Miejscowość:</span>
					<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Miejscowosc" /></ins></span>
					<br/>
					<span style="float: left;">Data:</span>
					<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:Data" /></ins></span>
					<xsl:choose>
						<xsl:when test="$Suma">
							<br style="clear: both;"/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:DiagnozaSytuacjiOsoby/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
				</section>
			</xsl:if>

			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan">
				<section style="page-break-before: always;">
					<h3>J. PLAN POMOCY I DZIAŁAŃ NA RZECZ OSOBY LUB RODZINY</h3>
					<table>
						<tr>
							<td style="width: 6mm;">1</td>
							<td>Łączny dochód w rodzinie (zgodnie z art. 8 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="width: 60mm; text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:LacznyDochodWRodzinie">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:LacznyDochodWRodzinie, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>2</td>
							<td>Dochód na osobę w rodzinie</td>
							<td style="text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:DochodNaOsobe">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:DochodNaOsobe, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>3</td>
							<td>Kryterium dochodowe dla danej osoby/rodziny (wynikające z art. 8 ust. 1 lub 2 ustawy z dnia 12 marca 2004 r. o pomocy społecznej)</td>
							<td style="text-align: right;">
								<xsl:if test="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:KryteriumDochodowe">
									<ins>
										<xsl:value-of select="format-number(ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:KryteriumDochodowe, '0,00')" />
									</ins>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td>4</td>
							<td colspan="2">Formy i zakres proponowanej pomocy</td>
						</tr>
					</table>
					<xsl:for-each select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy">
						<xsl:variable name="osoba-ze-skladu-klucz" select="ns1:Osoba"/>
						<xsl:variable name="osoba-ze-skladu" select="key('osobyWgId', $osoba-ze-skladu-klucz)"/>
						<table>
							<thead>
								<tr>
									<th colspan="5">
										<ins>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie1" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie2" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko2" />
										</ins>
										<xsl:text> </xsl:text>
										(Świadczenia)
									</th>
								</tr>
								<tr>
									<th>rodzaj i zakres</th>
									<th>okres</th>
									<th>plan</th>
									<th style="width: 60mm;">źródło finansowania</th>
									<th>procent należności</th>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="./ns1:ProponowanaPomoc">
									<tr>
										<td>
											<ins><xsl:value-of select="ns0:Rodzaj/ns0:RodzajSwiadczenia/slo:Opis" /></ins>
											<ins><xsl:value-of select="ns0:Rodzaj/ns0:RodzajSwiadczeniaPozaustawowego/slo:Opis" /></ins>
											<xsl:if test="ns0:Posilek/ns0:TypPosilku">
												<br/>
												<xsl:variable name="_TypPosilku" select="ns0:Posilek/ns0:TypPosilku" />
												<ins><xsl:value-of select="$TypPosilku[@key = $_TypPosilku]" /></ins>
											</xsl:if>
											<xsl:if test="ns0:Teleopieka and ns0:Teleopieka/ns0:RodzajUrzadzenia">
												<br/>
												<ins>
													Teleopieka
													<xsl:for-each select="ns0:Teleopieka/ns0:RodzajUrzadzenia">
														<xsl:variable name="_RodzajUrzadzenia" select="current()" /><xsl:if test="position() = 1"><xsl:text>: </xsl:text></xsl:if><xsl:value-of select="$RodzajUrzadzenia[@key = $_RodzajUrzadzenia]" /><xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
													</xsl:for-each>
												</ins>
											</xsl:if>
											<xsl:if test="ns0:Uwagi">
												<br/><br/><small><span class="textarea"><ins><xsl:value-of select="ns0:Uwagi"/></ins></span></small>
											</xsl:if>
										</td>
										<td>
											<ins>
												od <xsl:choose><xsl:when test="ns0:Okres/ns0:DataOd"><xsl:value-of select="ns0:Okres/ns0:DataOd"/></xsl:when><xsl:otherwise>____-__-__</xsl:otherwise></xsl:choose>
												<br/>do <xsl:choose><xsl:when test="ns0:Okres/ns0:DataDo"><xsl:value-of select="ns0:Okres/ns0:DataDo"/></xsl:when><xsl:otherwise>____-__-__</xsl:otherwise></xsl:choose>
											</ins>
										</td>
										<td>
											<ins>
												<xsl:choose><xsl:when test="ns0:Plan/ns0:Licznik"><xsl:value-of select="ns0:Plan/ns0:Licznik"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose>/<xsl:choose><xsl:when test="ns0:Plan/ns0:Mianownik"><xsl:value-of select="ns0:Plan/ns0:Mianownik"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose>
												<xsl:if test="ns0:Plan/ns0:Szczegoly">
													<br/><xsl:value-of select="ns0:Plan/ns0:Szczegoly"/>
												</xsl:if>
												<br/>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Poniedzialek = 'true'">pn<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Wtorek = 'true'">wt<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Sroda = 'true'">śr<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Czwartek = 'true'">czw<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Piatek = 'true'">pt<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Sobota = 'true'">sb<xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Niedziela = 'true'">ndz</xsl:if>
												<xsl:if test="ns0:Plan/ns0:DniTygodnia/ns0:Poniedzialek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Wtorek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Sroda = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Czwartek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Piatek = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Sobota = 'false' and ns0:Plan/ns0:DniTygodnia/ns0:Niedziela = 'false'">---</xsl:if>
	
												<xsl:if test="ns0:Plan/ns0:DniSwiateczne = 'true'"><br/>w dni świąteczne</xsl:if>
											</ins>
										</td>
										<td>
											<ins>
												<xsl:variable name="_ZrodloFinansowania" select="ns0:ZrodloFinansowania" />
												<xsl:value-of select="$ZrodloFinansowania[@key = $_ZrodloFinansowania]" />
												<xsl:if test="ns0:Kwota">
													<br/><xsl:value-of select="format-number(ns0:Kwota, '0,00')" />
												</xsl:if>
											</ins>
										</td>
										<td style="text-align: right;">
											<ins>
												<xsl:value-of select="ns0:ProcentNaleznosci" />
											</ins>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
						<xsl:if test="./ns1:InnaFormaWsparcia">
							<br/>
							<ins>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie1" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie2" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko2" />
								<xsl:text> </xsl:text>
								(Inne formy wsparcia)
							</ins>
							<table>
								<xsl:for-each select="./ns1:InnaFormaWsparcia">
									<tr>
										<td>
											<ins>
												<xsl:variable name="_InnaFormaWsparcia" select="current()" />
												<xsl:value-of select="$InnaFormaWsparcia[@key = $_InnaFormaWsparcia]" />
											</ins>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:if>
						<xsl:if test="./ns1:Opis">
							<br/>
							<ins>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie1" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Imie2" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko" />
								<xsl:text> </xsl:text>
								<xsl:value-of select="$osoba-ze-skladu/ns1:DanePodstawowe/ns1:Nazwisko2" />
							</ins>
							<div class="textarea" style="min-height: 50mm;">
								<ins>
									<xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:FormyIZakresPomocy/ns1:Opis" />
								</ins>
							</div>
						</xsl:if>
					</xsl:for-each>
					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Miejscowość:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Miejscowosc" /></ins></span>
							<br/>
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko pracownika socjalnego:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Miejscowosc" />
									<xsl:text>, </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:PlanPomocyIDzialan/ns1:PracownikSocjalny/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: left; border-top: 1px solid black; margin-top: 0.2cm;">(miejscowość i data)</span>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć pracownika socjalnego)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
			<xsl:if test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika">
				<section style="page-break-before: always;">
					<h3>Uwagi kierownika jednostki organizacyjnej pomocy społecznej</h3>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_W_CALOSCI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					1) zatwierdzam plan w całości
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ZATWIERDZENIE_Z_ZASTRZEZENIAMI'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					2) zatwierdzam plan z następującymi zastrzeżeniami:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:ZastrzezeniaDoPlanuPomocy" /></ins>
					</div>
					<br/>
					<xsl:choose>
						<xsl:when test="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:SposobZatwierdzeniaPlanuPomocy = 'ODRZUCENIE'">
							<ins>✓</ins>
						</xsl:when>
						<xsl:otherwise>
							&#160;&#160;&#160;
						</xsl:otherwise>
					</xsl:choose>
					3) odrzuca plan ze względu na:
					<br/>
					<div class="textarea" style="min-height: 90mm;">
						<ins><xsl:value-of select="/ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:PowodOdrzuceniaPlanuPomocy" /></ins>
					</div>
					<br/>

					<xsl:choose>
						<xsl:when test="$Suma">
							<span style="float: left;">Data:</span>
							<span style="float: right;"><ins><xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" /></ins></span>
							<br/>
							<span style="float: left;">Imię i nazwisko kierownika:</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<br style="clear: both;"/>
							<span style="float: left;">
								Data
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Data" />
								</ins>
							</span>
							<span style="float: right;">
								<ins>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Imie" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="ns1:Dokument/ns1:TrescDokumentu/ns1:UwagiKierownika/ns1:Kierownik/ns0:Nazwisko" />
								</ins>
							</span>
							<br style="clear: both;"/>
							<span style="float: right; border-top: 1px solid black; margin-top: 0.2cm;">(podpis i pieczęć kierownika)</span>
							<br style="clear: both;"/>
						</xsl:otherwise>
					</xsl:choose>
				</section>
			</xsl:if>
				<br/>
				<footer>
					<xsl:if test="$Suma">
						<xsl:variable name="Cyfry" select="translate($Suma, '-', '')" />
						🔒
						<span>
							<xsl:value-of select="substring($Cyfry,  0 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  4 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry,  8 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 12 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 16 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 20 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 24 + 1, 4)" />
							<xsl:text>-</xsl:text>
							<xsl:value-of select="substring($Cyfry, 28 + 1, 4)" />
						</span>
					</xsl:if>
				</footer>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="ns0-enumeracja">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of select="$ns0-e//xsd:simpleType[@name=$nazwa]//xsd:enumeration[@value = $wartosc]//xsd:documentation" />
	</xsl:template>
</xsl:stylesheet>
