package pl.gov.du.r2021r3.poz893.wywiad.cz3i4;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_SINGLETON;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import pl.gov.du.r2021r3.poz893.wywiad.cz3i4.Dokument.TrescDokumentu.PlanPomocyIDzialan;
import pl.gov.du.r2021r3.poz893.wywiad.cz3i4.Dokument.TrescDokumentu.PlanPomocyIDzialan.FormyIZakresPomocy;
import pl.gov.du.r2021r3.poz893.wywiad.wspolne.ProponowanaPomoc;
import pl.topteam.otm.utils.Processor;

/**
 * DOKŁADNA KOPIA z projektu otm
 * @author michal
 */

@Service
@Scope(SCOPE_SINGLETON)
public class Expander {
	@Autowired
	private pl.gov.du.r2021r3.poz893.wywiad.wspolne.Expander expander;

	public Dokument expand(Dokument dokument) {
		Processor.expand(dokument);
		expander.expand(dokument.getDaneDokumentu());
		expander.expand(dokument.getTrescDokumentu().getWywiad().getPracownikSocjalny());
		expander.expand(dokument.getTrescDokumentu().getDiagnozaSytuacjiOsoby().getPracownikSocjalny());
		expand(dokument.getTrescDokumentu().getPlanPomocyIDzialan());
		expander.expand(dokument.getTrescDokumentu().getUwagiKierownika().getKierownik());
		return dokument;
	}

	private PlanPomocyIDzialan expand(PlanPomocyIDzialan planPomocyIDzialan) {
		expand(planPomocyIDzialan.getFormyIZakresPomocy());
		expander.expand(planPomocyIDzialan.getPracownikSocjalny());
		return planPomocyIDzialan;
	}

	private void expand(FormyIZakresPomocy formyIZakresPomocy) {
		for (ProponowanaPomoc proponowanaPomoc : formyIZakresPomocy.getProponowanaPomoc()) {
			Processor.expand(proponowanaPomoc);
		}
	}
}
