package pl.gov.du.r2021r3.poz893.wywiad.wspolne;

import static com.google.common.base.Strings.nullToEmpty;
import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_SINGLETON;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

/**
 * DOKŁADNA KOPIA z projektu otm
 * @author michal
 */

@Service
@Scope(SCOPE_SINGLETON)
public class Expander {
	public DaneDokumentuTyp expand(DaneDokumentuTyp daneDokumentu) {
		DaneDokumentuTyp.Tytul tytul = daneDokumentu.getTytul();
		if (tytul.getNazwa() == null) {
			tytul.setNazwa("");
		}
		if (daneDokumentu.getStatus() == null) {
			daneDokumentu.setStatus(Status.B);
		}
		return daneDokumentu;
	}

	public PracownikTyp expand(PracownikTyp pracownik) {
		pracownik.setImie(nullToEmpty(pracownik.getImie()));
		pracownik.setNazwisko(nullToEmpty(pracownik.getNazwisko()));
		return pracownik;
	}
}
