<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xs="http://www.w3.org/2001/XMLSchema"
				xmlns:wis-m="http://top-team.pl/otm/wis/v20221101/metryczka"
				xmlns:wis-p="http://top-team.pl/otm/wis/v20221101/profile">

	<xsl:variable name="wis-e" select="document('../enumeracje/enumeracje.xsd')"/>
	<xsl:variable name="wis-ek" select="document('../kwestionariusz/kwestionariusz.xsd')"/>
	<xsl:variable name="wis-ep" select="document('profile.xsd')"/>

	<xsl:template match="/">
		<html>
			<head>
				<meta charset="utf-8"/>
				<style>
					<xsl:value-of select="document('../../../css/reset.html')/html/head/style"/>
				</style>
				<style>
					<xsl:value-of select="document('../../../css/styles.html')/html/head/style"/>
				</style>
			</head>
			<body>
				<xsl:apply-templates select="//wis-p:ProfilOdbiorcyUslugOpiekunczych"/>
				<xsl:apply-templates select="//wis-p:ProfilOdbiorcyUslugTeleopiekunczych"/>
				<xsl:apply-templates select="//wis-p:ProfilOdbiorcyPosilkow"/>
				<xsl:if test="not(//wis-p:ProfilOdbiorcyUslugOpiekunczych) and not(//wis-p:ProfilOdbiorcyUslugTeleopiekunczych) and not(//wis-p:ProfilOdbiorcyPosilkow)">
					<div class="text-warning">NIE ZNALEZIONO UZUPEŁNIONEGO PROFILU ODBIORCY</div>
				</xsl:if>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="wis-m:Metryczka">
		<xsl:text> </xsl:text>
		z dnia
		<ins><xsl:value-of select="wis-m:data"/></ins>
		<xsl:text> </xsl:text>
		dla
		<xsl:text> </xsl:text>
		<ins>
			<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Nazwisko1"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Nazwisko2"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Imie1"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Imie2"/>
		</ins>
	</xsl:template>
	<xsl:template match="wis-p:ProfilOdbiorcyUslugOpiekunczych">
		<br/>
		<table>
			<tr>
				<td colspan="5">
					Rekomendowane usługi opiekuńcze/specjalistyczne usługi opiekuńcze
					<xsl:if test="../wis-m:Metryczka">
						<xsl:apply-templates select="../wis-m:Metryczka"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
			<td>Opis</td>
				<td colspan="4">
					<xsl:value-of select="wis-p:opis"/>
				</td>
			</tr>
			<tr>
				<td>Sprawność fizyczna</td>
				<td colspan="4">
					<xsl:value-of select="wis-p:sprawnoscFizyczna"/>
				</td>
			</tr>
			<tr>
				<td>Sprawność intelektualna</td>
				<td colspan="4">
					<xsl:value-of select="wis-p:sprawnoscIntelektualna"/>
				</td>
			</tr>
			<tr>
				<td rowspan="2">Wymiar rekomendowanych usług</td>
				<td colspan="2">Tygodniowo</td>
				<td colspan="2">Miesięcznie</td>
			</tr>
			<tr>
				<td>min.</td>
				<td>max.</td>
				<td>min.</td>
				<td>max.</td>
			</tr>
			<tr>
				<td>usługi opiekuńcze</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:ogolne/wis-p:tygodniowo/wis-p:minimum"/>
				</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:ogolne/wis-p:tygodniowo/wis-p:maksimum"/>
				</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:ogolne/wis-p:miesiecznie/wis-p:minimum"/>
				</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:ogolne/wis-p:miesiecznie/wis-p:maksimum"/>
				</td>
			</tr>
			<tr>
				<td>specjalistyczne usługi opiekuńcze</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:specjalistyczne/wis-p:tygodniowo/wis-p:minimum"/>
				</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:specjalistyczne/wis-p:tygodniowo/wis-p:maksimum"/>
				</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:specjalistyczne/wis-p:miesiecznie/wis-p:minimum"/>
				</td>
				<td>
					<xsl:value-of
							select="wis-p:rekomendowaneUslugiOpiekuncze/wis-p:specjalistyczne/wis-p:miesiecznie/wis-p:maksimum"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="wis-p:ProfilOdbiorcyUslugTeleopiekunczych">
		<br/>
		<table>
			<tr>
				<td colspan="2">
					Rekomendowane urządzenia teleopieki
					<xsl:if test="../wis-m:Metryczka">
						<xsl:apply-templates select="../wis-m:Metryczka"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td>Opis</td>
				<td>
					<xsl:value-of select="wis-p:opis"/>
				</td>
			</tr>
			<tr>
				<td>Tryb życia</td>
				<td>
					<xsl:call-template name="kwestionariusz">
						<xsl:with-param name="nazwa" select="'TrybZycia'"/>
						<xsl:with-param name="wartosc" select="wis-p:trybZycia"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Stopień niesamodzielności ruchowej</td>
				<td>
					<xsl:value-of select="wis-p:stopienNiesamodzielnosciRuchowej"/>
				</td>
			</tr>
			<tr>
				<td>Stopień niesamodzielności poznawczej</td>
				<td>
					<xsl:value-of select="wis-p:stopienNiesamodzielnosciPoznawczej"/>
				</td>
			</tr>
			<tr>
				<td>Rekomendowane urządzenia</td>
				<td>
					<xsl:for-each select="wis-p:rekomendowaneUrzadzenia">
						<xsl:call-template name="enumeracje">
							<xsl:with-param name="nazwa" select="'RodzajUrzadzenia'"/>
							<xsl:with-param name="wartosc" select="current()"/>
						</xsl:call-template>
						<xsl:if test="position() != last()"><br/></xsl:if>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="wis-p:ProfilOdbiorcyPosilkow">
		<br/>
		<table>
			<tr>
				<td colspan="2">
					Profilowanie diety
					<xsl:if test="../wis-m:Metryczka">
						<xsl:apply-templates select="../wis-m:Metryczka"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td>Opis</td>
				<td>
					<xsl:value-of select="wis-p:opis"/>
				</td>
			</tr>
			<tr>
				<td>Choroby dietozależne</td>
				<td>
					<xsl:for-each select="wis-p:chorobaDietozalezna">
						<xsl:call-template name="enumeracje">
							<xsl:with-param name="nazwa" select="'ChorobaDietozalezna'"/>
							<xsl:with-param name="wartosc" select="current()"/>
						</xsl:call-template>
						<br/>
					</xsl:for-each>
					<xsl:for-each select="wis-p:innaChorobaDietozalezna">
						<xsl:value-of select="current()"/>
						<br/>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td>Alergia pokarmowa</td>
				<td>
					<xsl:for-each select="wis-p:alergiaPokarmowa">
						<xsl:call-template name="enumeracje">
							<xsl:with-param name="nazwa" select="'AlergiaPokarmowa'"/>
							<xsl:with-param name="wartosc" select="current()"/>
						</xsl:call-template>
						<br/>
					</xsl:for-each>
					<xsl:for-each select="wis-p:innaAlergiaPokarmowa">
						<xsl:value-of select="current()"/>
						<br/>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="enumeracje">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of
				select="$wis-e//xs:simpleType[@name=$nazwa]//xs:enumeration[@value = $wartosc]//xs:documentation"/>
	</xsl:template>
	<xsl:template name="kwestionariusz">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of
				select="$wis-ek//xs:simpleType[@name=$nazwa]//xs:enumeration[@value = $wartosc]//xs:documentation"/>
	</xsl:template>
</xsl:stylesheet>
