/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.du.r2021.poz893.wywiad.cz6;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import pl.gov.du.r2021.poz893.wywiad.cz6.Dokument;
import pl.gov.du.r2021.poz893.wywiad.wspolne.TakNie;
import pl.topteam.otm.utils.Processor;

@Service
@Scope(value="singleton")
public class Expander {
    @Autowired
    private pl.gov.du.r2021.poz893.wywiad.wspolne.Expander expander;

    public Dokument expand(Dokument dokument) {
        Processor.expand(dokument);
        this.expander.expand(dokument.getDaneDokumentu());
        this.expander.expand(dokument.getTrescDokumentu().getWywiad().getPracownikSocjalny());
        this.expander.expand(dokument.getTrescDokumentu().getDiagnozaSytuacjiOsoby().getPracownikSocjalny());
        this.expander.expand(dokument.getTrescDokumentu().getPlanPomocyIDzialan().getPracownikSocjalny());
        this.expander.expand(dokument.getTrescDokumentu().getUwagiKierownika().getKierownik());
        this.expand(dokument.getTrescDokumentu().getWywiad().getOsoba());
        return dokument;
    }

    private List<Dokument.TrescDokumentu.Wywiad.Osoba> expand(List<Dokument.TrescDokumentu.Wywiad.Osoba> osoby) {
        if (osoby.isEmpty()) {
            Dokument.TrescDokumentu.Wywiad.Osoba osoba2 = new Dokument.TrescDokumentu.Wywiad.Osoba();
            osoby.add(osoba2);
        }
        for (Dokument.TrescDokumentu.Wywiad.Osoba osoba3 : osoby) {
            this.expand(osoba3);
        }
        List osobyGlowneT = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.T).collect(Collectors.toList());
        List osobyGlowneN = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.N).collect(Collectors.toList());
        Preconditions.checkState((osobyGlowneT.size() <= 1 ? 1 : 0) != 0, (Object)"Wywiad zawiera wi\u0119cej ni\u017c 1 osob\u0119 g\u0142\u00f3wn\u0105");
        osoby.clear();
        osoby.addAll(osobyGlowneT);
        osoby.addAll(osobyGlowneN);
        for (Dokument.TrescDokumentu.Wywiad.Osoba osoba4 : Iterables.limit(osoby, (int)1)) {
            osoba4.getDanePodstawowe().setOsobaGlowna(TakNie.T);
        }
        return osoby;
    }

    public Dokument.TrescDokumentu.Wywiad.Osoba expand(Dokument.TrescDokumentu.Wywiad.Osoba osoba) {
        Processor.expand(osoba);
        this.expand(osoba.getDanePodstawowe());
        return osoba;
    }

    private Dokument.TrescDokumentu.Wywiad.Osoba.DanePodstawowe expand(Dokument.TrescDokumentu.Wywiad.Osoba.DanePodstawowe danePodstawowe) {
        if (danePodstawowe.getOsobaGlowna() == null) {
            danePodstawowe.setOsobaGlowna(TakNie.N);
        }
        return danePodstawowe;
    }
}

