package pl.gov.du.r2021.poz893.wywiad.cz1i2;

import static java.util.stream.Collectors.toList;
import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_SINGLETON;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.DiagnozaSytuacjiOsoby;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.Osoba;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.PlanPomocyIDzialan;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.UwagiKierownika;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.Wywiad;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.Wywiad.Gospodarstwo;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie;
import pl.gov.du.r2021.poz893.wywiad.cz1i2.Dokument.TrescDokumentu.Wywiad.Gospodarstwo.OsobaWGospodarstwie.DanePodstawowe;
import pl.gov.du.r2021.poz893.wywiad.wspolne.TakNie;
import pl.topteam.otm.utils.Processor;

/**
 * DOKŁADNA KOPIA z projektu otm
 * @author michal
 */

@Service
@Scope(SCOPE_SINGLETON)
public class Expander {
	@Autowired
	private pl.gov.du.r2021.poz893.wywiad.wspolne.Expander expander;

	public Dokument expand(Dokument dokument) {
		Processor.expand(dokument);
		expander.expand(dokument.getDaneDokumentu());
		expand(dokument.getTrescDokumentu());
		return dokument;
	}

	public OsobaWGospodarstwie expand(OsobaWGospodarstwie osoba) {
		Processor.expand(osoba);
		expand(osoba.getDanePodstawowe());
		return osoba;
	}

	private TrescDokumentu expand(TrescDokumentu trescDokumentu) {
		expand(trescDokumentu.getWywiad());
		trescDokumentu.getInneOsobyArt103().forEach(this::expand);
		expand(trescDokumentu.getDiagnozaSytuacjiOsoby());
		expand(trescDokumentu.getPlanPomocyIDzialan());
		expand(trescDokumentu.getUwagiKierownika());
		return trescDokumentu;
	}

	private Wywiad expand(Wywiad wywiad) {
		expander.expand(wywiad.getPracownikSocjalny());
		expand(wywiad.getGospodarstwo());
		return wywiad;
	}

	private List<Gospodarstwo> expand(List<Gospodarstwo> gospodarstwa) {
		// lista musi zawierać przynajmniej 1 gospodarstwo
		if (gospodarstwa.isEmpty()) {
			Gospodarstwo gospodarstwo = new Gospodarstwo();
			gospodarstwa.add(gospodarstwo);
		}
		// pierwsze gospodarstwo musi zawierać przynajmniej 1 osobę
		for (Gospodarstwo gospodarstwo : Iterables.limit(gospodarstwa, 1)) {
			List<OsobaWGospodarstwie> osoby = gospodarstwo.getOsoba();
			if (osoby.isEmpty()) {
				OsobaWGospodarstwie osoba = new OsobaWGospodarstwie();
				osoby.add(osoba);
			}
		}
		// wszystkie obiekty muszą zostać przygotowane do edycji
		for (Gospodarstwo gospodarstwo : gospodarstwa) {
			Processor.expand(gospodarstwo);
			List<OsobaWGospodarstwie> osoby = gospodarstwo.getOsoba();
			for (OsobaWGospodarstwie osoba : osoby) {
				expand(osoba);
			}
		}
		// pierwsze gospodarstwo musi zawierać dokładnie 1 osobę główną (ze wzgl. praktycznych na pocz. listy)
		for (Gospodarstwo gospodarstwo : Iterables.limit(gospodarstwa, 1)) {
			List<OsobaWGospodarstwie> osoby = gospodarstwo.getOsoba();
			List<OsobaWGospodarstwie> osobyGlowneT = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.T).collect(toList());
			List<OsobaWGospodarstwie> osobyGlowneN = osoby.stream().filter(osoba -> osoba.getDanePodstawowe().getOsobaGlowna() == TakNie.N).collect(toList());
			Preconditions.checkState(osobyGlowneT.size() <= 1, "Gospodarstwo zawiera więcej niż 1 osobę główną");
			osoby.clear();
			osoby.addAll(osobyGlowneT);
			osoby.addAll(osobyGlowneN);
			// pierwsza osoba obowiązkowo główna
			for (OsobaWGospodarstwie osoba : Iterables.limit(osoby, 1)) {
				osoba.getDanePodstawowe().setOsobaGlowna(TakNie.T);
			}
		}
		return gospodarstwa;
	}

	private DanePodstawowe expand(DanePodstawowe danePodstawowe) {
		if (danePodstawowe.getOsobaGlowna() == null) {
			danePodstawowe.setOsobaGlowna(TakNie.N);
		}
		return danePodstawowe;
	}

	private void expand(Osoba osoba) {
		Processor.expand(osoba);
	}

	private DiagnozaSytuacjiOsoby expand(DiagnozaSytuacjiOsoby diagnozaSytuacjiOsoby) {
		expander.expand(diagnozaSytuacjiOsoby.getPracownikSocjalny());
		return diagnozaSytuacjiOsoby;
	}

	private PlanPomocyIDzialan expand(PlanPomocyIDzialan planPomocyIDzialan) {
		expander.expand(planPomocyIDzialan.getPracownikSocjalny());
		return planPomocyIDzialan;
	}

	private UwagiKierownika expand(UwagiKierownika uwagiKierownika) {
		expander.expand(uwagiKierownika.getKierownik());
		return uwagiKierownika;
	}
}
