<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xs="http://www.w3.org/2001/XMLSchema"
				xmlns:wis-k="http://top-team.pl/otm/wis/v20221101/kwestionariusz"
				xmlns:wis-m="http://top-team.pl/otm/wis/v20221101/metryczka">

	<xsl:variable name="wis-e" select="document('../enumeracje/enumeracje.xsd')" />
	<xsl:variable name="wis-ek" select="document('kwestionariusz.xsd')" />

	<xsl:output method="html" encoding="utf-8"/>

	<xsl:template match="/">
		<html>
			<head>
				<meta charset="utf-8"/>
				<style>
					<xsl:value-of select="document('../../../css/reset.html')/html/head/style" />
				</style>
				<style>
					<xsl:value-of select="document('../../../css/styles.html')/html/head/style"/>
				</style>
				<style type="text/css">
					.center {
						text-align: center;
					}
					.bold {
						font-weight: bold;
					}
				</style>
				<style type="text/css" media="print">
					.print-break {
						page-break-after: always;
					}
				</style>
			</head>
			<body>
				<xsl:choose>
					<xsl:when test="not(//wis-k:Kwestionariusz)">
						<div class="text-warning">NIE ZNALEZIONO UZUPEŁNIONEGO KWESTIONARIUSZA</div>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="//wis-k:Kwestionariusz"/>
					</xsl:otherwise>
				</xsl:choose>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="wis-k:Kwestionariusz">
		<xsl:if test="position() > 1">
			<div class="print-break"></div>
		</xsl:if>
		<table>
			<caption class="bold">
				SKALA OCENY STOPNIA SAMODZIELNOŚCI
			</caption>
			<xsl:if test="../wis-m:Metryczka">
				<xsl:apply-templates select="../wis-m:Metryczka"/>
				<br/>
			</xsl:if>
			<xsl:apply-templates select="wis-k:OcenaSamodzielnosci/wis-k:Dziedzina1" />
			<xsl:apply-templates select="wis-k:OcenaSamodzielnosci/wis-k:Dziedzina2" />
			<xsl:apply-templates select="wis-k:OcenaSamodzielnosci/wis-k:Dziedzina3" />
			<xsl:apply-templates select="wis-k:OcenaSamodzielnosci/wis-k:Dziedzina4" />
			<xsl:apply-templates select="wis-k:OcenaSamodzielnosci/wis-k:Dziedzina5" />
		</table>
		<xsl:apply-templates select="wis-k:OcenaSamodzielnosci/wis-k:Bariery" />
		<xsl:apply-templates select="wis-k:ProfilowanieDiety" />
		<xsl:apply-templates select="wis-k:ProfilowanieTeleopieki" />
		<br/>
	</xsl:template>

	<xsl:template match="wis-m:Metryczka">
		<section>
			Kwestionariusz dla
			<xsl:text> </xsl:text>
			<ins>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Nazwisko1"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Nazwisko2"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Imie1"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="wis-m:Osoba/wis-m:DanePodstawowe/wis-m:Imie2"/>
			</ins>
			z dnia
			<ins><xsl:value-of select="wis-m:data"/></ins>
		</section>
	</xsl:template>

	<xsl:template match="wis-k:Dziedzina1">
		<tr>
			<td colspan="3" class="bold">Dziedzina 1: Funkcje poznawcze</td>
		</tr>
		<xsl:call-template name="wyswietlNaglowekDziedziny"/>
		<tr>
			<td>D 1.1</td>
			<td>skupienie uwagi na wykonywaniu jakiejś czynności przez dziesięć minut?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz1"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 1.2</td>
			<td>pamiętanie o przyjmowaniu leków, o terminach opłat (czynsz, prąd, telefon), o ulubionym programie
				telewizyjnym?
			</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz2"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 1.3</td>
			<td>uczenie się nowego zadania, np.: uczenie się nowej trasy dojazdu?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz3"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 1.4</td>
			<td>ogólne rozumienie tego, co mówią inni? Np. w sklepie podczas zakupów, podczas rozmowy z bliskimi</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz4"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 1.5</td>
			<td>rozpoczynanie i kontynuowanie rozmowy?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz5"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 1.6</td>
			<td>czytanie prasy/książek?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz6"/>
			</xsl:call-template>
		</tr>
	</xsl:template>

	<xsl:template match="wis-k:Dziedzina2">
		<tr>
			<td colspan="3" class="bold">Dziedzina 2: Poruszanie się</td>
		</tr>
		<xsl:call-template name="wyswietlNaglowekDziedziny"/>
		<tr>
			<td>D 2.1</td>
			<td>stanie przez dłuższy czas (ok. 30 minut)?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz1"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 2.2</td>
			<td>zmiana pozycji ciała z siedzącej na stojącą lub odwrotnie?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz2"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 2.3</td>
			<td>poruszanie się wewnątrz domu?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz3"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 2.4</td>
			<td>wychodzenie z domu?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz4"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 2.5</td>
			<td>chodzenie na duże odległości, np. 1 kilometr (pieszo lub na wózku lub z balkonikiem)?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz5"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 2.6</td>
			<td>poruszanie się po schodach?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz6"/>
			</xsl:call-template>
		</tr>

		<tr>
			<td>D 2.7</td>
			<td>samodzielne poruszanie się komunikacją miejską?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz7"/>
			</xsl:call-template>
		</tr>

	</xsl:template>

	<xsl:template match="wis-k:Dziedzina3">
		<tr>
			<td colspan="3" class="bold">Dziedzina 3: Dbanie o siebie</td>
		</tr>
		<xsl:call-template name="wyswietlNaglowekDziedziny"/>
		<tr>
			<td>D 3.1</td>
			<td>samodzielne mycie całego ciała?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz1"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 3.2</td>
			<td>samodzielne wykonywanie czynności z zakresu higieny osobistej?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz2"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 3.3</td>
			<td>samodzielne jedzenie?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz3"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 3.4</td>
			<td>samodzielne ubieranie się?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz4"/>
			</xsl:call-template>
		</tr>
	</xsl:template>

	<xsl:template match="wis-k:Dziedzina4">
		<tr>
			<td colspan="3" class="bold">Dziedzina 4: Dobre relacje</td>
		</tr>
		<xsl:call-template name="wyswietlNaglowekDziedziny"/>
		<tr>
			<td>D 4.1</td>
			<td>nawiązywanie kontaktów z osobami, których Pan/Pani nie zna?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz1"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 4.2</td>
			<td>utrzymywanie kontaktów towarzyskich?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz2"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 4.3</td>
			<td>utrzymywanie dobrych stosunków z osobami bliskimi?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz3"/>
			</xsl:call-template>
		</tr>
	</xsl:template>

	<xsl:template match="wis-k:Dziedzina5">
		<tr>
			<td colspan="3" class="bold">Dziedzina 5: Aktywność życiowa</td>
		</tr>
		<xsl:call-template name="wyswietlNaglowekDziedziny"/>
		<tr>
			<td>D 5.1</td>
			<td>samodzielne przygotowywanie posiłków?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz1"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 5.2</td>
			<td>samodzielne sprzątanie mieszkania?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz2"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 5.3</td>
			<td>samodzielne wykonywania prania, w tym rozwieszanie?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz3"/>
			</xsl:call-template>
		</tr>
		<tr>
			<td>D 5.4</td>
			<td>samodzielne dokonywanie zakupów?</td>
			<xsl:call-template name="wyswietlOdpowiedz">
				<xsl:with-param name="wartosc" select="wis-k:Odpowiedz4"/>
			</xsl:call-template>
		</tr>
	</xsl:template>

	<xsl:template match="wis-k:Bariery">
		<table style="margin-top: 20px;">
			<tr>
				<td colspan="3" class="bold">Bariery w środowisku</td>
			</tr>
			<tr>
				<td colspan="2" class="bold">Czy w Pana/Pani środowisku znajdują się poniższe bariery?</td>
				<td class="bold">Udzielona odpowiedź</td>
			</tr>
			<tr>
				<td>B 1.1</td>
				<td>Bariery architektoniczne</td>
				<td>
					<xsl:call-template name="enumeracjaKwestionariusz">
						<xsl:with-param name="nazwa" select="'WartoscLogiczna'"/>
						<xsl:with-param name="wartosc" select="wis-k:Odpowiedz1"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>B 1.2</td>
				<td>Bariery w komunikowaniu się</td>
				<td>
					<xsl:call-template name="enumeracjaKwestionariusz">
						<xsl:with-param name="nazwa" select="'WartoscLogiczna'"/>
						<xsl:with-param name="wartosc" select="wis-k:Odpowiedz2"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="wis-k:ProfilowanieDiety">
		<table style="margin-top: 20px;">
			<tr>
				<td colspan="2" class="bold">Kwestionariusz profilowania diety</td>
			</tr>
			<tr>
				<td>Dieta ze wskazań lekarza</td>
				<td>
					<xsl:value-of select="wis-k:DietaZeWskazanLekarza"/>
				</td>
			</tr>
			<tr>
				<td>Choroby dietozależne</td>
				<td>
					<xsl:for-each select="wis-k:ChorobaDietozalezna">
					   <xsl:call-template name="enumeracja">
						   <xsl:with-param name="nazwa" select="'ChorobaDietozalezna'"/>
						   <xsl:with-param name="wartosc" select="current()"/>
					   </xsl:call-template><br/>
					</xsl:for-each>
					<xsl:for-each select="wis-k:InnaChorobaDietozalezna">
						<xsl:value-of select="current()"/><br/>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td>Preferowany rodzaj diety</td>
				<td>
					<xsl:for-each select="wis-k:PreferowanyRodzajDiety">
						<xsl:call-template name="enumeracja">
							<xsl:with-param name="nazwa" select="'PreferowanyRodzajDiety'"/>
							<xsl:with-param name="wartosc" select="current()"/>
						</xsl:call-template><br/>
					</xsl:for-each>
					<xsl:for-each select="wis-k:InnyPreferowanyRodzajDiety">
						<xsl:value-of select="current()"/><br/>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td>Alergie pokarmowe</td>
				<td>
					<xsl:for-each select="wis-k:AlergiaPokarmowa">
						<xsl:call-template name="enumeracja">
							<xsl:with-param name="nazwa" select="'AlergiaPokarmowa'"/>
							<xsl:with-param name="wartosc" select="current()"/>
						</xsl:call-template><br/>
					</xsl:for-each>
					<xsl:for-each select="wis-k:InnaAlergiaPokarmowa">
						<xsl:value-of select="current()"/><br/>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td>Uwagi</td>
				<td><xsl:value-of select="wis-k:Uwagi"/></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="wis-k:ProfilowanieTeleopieki">
		<table style="margin-top: 5mm;:">
			<tr>
				<td colspan="2" class="bold">Kwestionariusz profilowania odbiorcy usług teleopieki</td>
			</tr>
			<tr>
				<td>Tryb życia</td>
				<td>
					<xsl:call-template name="enumeracjaKwestionariusz">
						<xsl:with-param name="nazwa" select="'TrybZycia'"/>
						<xsl:with-param name="wartosc" select="wis-k:TrybZycia"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Mieszka samotnie</td>
				<td>
					<xsl:call-template name="enumeracjaKwestionariusz">
						<xsl:with-param name="nazwa" select="'WartoscLogiczna'"/>
						<xsl:with-param name="wartosc" select="wis-k:SamotneZamieszkiwanie"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Inne ryzyka (w domu: gaz, gazowy piecyk łazienkowy)</td>
				<td>
					<xsl:call-template name="enumeracja">
						<xsl:with-param name="nazwa" select="'CzynnikRyzyka'"/>
						<xsl:with-param name="wartosc" select="wis-k:CzynnikRyzyka"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="wyswietlNaglowekDziedziny">
		<tr>
			<td colspan="2" class="bold">Jak dużo trudności sprawiało Panu/Pani w ciągu ostatniego miesiąca:</td>
			<td class="bold">Udzielona odpowiedź</td>
		</tr>
	</xsl:template>

	<xsl:template name="wyswietlOdpowiedz">
		<xsl:param name="wartosc"/>
		<td>
			<xsl:call-template name="enumeracjaKwestionariusz">
				<xsl:with-param name="nazwa" select="'StopienTrudnosci'"/>
				<xsl:with-param name="wartosc" select="$wartosc"/>
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template name="enumeracja">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of select="$wis-e//xs:simpleType[@name=$nazwa]//xs:enumeration[@value = $wartosc]//xs:documentation" />
	</xsl:template>
	<xsl:template name="enumeracjaKwestionariusz">
		<xsl:param name="nazwa"/>
		<xsl:param name="wartosc"/>
		<xsl:value-of select="$wis-ek//xs:simpleType[@name=$nazwa]//xs:enumeration[@value = $wartosc]//xs:documentation" />
	</xsl:template>
</xsl:stylesheet>
