/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.otm.utils;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.du.r2021.poz893.wywiad.cz6.ObjectFactory;

public class Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class);
    private static final Class<?>[] CLASSES = new Class[]{pl.gov.du.r2021.poz893.wywiad.cz1i2.ObjectFactory.class, pl.gov.du.r2021.poz893.wywiad.cz3i4.ObjectFactory.class, pl.gov.du.r2021.poz893.wywiad.cz5.ObjectFactory.class, ObjectFactory.class, pl.gov.du.r2021.poz893.wywiad.cz7.ObjectFactory.class, pl.gov.du.r2021.poz893.wywiad.cz8.ObjectFactory.class, pl.gov.du.r2021.poz893.wywiad.cz9.ObjectFactory.class, pl.gov.du.r2021.poz893.wywiad.wspolne.ObjectFactory.class, pl.gov.du.r2021r2.poz893.wywiad.cz1i2.ObjectFactory.class, pl.gov.du.r2021r2.poz893.wywiad.cz3i4.ObjectFactory.class, pl.gov.du.r2021r2.poz893.wywiad.wspolne.ObjectFactory.class, pl.gov.du.r2021r3.poz893.wywiad.cz1i2.ObjectFactory.class, pl.gov.du.r2021r3.poz893.wywiad.cz3i4.ObjectFactory.class, pl.gov.du.r2021r3.poz893.wywiad.wspolne.ObjectFactory.class, pl.topteam.otm.wis.v20221101.pakiet.ObjectFactory.class, pl.topteam.otm.wis.v20221101.metryczka.ObjectFactory.class, pl.topteam.otm.wis.v20221101.enumeracje.ObjectFactory.class, pl.topteam.otm.wis.v20221101.kwestionariusz.ObjectFactory.class, pl.topteam.otm.wis.v20221101.profile.ObjectFactory.class, pl.topteam.otm.wis.v20221101.rozszerzenia.ObjectFactory.class};
    private static final Class<?>[] CLASSES_IGNORED = new Class[]{pl.topteam.otm.slownik.r1.ObjectFactory.class, pl.topteam.otm.slowo.r1.ObjectFactory.class};
    private static final Map<Class<?>, Supplier<?>> SUPPLIERS;

    public static <T> T expand(T object) {
        if (!Processor.isXmlComplexType(object)) {
            return object;
        }
        try {
            Class<?> clazz = object.getClass();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                if (Collection.class.isAssignableFrom(descriptor.getPropertyType())) {
                    Object collection = descriptor.getReadMethod().invoke(object, new Object[0]);
                    for (Object value : (Collection)collection) {
                        Processor.expand(value);
                    }
                    continue;
                }
                Supplier<?> supplier = SUPPLIERS.get(descriptor.getPropertyType());
                if (supplier == null) continue;
                Object value = descriptor.getReadMethod().invoke(object, new Object[0]);
                descriptor.getWriteMethod().invoke(object, Processor.expand(value != null ? value : supplier.get()));
            }
            return object;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T collapse(T object) {
        if (!Processor.isXmlComplexType(object)) {
            return object;
        }
        try {
            boolean isEmpty = true;
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!Processor.isXmlElement(field)) continue;
                    field.setAccessible(true);
                    Object value = Processor.collapse(field.get(object));
                    isEmpty &= Processor.isEmpty(value);
                    field.set(object, value);
                    field.setAccessible(false);
                }
            }
            return (T)(!isEmpty ? object : null);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static <T> boolean isXmlComplexType(T object) {
        return Processor.isXmlType(object) && !Processor.isXmlEnum(object);
    }

    private static boolean isXmlType(Object object) {
        return object != null && object.getClass().isAnnotationPresent(XmlType.class);
    }

    private static boolean isXmlEnum(Object object) {
        return object != null && object.getClass().isAnnotationPresent(XmlEnum.class);
    }

    private static boolean isXmlElement(Field field) {
        return field != null && field.isAnnotationPresent(XmlElement.class);
    }

    private static boolean isEmpty(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            return list.isEmpty();
        }
        if (value instanceof String) {
            String string = (String)value;
            return string.isEmpty();
        }
        return value == null;
    }

    static {
        ImmutableSet classes = ImmutableSet.copyOf((Object[])CLASSES);
        Class<?>[] classesIgnored = ImmutableSet.copyOf((Object[])CLASSES_IGNORED);
        Verify.verify((boolean)Sets.intersection((Set)classes, (Set)classesIgnored).isEmpty());
        ImmutableMap.Builder suppliers = ImmutableMap.builder();
        try {
            for (Class<?> clazz : CLASSES) {
                Object factory = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (method.getParameterCount() != 0) continue;
                    Class<?> type = method.getReturnType();
                    suppliers.put(type, new Invoker(factory, method));
                }
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        SUPPLIERS = suppliers.build();
    }

    private static final class Invoker<T>
    implements Supplier<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(Invoker.class);
        private final Object instance;
        private final Method method;

        public Invoker(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
        }

        @Override
        public T get() {
            try {
                Object value = this.method.invoke(this.instance, new Object[0]);
                return (T)value;
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

